/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.opplugin.cost.apply;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.entity.BudgetCosts;
import kd.occ.ocbase.common.util.BigDecimalUtil;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ocmem.business.budgetcosts.BudgetCostsServiceImpl;
import kd.occ.ocmem.business.budgetcosts.BudgetCostsUpdateHelper;
import kd.occ.ocmem.business.cost.CostAppFormHelper;
import kd.occ.ocmem.business.cost.CostBillServiceHelper;
import kd.occ.ocmem.common.constants.MarketCostApplyConstants;
import kd.occ.ocmem.common.util.OCMEMOppUtil;
import kd.occ.ocmem.opplugin.basedata.OCMEMBillOppPlugin;
import kd.occ.ocmem.opplugin.cost.apply.MarketCostApplyValidator;

public class MarketCostApplySubmitOp
extends OCMEMBillOppPlugin
implements MarketCostApplyConstants {
    private static final String[] key_words = new String[]{"shopnumber", "storename", "storetype", "shoptype", "shoparea", "shopregion", "address", "citytype", "shopphone", "iteminfonum", "iteminfomodel", "itembrands", "itemclass"};

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("billdate");
        e.getFieldKeys().add("expensetype");
        e.getFieldKeys().add("dept");
        e.getFieldKeys().add("orderchannel");
        e.getFieldKeys().add("orderchannel");
        e.getFieldKeys().add("budget");
        e.getFieldKeys().add("totalamount");
        e.getFieldKeys().add("currency");
        e.getFieldKeys().add("number");
        e.getFieldKeys().add("budget");
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("begindate");
        e.getFieldKeys().add("enddate");
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("entryentity.entryexpensetype");
        e.getFieldKeys().add("entryentity.entryexpensetype.writeoffno");
        e.getFieldKeys().add("entryentity.qty");
        e.getFieldKeys().add("entryentity.entrywriteoff");
        e.getFieldKeys().add("entryentity.amount");
        e.getFieldKeys().add("entryentity.iteminfo");
        e.getFieldKeys().add("entryentity.baseunit");
        e.getFieldKeys().add("entryentity.price");
        e.getFieldKeys().add("entryentity.material");
        e.getFieldKeys().add("entryentity.auxptyid");
        e.getFieldKeys().add("entryentity.entrybegindate");
        e.getFieldKeys().add("entryentity.entryenddate");
        e.getFieldKeys().add("entryentity.balancenumber");
        e.getFieldKeys().add("entryentity.rowbudget");
        OCMEMOppUtil.onPreparePropertys((PreparePropertysEventArgs)e, (String)"entryentity", (String)"bill", (String)"ocmem_mcostapply_entry");
        e.getFieldKeys().add("entrywriteoffname");
        e.getFieldKeys().add("costdept");
        e.getFieldKeys().add("entryentity.refundamount");
        e.getFieldKeys().add("entryentity.rowexpensetype");
        e.getFieldKeys().add("budgetyear");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new MarketCostApplyValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        this.checkEntryExists(e);
        this.checkEmpty(e);
        this.submitCheck(e);
        this.checkHeadAndEntryDate(e);
    }

    private void checkHeadAndEntryDate(BeforeOperationArgs e) {
        DynamicObject[] infos;
        for (DynamicObject info : infos = e.getDataEntities()) {
            String billno = info.getString("billno");
            Date beginDate = info.getDate("begindate");
            Date endDate = info.getDate("enddate");
            DynamicObjectCollection entryCollection = info.getDynamicObjectCollection("entryentity");
            for (DynamicObject eachEntry : entryCollection) {
                Date entryBeginDate = eachEntry.getDate("entrybegindate");
                Date entryEndDate = eachEntry.getDate("entryenddate");
                if (entryBeginDate != null && beginDate.getTime() > entryBeginDate.getTime()) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5355\u636e\u5934\u7684\u6700\u65e9\u5f00\u59cb\u65e5\u671f\u5927\u4e8e\u5355\u636e\u4f53\u4e2d\u5f00\u59cb\u65e5\u671f\uff0c\u8bf7\u68c0\u67e5", (String)"MarketCostApplySubmitOp_17", (String)"occ-ocmem-opplugin", (Object[])new Object[0]), billno));
                }
                if (entryEndDate == null || endDate.getTime() >= entryEndDate.getTime()) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5355\u636e\u5934\u7684\u6700\u665a\u7ed3\u675f\u65e5\u671f\u5c0f\u4e8e\u5355\u636e\u4f53\u4e2d\u7ed3\u675f\u65e5\u671f\uff0c\u8bf7\u68c0\u67e5", (String)"MarketCostApplySubmitOp_18", (String)"occ-ocmem-opplugin", (Object[])new Object[0]), billno));
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        this.submitAfter(e);
        this.reduceBudgetAmount(e);
    }

    protected void submitAfter(EndOperationTransactionArgs e) {
        super.submitAfter(e);
    }

    @Override
    protected List<String[]> getRequiredFieldList(DynamicObject dataInfo) {
        ArrayList<String[]> listField = new ArrayList<String[]>();
        listField.add(new String[]{"billno", ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"MarketCostApplySubmitOp_2", (String)"occ-ocmem-opplugin", (Object[])new Object[0])});
        return listField;
    }

    private void checkEntryExists(BeforeOperationArgs e) {
        DynamicObject[] infos;
        for (DynamicObject info : infos = e.getDataEntities()) {
            String billno = info.getString("billno");
            DynamicObjectCollection entryCollection = info.getDynamicObjectCollection("entryentity");
            if (entryCollection == null || entryCollection.size() == 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5355\u636e\u4f53\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (String)"MarketCostApplySubmitOp_19", (String)"occ-ocmem-opplugin", (Object[])new Object[0]), billno));
            }
            for (DynamicObject eachEntry : entryCollection) {
                DynamicObject auxptyId;
                DynamicObject material = eachEntry.getDynamicObject("material");
                if (material != null && material.getBoolean("isuseauxpty") && (auxptyId = eachEntry.getDynamicObject("auxptyid")) == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5355\u636e\u4f53\u8f85\u52a9\u5c5e\u6027\u672a\u586b\u5199\uff0c\u8bf7\u68c0\u67e5", (String)"MarketCostApplySubmitOp_20", (String)"occ-ocmem-opplugin", (Object[])new Object[0]), billno));
                }
                DynamicObject entryWriteOffId = eachEntry.getDynamicObject("entrywriteoff");
                String typeSign = entryWriteOffId.getString("typesign");
                if (typeSign.equals("A")) {
                    BigDecimal amount = eachEntry.getBigDecimal("amount");
                    if (amount.compareTo(BigDecimal.ZERO) > 0) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u884c\u7c7b\u578b\u4e3a\u73b0\u91d1\u7c7b,\u7533\u8bf7\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0\uff0c\u8bf7\u68c0\u67e5", (String)"MarketCostApplySubmitOp_21", (String)"occ-ocmem-opplugin", (Object[])new Object[0]), billno));
                }
                if (!typeSign.equals("B")) continue;
                Object itemInfo = eachEntry.get("iteminfo");
                if (itemInfo == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u884c\u7c7b\u578b\u4e3a\u7269\u6599\u7c7b,\u4ea7\u54c1\u540d\u79f0\u5fc5\u586b\uff0c\u8bf7\u68c0\u67e5", (String)"MarketCostApplySubmitOp_22", (String)"occ-ocmem-opplugin", (Object[])new Object[0]), billno));
                }
                Object baseUnit = eachEntry.get("baseunit");
                if (baseUnit == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u884c\u7c7b\u578b\u4e3a\u7269\u6599\u7c7b,\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d\u5fc5\u586b\uff0c\u8bf7\u68c0\u67e5", (String)"MarketCostApplySubmitOp_23", (String)"occ-ocmem-opplugin", (Object[])new Object[0]), billno));
                }
                BigDecimal qty = eachEntry.getBigDecimal("qty");
                if (qty.compareTo(BigDecimal.ZERO) <= 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u884c\u7c7b\u578b\u4e3a\u7269\u6599\u7c7b,\u6570\u91cf\u8981\u5927\u4e8e0\uff0c\u8bf7\u68c0\u67e5", (String)"MarketCostApplySubmitOp_24", (String)"occ-ocmem-opplugin", (Object[])new Object[0]), billno));
                }
                BigDecimal price = eachEntry.getBigDecimal("price");
                if (price.compareTo(BigDecimal.ZERO) > 0) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u884c\u7c7b\u578b\u4e3a\u7269\u6599\u7c7b,\u5355\u4ef7\u9700\u8981\u586b\u5199\uff0c\u8bf7\u68c0\u67e5", (String)"MarketCostApplySubmitOp_25", (String)"occ-ocmem-opplugin", (Object[])new Object[0]), billno));
            }
        }
    }

    private void submitCheck(BeforeOperationArgs e) {
        DynamicObject[] infos;
        for (DynamicObject info : infos = e.getDataEntities()) {
            long currencyId = DynamicObjectUtils.getPkValue((DynamicObject)info, (String)"currency");
            long budgetYearId = DynamicObjectUtils.getPkValue((DynamicObject)info, (String)"budgetyear");
            DynamicObjectCollection entryCollection = info.getDynamicObjectCollection("entryentity");
            for (DynamicObject eachEntry : entryCollection) {
                DynamicObject getAvailableAmount;
                DynamicObject expensetype = eachEntry.getDynamicObject("rowexpensetype");
                long orgId = DynamicObjectUtils.getPkValue((DynamicObject)info, (String)"costdept");
                long channelId = DynamicObjectUtils.getPkValue((DynamicObject)info, (String)"orderchannel");
                long expensetTypeId = DynamicObjectUtils.getPkValue((DynamicObject)expensetype);
                if (!CostAppFormHelper.ifBudget((DynamicObject)expensetype)) continue;
                String control = expensetype.getString("control");
                if (!control.contains("1")) {
                    orgId = 0L;
                }
                if (!control.contains("2")) {
                    channelId = 0L;
                }
                if ((getAvailableAmount = BudgetCostsServiceImpl.queryBudgetCostsInfo((long)orgId, (long)channelId, (long)currencyId, (long)expensetTypeId, (long)budgetYearId)) == null) {
                    eachEntry.set("rowbudget", (Object)BigDecimal.ZERO);
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u4f59\u989d\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u8d22\u52a1\u521b\u5efa\u9884\u7b97\u540e\u518d\u63d0\u4ea4", (String)"MarketCostApplySubmitOp_26", (String)"occ-ocmem-opplugin", (Object[])new Object[0]), info.getString("billno")));
                }
                BigDecimal availableamount = getAvailableAmount.getBigDecimal("availableamount");
                eachEntry.set("rowbudget", (Object)availableamount);
                eachEntry.set("balancenumber", (Object)getAvailableAmount.getString("number"));
                BigDecimal totalamount = eachEntry.getBigDecimal("amount");
                if (availableamount.compareTo(totalamount) >= 0) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u4f59\u989d\u4e3a %2$s", (String)"MarketCostApplySubmitOp_27", (String)"occ-ocmem-opplugin", (Object[])new Object[0]), info.getString("billno"), availableamount));
            }
        }
    }

    private void reduceBudgetAmount(EndOperationTransactionArgs e) {
        DynamicObject[] infos;
        for (DynamicObject info : infos = e.getDataEntities()) {
            DynamicObjectCollection entryCollection = info.getDynamicObjectCollection("entryentity");
            for (DynamicObject eachEntry : entryCollection) {
                DynamicObject expenseType = eachEntry.getDynamicObject("rowexpensetype");
                if (!CostAppFormHelper.ifBudget((DynamicObject)expenseType)) continue;
                BudgetCosts anewBudgetCost = new BudgetCosts();
                String control = expenseType.getString("control");
                if (control.contains("1")) {
                    anewBudgetCost.setOrgId(info.getDynamicObject("costdept").getLong("id"));
                }
                if (control.contains("2")) {
                    anewBudgetCost.setChannelId(info.getDynamicObject("orderchannel").getLong("id"));
                }
                anewBudgetCost.setSourceBill("ocmem_marketcost_apply");
                anewBudgetCost.setSourceBillNo(info.getString("billno"));
                anewBudgetCost.setNumber(info.getString("number"));
                anewBudgetCost.setAvailableAmount(eachEntry.getBigDecimal("amount"));
                anewBudgetCost.setDateTime(info.getDate("billdate"));
                anewBudgetCost.setFeeTypeId(DynamicObjectUtils.getPkValue((DynamicObject)expenseType));
                anewBudgetCost.setCurrencyId(info.getDynamicObject("currency").getLong("id"));
                anewBudgetCost.setBudgetYearId(DynamicObjectUtils.getPkValue((DynamicObject)info, (String)"budgetyear"));
                QFilter Filter = new QFilter("number", "=", (Object)eachEntry.getString("balancenumber"));
                DynamicObject[] queryObjects = BusinessDataServiceHelper.load((String)"ocdbd_budgetbalance", (String)"id", (QFilter[])new QFilter[]{Filter});
                if (queryObjects != null && queryObjects.length > 0) {
                    anewBudgetCost.setId(queryObjects[0].getLong("id"));
                }
                ArrayList<BudgetCosts> budgetCostsList = new ArrayList<BudgetCosts>(1);
                budgetCostsList.add(anewBudgetCost);
                BudgetCostsUpdateHelper.occupyBudgetCosts(budgetCostsList);
            }
        }
    }

    private void checkEmpty(BeforeOperationArgs args) {
        DynamicObject[] infos = args.getDataEntities();
        for (int i = 0; i < infos.length; ++i) {
            StringBuilder msg = new StringBuilder();
            long activityTypeId = DynamicObjectUtils.getPkValue((DynamicObject)infos[i].getDynamicObject("activitytype"));
            DynamicObject expensetype = CostBillServiceHelper.getBillConfigByActivityType((long)activityTypeId);
            if (expensetype != null) {
                DynamicObjectCollection entrys;
                boolean bool = infos[i].getDataEntityType().getProperties().containsKey((Object)"entryentity");
                DynamicObjectCollection billconfigentrys = expensetype.getDynamicObjectCollection("billconfigentry");
                if (!bool) {
                    StringBuilder sql = new StringBuilder("entryentity,entryentity.id");
                    for (DynamicObject billconfigentry : billconfigentrys) {
                        sql.append(",entryentity.").append(billconfigentry.getDynamicObject("fieldname").getString("number"));
                    }
                    DynamicObject e = BusinessDataServiceHelper.loadSingle((Object)infos[i].getPkValue(), (String)infos[i].getDataEntityType().getName(), (String)sql.toString());
                    entrys = e.getDynamicObjectCollection("entryentity");
                } else {
                    entrys = infos[i].getDynamicObjectCollection("entryentity");
                }
                if (entrys == null || entrys.size() < 1) {
                    msg.append(ResManager.loadKDString((String)"\u5206\u5f55\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MarketCostApplySubmitOp_12", (String)"occ-ocmem-opplugin", (Object[])new Object[0]));
                } else {
                    for (DynamicObject billconfigentry : billconfigentrys) {
                        DynamicObject entry;
                        int j;
                        DynamicObject fieldName = billconfigentry.getDynamicObject("fieldname");
                        if (fieldName == null) continue;
                        if (billconfigentry.getBoolean("isrequired")) {
                            for (j = 0; j < entrys.size(); ++j) {
                                DynamicObject entry2 = (DynamicObject)entrys.get(j);
                                if (Arrays.asList(key_words).contains(fieldName.getString("number"))) continue;
                                Object fieldObj = entry2.get(fieldName.getString("number"));
                                if (null != fieldObj) {
                                    if (fieldObj instanceof BigDecimal) {
                                        if (BigDecimal.ZERO.compareTo((BigDecimal)fieldObj) < 0 || fieldObj.equals("originalamt")) continue;
                                        msg.append(String.format(ResManager.loadKDString((String)"\u7b2c[%1$s]\u884c[%2$s]\u4e0d\u80fd\u5c0f\u4e8e\u6216\u7b49\u4e8e0\u3002", (String)"MarketCostApplySubmitOp_13", (String)"occ-ocmem-opplugin", (Object[])new Object[0]), j + 1, fieldName.getString("name")));
                                        continue;
                                    }
                                    if (!StringUtils.isEmpty((String)fieldObj.toString())) continue;
                                    msg.append(String.format(ResManager.loadKDString((String)"\u7b2c[%1$s]\u884c[%2$s]\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MarketCostApplySubmitOp_14", (String)"occ-ocmem-opplugin", (Object[])new Object[0]), j + 1, fieldName.getString("name")));
                                    continue;
                                }
                                msg.append(String.format(ResManager.loadKDString((String)"\u7b2c[%1$s]\u884c[%2$s]\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MarketCostApplySubmitOp_14", (String)"occ-ocmem-opplugin", (Object[])new Object[0]), j + 1, fieldName.getString("name")));
                            }
                        }
                        if ("costprice".equals(fieldName.getString("number")) && billconfigentry.getBoolean("isdisplay")) {
                            for (j = 0; j < billconfigentrys.size(); ++j) {
                                DynamicObject e = (DynamicObject)billconfigentrys.get(j);
                                DynamicObject fieldName2 = e.getDynamicObject("fieldname");
                                if (fieldName2 == null || !"price".equals(fieldName2.getString("number")) || e.getBoolean("isdisplay")) continue;
                                for (int t = 0; t < entrys.size(); ++t) {
                                    entry = (DynamicObject)entrys.get(t);
                                    entry.set("price", entry.get("costprice"));
                                    entry.set("amount", (Object)BigDecimalUtil.multiplyObject((Object)entry.get("qty"), (Object)entry.get("price"), (int)10));
                                    entry.set("amtunapproved", (Object)BigDecimalUtil.subtractObject((Object)"amount", (Object)entry.get("amtapproved")));
                                }
                            }
                        }
                        if (!"amount".equalsIgnoreCase(fieldName.getString("number"))) continue;
                        for (DynamicObject filed : billconfigentrys) {
                            DynamicObject tempFieldName = filed.getDynamicObject("fieldname");
                            if (tempFieldName == null || !"amount".equalsIgnoreCase(tempFieldName.getString("number")) || !filed.getBoolean("isdisplay")) continue;
                            for (int j2 = 0; j2 < entrys.size(); ++j2) {
                                entry = (DynamicObject)entrys.get(j2);
                                BigDecimal amount = entry.getBigDecimal("amount");
                                if (null != amount && BigDecimal.ZERO.compareTo(amount) < 0) continue;
                                msg.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u3010\u7533\u8bf7\u91d1\u989d\u3011\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"MarketCostApplySubmitOp_15", (String)"occ-ocmem-opplugin", (Object[])new Object[0]), j2 + 1));
                            }
                        }
                    }
                    Date currentDate = DateUtil.getDayFirst((Date)new Date());
                    for (int j = 0; j < entrys.size(); ++j) {
                        Date endDate;
                        Date beginDate = ((DynamicObject)entrys.get(j)).getDate("entrybegindate");
                        if (beginDate != null) {
                            beginDate = DateUtil.getDayFirst((Date)beginDate);
                        }
                        if ((endDate = ((DynamicObject)entrys.get(j)).getDate("entryenddate")) != null) {
                            endDate = DateUtil.getDayLast((Date)endDate);
                        }
                        if (beginDate == null || endDate == null || beginDate.getTime() <= endDate.getTime()) continue;
                        msg.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"MarketCostApplySubmitOp_16", (String)"occ-ocmem-opplugin", (Object[])new Object[0]), j + 1));
                    }
                }
            }
            if (msg.length() <= 0) continue;
            throw new KDBizException(msg.toString());
        }
    }
}

