/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.opplugin.cost.apply;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.validator.BatchFastValidator;

public class MarketCostApplyValidator
extends BatchFastValidator {
    public void save(ExtendedDataEntity[] datas) {
        super.save(datas);
        this.verifyExpenseTypeOrgPattern(datas);
    }

    public void submit(ExtendedDataEntity[] datas) {
        super.submit(datas);
        this.verifyExpenseTypeOrgPattern(datas);
    }

    private void verifyExpenseTypeOrgPattern(ExtendedDataEntity[] datas) {
        for (ExtendedDataEntity data : datas) {
            DynamicObject bill = data.getDataEntity();
            DynamicObject costDept = bill.getDynamicObject("costdept");
            long orgPattern = DynamicObjectUtils.getPkValue((DynamicObject)costDept, (String)"orgpattern");
            DynamicObjectCollection entryCollection = bill.getDynamicObjectCollection("entryentity");
            for (DynamicObject eachEntry : entryCollection) {
                DynamicObject rowExpenseType = eachEntry.getDynamicObject("rowexpensetype");
                long entryOrgPattern = DynamicObjectUtils.getPkValue((DynamicObject)rowExpenseType, (String)"orgpattern");
                if (entryOrgPattern <= 0L || entryOrgPattern == orgPattern) continue;
                this.addFatalErrorMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u8d39\u7528\u7c7b\u578b\u4e0d\u5141\u8bb8\u5728\u5f53\u524d\u5355\u636e\u7684\u8d39\u7528\u627f\u62c5\u90e8\u95e8\u4f7f\u7528\u3002", (String)"MarketCostApplyValidator_0", (String)"occ-ocmem-opplugin", (Object[])new Object[0]), eachEntry.getInt("seq")));
            }
        }
    }
}

