/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.opplugin.cost.reimburse;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.util.BigDecimalUtil;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.Convert;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocmem.business.budgetcosts.BudgetCostsServiceImpl;
import kd.occ.ocmem.business.money.MoneyIncomeHelper;
import kd.occ.ocmem.common.enums.BizBillStatusEnum;
import kd.occ.ocmem.opplugin.basedata.OCMEMBillOppPlugin;

public class MarketCostReimburseAuditOp
extends OCMEMBillOppPlugin {
    protected Log logger = LogFactory.getLog(MarketCostReimburseAuditOp.class);
    private static final String MARKET_COST_APPLY_COLS = "entryentity,entryentity.refundamount,entryentity.amtapproved,entryentity.amtunapproved,totalrefundamount,totalamtapproved,entryentity.amount,totalamount,totalamtunapproved,billstatus,issyn";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("entrys.amount");
        e.getFieldKeys().add("entrys.reimburseway");
        e.getFieldKeys().add("entrys.entryaccountid");
        e.getFieldKeys().add("entrys.amtapproved");
        e.getFieldKeys().add("entrys.writeoff");
        e.getFieldKeys().add("entrys.finalamt");
        e.getFieldKeys().add("entrys.iteminfo");
        e.getFieldKeys().add("entrys.material");
        e.getFieldKeys().add("entrys.auxptyid");
        e.getFieldKeys().add("entrys.baseunit");
        e.getFieldKeys().add("entrys.finalqty");
        e.getFieldKeys().add("entrys.rowexpensetype");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("costdept");
        e.getFieldKeys().add("orderchannel");
        e.getFieldKeys().add("settleorgid");
        e.getFieldKeys().add("currency");
        e.getFieldKeys().add("entrys");
        e.getFieldKeys().add("paymethod");
        e.getFieldKeys().add("reimburseway");
        e.getFieldKeys().add("accounttype");
        e.getFieldKeys().add("verifiedqty");
        e.getFieldKeys().add("billdate");
        e.getFieldKeys().add("entrys");
        e.getFieldKeys().add("entrys.sourceid");
        e.getFieldKeys().add("entrys.sourceentryid");
        e.getFieldKeys().add("entrys.amount");
        e.getFieldKeys().add("budgetyear");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        this.auditBefore(e);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        this.auditAfter(e);
        MoneyIncomeHelper.batchUpdateRebateAccountListByAudit((DynamicObject[])e.getDataEntities());
        this.updateBudgetWriteoffAmt(e.getDataEntities());
    }

    protected void auditAfter(EndOperationTransactionArgs args) {
        super.auditAfter(args);
        this.updateMarketCostApplyBill(args);
    }

    private void updateMarketCostApplyBill(EndOperationTransactionArgs args) {
        List billDataEntities = DynamicObjectUtils.convertDynamicObjList((DynamicObject[])args.getDataEntities());
        Map<Long, DynamicObject> applyBillMap = this.getLinkedMarketCostApplyList(billDataEntities);
        ArrayList<DynamicObject> updateApplyList = new ArrayList<DynamicObject>(billDataEntities.size());
        for (DynamicObject reimburseBill : billDataEntities) {
            long sourceBillId;
            DynamicObject applyBill;
            DynamicObjectCollection reimburseDetail = reimburseBill.getDynamicObjectCollection("entrys");
            if (CollectionUtils.isEmpty((Collection)reimburseDetail) || (applyBill = applyBillMap.get(sourceBillId = Convert.toLong((Object)((DynamicObject)reimburseDetail.get(0)).get("sourceid")))) == null) continue;
            DynamicObjectCollection sourceDetailList = applyBill.getDynamicObjectCollection("entryentity");
            Map<Long, DynamicObject> detailMap = sourceDetailList.stream().collect(Collectors.toMap(a -> DynamicObjectUtils.getPkValue((DynamicObject)a), a -> a, (k1, k2) -> k1));
            BigDecimal refundAmountSum = BigDecimal.ZERO;
            BigDecimal amtApprovedSum = BigDecimal.ZERO;
            for (DynamicObject rdetail : reimburseDetail) {
                long sourceEntryId = Convert.toLong((Object)rdetail.get("sourceentryid"));
                DynamicObject sourceEntry = detailMap.get(sourceEntryId);
                if (sourceEntry == null) continue;
                sourceEntry.set("refundamount", (Object)sourceEntry.getBigDecimal("refundamount").add(rdetail.getBigDecimal("amount")));
                BigDecimal totalAmtApproved = sourceEntry.getBigDecimal("amtapproved").add(rdetail.getBigDecimal("amtapproved"));
                sourceEntry.set("amtapproved", (Object)totalAmtApproved);
                sourceEntry.set("amtunapproved", (Object)BigDecimalUtil.subtractObject((Object)sourceEntry.getBigDecimal("amount"), (Object)sourceEntry.getBigDecimal("amtapproved")));
                refundAmountSum = refundAmountSum.add(sourceEntry.getBigDecimal("amtapproved"));
                amtApprovedSum = amtApprovedSum.add(rdetail.getBigDecimal("amtapproved"));
            }
            applyBill.set("totalrefundamount", (Object)refundAmountSum);
            applyBill.set("totalamtapproved", (Object)applyBill.getBigDecimal("totalamtapproved").add(amtApprovedSum));
            applyBill.set("totalamtunapproved", (Object)BigDecimalUtil.subtractObject((Object)applyBill.get("totalamount"), (Object)applyBill.getBigDecimal("totalamtapproved")));
            if (applyBill.getBigDecimal("totalamtapproved").compareTo(BigDecimal.ZERO) > 0) {
                if (applyBill.getBigDecimal("totalamtunapproved").compareTo(BigDecimal.ZERO) > 0) {
                    applyBill.set("billstatus", (Object)BizBillStatusEnum.PARTREFUND.getValue());
                } else {
                    applyBill.set("billstatus", (Object)BizBillStatusEnum.CLOSED.getValue());
                }
            } else {
                applyBill.set("billstatus", (Object)BizBillStatusEnum.AUDIDPASS.getValue());
            }
            updateApplyList.add(applyBill);
        }
        SaveServiceHelper.save((DynamicObject[])updateApplyList.toArray(new DynamicObject[updateApplyList.size()]));
    }

    private Map<Long, DynamicObject> getLinkedMarketCostApplyList(List<DynamicObject> billDataEntities) {
        ArrayList<Long> applyIdList = new ArrayList<Long>(billDataEntities.size());
        for (DynamicObject bill : billDataEntities) {
            DynamicObjectCollection detail = bill.getDynamicObjectCollection("entrys");
            if (CollectionUtils.isEmpty((Collection)detail)) continue;
            applyIdList.add(Convert.toLong((Object)((DynamicObject)detail.get(0)).get("sourceid")));
        }
        QFilter filter = new QFilter("id", "in", applyIdList);
        DynamicObject[] queryApplyList = BusinessDataServiceHelper.load((String)"ocmem_marketcost_apply", (String)MARKET_COST_APPLY_COLS, (QFilter[])filter.toArray());
        List applyList = DynamicObjectUtils.convertDynamicObjList((DynamicObject[])queryApplyList);
        return applyList.stream().collect(Collectors.toMap(a -> DynamicObjectUtils.getPkValue((DynamicObject)a), a -> a, (k1, k2) -> k1));
    }

    private void updateBudgetWriteoffAmt(DynamicObject[] dataEntities) {
        if (CommonUtils.isNull((Object)dataEntities)) {
            return;
        }
        ArrayList<DynamicObject> updateBudgetCostList = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject billDynObj : dataEntities) {
            DynamicObject budgetYear = billDynObj.getDynamicObject("budgetyear");
            DynamicObjectCollection entryColl = billDynObj.getDynamicObjectCollection("entrys");
            Map<Long, List<DynamicObject>> hsMap = entryColl.stream().collect(Collectors.groupingBy(p -> p.getLong("rowexpensetype_id")));
            long currencyId = DynamicObjectUtils.getPkValue((DynamicObject)billDynObj, (String)"currency");
            for (Map.Entry<Long, List<DynamicObject>> entry : hsMap.entrySet()) {
                long expenseTypeId;
                DynamicObject budgetCostDynObj;
                BigDecimal sumAmtApproved = entry.getValue().stream().map(obj -> obj.getBigDecimal("amtapproved")).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (sumAmtApproved.compareTo(BigDecimal.ZERO) <= 0) continue;
                long orgId = 0L;
                long channelId = 0L;
                DynamicObject rowExpenseTypeObj = entry.getValue().get(0).getDynamicObject("rowexpensetype");
                String control = rowExpenseTypeObj.getString("control");
                if (control.contains("1")) {
                    orgId = DynamicObjectUtils.getPkValue((DynamicObject)billDynObj, (String)"costdept");
                }
                if (control.contains("2")) {
                    channelId = DynamicObjectUtils.getPkValue((DynamicObject)billDynObj, (String)"orderchannel");
                }
                if ((budgetCostDynObj = BudgetCostsServiceImpl.queryBudgetCostsInfo((long)orgId, (long)channelId, (long)currencyId, (long)(expenseTypeId = entry.getKey().longValue()), (long)DynamicObjectUtils.getPkValue((DynamicObject)budgetYear))) == null) continue;
                budgetCostDynObj.set("writeoffamt", (Object)budgetCostDynObj.getBigDecimal("writeoffamt").add(sumAmtApproved));
                updateBudgetCostList.add(budgetCostDynObj);
            }
        }
        SaveServiceHelper.save((DynamicObject[])updateBudgetCostList.toArray(new DynamicObject[updateBudgetCostList.size()]));
    }
}

