/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.opplugin.cost.reimburse;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.BigDecimalUtil;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ocmem.common.enums.BizBillStatusEnum;
import kd.occ.ocmem.common.util.OCMEMOppUtil;
import kd.occ.ocmem.opplugin.basedata.OCMEMBillOppPlugin;

public class MarketCostReimburseSubmitOp
extends OCMEMBillOppPlugin {
    protected Log logger = LogFactory.getLog(MarketCostReimburseSubmitOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("entrys.sourceid");
        e.getFieldKeys().add("entrys.sourceentryid");
        e.getFieldKeys().add("entrys.amtapproved");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("receivable");
        e.getFieldKeys().add("totalamtapproved");
        e.getFieldKeys().add("receivable.receivableamt");
        e.getFieldKeys().add("totalamount");
        e.getFieldKeys().add("totalamtapproved");
        e.getFieldKeys().add("entrys");
        OCMEMOppUtil.onPreparePropertys((PreparePropertysEventArgs)e, (String)"entrys", (String)"bill", (String)"ocmem_mc_reimburseentry");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        this.checkEntryExists(e);
        DynamicObject[] objs = e.getDataEntities();
        for (int i = 0; i < objs.length; ++i) {
            this.checkBill(objs[i]);
        }
    }

    private void checkEntryExists(BeforeOperationArgs e) {
        DynamicObject[] infos;
        for (DynamicObject info : infos = e.getDataEntities()) {
            String billno = info.getString("billno");
            DynamicObjectCollection entryCollection = info.getDynamicObjectCollection("entrys");
            if (entryCollection != null && entryCollection.size() != 0) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5355\u636e\u4f53\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (String)"MarketCostReimburseSubmitOp_6", (String)"occ-ocmem-opplugin", (Object[])new Object[0]), billno));
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        this.submitAfter(e);
    }

    protected void submitAfter(EndOperationTransactionArgs args) {
        super.submitAfter(args);
    }

    protected void checkBill(DynamicObject dynamicObject) {
        DynamicObject dynObj;
        StringBuilder msg = new StringBuilder();
        DynamicObjectCollection entrys2 = dynamicObject.getDynamicObjectCollection("entrys");
        for (int i = 0; i < entrys2.size(); ++i) {
            DynamicObject eInfo = (DynamicObject)entrys2.get(i);
            if (eInfo.getBigDecimal("amount") == null || eInfo.getBigDecimal("amount").abs().floatValue() < 0.01f) {
                msg.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u62a5\u9500\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\u6216\u4e3a0", (String)"MarketCostReimburseSubmitOp_1", (String)"occ-ocmem-opplugin", (Object[])new Object[0]), i + 1));
                continue;
            }
            BigDecimal dif = BigDecimalUtil.subtractObject((Object)eInfo.getBigDecimal("amtapply"), (Object)eInfo.getBigDecimal("amount"));
            if (dif == null || !(dif.floatValue() < -0.01f)) continue;
            msg.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u62a5\u9500\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u7533\u8bf7\u91d1\u989d\u3002", (String)"MarketCostReimburseSubmitOp_2", (String)"occ-ocmem-opplugin", (Object[])new Object[0]), i + 1));
        }
        BigDecimal borrowSum = BigDecimal.ZERO;
        if (dynamicObject.getDataEntityType().getProperties().containsKey((Object)"offsetborrow")) {
            DynamicObjectCollection offsetEntrys = dynamicObject.getDynamicObjectCollection("offsetborrow");
            for (int i = 0; i < offsetEntrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)offsetEntrys.get(i);
                if (entry.getBigDecimal("offsetamt").compareTo(entry.getBigDecimal("brwamt")) <= 0) continue;
                msg.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u51b2\u9500\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u501f\u6b3e\u91d1\u989d\u3002", (String)"MarketCostReimburseSubmitOp_3", (String)"occ-ocmem-opplugin", (Object[])new Object[0]), i + 1));
                borrowSum = BigDecimalUtil.addObject((Object)borrowSum, (Object)entry.getBigDecimal("offsetamt"));
            }
        }
        DynamicObjectCollection dynReceivables = (DynamicObjectCollection)dynamicObject.get("receivable");
        BigDecimal receiveSum = BigDecimal.ZERO;
        if (dynReceivables != null && dynReceivables.size() != 0) {
            BigDecimal totalamount;
            int rowCount = dynReceivables.size();
            for (int i = 0; i < rowCount; ++i) {
                DynamicObject dyn = (DynamicObject)dynReceivables.get(i);
                BigDecimal val = dyn.getBigDecimal("receivableamt");
                receiveSum = receiveSum.add(val == null ? BigDecimal.ZERO : val);
            }
            BigDecimal sum = receiveSum.add(borrowSum);
            BigDecimal bigDecimal = totalamount = dynamicObject.getBigDecimal("totalamtapproved") == null ? BigDecimal.ZERO : dynamicObject.getBigDecimal("totalamtapproved");
            if (totalamount.compareTo(sum) != 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6536\u6b3e\u91d1\u989d\u5408\u8ba1\u4e0e\u51b2\u9500\u91d1\u989d\u5408\u8ba1\u4e4b\u548c\u5fc5\u987b\u7b49\u4e8e\u6838\u51c6\u91d1\u989d\u5408\u8ba1\u3002", (String)"MarketCostReimburseSubmitOp_4", (String)"occ-ocmem-opplugin", (Object[])new Object[0]));
            }
        }
        if ((dynObj = dynamicObject).getDynamicObjectCollection("entrys") == null && dynObj.getDynamicObjectCollection("entrys").size() == 0) {
            this.logger.info(dynObj.getString("billno") + " entrys is null.");
            return;
        }
        DynamicObjectCollection entryColl = dynObj.getDynamicObjectCollection("entrys");
        if (entryColl == null || entryColl.size() < 1) {
            this.logger.info(dynObj.getString("billno") + " entrys is empty.");
            return;
        }
        Object applyBillId = ((DynamicObject)entryColl.get(0)).get("sourceid");
        if (applyBillId == null || StringUtils.isEmpty((String)applyBillId.toString()) || "0".equals(applyBillId.toString())) {
            this.logger.info(dynObj.getString("billno") + " applyBillId is null.");
            return;
        }
        StringBuilder selector = new StringBuilder();
        selector.append("id,");
        selector.append("totalamtapply,");
        selector.append("totalamount,");
        selector.append("totalamtunapproved,");
        selector.append("entrys,");
        selector.append("entrys.id,");
        selector.append("entrys.sourceentryid,");
        selector.append("entrys.sourceid,");
        selector.append("entrys.amount,");
        selector.append("entrys.amtapproved,");
        selector.append("entrys.amtunapproved");
        QFilter filters = new QFilter("entrys.sourceid", "=", applyBillId);
        filters.and("billstatus", "!=", (Object)BizBillStatusEnum.AUDITNOPASS.getValue());
        if (dynObj.getPkValue() != null) {
            filters.and("id", "!=", dynObj.getPkValue());
        }
        DynamicObject[] reimburseDyns = BusinessDataServiceHelper.load((String)dynObj.getDataEntityType().getName(), (String)selector.toString(), (QFilter[])filters.toArray());
        HashMap<String, BigDecimal> applyEntryValMap = new HashMap<String, BigDecimal>();
        if (reimburseDyns != null && reimburseDyns.length != 0) {
            this.logger.info(dynObj.getString("billno") + " reimbursopp is" + reimburseDyns.length);
            for (int t = 0; t < reimburseDyns.length; ++t) {
                DynamicObject dynInfo = reimburseDyns[t];
                this.addEnryToMap(applyEntryValMap, dynInfo);
            }
        } else {
            this.logger.info(dynObj.getString("billno") + " reimbursopp is empty");
        }
        this.addEnryToMap(applyEntryValMap, dynObj);
        DynamicObject applyBill = BusinessDataServiceHelper.loadSingle((Object)applyBillId, (String)"ocmem_marketcost_apply");
        if (applyBill != null) {
            DynamicObjectCollection applyEntrys = (DynamicObjectCollection)applyBill.get("entryentity");
            for (int t = 0; t < applyEntrys.size(); ++t) {
                BigDecimal applyEntryVal;
                DynamicObject entry = (DynamicObject)applyEntrys.get(t);
                Object entryId = entry.getPkValue();
                BigDecimal amount = entry.getBigDecimal("amount");
                BigDecimal dif = BigDecimalUtil.subtractObject((Object)amount, (Object)(applyEntryVal = (BigDecimal)applyEntryValMap.get(entryId.toString())));
                if (dif == null || !(dif.floatValue() < -0.01f)) continue;
                msg.append(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u540e\uff0c\u5355\u636e\u7f16\u53f7\u4e3a\uff1a%1$s\u7684\u7b2c%2$s\u884c\u7684\u7d2f\u8ba1\u751f\u6210\u751f\u6210\u7684\u5e02\u573a\u8d39\u7528\u62a5\u9500\u5355\u91d1\u989d%3$s\u5927\u4e8e\u5e02\u573a\u8d39\u7528\u7533\u8bf7\u5355\u91d1\u989d%4$s", (String)"MarketCostReimburseSubmitOp_5", (String)"occ-ocmem-opplugin", (Object[])new Object[0]), applyBill.getString("billno"), t + 1, BigDecimalUtil.setScale((Object)applyEntryVal), BigDecimalUtil.setScale((Object)amount)));
            }
        }
        if (msg.length() > 0) {
            throw new KDBizException(msg.toString());
        }
    }

    protected void addEnryToMap(Map<String, BigDecimal> applyEntryValMap, DynamicObject dynInfo) {
        DynamicObjectCollection entrys = (DynamicObjectCollection)dynInfo.get("entrys");
        if (entrys != null) {
            for (int j = 0; j < entrys.size(); ++j) {
                DynamicObject entry = (DynamicObject)entrys.get(j);
                Object applyentryid = entry.get("sourceentryid");
                if (applyentryid == null) continue;
                BigDecimal amtapproved = entry.getBigDecimal("amtapproved") == null ? BigDecimal.ZERO : entry.getBigDecimal("amtapproved");
                String mapKey2 = applyentryid.toString();
                if (applyEntryValMap.get(mapKey2) != null) {
                    applyEntryValMap.put(mapKey2, BigDecimalUtil.addObject((Object)applyEntryValMap.get(mapKey2), (Object)amtapproved));
                    continue;
                }
                applyEntryValMap.put(mapKey2, amtapproved);
            }
        }
    }
}

