/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.opplugin.expensebudget.validator;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.model.CheckResult;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ocbase.common.validator.BatchFastValidator;
import kd.occ.ocmem.business.budgetcosts.AssignBudgetHelper;

public class AssignBudgetOpValidator
extends BatchFastValidator {
    public void save(ExtendedDataEntity[] datas) {
        CheckResult result = null;
        for (ExtendedDataEntity data : datas) {
            DynamicObject billDynObj = data.getDataEntity();
            result = this.billCommonCheck(billDynObj);
            if (result.isSuccess()) continue;
            this.addErrorMessage(data, result.getMsg());
        }
    }

    public void submit(ExtendedDataEntity[] datas) {
        if (this.isFromListPage()) {
            return;
        }
        CheckResult result = null;
        for (ExtendedDataEntity data : datas) {
            DynamicObject billDynObj = data.getDataEntity();
            result = this.billCommonCheck(billDynObj);
            if (result.isSuccess()) continue;
            this.addErrorMessage(data, result.getMsg());
        }
    }

    private CheckResult billCommonCheck(DynamicObject billDynObj) {
        StringBuilder msgStrBuff = new StringBuilder();
        BigDecimal beforeSumAsnAmount = billDynObj.getBigDecimal("beforesumasnamount");
        DynamicObjectCollection entryColl = billDynObj.getDynamicObjectCollection("entryentity");
        BigDecimal sumAssignAmount = entryColl.stream().map(obj -> obj.getBigDecimal("assignamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal differentAmount = sumAssignAmount.subtract(beforeSumAsnAmount);
        QFilter filter = new QFilter("billno", "=", (Object)billDynObj.getString("budgetbillno"));
        DynamicObject expenseBudget = BusinessDataServiceHelper.loadSingle((String)"ocmem_expensebudget", (String)StringUtils.join((CharSequence)",", (Object[])new Object[]{"availableamount", "id"}), (QFilter[])filter.toArray());
        BigDecimal availableAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)expenseBudget, (String)"availableamount");
        if ("1".equals(billDynObj.getString("sourcetype")) && availableAmount.subtract(differentAmount).compareTo(BigDecimal.ZERO) < 0) {
            msgStrBuff.append(ResManager.loadKDString((String)"\u5206\u914d\u91d1\u989d\u4e4b\u548c\u4e0d\u80fd\u5927\u4e8e\u53ef\u5206\u914d\u4f59\u989d\u3002", (String)"AssignBudgetOpValidator_0", (String)"occ-ocmem-opplugin", (Object[])new Object[0]));
        } else {
            String msg = this.verifyBudgetBalanceUnique(billDynObj, entryColl);
            if (StringUtils.isNotEmpty((String)msg)) {
                msgStrBuff.append(msg);
            }
        }
        if (msgStrBuff.length() > 0) {
            return CheckResult.returnFalse((String)msgStrBuff.toString());
        }
        return CheckResult.returnTrue();
    }

    private String verifyBudgetBalanceUnique(DynamicObject billDynObj, DynamicObjectCollection entryColl) {
        List channelIdList;
        List expensetypeIdList;
        StringBuilder msgStrBuff = new StringBuilder();
        List orgIdList = entryColl.stream().map(dynObj -> DynamicObjectUtils.getPkValue((DynamicObject)dynObj, (String)"assignorgid")).collect(Collectors.toList());
        List budgetBalanceDynObjList = AssignBudgetHelper.queryBudgetBalanceDynObj(orgIdList, expensetypeIdList = entryColl.stream().map(dynObj -> DynamicObjectUtils.getPkValue((DynamicObject)dynObj, (String)"assignexpensetypeid")).collect(Collectors.toList()), channelIdList = entryColl.stream().map(dynObj -> DynamicObjectUtils.getPkValue((DynamicObject)dynObj, (String)"assignchannelid")).collect(Collectors.toList()));
        if (CommonUtils.isNull((Object)budgetBalanceDynObjList)) {
            return msgStrBuff.toString();
        }
        Map<String, List<DynamicObject>> budgetBalanceDynObjMap = budgetBalanceDynObjList.stream().collect(Collectors.groupingBy(dynObj -> this.getKeyString(DynamicObjectUtils.getPkValue((DynamicObject)dynObj, (String)"org"), DynamicObjectUtils.getPkValue((DynamicObject)dynObj, (String)"feetype"), DynamicObjectUtils.getPkValue((DynamicObject)dynObj, (String)"channel"))));
        for (DynamicObject entryDynObj : entryColl) {
            long budgetYearId;
            List balanceYearList;
            String key = this.getKeyString(DynamicObjectUtils.getPkValue((DynamicObject)entryDynObj, (String)"assignorgid"), DynamicObjectUtils.getPkValue((DynamicObject)entryDynObj, (String)"assignexpensetypeid"), DynamicObjectUtils.getPkValue((DynamicObject)entryDynObj, (String)"assignchannelid"));
            List<DynamicObject> list = budgetBalanceDynObjMap.get(key);
            if (list == null || list.size() <= 0 || !(balanceYearList = list.stream().map(dynObj -> DynamicObjectUtils.getPkValue((DynamicObject)dynObj, (String)"budgetyear")).collect(Collectors.toList())).contains(budgetYearId = DynamicObjectUtils.getPkValue((DynamicObject)billDynObj, (String)"budgetyear"))) continue;
            msgStrBuff.append(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u884c%1$s\u4e2d\u7684\u5e74\u5ea6%2$s\u3001\u7ec4\u7ec7%3$s\u3001\u8d39\u7528\u7c7b\u578b%4$s\u3001\u6e20\u9053%5$s\u7684\u9884\u7b97\u4f59\u989d\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u5206\u914d\uff0c\u8bf7\u4f7f\u7528\u9884\u7b97\u8c03\u6574\u3002", (String)"AssignBudgetOpValidator_1", (String)"occ-ocmem-opplugin", (Object[])new Object[0]), entryDynObj.getInt("seq"), DynamicObjectUtils.getString((DynamicObject)billDynObj.getDynamicObject("budgetyear"), (String)"name"), DynamicObjectUtils.getString((DynamicObject)entryDynObj.getDynamicObject("assignorgid"), (String)"name"), DynamicObjectUtils.getString((DynamicObject)entryDynObj.getDynamicObject("assignexpensetypeid"), (String)"name"), DynamicObjectUtils.getString((DynamicObject)entryDynObj.getDynamicObject("assignchannelid"), (String)"name")));
        }
        return msgStrBuff.toString();
    }

    private String getKeyString(long orgId, long expensetypeId, long channelId) {
        return StringUtils.join((CharSequence)"_", (Object[])new Object[]{orgId, expensetypeId, channelId});
    }
}

