/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.opplugin.rule.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.pagemodel.ocmem.OcmemRollRateRule;
import kd.occ.ocbase.common.util.CollectionUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;

public class RollRateRuleValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] datas;
        for (ExtendedDataEntity data : datas = this.getDataEntities()) {
            this.checkMustInput(data, data.getDataEntity());
            this.checkUnique(data, data.getDataEntity());
        }
    }

    private void checkMustInput(ExtendedDataEntity data, DynamicObject rollRateRule) {
        DynamicObjectCollection channelDetail;
        String channelRange;
        DynamicObjectCollection orgDetail;
        String rateSetting = DynamicObjectUtils.getString((DynamicObject)rollRateRule, (String)"ratesetting");
        if ("A".equalsIgnoreCase(rateSetting)) {
            if (DynamicObjectUtils.getDynamicObject((DynamicObject)rollRateRule, (String)"itemid") == null) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5f53\u8d39\u7387\u8bbe\u7f6e\u65b9\u6848\u4e3a\u5546\u54c1\u65f6\uff0c\u8bf7\u9009\u62e9\u5bf9\u5e94\u5546\u54c1\u3002", (String)"RollRateRuleValidator_1", (String)"occ-ocmem-opplugin", (Object[])new Object[0]));
            }
        } else if ("B".equalsIgnoreCase(rateSetting) && DynamicObjectUtils.getDynamicObject((DynamicObject)rollRateRule, (String)"itemclass") == null) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u5f53\u8d39\u7387\u8bbe\u7f6e\u65b9\u6848\u4e3a\u5546\u54c1\u5206\u7c7b\u65f6\uff0c\u8bf7\u9009\u62e9\u5bf9\u5e94\u5546\u54c1\u5206\u7c7b\u3002", (String)"RollRateRuleValidator_2", (String)"occ-ocmem-opplugin", (Object[])new Object[0]));
        }
        if ("B".equalsIgnoreCase(DynamicObjectUtils.getString((DynamicObject)rollRateRule, (String)"userange")) && CollectionUtil.isNull((List)(orgDetail = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)rollRateRule, (String)"useorgentity")))) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u5f53\u65b9\u6848\u9002\u7528\u8303\u56f4\u4e3a\u6307\u5b9a\u9002\u7528\u7ec4\u7ec7\u65f6\uff0c\u8bf7\u586b\u5199\u9002\u7528\u7ec4\u7ec7\u5206\u5f55\u3002", (String)"RollRateRuleValidator_3", (String)"occ-ocmem-opplugin", (Object[])new Object[0]));
        }
        if ("B".equalsIgnoreCase(channelRange = DynamicObjectUtils.getString((DynamicObject)rollRateRule, (String)"channelrange"))) {
            DynamicObjectCollection channelTypeDetail = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)rollRateRule, (String)"channeltype");
            if (CollectionUtil.isNull((List)channelTypeDetail)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5f53\u9002\u7528\u6e20\u9053\u8303\u56f4\u4e3a\u6307\u5b9a\u9002\u7528\u7c7b\u578b\u65f6\uff0c\u8bf7\u9009\u62e9\u5bf9\u5e94\u7684\u6e20\u9053\u7c7b\u578b\u3002", (String)"RollRateRuleValidator_4", (String)"occ-ocmem-opplugin", (Object[])new Object[0]));
            }
        } else if ("C".equalsIgnoreCase(channelRange) && CollectionUtil.isNull((List)(channelDetail = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)rollRateRule, (String)"channelentity")))) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u5f53\u9002\u7528\u6e20\u9053\u8303\u56f4\u4e3a\u6307\u5b9a\u6e20\u9053\u65f6\uff0c\u8bf7\u586b\u5199\u9002\u7528\u6e20\u9053\u5206\u5f55\u3002", (String)"RollRateRuleValidator_5", (String)"occ-ocmem-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkUnique(ExtendedDataEntity data, DynamicObject rollRateRule) {
        QFilter filter = new QFilter("id", "!=", rollRateRule.getPkValue());
        filter.and(this.buildItemFilter(rollRateRule));
        filter.and(this.buildOrgFilter(rollRateRule));
        filter.and(this.buildChannelFilter(rollRateRule));
        filter.and(this.buildExpenseTypeFilter(rollRateRule));
        DynamicObject[] result = BusinessDataServiceHelper.load((String)"ocmem_rollraterule", (String)"id", (QFilter[])filter.toArray());
        if (result != null && result.length > 0) {
            this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u53d8\u52a8\u8d39\u7387\u89c4\u5219\u7684\u65b9\u6848\u9002\u7528\u8303\u56f4/\u9002\u7528\u6e20\u9053\u8303\u56f4/\u5546\u54c1/\u5206\u7c7b/\u8d39\u7528\u7c7b\u578b\u5206\u914d\u6bd4\u4f8b\u5b58\u5728\u91cd\u590d\u5b9a\u4e49\uff0c\u5173\u8054\u89c4\u5219\u7f16\u53f7\u4e3a%1$s\uff0c\u8bf7\u5148\u8fdb\u884c\u4fee\u6539\u3002", (String)"RollRateRuleValidator_6", (String)"occ-ocmem-opplugin", (Object[])new Object[0]), result[0].getString("number")));
        }
    }

    private QFilter buildItemFilter(DynamicObject rollRateRule) {
        String rateSetting = DynamicObjectUtils.getString((DynamicObject)rollRateRule, (String)"ratesetting");
        QFilter filter = new QFilter("ratesetting", "=", (Object)rateSetting);
        if ("A".equalsIgnoreCase(rateSetting)) {
            filter.and("itemid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)rollRateRule, (String)"itemid"));
        } else if ("B".equalsIgnoreCase(rateSetting)) {
            filter.and("itemclass", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)rollRateRule, (String)"itemclass"));
        }
        return filter;
    }

    private QFilter buildExpenseTypeFilter(DynamicObject rollRateRule) {
        DynamicObjectCollection expenseTypeList = rollRateRule.getDynamicObjectCollection("entryentity");
        return new QFilter(OcmemRollRateRule.EF_entry_expensetypeid, "in", this.getIdList(expenseTypeList, "expensetypeid"));
    }

    private QFilter buildOrgFilter(DynamicObject rollRateRule) {
        String useRange = DynamicObjectUtils.getString((DynamicObject)rollRateRule, (String)"userange");
        QFilter filter = new QFilter("userange", "=", (Object)useRange);
        if ("B".equalsIgnoreCase(useRange)) {
            DynamicObjectCollection orgDetail = rollRateRule.getDynamicObjectCollection("useorgentity");
            filter.and(OcmemRollRateRule.EF_useorgentity_useorg, "in", this.getIdList(orgDetail, "useorg"));
        }
        return filter;
    }

    private QFilter buildChannelFilter(DynamicObject rollRateRule) {
        String channelRange = DynamicObjectUtils.getString((DynamicObject)rollRateRule, (String)"channelrange");
        QFilter filter = new QFilter("channelrange", "=", (Object)channelRange);
        if ("B".equalsIgnoreCase(channelRange)) {
            DynamicObjectCollection channelTypeList = rollRateRule.getDynamicObjectCollection("channeltype");
            filter.and(OcmemRollRateRule.F_channeltype_basedataid, "in", (Object)DynamicObjectUtils.getBaseDataIds((DynamicObjectCollection)channelTypeList));
        } else if ("C".equalsIgnoreCase(channelRange)) {
            DynamicObjectCollection channelDetailList = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)rollRateRule, (String)"channelentity");
            filter.and(OcmemRollRateRule.EF_channelentity_channel, "in", this.getIdList(channelDetailList, "channel"));
        }
        return filter;
    }

    private List<Long> getIdList(DynamicObjectCollection collection, String colName) {
        ArrayList<Long> idList = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            return collection.stream().map(s -> s.getLong(colName + ".id")).collect(Collectors.toList());
        }
        return idList;
    }
}

