/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.business.adjustbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.constants.BigDecimalConstants;
import kd.occ.ocbase.common.pagemodel.OcdbdBudgetbalance;
import kd.occ.ocbase.common.pagemodel.ocmem.OcmemRollRateRule;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocmem.business.adjustbill.ScrollCalculateHelper;
import org.apache.commons.lang.StringUtils;

public class BudgetAdjustBillHelper {
    private BudgetAdjustBillHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DynamicObject> scrollCalculateExpenseBudget(DynamicObject adjustBillEntryDynObj, BigDecimal totalBudgetAmount, Date date) {
        ArrayList<DynamicObject> adjustBillEntryList = new ArrayList<DynamicObject>(30);
        long departmentId = DynamicObjectUtils.getPkValue((DynamicObject)adjustBillEntryDynObj, (String)"entryorg");
        if (totalBudgetAmount.compareTo(BigDecimal.ZERO) <= 0 || adjustBillEntryDynObj == null || departmentId == 0L) {
            return adjustBillEntryList;
        }
        try (DataSet dataSe1 = ScrollCalculateHelper.scrollCalculateExpenseRate(adjustBillEntryDynObj, totalBudgetAmount, date);){
            String rollRuleNumber = "";
            while (dataSe1.hasNext()) {
                Row balanceRow = dataSe1.next();
                if (StringUtils.isNotEmpty((String)rollRuleNumber) && !rollRuleNumber.equalsIgnoreCase(balanceRow.getString("number"))) {
                    break;
                }
                rollRuleNumber = balanceRow.getString("number");
                BigDecimal rollRate = balanceRow.getBigDecimal(OcdbdBudgetbalance.F_feetype_rollrate);
                if (rollRate == null || rollRate.compareTo(BigDecimal.ZERO) <= 0) continue;
                adjustBillEntryList.add(BudgetAdjustBillHelper.createAdjustBillEntry(adjustBillEntryDynObj, balanceRow, totalBudgetAmount));
            }
        }
        if (!CommonUtils.isNull(adjustBillEntryList)) {
            BusinessDataServiceHelper.loadRefence((Object[])adjustBillEntryList.toArray(), (IDataEntityType)((DynamicObject)adjustBillEntryList.get(0)).getDynamicObjectType());
        }
        return adjustBillEntryList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DynamicObject> scrollCalculateExpenseBudget(DynamicObject adjustBillEntryDynObj, BigDecimal totalBudgetAmount, long budgetYearId) {
        ArrayList<DynamicObject> adjustBillEntryList = new ArrayList<DynamicObject>(30);
        long departmentId = DynamicObjectUtils.getPkValue((DynamicObject)adjustBillEntryDynObj, (String)"entryorg");
        if (totalBudgetAmount.compareTo(BigDecimal.ZERO) <= 0 || adjustBillEntryDynObj == null || departmentId == 0L) {
            return adjustBillEntryList;
        }
        try (DataSet dataSe1 = ScrollCalculateHelper.scrollCalculateExpenseRate(adjustBillEntryDynObj, totalBudgetAmount, budgetYearId);){
            String rollRuleNumber = "";
            while (dataSe1.hasNext()) {
                Row balanceRow = dataSe1.next();
                if (StringUtils.isNotEmpty((String)rollRuleNumber) && !rollRuleNumber.equalsIgnoreCase(balanceRow.getString("number"))) {
                    break;
                }
                rollRuleNumber = balanceRow.getString("number");
                BigDecimal rollRate = balanceRow.getBigDecimal(OcdbdBudgetbalance.F_feetype_rollrate);
                if (rollRate == null || rollRate.compareTo(BigDecimal.ZERO) <= 0) continue;
                adjustBillEntryList.add(BudgetAdjustBillHelper.createAdjustBillEntry(adjustBillEntryDynObj, balanceRow, totalBudgetAmount));
            }
        }
        if (!CommonUtils.isNull(adjustBillEntryList)) {
            BusinessDataServiceHelper.loadRefence((Object[])adjustBillEntryList.toArray(), (IDataEntityType)((DynamicObject)adjustBillEntryList.get(0)).getDynamicObjectType());
        }
        return adjustBillEntryList;
    }

    private static DataSet getBudgetBalanceDataSetByRollRateRule(List<Long> orgParentIdList, long channelId, long itemId, Date date) {
        QFilter ruleItemFilter = new QFilter("itemid", "=", (Object)itemId);
        ruleItemFilter = ruleItemFilter.and(new QFilter("enable", "=", (Object)"1"));
        ruleItemFilter = ruleItemFilter.and(new QFilter("status", "=", (Object)"C"));
        DataSet rateRuleDataSet = QueryServiceHelper.queryDataSet((String)BudgetAdjustBillHelper.class.getName(), (String)"ocmem_rollraterule", (String)String.join((CharSequence)",", OcmemRollRateRule.EF_entry_orgpattern, OcmemRollRateRule.EF_entry_expensetypeid, OcmemRollRateRule.EF_entry_allocationrate), (QFilter[])ruleItemFilter.toArray(), null);
        DataSet dataSet = BudgetAdjustBillHelper.getBudgetBalanceDataSet(orgParentIdList, channelId, date);
        return dataSet.leftJoin(rateRuleDataSet).on(OcdbdBudgetbalance.F_org_orgpattern, OcmemRollRateRule.EF_entry_orgpattern).on("feetype", OcmemRollRateRule.EF_entry_expensetypeid).select(dataSet.getRowMeta().getFieldNames(), new String[]{OcmemRollRateRule.EF_entry_allocationrate + " " + OcdbdBudgetbalance.F_feetype_rollrate}).finish();
    }

    private static DataSet getBudgetBalanceDataSet(List<Long> orgParentIdList, long channelId, Date date) {
        HashSet<Long> channelIdSet = new HashSet<Long>(2);
        channelIdSet.add(channelId);
        channelIdSet.add(0L);
        String selectFields = String.join((CharSequence)",", "id", "parent", "number", "org", "channel", "availableamount", "currency", "feetype", OcdbdBudgetbalance.F_feetype_ifbudget, OcdbdBudgetbalance.F_feetype_control, OcdbdBudgetbalance.F_feetype_expensetype, OcdbdBudgetbalance.F_org_longnumber, OcdbdBudgetbalance.F_org_orgpattern);
        QFilter qFilter = new QFilter(OcdbdBudgetbalance.F_feetype_ifbudget, "=", (Object)"1");
        qFilter = qFilter.and(new QFilter(OcdbdBudgetbalance.F_feetype_expensetype, "in", (Object)new String[]{"B", "C"}));
        qFilter = qFilter.and(new QFilter(OcdbdBudgetbalance.F_feetype_status, "=", (Object)"C"));
        qFilter = qFilter.and(new QFilter(OcdbdBudgetbalance.F_feetype_enable, "=", (Object)"1"));
        qFilter = qFilter.and(new QFilter("channel", "in", channelIdSet));
        qFilter = qFilter.and(new QFilter("org", "in", orgParentIdList));
        qFilter = qFilter.and(new QFilter("year", ">=", (Object)DateUtil.getFirstDayOfYear((Date)date)));
        qFilter = qFilter.and(new QFilter("year", "<=", (Object)DateUtil.getLastDayOfYear((Date)date)));
        qFilter = qFilter.and(new QFilter("currency", "=", (Object)1L));
        qFilter = qFilter.and(new QFilter(OcdbdBudgetbalance.F_org_viewid, "=", (Object)1));
        return QueryServiceHelper.queryDataSet((String)BudgetAdjustBillHelper.class.getName(), (String)"ocdbd_budgetbalance", (String)selectFields, (QFilter[])qFilter.toArray(), null);
    }

    private static int getAmtPrecision(DynamicObject currencyDynObj) {
        int amountPrecision = 2;
        if (currencyDynObj != null) {
            amountPrecision = currencyDynObj.getInt("amtprecision");
        }
        return amountPrecision;
    }

    private static DynamicObject createAdjustBillEntry(DynamicObject adjustBillEntryDynObj, Row balanceRow, BigDecimal totalBudgetAmount) {
        DynamicObject addEntryDynObj = new DynamicObject(adjustBillEntryDynObj.getDynamicObjectType());
        DynamicObjectUtils.copyPropertiesWithOutId((DynamicObject)addEntryDynObj, (DynamicObject)adjustBillEntryDynObj);
        addEntryDynObj.set("entryorg", null);
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)addEntryDynObj, (String)"entryorg", (long)balanceRow.getLong("org"));
        addEntryDynObj.set("currency", null);
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)addEntryDynObj, (String)"currency", (long)balanceRow.getLong("currency"));
        addEntryDynObj.set("feetype", null);
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)addEntryDynObj, (String)"feetype", (long)balanceRow.getLong("feetype"));
        addEntryDynObj.set("channel", null);
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)addEntryDynObj, (String)"channel", (long)balanceRow.getLong("channel"));
        addEntryDynObj.set("budgetbalance", null);
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)addEntryDynObj, (String)"budgetbalance", (long)balanceRow.getLong("id"));
        addEntryDynObj.set("oldamount", (Object)balanceRow.getBigDecimal("availableamount"));
        int amountPrecision = BudgetAdjustBillHelper.getAmtPrecision(adjustBillEntryDynObj.getDynamicObject("currency"));
        BigDecimal adjustamount = totalBudgetAmount.multiply(balanceRow.getBigDecimal(OcdbdBudgetbalance.F_feetype_rollrate).divide(BigDecimalConstants.ONEHUNDRED)).setScale(amountPrecision, 4);
        addEntryDynObj.set("adjustamount", (Object)adjustamount);
        addEntryDynObj.set("newamount", (Object)adjustamount.add(addEntryDynObj.getBigDecimal("oldamount")));
        return addEntryDynObj;
    }
}

