/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.business.adjustbill;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.orm.query.QFilter;
import kd.occ.ocbase.common.pagemodel.OcdbdBudgetbalance;
import kd.occ.ocbase.common.pagemodel.ocmem.OcmemRollRateRule;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocmem.business.adjustbill.DataSetHepler;

public class DataSetFilter {
    private static final String USE_RANGE_ALL_ORG = "A";
    private static final String USE_RANGE_APPOINT_ORG = "B";
    private static final String CHANNELRANGE_CHANNEL_TYPE = "B";
    private static final String CHANNELRANGE_CHANNEL = "C";
    private static final String CHANNELRANGE_ALL_CHANNEL = "A";
    private static final String CHANNEL_TYPE_BASEDATAID = "channeltype.fbasedataid";
    private static final String RATESETTING_ITEM = "A";
    private static final String RATESETTING_ITEM_CLASS = "B";
    private static final String STATUS_AUDIT = "C";
    private static final String ENABLE_TRUE = "1";

    public static QFilter getItemAndAllOrgAndChlRangeFilter(long channelId, long itemId) {
        QFilter ruleFilter = DataSetFilter.buildItemRollRateRuleFilter(itemId);
        ruleFilter = ruleFilter.and("userange", "=", (Object)"A");
        ruleFilter = ruleFilter.and("channelrange", "=", (Object)"B");
        ruleFilter = ruleFilter.and(CHANNEL_TYPE_BASEDATAID, "in", (Object)DataSetHepler.getChannelTypeId(channelId));
        return ruleFilter;
    }

    public static QFilter getItemAndAllOrgAndChlDetailFilter(long channelId, long itemId) {
        QFilter ruleFilter = DataSetFilter.buildItemRollRateRuleFilter(itemId);
        ruleFilter = ruleFilter.and("userange", "=", (Object)"A");
        ruleFilter = ruleFilter.and("channelrange", "=", (Object)"C");
        ruleFilter = ruleFilter.and(OcmemRollRateRule.EF_channelentity_channel, "=", (Object)channelId);
        return ruleFilter;
    }

    public static QFilter getItemAndAllOrgAndAllChlRangeFilter(long itemId) {
        QFilter ruleFilter = DataSetFilter.buildItemRollRateRuleFilter(itemId);
        ruleFilter = ruleFilter.and("userange", "=", (Object)"A");
        ruleFilter = ruleFilter.and("channelrange", "=", (Object)"A");
        return ruleFilter;
    }

    public static QFilter getItemAndOrgAndChlRangeFilter(long orgId, long channelId, long itemId) {
        QFilter ruleFilter = DataSetFilter.buildItemRollRateRuleFilter(itemId);
        ruleFilter = ruleFilter.and("userange", "=", (Object)"B");
        ruleFilter = ruleFilter.and(OcmemRollRateRule.EF_useorgentity_useorg, "=", (Object)orgId);
        ruleFilter = ruleFilter.and("channelrange", "=", (Object)"B");
        ruleFilter = ruleFilter.and(CHANNEL_TYPE_BASEDATAID, "in", (Object)DataSetHepler.getChannelTypeId(channelId));
        return ruleFilter;
    }

    public static QFilter getItemAndOrgAndChlDetailFilter(long orgId, long channelId, long itemId) {
        QFilter ruleFilter = DataSetFilter.buildItemRollRateRuleFilter(itemId);
        ruleFilter = ruleFilter.and("userange", "=", (Object)"B");
        ruleFilter = ruleFilter.and(OcmemRollRateRule.EF_useorgentity_useorg, "=", (Object)orgId);
        ruleFilter = ruleFilter.and("channelrange", "=", (Object)"C");
        ruleFilter = ruleFilter.and(OcmemRollRateRule.EF_channelentity_channel, "=", (Object)channelId);
        return ruleFilter;
    }

    public static QFilter getItemAndOrgAndAllChlRangeFilter(long orgId, long itemId) {
        QFilter ruleFilter = DataSetFilter.buildItemRollRateRuleFilter(itemId);
        ruleFilter = ruleFilter.and("userange", "=", (Object)"B");
        ruleFilter = ruleFilter.and(OcmemRollRateRule.EF_useorgentity_useorg, "=", (Object)orgId);
        ruleFilter = ruleFilter.and("channelrange", "=", (Object)"A");
        return ruleFilter;
    }

    private static QFilter buildItemRollRateRuleFilter(long itemId) {
        QFilter ruleFilter = new QFilter("enable", "=", (Object)ENABLE_TRUE);
        ruleFilter = ruleFilter.and("status", "=", (Object)"C");
        ruleFilter = ruleFilter.and("ratesetting", "=", (Object)"A");
        ruleFilter = ruleFilter.and("itemid", "=", (Object)itemId);
        return ruleFilter;
    }

    private static QFilter buildItemClassRollRateRuleFilter(List<Long> itemClassIds) {
        QFilter ruleFilter = new QFilter("enable", "=", (Object)ENABLE_TRUE);
        ruleFilter = ruleFilter.and("status", "=", (Object)"C");
        ruleFilter = ruleFilter.and("ratesetting", "=", (Object)"B");
        ruleFilter = ruleFilter.and("itemclass", "in", itemClassIds);
        return ruleFilter;
    }

    public static QFilter getItemClassAndAllOrgAndChlDetailFilter(long channelId, List<Long> itemClassIds) {
        QFilter ruleFilter = DataSetFilter.buildItemClassRollRateRuleFilter(itemClassIds);
        ruleFilter = ruleFilter.and("userange", "=", (Object)"A");
        ruleFilter = ruleFilter.and("channelrange", "=", (Object)"C");
        ruleFilter = ruleFilter.and(OcmemRollRateRule.EF_channelentity_channel, "=", (Object)channelId);
        return ruleFilter;
    }

    public static QFilter getItemClassAndAllOrgAndChlRangeFilter(long channelId, List<Long> itemClassIds) {
        QFilter ruleFilter = DataSetFilter.buildItemClassRollRateRuleFilter(itemClassIds);
        ruleFilter = ruleFilter.and("userange", "=", (Object)"A");
        ruleFilter = ruleFilter.and("channelrange", "=", (Object)"B");
        ruleFilter = ruleFilter.and(CHANNEL_TYPE_BASEDATAID, "in", (Object)DataSetHepler.getChannelTypeId(channelId));
        return ruleFilter;
    }

    public static QFilter getItemClassAndAllOrgAndAllChlRangeFilter(List<Long> itemClassIds) {
        QFilter ruleFilter = DataSetFilter.buildItemClassRollRateRuleFilter(itemClassIds);
        ruleFilter = ruleFilter.and("userange", "=", (Object)"A");
        ruleFilter = ruleFilter.and("channelrange", "=", (Object)"A");
        return ruleFilter;
    }

    public static QFilter getItemClassAndOrgAndChlRangeFilter(long orgId, long channelId, List<Long> itemClassIds) {
        QFilter ruleFilter = DataSetFilter.buildItemClassRollRateRuleFilter(itemClassIds);
        ruleFilter = ruleFilter.and("userange", "=", (Object)"B");
        ruleFilter = ruleFilter.and(OcmemRollRateRule.EF_useorgentity_useorg, "=", (Object)orgId);
        ruleFilter = ruleFilter.and("channelrange", "=", (Object)"B");
        ruleFilter = ruleFilter.and(CHANNEL_TYPE_BASEDATAID, "in", (Object)DataSetHepler.getChannelTypeId(channelId));
        return ruleFilter;
    }

    public static QFilter getItemClassAndOrgAndChlDetailFilter(long orgId, long channelId, List<Long> itemClassIds) {
        QFilter ruleFilter = DataSetFilter.buildItemClassRollRateRuleFilter(itemClassIds);
        ruleFilter = ruleFilter.and("userange", "=", (Object)"B");
        ruleFilter = ruleFilter.and(OcmemRollRateRule.EF_useorgentity_useorg, "=", (Object)orgId);
        ruleFilter = ruleFilter.and("channelrange", "=", (Object)"C");
        ruleFilter = ruleFilter.and(OcmemRollRateRule.EF_channelentity_channel, "=", (Object)channelId);
        return ruleFilter;
    }

    public static QFilter getItemClassAndOrgAndAllChlRangeFilter(long orgId, List<Long> itemClassIds) {
        QFilter ruleFilter = DataSetFilter.buildItemClassRollRateRuleFilter(itemClassIds);
        ruleFilter = ruleFilter.and("userange", "=", (Object)"B");
        ruleFilter = ruleFilter.and(OcmemRollRateRule.EF_useorgentity_useorg, "=", (Object)orgId);
        ruleFilter = ruleFilter.and("channelrange", "=", (Object)"A");
        return ruleFilter;
    }

    public static QFilter buildBudgetBalanceFilter(List<Long> orgIdList, long channelId, Date date) {
        ArrayList<Long> channnelIdList = new ArrayList<Long>(2);
        channnelIdList.add(0L);
        channnelIdList.add(channelId);
        QFilter qFilter = new QFilter(OcdbdBudgetbalance.F_feetype_ifbudget, "=", (Object)ENABLE_TRUE);
        qFilter = qFilter.and(new QFilter(OcdbdBudgetbalance.F_feetype_expensetype, "in", (Object)new String[]{"B", "C"}));
        qFilter = qFilter.and(new QFilter(OcdbdBudgetbalance.F_feetype_status, "=", (Object)"C"));
        qFilter = qFilter.and(new QFilter(OcdbdBudgetbalance.F_feetype_enable, "=", (Object)ENABLE_TRUE));
        qFilter = qFilter.and(new QFilter("channel", "in", channnelIdList));
        qFilter = qFilter.and(new QFilter("org", "in", orgIdList));
        qFilter = qFilter.and(new QFilter(OcdbdBudgetbalance.F_org_viewid, "=", (Object)1));
        qFilter = qFilter.and(new QFilter("year", ">=", (Object)DateUtil.getFirstDayOfYear((Date)date)));
        qFilter = qFilter.and(new QFilter("year", "<=", (Object)DateUtil.getLastDayOfYear((Date)date)));
        qFilter = qFilter.and(new QFilter("currency", "=", (Object)1L));
        qFilter = qFilter.and(new QFilter("enable", "=", (Object)ENABLE_TRUE));
        return qFilter;
    }
}

