/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.business.adjustbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.occ.ocbase.common.pagemodel.OcdbdBudgetbalance;
import kd.occ.ocbase.common.pagemodel.ocmem.OcmemRollRateRule;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocmem.business.adjustbill.DataSetFilter;
import kd.occ.ocmem.business.adjustbill.DataSetHepler;

public class ScrollCalculateHelper {
    private static final String BUDGET_SELECT_FIELDS = String.join((CharSequence)",", "id", "parent", "org", "channel", "availableamount", "currency", "feetype", OcdbdBudgetbalance.F_feetype_ifbudget, OcdbdBudgetbalance.F_feetype_control, OcdbdBudgetbalance.F_feetype_expensetype, OcdbdBudgetbalance.F_org_longnumber, OcdbdBudgetbalance.F_org_orgpattern);
    private static final long RATE_SEQ_ITEM_APPOINT_ORG = 1472318748492065792L;
    private static final long RATE_SEQ_ITEM_ALL_ORG = 1472318814502022144L;
    private static final long RATE_SEQ_ITEMCLASS_ALL_ORG = 1472319009855801344L;
    private static final long RATE_SEQ_ITEMCLASS_APPOINT_ORG = 1472318901709867008L;

    public static DataSet scrollCalculateExpenseRate(DynamicObject adjustBillEntry, BigDecimal totalBudgetAmount, Date date) {
        long itemId = DynamicObjectUtils.getPkValue((DynamicObject)adjustBillEntry, (String)"feetype");
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)adjustBillEntry, (String)"entryorg");
        long channelId = DynamicObjectUtils.getPkValue((DynamicObject)adjustBillEntry, (String)"channel");
        DataSet rateRuleDataSet = ScrollCalculateHelper.getAllRuleDataSet(orgId, channelId, itemId);
        DataSet budgetBalanceData = ScrollCalculateHelper.getBudgetBalanceDataSet(orgId, channelId, date);
        DataSet resultSet = budgetBalanceData.leftJoin(rateRuleDataSet).on(OcdbdBudgetbalance.F_org_orgpattern, OcmemRollRateRule.EF_entry_orgpattern).on("feetype", OcmemRollRateRule.EF_entry_expensetypeid).select(budgetBalanceData.getRowMeta().getFieldNames(), new String[]{OcmemRollRateRule.EF_entry_allocationrate + " " + OcdbdBudgetbalance.F_feetype_rollrate, "number"}).finish();
        DataSet resultCopy1 = resultSet.copy();
        resultCopy1 = resultCopy1.where(OcdbdBudgetbalance.F_feetype_control + " like '%,2,%' AND " + "channel" + "=" + channelId);
        DataSet resultCopy2 = resultSet.copy();
        resultCopy2 = resultCopy2.where(OcdbdBudgetbalance.F_feetype_control + " not like '%,2,%' AND " + "channel" + "=" + 0);
        if (resultCopy1.hasNext()) {
            resultCopy2 = resultCopy1.union(resultCopy2);
        }
        resultCopy1.close();
        return resultCopy2.orderBy(new String[]{"number desc"});
    }

    public static DataSet scrollCalculateExpenseRate(DynamicObject adjustBillEntry, BigDecimal totalBudgetAmount, long budgetYearId) {
        long itemId = DynamicObjectUtils.getPkValue((DynamicObject)adjustBillEntry, (String)"feetype");
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)adjustBillEntry, (String)"entryorg");
        long channelId = DynamicObjectUtils.getPkValue((DynamicObject)adjustBillEntry, (String)"channel");
        DataSet rateRuleDataSet = ScrollCalculateHelper.getAllRuleDataSet(orgId, channelId, itemId);
        DataSet budgetBalanceData = ScrollCalculateHelper.getBudgetBalanceDataSet(orgId, channelId, budgetYearId);
        DataSet resultSet = budgetBalanceData.leftJoin(rateRuleDataSet).on(OcdbdBudgetbalance.F_org_orgpattern, OcmemRollRateRule.EF_entry_orgpattern).on("feetype", OcmemRollRateRule.EF_entry_expensetypeid).select(budgetBalanceData.getRowMeta().getFieldNames(), new String[]{OcmemRollRateRule.EF_entry_allocationrate + " " + OcdbdBudgetbalance.F_feetype_rollrate, "number"}).finish();
        DataSet resultCopy1 = resultSet.copy();
        resultCopy1 = resultCopy1.where(OcdbdBudgetbalance.F_feetype_control + " like '%,2,%' AND " + "channel" + "=" + channelId);
        DataSet resultCopy2 = resultSet.copy();
        resultCopy2 = resultCopy2.where(OcdbdBudgetbalance.F_feetype_control + " not like '%,2,%' AND " + "channel" + "=" + 0);
        if (resultCopy1.hasNext()) {
            resultCopy2 = resultCopy1.union(resultCopy2);
        }
        resultCopy1.close();
        return resultCopy2.orderBy(new String[]{"number desc"});
    }

    private static DataSet getItemAndOrgAndChlDetailRange(long orgId, long channelId, long itemId) {
        QFilter ruleFilter = DataSetFilter.getItemAndOrgAndChlDetailFilter(orgId, channelId, itemId);
        return DataSetHepler.getQueryRollRateDataSet(ruleFilter);
    }

    private static DataSet getItemAndAllOrgAndChlDetailRange(long channelId, long itemId) {
        QFilter ruleFilter = DataSetFilter.getItemAndAllOrgAndChlDetailFilter(channelId, itemId);
        return DataSetHepler.getQueryRollRateDataSet(ruleFilter);
    }

    private static DataSet getItemAndAllOrgAndChlRange(long channelId, long itemId) {
        QFilter ruleFilter = DataSetFilter.getItemAndAllOrgAndChlRangeFilter(channelId, itemId);
        return DataSetHepler.getQueryRollRateDataSet(ruleFilter);
    }

    private static DataSet getItemAndAllOrgAndAllChlRange(long itemId) {
        QFilter ruleFilter = DataSetFilter.getItemAndAllOrgAndAllChlRangeFilter(itemId);
        return DataSetHepler.getQueryRollRateDataSet(ruleFilter);
    }

    private static DataSet getItemAndOrgAndAllChlRange(long orgId, long itemId) {
        QFilter ruleFilter = DataSetFilter.getItemAndOrgAndAllChlRangeFilter(orgId, itemId);
        return DataSetHepler.getQueryRollRateDataSet(ruleFilter);
    }

    private static DataSet getItemAndOrgAndChlRange(long orgId, long channelId, long itemId) {
        QFilter ruleFilter = DataSetFilter.getItemAndOrgAndChlRangeFilter(orgId, channelId, itemId);
        return DataSetHepler.getQueryRollRateDataSet(ruleFilter);
    }

    private static DataSet getAllRuleDataSet(long orgId, long channelId, long itemId) {
        LinkedHashMap<Long, DynamicObject> ruleSeqMap = ScrollCalculateHelper.queryRuleSeqInfoMap();
        List<Long> itemClassIds = DataSetHepler.getItemClassIdList(itemId);
        for (Map.Entry<Long, DynamicObject> entry : ruleSeqMap.entrySet()) {
            DataSet dataSetResult1 = null;
            DataSet dataSetResult2 = null;
            DataSet dataSetResult3 = null;
            if (1472319009855801344L == entry.getKey()) {
                dataSetResult1 = ScrollCalculateHelper.getItemClassAndAllOrgAndAllChlRange(itemClassIds);
                dataSetResult2 = ScrollCalculateHelper.getItemClassAndAllOrgAndChlRange(channelId, itemClassIds);
                dataSetResult3 = ScrollCalculateHelper.getItemClassAndAllOrgAndChlDetailRange(channelId, itemClassIds);
            } else if (1472318901709867008L == entry.getKey()) {
                dataSetResult1 = ScrollCalculateHelper.getItemClassAndOrgAndAllChlRange(orgId, itemClassIds);
                dataSetResult2 = ScrollCalculateHelper.getItemClassAndOrgAndChlRange(orgId, channelId, itemClassIds);
                dataSetResult3 = ScrollCalculateHelper.getItemClassAndOrgAndChlDetailRange(orgId, channelId, itemClassIds);
            } else if (1472318748492065792L == entry.getKey()) {
                dataSetResult1 = ScrollCalculateHelper.getItemAndOrgAndAllChlRange(orgId, itemId);
                dataSetResult2 = ScrollCalculateHelper.getItemAndOrgAndChlRange(orgId, channelId, itemId);
                dataSetResult3 = ScrollCalculateHelper.getItemAndOrgAndChlDetailRange(orgId, channelId, itemId);
            } else if (1472318814502022144L == entry.getKey()) {
                dataSetResult1 = ScrollCalculateHelper.getItemAndAllOrgAndAllChlRange(itemId);
                dataSetResult2 = ScrollCalculateHelper.getItemAndAllOrgAndChlRange(channelId, itemId);
                dataSetResult3 = ScrollCalculateHelper.getItemAndAllOrgAndChlDetailRange(channelId, itemId);
            }
            if (dataSetResult3 != null && dataSetResult3.hasNext()) {
                return dataSetResult3;
            }
            if (dataSetResult2 != null && dataSetResult2.hasNext()) {
                return dataSetResult2;
            }
            if (dataSetResult1 == null || !dataSetResult1.hasNext()) continue;
            return dataSetResult1;
        }
        return DataSetHepler.getQueryRollRateDataSet(new QFilter("1", "!=", (Object)1));
    }

    private static LinkedHashMap<Long, DynamicObject> queryRuleSeqInfoMap() {
        ArrayList<Long> ids = new ArrayList<Long>(4);
        ids.add(1472319009855801344L);
        ids.add(1472318901709867008L);
        ids.add(1472318748492065792L);
        ids.add(1472318814502022144L);
        QFilter filter = new QFilter("id", "in", ids);
        filter.and("enable", "=", (Object)"1");
        DynamicObject[] resultList = BusinessDataServiceHelper.load((String)"ocmem_rateseq", (String)"id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,rateseq,issyspreset", (QFilter[])filter.toArray(), (String)"rateseq");
        LinkedHashMap<Long, DynamicObject> resultMap = new LinkedHashMap<Long, DynamicObject>(4);
        for (DynamicObject result : resultList) {
            resultMap.put(DynamicObjectUtils.getPkValue((DynamicObject)result), result);
        }
        return resultMap;
    }

    private static DataSet getItemClassAndOrgAndChlDetailRange(long orgId, long channelId, List<Long> itemClassIds) {
        QFilter ruleFilter = DataSetFilter.getItemClassAndOrgAndChlDetailFilter(orgId, channelId, itemClassIds);
        return DataSetHepler.getQueryRollRateDataSet(ruleFilter);
    }

    private static DataSet getItemClassAndAllOrgAndChlDetailRange(long channelId, List<Long> itemClassIds) {
        QFilter ruleFilter = DataSetFilter.getItemClassAndAllOrgAndChlDetailFilter(channelId, itemClassIds);
        return DataSetHepler.getQueryRollRateDataSet(ruleFilter);
    }

    private static DataSet getItemClassAndAllOrgAndChlRange(long channelId, List<Long> itemClassIds) {
        QFilter ruleFilter = DataSetFilter.getItemClassAndAllOrgAndChlRangeFilter(channelId, itemClassIds);
        return DataSetHepler.getQueryRollRateDataSet(ruleFilter);
    }

    private static DataSet getItemClassAndAllOrgAndAllChlRange(List<Long> itemClassIds) {
        QFilter ruleFilter = DataSetFilter.getItemClassAndAllOrgAndAllChlRangeFilter(itemClassIds);
        return DataSetHepler.getQueryRollRateDataSet(ruleFilter);
    }

    private static DataSet getItemClassAndOrgAndAllChlRange(long orgId, List<Long> itemClassIds) {
        QFilter ruleFilter = DataSetFilter.getItemClassAndOrgAndAllChlRangeFilter(orgId, itemClassIds);
        return DataSetHepler.getQueryRollRateDataSet(ruleFilter);
    }

    private static DataSet getItemClassAndOrgAndChlRange(long orgId, long channelId, List<Long> itemClassIds) {
        QFilter ruleFilter = DataSetFilter.getItemClassAndOrgAndChlRangeFilter(orgId, channelId, itemClassIds);
        return DataSetHepler.getQueryRollRateDataSet(ruleFilter);
    }

    private static DataSet getBudgetBalanceDataSet(long orgId, long channelId, Date date) {
        List orgParentIdList = OrgUnitServiceHelper.getAllSuperiorOrgs((String)"01", (long)orgId);
        orgParentIdList.add(orgId);
        QFilter qFilter = DataSetFilter.buildBudgetBalanceFilter(orgParentIdList, channelId, date);
        return QueryServiceHelper.queryDataSet((String)ScrollCalculateHelper.class.getName(), (String)"ocdbd_budgetbalance", (String)BUDGET_SELECT_FIELDS, (QFilter[])qFilter.toArray(), null);
    }

    private static DataSet getBudgetBalanceDataSet(long orgId, long channelId, long budgetYearId) {
        List orgParentIdList = OrgUnitServiceHelper.getAllSuperiorOrgs((String)"01", (long)orgId);
        orgParentIdList.add(orgId);
        QFilter qFilter = ScrollCalculateHelper.buildBudgetBalanceFilter(orgParentIdList, channelId, budgetYearId);
        return QueryServiceHelper.queryDataSet((String)ScrollCalculateHelper.class.getName(), (String)"ocdbd_budgetbalance", (String)BUDGET_SELECT_FIELDS, (QFilter[])qFilter.toArray(), null);
    }

    private static QFilter buildBudgetBalanceFilter(List<Long> orgIdList, long channelId, long budgetYearId) {
        ArrayList<Long> channnelIdList = new ArrayList<Long>(2);
        channnelIdList.add(0L);
        channnelIdList.add(channelId);
        QFilter qFilter = new QFilter(OcdbdBudgetbalance.F_feetype_ifbudget, "=", (Object)"1");
        qFilter = qFilter.and(new QFilter(OcdbdBudgetbalance.F_feetype_expensetype, "in", (Object)new String[]{"B", "C"}));
        qFilter = qFilter.and(new QFilter(OcdbdBudgetbalance.F_feetype_status, "=", (Object)"C"));
        qFilter = qFilter.and(new QFilter(OcdbdBudgetbalance.F_feetype_enable, "=", (Object)"1"));
        qFilter = qFilter.and(new QFilter("channel", "in", channnelIdList));
        qFilter = qFilter.and(new QFilter("org", "in", orgIdList));
        qFilter = qFilter.and(new QFilter(OcdbdBudgetbalance.F_org_viewid, "=", (Object)1));
        qFilter = qFilter.and(new QFilter("budgetyear", "=", (Object)budgetYearId));
        qFilter = qFilter.and(new QFilter("currency", "=", (Object)1L));
        qFilter = qFilter.and(new QFilter("enable", "=", (Object)"1"));
        return qFilter;
    }
}

