/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.business.budgetcosts;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.entity.BudgetCosts;
import kd.occ.ocbase.common.enums.StatusEnum;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocmem.business.budgetcosts.BudgetCostsServiceImpl;
import kd.occ.ocmem.business.budgetcosts.BudgetCostsUpdateHelper;

public class AssignBudgetHelper {
    public static void createExpenseBudgetBill(List<DynamicObject> assignBudgetDynObjList) {
        if (CommonUtils.isNull(assignBudgetDynObjList)) {
            return;
        }
        ArrayList<DynamicObject> saveDynObjList = new ArrayList<DynamicObject>(10);
        for (DynamicObject billDynObj : assignBudgetDynObjList) {
            DynamicObjectCollection entryColl = billDynObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryDynObj : entryColl) {
                DynamicObject expenseBudgetDynObj = BusinessDataServiceHelper.newDynamicObject((String)"ocmem_expensebudget");
                expenseBudgetDynObj.set("year", (Object)billDynObj.getDate("year"));
                expenseBudgetDynObj.set("budgetyear", (Object)DynamicObjectUtils.getPkValue((DynamicObject)billDynObj, (String)"budgetyear"));
                expenseBudgetDynObj.set("billstatus", (Object)StatusEnum.DRAFT.getValue());
                expenseBudgetDynObj.set("orgid", (Object)DynamicObjectUtils.getPkValue((DynamicObject)entryDynObj.getDynamicObject("assignorgid")));
                expenseBudgetDynObj.set("expensetypeid", (Object)DynamicObjectUtils.getPkValue((DynamicObject)entryDynObj.getDynamicObject("assignexpensetypeid")));
                expenseBudgetDynObj.set("channelid", (Object)DynamicObjectUtils.getPkValue((DynamicObject)entryDynObj.getDynamicObject("assignchannelid")));
                expenseBudgetDynObj.set("currencyid", (Object)DynamicObjectUtils.getPkValue((DynamicObject)billDynObj, (String)"currencyid"));
                expenseBudgetDynObj.set("availableamount", (Object)entryDynObj.getBigDecimal("assignamount"));
                expenseBudgetDynObj.set("beginmount", (Object)expenseBudgetDynObj.getBigDecimal("availableamount"));
                expenseBudgetDynObj.set("parentorgid", (Object)DynamicObjectUtils.getPkValue((DynamicObject)entryDynObj.getDynamicObject("assignparentorgid")));
                expenseBudgetDynObj.set("remark", (Object)entryDynObj.getString("entryremark"));
                expenseBudgetDynObj.set("creator", (Object)RequestContext.get().getCurrUserId());
                expenseBudgetDynObj.set("createtime", (Object)TimeServiceHelper.now());
                expenseBudgetDynObj.set("enable", (Object)"1");
                saveDynObjList.add(expenseBudgetDynObj);
            }
        }
        if (saveDynObjList.size() > 0) {
            String[] batchNumber = CodeRuleServiceHelper.getBatchNumber((String)"ocmem_expensebudget", (DynamicObject)((DynamicObject)saveDynObjList.get(0)), null, (int)saveDynObjList.size());
            int index = 0;
            for (DynamicObject saveDynObj : saveDynObjList) {
                saveDynObj.set("billno", (Object)batchNumber[index]);
                ++index;
            }
            SaveServiceHelper.save((DynamicObject[])saveDynObjList.toArray(new DynamicObject[saveDynObjList.size()]));
        }
    }

    public static void createBudgetCostsBill(List<DynamicObject> assignBudgetDynObjList) {
        if (CommonUtils.isNull(assignBudgetDynObjList)) {
            return;
        }
        ArrayList<BudgetCosts> budgetCostsList = new ArrayList<BudgetCosts>(16);
        ArrayList<BudgetCosts> addBudgetCostsList = new ArrayList<BudgetCosts>(16);
        for (DynamicObject billDynObj : assignBudgetDynObjList) {
            DynamicObject budgetCostDynObj = BudgetCostsServiceImpl.queryBudgetCostsInfo(DynamicObjectUtils.getPkValue((DynamicObject)billDynObj, (String)"orgid"), DynamicObjectUtils.getPkValue((DynamicObject)billDynObj, (String)"channelid"), DynamicObjectUtils.getPkValue((DynamicObject)billDynObj, (String)"currencyid"), DynamicObjectUtils.getPkValue((DynamicObject)billDynObj, (String)"expensetypeid"), DynamicObjectUtils.getPkValue((DynamicObject)billDynObj, (String)"budgetyear"));
            DynamicObjectCollection entryColl = billDynObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryDynObj : entryColl) {
                BudgetCosts budgetCosts = AssignBudgetHelper.createBudgetCostsByAssign(billDynObj, entryDynObj, budgetCostDynObj);
                if ("0".equals(billDynObj.getString("sourcetype")) && budgetCosts.getAvailableAmount().compareTo(BigDecimal.ZERO) > 0) {
                    addBudgetCostsList.add(budgetCosts);
                    continue;
                }
                budgetCostsList.add(budgetCosts);
            }
        }
        if (budgetCostsList.size() > 0) {
            BudgetCostsUpdateHelper.insertBudgetCosts(budgetCostsList);
        }
        if (addBudgetCostsList.size() > 0) {
            BudgetCostsUpdateHelper.supplementBudgetCosts(addBudgetCostsList);
        }
    }

    public static void setAvailableAmountByOperate(List<DynamicObject> assignBudgetDynObjList, boolean isDelete) {
        if (CommonUtils.isNull(assignBudgetDynObjList)) {
            return;
        }
        ArrayList<DynamicObject> expenseBudgetDynObjList = new ArrayList<DynamicObject>(assignBudgetDynObjList.size());
        for (DynamicObject billDynObj : assignBudgetDynObjList) {
            if ("0".equals(billDynObj.getString("sourcetype"))) continue;
            DynamicObjectCollection entryColl = billDynObj.getDynamicObjectCollection("entryentity");
            BigDecimal sumAssignEntryAmount = entryColl.stream().map(obj -> obj.getBigDecimal("assignamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            long expenseBudgetId = billDynObj.getLong("expensebudgetid");
            DynamicObject expenseBudgetDynObj = BusinessDataServiceHelper.loadSingle((Object)expenseBudgetId, (String)"ocmem_expensebudget");
            BigDecimal availableAmount = expenseBudgetDynObj.getBigDecimal("availableamount");
            BigDecimal sumAssignAvailableAmount = billDynObj.getBigDecimal("assignavailableamount");
            availableAmount = isDelete ? availableAmount.add(sumAssignAvailableAmount) : availableAmount.subtract(sumAssignEntryAmount.subtract(sumAssignAvailableAmount));
            expenseBudgetDynObj.set("availableamount", (Object)availableAmount);
            expenseBudgetDynObjList.add(expenseBudgetDynObj);
            billDynObj.set("availableamount", (Object)availableAmount);
            billDynObj.set("assignavailableamount", (Object)sumAssignEntryAmount);
        }
        if (expenseBudgetDynObjList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])expenseBudgetDynObjList.toArray(new DynamicObject[expenseBudgetDynObjList.size()]));
        }
    }

    public static DynamicObject[] queryBudgetBalanceDynObj(long orgId, long expensetypeId, long channelId, Date year) {
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        qFilter = qFilter.and(new QFilter("feetype", "=", (Object)expensetypeId)).and(new QFilter("channel", "=", (Object)channelId)).and(new QFilter("year", "=", (Object)year));
        return BusinessDataServiceHelper.load((String)"ocdbd_budgetbalance", (String)"number", (QFilter[])qFilter.toArray());
    }

    public static List<DynamicObject> queryBudgetBalanceDynObj(List<Long> orgIdList, List<Long> expensetypeIdList, List<Long> channelIdList) {
        if (CommonUtils.isNull(orgIdList) || CommonUtils.isNull(expensetypeIdList) || CommonUtils.isNull(channelIdList)) {
            return null;
        }
        QFilter qFilter = new QFilter("org", "in", orgIdList);
        qFilter = qFilter.and(new QFilter("feetype", "in", expensetypeIdList)).and(new QFilter("channel", "in", channelIdList));
        String selectFields = String.join((CharSequence)",", "org", "feetype", "channel", "year", "budgetyear");
        DynamicObject[] budgetBalanceDynObjs = BusinessDataServiceHelper.load((String)"ocdbd_budgetbalance", (String)selectFields, (QFilter[])qFilter.toArray());
        return DynamicObjectUtils.convertDynamicObjList((DynamicObject[])budgetBalanceDynObjs);
    }

    private static BudgetCosts createBudgetCostsByAssign(DynamicObject billDynObj, DynamicObject entryDynObj, DynamicObject budgetCostDynObj) {
        BudgetCosts budgetCosts = new BudgetCosts();
        budgetCosts.setOrgId(DynamicObjectUtils.getPkValue((DynamicObject)entryDynObj, (String)"assignorgid"));
        budgetCosts.setAvailableAmount(entryDynObj.getBigDecimal("assignamount"));
        budgetCosts.setYearEstimateAmt(entryDynObj.getBigDecimal("entryestimateamt"));
        budgetCosts.setDateTime(billDynObj.getDate("year"));
        budgetCosts.setBudgetYearId(DynamicObjectUtils.getPkValue((DynamicObject)billDynObj, (String)"budgetyear"));
        budgetCosts.setFeeTypeId(DynamicObjectUtils.getPkValue((DynamicObject)entryDynObj, (String)"assignexpensetypeid"));
        budgetCosts.setChannelId(DynamicObjectUtils.getPkValue((DynamicObject)entryDynObj, (String)"assignchannelid"));
        budgetCosts.setCurrencyId(DynamicObjectUtils.getPkValue((DynamicObject)billDynObj, (String)"currencyid"));
        budgetCosts.setSourceBill("ocmem_assignbudget");
        budgetCosts.setSourceBillNo(billDynObj.getString("billno"));
        budgetCosts.setParentId(DynamicObjectUtils.getPkValue((DynamicObject)budgetCostDynObj));
        return budgetCosts;
    }
}

