/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.business.budgetcosts;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.JSONUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.occ.ocbase.common.entity.BudgetCosts;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocmem.business.budgetcosts.BudgetRecordHelper;
import kd.occ.ocmem.common.enums.UpdateOperationEnum;
import kd.occ.ocmem.common.vo.BudgetRecord;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class BudgetCostsServiceImpl {
    private static final long DLOCK_TIME = 180000L;
    private static Log logger = LogFactory.getLog(BudgetCostsServiceImpl.class);
    private static String DLOCK_KEY = "kd.occ.ocmem.business.budgetcosts.BudgetCostsServiceImpl";

    public static void distributeBudgetCostList(List<BudgetCosts> budgetCostsList) {
        block8: {
            if (CollectionUtils.isEmpty(budgetCostsList)) {
                return;
            }
            DLock dLock = null;
            try {
                dLock = BudgetCostsServiceImpl.createDLock();
                if (dLock.tryLock(180000L)) {
                    BudgetCostsServiceImpl.checkBudgetCostExist(budgetCostsList);
                    BudgetCostsServiceImpl.batchInsertBudgetCostsList(budgetCostsList, UpdateOperationEnum.DISTRIBUTION);
                    break block8;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5206\u5e03\u5f0f\u6240\u5931\u8d25", (String)"BudgetCostsServiceImpl_0", (String)"occ-ocmem-business", (Object[])new Object[0]));
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (dLock != null) {
                    dLock.unlock();
                }
            }
        }
    }

    public static void adjustBudgetCostList(List<BudgetCosts> budgetCostsList) {
        block7: {
            DLock dLock = null;
            try {
                dLock = BudgetCostsServiceImpl.createDLock();
                if (dLock.tryLock(180000L)) {
                    BudgetCostsServiceImpl.checkBudgetCostInfoList(budgetCostsList);
                    BudgetCostsServiceImpl.batchAdjustBudgetCost(budgetCostsList, UpdateOperationEnum.ADJUST);
                    break block7;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5206\u5e03\u5f0f\u6240\u5931\u8d25", (String)"BudgetCostsServiceImpl_0", (String)"occ-ocmem-business", (Object[])new Object[0]));
            }
            catch (Exception e) {
                logger.info(MessageFormat.format("\u9884\u7b97\u4f59\u989d\u8c03\u6574\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a{0}", e.getMessage()));
                throw e;
            }
            finally {
                if (dLock != null) {
                    dLock.unlock();
                }
            }
        }
    }

    public static void releaseBudgetCostList(List<BudgetCosts> budgetCostsList) {
        block7: {
            DLock dLock = null;
            try {
                dLock = BudgetCostsServiceImpl.createDLock();
                if (dLock.tryLock(180000L)) {
                    BudgetCostsServiceImpl.checkBudgetCostInfoList(budgetCostsList);
                    BudgetCostsServiceImpl.batchAdjustBudgetCost(budgetCostsList, UpdateOperationEnum.RELEASE);
                    break block7;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5206\u5e03\u5f0f\u6240\u5931\u8d25", (String)"BudgetCostsServiceImpl_0", (String)"occ-ocmem-business", (Object[])new Object[0]));
            }
            catch (Exception e) {
                logger.info("\u9884\u7b97\u4f59\u989d\u91ca\u653e\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e);
                throw e;
            }
            finally {
                if (dLock != null) {
                    dLock.unlock();
                }
            }
        }
    }

    public static void occupyBudgetCostsList(List<BudgetCosts> budgetCostsList) {
        block7: {
            DLock dLock = null;
            try {
                dLock = BudgetCostsServiceImpl.createDLock();
                if (dLock.tryLock(180000L)) {
                    BudgetCostsServiceImpl.checkBudgetCostInfoList(budgetCostsList);
                    BudgetCostsServiceImpl.batchAdjustBudgetCost(budgetCostsList, UpdateOperationEnum.OCCUPY);
                    break block7;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5206\u5e03\u5f0f\u6240\u5931\u8d25", (String)"BudgetCostsServiceImpl_0", (String)"occ-ocmem-business", (Object[])new Object[0]));
            }
            catch (Exception e) {
                logger.info("\u9884\u7b97\u91d1\u989d\u91ca\u653e\u8c03\u7528\u5931\u8d25\uff0c\u539f\u56e0\u662f" + e);
                throw e;
            }
            finally {
                if (dLock != null) {
                    dLock.unlock();
                }
            }
        }
    }

    private static void batchAdjustBudgetCost(List<BudgetCosts> budgetCostsList, UpdateOperationEnum updateOperationEnum) {
        Map<Long, DynamicObject> budgetCostMap = BudgetCostsServiceImpl.getParentBudgetCostMap(budgetCostsList);
        ArrayList<BudgetRecord> budgetRecordList = new ArrayList<BudgetRecord>(budgetCostMap.size());
        String upperNumber = null;
        Map<String, List<BudgetCosts>> paramMap = budgetCostsList.stream().collect(Collectors.groupingBy(BudgetCosts::toString));
        for (Map.Entry<String, List<BudgetCosts>> param : paramMap.entrySet()) {
            for (BudgetCosts budgetCosts : param.getValue()) {
                BudgetCostsServiceImpl.updateBudgetCostInfo(budgetCosts.getId(), budgetCostMap, budgetCosts, budgetRecordList, upperNumber, updateOperationEnum);
            }
        }
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(budgetCostMap.values());
        if (CollectionUtils.isNotEmpty(updateList)) {
            BudgetRecordHelper.batchInsertRecordList(budgetRecordList, updateOperationEnum);
            SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[updateList.size()]));
        }
    }

    private static Map<Long, DynamicObject> getParentBudgetCostMap(List<BudgetCosts> paramList) {
        List<DynamicObject> budgetCostInfoList = BudgetCostsServiceImpl.getBudgetBalanceDataEntities(paramList);
        ArrayList<String> numberList = new ArrayList<String>(budgetCostInfoList.size());
        for (DynamicObject budgetCost : budgetCostInfoList) {
            numberList.addAll(Arrays.asList(budgetCost.getString("longnumber").split("\\.")));
        }
        QFilter parentFilter = new QFilter("number", "in", numberList);
        DynamicObject[] parentList = BusinessDataServiceHelper.load((String)"ocdbd_budgetbalance", (String)"id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,longnumber,level,fullname,isleaf,parent,org,feetype,channel,currency,amount,availableamount,usedamount,sourcebill,year,yearestimateamt,writeoffamt,budgetyear", (QFilter[])parentFilter.toArray());
        HashMap<Long, DynamicObject> budgetCostMap = new HashMap<Long, DynamicObject>(parentList.length);
        for (DynamicObject bg : parentList) {
            budgetCostMap.put(bg.getLong("id"), bg);
        }
        return budgetCostMap;
    }

    private static void updateBudgetCostInfo(long budgetCostId, Map<Long, DynamicObject> budgetCostMap, BudgetCosts param, List<BudgetRecord> recordList, String lowerBudgetNumber, UpdateOperationEnum updateOperation) {
        DynamicObject upperBudgetCost = budgetCostMap.get(budgetCostId);
        if (upperBudgetCost == null) {
            return;
        }
        BigDecimal updateAmount = UpdateOperationEnum.OCCUPY == updateOperation ? param.getAvailableAmount().negate() : param.getAvailableAmount();
        BigDecimal beforeAmount = upperBudgetCost.getBigDecimal("availableamount");
        BigDecimal afterAmount = beforeAmount.add(updateAmount);
        if (BigDecimal.ZERO.compareTo(afterAmount) > 0) {
            throw new KDBizException(BudgetCostsServiceImpl.buildAfterAmountError(lowerBudgetNumber, upperBudgetCost));
        }
        if (UpdateOperationEnum.OCCUPY == updateOperation || UpdateOperationEnum.RELEASE == updateOperation) {
            BigDecimal updateOccupyAmount = UpdateOperationEnum.RELEASE == updateOperation ? param.getAvailableAmount().negate() : param.getAvailableAmount();
            upperBudgetCost.set("usedamount", (Object)upperBudgetCost.getBigDecimal("usedamount").add(updateOccupyAmount));
        }
        upperBudgetCost.set("availableamount", (Object)afterAmount);
        upperBudgetCost.set("modifytime", (Object)TimeServiceHelper.now());
        BudgetRecord budgetRecord = BudgetCostsServiceImpl.buildBudgetRecord(upperBudgetCost, beforeAmount, updateAmount, afterAmount, param, updateOperation);
        recordList.add(budgetRecord);
        budgetCostMap.put(budgetCostId, upperBudgetCost);
        long parentId = DynamicObjectUtils.getPkValue((DynamicObject)upperBudgetCost.getDynamicObject("parent"));
        if (StringUtils.isEmpty((String)lowerBudgetNumber)) {
            lowerBudgetNumber = upperBudgetCost.getString("number");
        }
        BudgetCostsServiceImpl.updateBudgetCostInfo(parentId, budgetCostMap, param, recordList, lowerBudgetNumber, updateOperation);
    }

    private static BudgetRecord buildBudgetRecord(DynamicObject budgetCost, BigDecimal beforeAmount, BigDecimal updateAmount, BigDecimal afterAmount, BudgetCosts budgetCosts, UpdateOperationEnum updateOperationEnum) {
        BudgetRecord budgetRecord = new BudgetRecord();
        budgetRecord.setBudgetBalanceId(DynamicObjectUtils.getPkValue((DynamicObject)budgetCost));
        budgetRecord.setBeforeAmount(beforeAmount);
        budgetRecord.setUpdateAmount(updateAmount);
        budgetRecord.setAfterAmount(afterAmount);
        budgetRecord.setSourceBill(budgetCosts.getSourceBill());
        budgetRecord.setSourceBillNo(budgetCosts.getSourceBillNo());
        budgetRecord.setOperation(updateOperationEnum.getValue());
        budgetRecord.setOrgId(DynamicObjectUtils.getPkValue((DynamicObject)budgetCost, (String)"org"));
        budgetRecord.setFeeTypeId(DynamicObjectUtils.getPkValue((DynamicObject)budgetCost, (String)"feetype"));
        budgetRecord.setChannelId(DynamicObjectUtils.getPkValue((DynamicObject)budgetCost, (String)"channel"));
        budgetRecord.setDateTime(BudgetCostsServiceImpl.getFirstDayOfYear(budgetCost.getDate("year")));
        budgetRecord.setCurrencyId(DynamicObjectUtils.getPkValue((DynamicObject)budgetCost, (String)"currency"));
        budgetRecord.setBudgetYearId(DynamicObjectUtils.getPkValue((DynamicObject)budgetCost, (String)"budgetyear"));
        return budgetRecord;
    }

    private static List<DynamicObject> getBudgetBalanceDataEntities(List<BudgetCosts> budgetCostsList) {
        Map<String, DynamicObject> budgetCostMap = BudgetCostsServiceImpl.getBudgetCostInfoMap(budgetCostsList);
        ArrayList<DynamicObject> budgetCostInfoList = new ArrayList<DynamicObject>(budgetCostMap.size());
        for (BudgetCosts param : budgetCostsList) {
            DynamicObject budgetCostsInfo = budgetCostMap.get(param.toString());
            if (budgetCostsInfo == null) {
                throw new KDBizException(BudgetCostsServiceImpl.getCheckErrorMessage(param));
            }
            budgetCostInfoList.add(budgetCostsInfo);
        }
        return budgetCostInfoList;
    }

    private static Map<String, DynamicObject> getBudgetCostInfoMap(List<BudgetCosts> paramList) {
        List<Object> ids = CollectionUtils.isEmpty(paramList) ? new ArrayList(0) : paramList.stream().map(BudgetCosts::getId).collect(Collectors.toList());
        QFilter filter = new QFilter("id", "in", ids);
        DynamicObject[] queryBudgetCostList = BusinessDataServiceHelper.load((String)"ocdbd_budgetbalance", (String)"id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,longnumber,level,fullname,isleaf,parent,org,feetype,channel,currency,amount,availableamount,usedamount,sourcebill,year,yearestimateamt,writeoffamt,budgetyear", (QFilter[])(filter = filter.and("enable", "=", (Object)"1")).toArray());
        if (queryBudgetCostList == null || queryBudgetCostList.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u6574\u7684\u9884\u7b97\u4f59\u989d\u8d26\u6237\u6570\u636e\u5747\u4e0d\u5b58\u5728\uff0c\u6216\u5df2\u88ab\u7981\u7528\uff0c\u6216\u5df2\u88ab\u5220\u9664\u3002", (String)"BudgetCostsServiceImpl_1", (String)"occ-ocmem-business", (Object[])new Object[0]));
        }
        HashMap<String, DynamicObject> budgetCostMap = new HashMap<String, DynamicObject>(queryBudgetCostList.length);
        for (DynamicObject bg : queryBudgetCostList) {
            budgetCostMap.put(BudgetCostsServiceImpl.getGroupKey(bg), bg);
        }
        return budgetCostMap;
    }

    private static String buildAfterAmountError(String budgetNumber, DynamicObject budgetBalance) {
        if (StringUtils.isEmpty((String)budgetNumber)) {
            return String.format(ResManager.loadKDString((String)"\u9884\u7b97\u7f16\u7801%1$s\u9884\u7b97\u4f59\u989d\u4e0d\u8db3\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u63d0\u4ea4\u5355\u636e\u3002", (String)"BudgetCostsServiceImpl_2", (String)"occ-ocmem-business", (Object[])new Object[0]), budgetBalance.getString("number"));
        }
        return String.format(ResManager.loadKDString((String)"\u9884\u7b97\u7f16\u7801%1$s\u7684\u4e0a\u7ea7\u9884\u7b97\u7f16\u7801%2$s\u9884\u7b97\u4f59\u989d\u4e0d\u8db3\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u63d0\u4ea4\u5355\u636e\u3002", (String)"BudgetCostsServiceImpl_3", (String)"occ-ocmem-business", (Object[])new Object[0]), budgetNumber, budgetBalance.getString("number"));
    }

    private static StringBuilder buildErrorMsg(DynamicObject budgetBalance) {
        StringBuilder error = new StringBuilder();
        error.append(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7[%1$s]", (String)"BudgetCostsServiceImpl_31", (String)"occ-ocmem-business", (Object[])new Object[0]), DynamicObjectUtils.getString((DynamicObject)budgetBalance.getDynamicObject("org"), (String)"name"))).append("\uff0c");
        error.append(String.format(ResManager.loadKDString((String)"\u5e74\u4efd[%1$s]", (String)"BudgetCostsServiceImpl_32", (String)"occ-ocmem-business", (Object[])new Object[0]), DynamicObjectUtils.getString((DynamicObject)budgetBalance.getDynamicObject("budgetyear"), (String)"name"))).append("\uff0c");
        String errorMsg = DynamicObjectUtils.getString((DynamicObject)budgetBalance.getDynamicObject("channel"), (String)"name");
        if (StringUtils.isNotEmpty((String)errorMsg)) {
            error.append(String.format(ResManager.loadKDString((String)"\u6e20\u9053[%1$s]", (String)"BudgetCostsServiceImpl_27", (String)"occ-ocmem-business", (Object[])new Object[0]), errorMsg)).append("\uff0c");
        }
        if (StringUtils.isNotEmpty((String)(errorMsg = DynamicObjectUtils.getString((DynamicObject)budgetBalance.getDynamicObject("currency"), (String)"name")))) {
            error.append(String.format(ResManager.loadKDString((String)"\u5e01\u522b[%1$s]", (String)"BudgetCostsServiceImpl_30", (String)"occ-ocmem-business", (Object[])new Object[0]), errorMsg)).append("\uff0c");
        }
        if (StringUtils.isNotEmpty((String)(errorMsg = DynamicObjectUtils.getString((DynamicObject)budgetBalance.getDynamicObject("feetype"), (String)"name")))) {
            error.append(String.format(ResManager.loadKDString((String)"\u8d39\u7528\u7c7b\u578b[%1$s]", (String)"BudgetCostsServiceImpl_28", (String)"occ-ocmem-business", (Object[])new Object[0]), errorMsg)).append("\uff0c");
        }
        return error;
    }

    private static String getCheckErrorMessage(BudgetCosts budgetCosts) {
        DynamicObject budgetBalance = BudgetCostsServiceImpl.buildBudgetBalance(budgetCosts);
        ArrayList<DynamicObject> dataEntitys = new ArrayList<DynamicObject>(1);
        dataEntitys.add(budgetBalance);
        BusinessDataServiceHelper.loadRefence((Object[])dataEntitys.toArray(), (IDataEntityType)budgetBalance.getDataEntityType());
        StringBuilder error = BudgetCostsServiceImpl.buildErrorMsg(budgetBalance);
        error.append(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u9884\u7b97\u4f59\u989d\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u6216\u5df2\u88ab\u7981\u7528\uff0c\u6216\u5df2\u88ab\u5220\u9664\u3002", (String)"BudgetCostsServiceImpl_9", (String)"occ-ocmem-business", (Object[])new Object[0]));
        return error.toString();
    }

    private static String getGroupKey(DynamicObject budgetCost) {
        StringBuilder key = new StringBuilder();
        key.append(DynamicObjectUtils.getPkValue((DynamicObject)budgetCost, (String)"org")).append('_');
        key.append(DynamicObjectUtils.getPkValue((DynamicObject)budgetCost, (String)"channel")).append('_');
        key.append(DynamicObjectUtils.getPkValue((DynamicObject)budgetCost, (String)"currency")).append('_');
        key.append(DynamicObjectUtils.getPkValue((DynamicObject)budgetCost, (String)"feetype")).append('_');
        key.append(DynamicObjectUtils.getPkValue((DynamicObject)budgetCost, (String)"budgetyear"));
        return key.toString();
    }

    private static String getGroupIdKey(DynamicObject budgetCost) {
        StringBuilder key = new StringBuilder();
        key.append(budgetCost.getLong("org_id")).append('_');
        key.append(budgetCost.getLong("channel_id")).append('_');
        key.append(budgetCost.getLong("currency_id")).append('_');
        key.append(budgetCost.getLong("feetype_id")).append('_');
        key.append(budgetCost.getLong("budgetyear_id"));
        return key.toString();
    }

    private static DLock createDLock() {
        return DLock.create((String)DLOCK_KEY, (String)ResManager.loadKDString((String)"\u5168\u6e20\u9053\u4e91\u9884\u7b97\u8d39\u7528\u5206\u5e03\u5f0f\u9501", (String)"BudgetCostsServiceImpl_10", (String)"occ-ocmem-business", (Object[])new Object[0]));
    }

    private static List<BudgetCosts> batchInsertBudgetCostsList(List<BudgetCosts> paramList, UpdateOperationEnum updateOperationEnum) {
        if (CollectionUtils.isEmpty(paramList)) {
            return new ArrayList<BudgetCosts>(0);
        }
        ArrayList<DynamicObject> saveBudgetCostList = new ArrayList<DynamicObject>(paramList.size());
        ArrayList<BudgetRecord> budgetRecordList = new ArrayList<BudgetRecord>(paramList.size());
        for (BudgetCosts budgetCosts : paramList) {
            DynamicObject newBudgetCost = BudgetCostsServiceImpl.buildSaveBudgetCost(budgetCosts);
            saveBudgetCostList.add(newBudgetCost);
            budgetRecordList.add(BudgetCostsServiceImpl.buildBudgetRecordForNew(budgetCosts));
        }
        if (CollectionUtils.isNotEmpty(saveBudgetCostList)) {
            OperationResult operationResult = SaveServiceHelper.saveOperate((String)"ocdbd_budgetbalance", (DynamicObject[])saveBudgetCostList.toArray(new DynamicObject[saveBudgetCostList.size()]), (OperateOption)OperateOption.create());
            if (!operationResult.isSuccess()) {
                StringBuilder sb = new StringBuilder(300);
                List operateErrorInfoList = operationResult.getAllErrorInfo();
                for (OperateErrorInfo operateErrorInfo : operateErrorInfoList) {
                    sb.append(operateErrorInfo.getMessage()).append(',');
                }
                if (StringUtils.isNotEmpty((String)sb.toString())) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9884\u7b97\u4f59\u989d\u5206\u914d\u4fdd\u5b58\u5931\u8d25\uff0c\u539f\u56e0\u662f%1$s", (String)"BudgetCostsServiceImpl_11", (String)"occ-ocmem-business", (Object[])new Object[0]), sb.toString()));
                }
            }
            BudgetCostsServiceImpl.updateBudgetBalanceParamAndRecordList(saveBudgetCostList, paramList, budgetRecordList);
            BudgetRecordHelper.batchInsertRecordList(budgetRecordList, updateOperationEnum);
        }
        return paramList;
    }

    private static void updateBudgetBalanceParamAndRecordList(List<DynamicObject> budgetCostList, List<BudgetCosts> paramList, List<BudgetRecord> recordParamList) {
        DynamicObject saveEntity;
        Map<String, DynamicObject> budgetCostMap = budgetCostList.stream().collect(Collectors.toMap(b -> BudgetCostsServiceImpl.getGroupIdKey(b), v -> v, (r1, r2) -> r1));
        for (BudgetCosts budgetCosts : paramList) {
            saveEntity = budgetCostMap.get(budgetCosts.toString());
            if (saveEntity == null) continue;
            budgetCosts.setId(DynamicObjectUtils.getPkValue((DynamicObject)saveEntity));
        }
        for (BudgetRecord budgetRecord : recordParamList) {
            saveEntity = budgetCostMap.get(budgetRecord.toString());
            if (saveEntity == null) continue;
            budgetRecord.setBudgetBalanceId(DynamicObjectUtils.getPkValue((DynamicObject)saveEntity));
        }
    }

    private static DynamicObject buildSaveBudgetCost(BudgetCosts budgetCostsParam) {
        DynamicObject newBudgetCost = BusinessDataServiceHelper.newDynamicObject((String)"ocdbd_budgetbalance");
        budgetCostsParam.setDateTime(BudgetCostsServiceImpl.getFirstDayOfYear(budgetCostsParam.getDateTime()));
        newBudgetCost.set("year", (Object)budgetCostsParam.getDateTime());
        newBudgetCost.set("amount", (Object)budgetCostsParam.getAvailableAmount());
        newBudgetCost.set("availableamount", (Object)budgetCostsParam.getAvailableAmount());
        newBudgetCost.set("yearestimateamt", (Object)budgetCostsParam.getYearEstimateAmt());
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)newBudgetCost, (String)"org", (long)budgetCostsParam.getOrgId());
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)newBudgetCost, (String)"channel", (long)budgetCostsParam.getChannelId());
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)newBudgetCost, (String)"budgetyear", (long)budgetCostsParam.getBudgetYearId());
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)newBudgetCost, (String)"feetype", (long)budgetCostsParam.getFeeTypeId());
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)newBudgetCost, (String)"currency", (long)budgetCostsParam.getCurrencyId());
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)newBudgetCost, (String)"parent", (long)budgetCostsParam.getParentId());
        newBudgetCost.set("sourcebill", (Object)budgetCostsParam.getSourceBill());
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)newBudgetCost, (String)"creator", (long)UserServiceHelper.getCurrentUserId());
        newBudgetCost.set("createtime", (Object)TimeServiceHelper.now());
        newBudgetCost.set("enable", (Object)"1");
        return newBudgetCost;
    }

    private static BudgetRecord buildBudgetRecordForNew(BudgetCosts budgetCosts) {
        BudgetRecord budgetRecord = BudgetCostsServiceImpl.castToBudgetRecord(budgetCosts);
        budgetRecord.setBeforeAmount(BigDecimal.ZERO);
        budgetRecord.setUpdateAmount(budgetCosts.getAvailableAmount());
        budgetRecord.setAfterAmount(budgetCosts.getAvailableAmount());
        return budgetRecord;
    }

    private static BudgetRecord castToBudgetRecord(BudgetCosts budgetCosts) {
        try {
            return (BudgetRecord)JSONUtils.cast((String)JSONUtils.toString((Object)budgetCosts), BudgetRecord.class);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u5bf9\u8c61\u8f6c\u6362\u5931\u8d25", (String)"BudgetCostsServiceImpl_12", (String)"occ-ocmem-business", (Object[])new Object[0]));
        }
    }

    private static void checkBudgetCostExist(List<BudgetCosts> mergeBudgetCosts) {
        Map<String, DynamicObject> queryMap = BudgetCostsServiceImpl.queryExistBudgetCostMap(mergeBudgetCosts);
        ArrayList<DynamicObject> errorList = new ArrayList<DynamicObject>(2);
        for (BudgetCosts budgetCosts : mergeBudgetCosts) {
            DynamicObject bc = queryMap.get(budgetCosts.toString());
            if (bc == null) continue;
            errorList.add(bc);
        }
        BudgetCostsServiceImpl.buildExistErrorMsg(errorList);
    }

    private static Map<String, DynamicObject> queryExistBudgetCostMap(List<BudgetCosts> budgetCostsList) {
        DynamicObject[] existList;
        if (CollectionUtils.isEmpty(budgetCostsList)) {
            return new HashMap<String, DynamicObject>(0);
        }
        int size = budgetCostsList.size();
        HashMap<String, DynamicObject> queryMap = new HashMap<String, DynamicObject>(size);
        ArrayList<Long> orgIds = new ArrayList<Long>(size);
        ArrayList<Long> dateList = new ArrayList<Long>(size);
        for (BudgetCosts budgetCosts : budgetCostsList) {
            orgIds.add(budgetCosts.getOrgId());
            dateList.add(budgetCosts.getBudgetYearId());
        }
        QFilter filters = new QFilter("org", "in", orgIds);
        filters.and(new QFilter("budgetyear", "in", dateList));
        for (DynamicObject queryInfo : existList = BusinessDataServiceHelper.load((String)"ocdbd_budgetbalance", (String)"id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,longnumber,level,fullname,isleaf,parent,org,feetype,channel,currency,amount,availableamount,usedamount,sourcebill,year,yearestimateamt,writeoffamt,budgetyear", (QFilter[])filters.toArray())) {
            queryMap.put(BudgetCostsServiceImpl.getGroupKey(queryInfo), queryInfo);
        }
        return queryMap;
    }

    public static DynamicObject[] getBudgetBalanceList(List<BudgetCosts> budgetCostsList) {
        QFilter filterList = new QFilter("1", "!=", (Object)1);
        if (CollectionUtils.isNotEmpty(budgetCostsList)) {
            for (BudgetCosts budgetCosts : budgetCostsList) {
                QFilter filter = BudgetCostsServiceImpl.buildFilters(budgetCosts);
                filterList.or(filter);
            }
        }
        return BusinessDataServiceHelper.load((String)"ocdbd_budgetbalance", (String)"id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,longnumber,level,fullname,isleaf,parent,org,feetype,channel,currency,amount,availableamount,usedamount,sourcebill,year,yearestimateamt,writeoffamt,budgetyear", (QFilter[])filterList.toArray());
    }

    public static List<DynamicObject> queryBudgetBalanceList(List<BudgetCosts> budgetCostsList) {
        DynamicObject[] queryList = BudgetCostsServiceImpl.getBudgetBalanceList(budgetCostsList);
        return DynamicObjectUtils.convertDynamicObjList((DynamicObject[])queryList);
    }

    public static DynamicObject queryBudgetBalance(BudgetCosts budgetCosts) {
        if (budgetCosts == null) {
            return null;
        }
        QFilter filter = BudgetCostsServiceImpl.buildFilters(budgetCosts);
        return BusinessDataServiceHelper.loadSingle((String)"ocdbd_budgetbalance", (String)"id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,longnumber,level,fullname,isleaf,parent,org,feetype,channel,currency,amount,availableamount,usedamount,sourcebill,year,yearestimateamt,writeoffamt,budgetyear", (QFilter[])filter.toArray());
    }

    private static DynamicObject buildBudgetBalance(BudgetCosts budgetCosts) {
        DynamicObject budgetBalance = BusinessDataServiceHelper.newDynamicObject((String)"ocdbd_budgetbalance");
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)budgetBalance, (String)"org", (long)budgetCosts.getOrgId());
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)budgetBalance, (String)"channel", (long)budgetCosts.getChannelId());
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)budgetBalance, (String)"currency", (long)budgetCosts.getCurrencyId());
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)budgetBalance, (String)"feetype", (long)budgetCosts.getFeeTypeId());
        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)budgetBalance, (String)"budgetyear", (long)budgetCosts.getBudgetYearId());
        budgetBalance.set("year", (Object)budgetCosts.getDateTime());
        budgetBalance.set("number", (Object)budgetCosts.getNumber());
        return budgetBalance;
    }

    private static QFilter buildFilters(BudgetCosts budgetCosts) {
        return BudgetCostsServiceImpl.buildFilters(budgetCosts.getOrgId(), budgetCosts.getChannelId(), budgetCosts.getCurrencyId(), budgetCosts.getFeeTypeId(), budgetCosts.getBudgetYearId());
    }

    public static void supplementBudgetCostsList(List<BudgetCosts> budgetCostsList) {
        block8: {
            if (CollectionUtils.isEmpty(budgetCostsList)) {
                return;
            }
            DLock dLock = null;
            try {
                dLock = BudgetCostsServiceImpl.createDLock();
                if (dLock.tryLock(180000L)) {
                    BudgetCostsServiceImpl.checkBudgetCostExist(budgetCostsList);
                    BudgetCostsServiceImpl.batchUpdateSupplementBudgetCostsList(budgetCostsList);
                    break block8;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5206\u5e03\u5f0f\u6240\u5931\u8d25", (String)"BudgetCostsServiceImpl_0", (String)"occ-ocmem-business", (Object[])new Object[0]));
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (dLock != null) {
                    dLock.unlock();
                }
            }
        }
    }

    private static void batchUpdateSupplementBudgetCostsList(List<BudgetCosts> paramList) {
        BudgetCostsServiceImpl.batchInsertBudgetCostsList(paramList, UpdateOperationEnum.supplement);
        BudgetCostsServiceImpl.batchUpdateUpperBudgetCostsList(paramList);
    }

    private static void batchUpdateUpperBudgetCostsList(List<BudgetCosts> paramList) {
        Map<Long, DynamicObject> budgetCostMap = BudgetCostsServiceImpl.getParentBudgetCostMap(paramList);
        ArrayList<BudgetRecord> budgetRecordList = new ArrayList<BudgetRecord>(budgetCostMap.size());
        for (BudgetCosts param : paramList) {
            DynamicObject budgetCost = budgetCostMap.get(param.getId());
            long parentId = DynamicObjectUtils.getPkValue((DynamicObject)budgetCost.getDynamicObject("parent"));
            if (parentId == 0L || param.getAvailableAmount().compareTo(BigDecimal.ZERO) == 0) continue;
            String upperNumber = budgetCost.getString("number");
            BudgetCostsServiceImpl.updateBudgetCostInfo(parentId, budgetCostMap, param, budgetRecordList, upperNumber, UpdateOperationEnum.ADJUST);
        }
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(budgetCostMap.values());
        if (CollectionUtils.isNotEmpty(updateList)) {
            SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[updateList.size()]));
            BudgetRecordHelper.batchInsertRecordList(budgetRecordList, UpdateOperationEnum.ADJUST);
        }
    }

    public static List<BudgetCosts> mergeBudgetCostsList(List<BudgetCosts> budgetCostsList) {
        BudgetCostsServiceImpl.checkBudgetCostInfoList(budgetCostsList);
        Map<String, List<BudgetCosts>> groupBy = budgetCostsList.stream().collect(Collectors.groupingBy(BudgetCosts::toString));
        ArrayList<BudgetCosts> mergetList = new ArrayList<BudgetCosts>(budgetCostsList.size());
        for (Map.Entry<String, List<BudgetCosts>> bc : groupBy.entrySet()) {
            if (CollectionUtils.isEmpty((Collection)bc.getValue())) continue;
            BudgetCosts budgetCosts = bc.getValue().get(0);
            BigDecimal total = bc.getValue().stream().map(BudgetCosts::getAvailableAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            budgetCosts.setAvailableAmount(total);
            mergetList.add(budgetCosts);
        }
        return mergetList;
    }

    private static void checkBudgetCostInfoList(List<BudgetCosts> budgetCostsList) {
        if (CollectionUtils.isEmpty(budgetCostsList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9884\u7b97\u4f59\u989d\u5165\u53c2\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u662f\u5426\u6b63\u786e\u3002", (String)"BudgetCostsServiceImpl_13", (String)"occ-ocmem-business", (Object[])new Object[0]));
        }
        for (BudgetCosts budgetCosts : budgetCostsList) {
            if (budgetCosts == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9884\u7b97\u4f59\u989d\u5165\u53c2\u6570\u636e\u4f20\u8f93\u6709\u8bef\u3002", (String)"BudgetCostsServiceImpl_14", (String)"occ-ocmem-business", (Object[])new Object[0]));
            }
            if (budgetCosts.getBudgetYearId() == 0L || budgetCosts.getOrgId() == 0L) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e\u6807\u8bc6\u4e3a\u3010%1$s\u3011\uff0c\u6765\u6e90\u5355\u636e\u7f16\u7801\u4e3a\u3010%2$s\u3011\u7684\u9884\u7b97\u4f59\u989d\u5165\u53c2\uff0c\u5e74\u4efd\u6216\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"BudgetCostsServiceImpl_15", (String)"occ-ocmem-business", (Object[])new Object[0]), budgetCosts.getSourceBill(), budgetCosts.getSourceBillNo()));
            }
            if (budgetCosts.getCurrencyId() != 0L) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e\u6807\u8bc6\u4e3a\u3010%1$s\u3011\uff0c\u6765\u6e90\u5355\u636e\u7f16\u7801\u4e3a\u3010%2$s\u3011\u7684\u9884\u7b97\u4f59\u989d\u5165\u53c2\uff0c\u5e01\u522b\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"BudgetCostsServiceImpl_16", (String)"occ-ocmem-business", (Object[])new Object[0]), budgetCosts.getSourceBill(), budgetCosts.getSourceBillNo()));
        }
    }

    private static void buildExistErrorMsg(List<DynamicObject> budgetCostList) {
        if (CollectionUtils.isNotEmpty(budgetCostList)) {
            StringBuilder error = new StringBuilder();
            error.append(ResManager.loadKDString((String)"\u4ee5\u4e0b\u9884\u7b97\u4f59\u989d\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u518d\u6b21\u5206\u914d\uff1a", (String)"BudgetCostsServiceImpl_17", (String)"occ-ocmem-business", (Object[])new Object[0])).append('\n');
            for (int i = 0; i < budgetCostList.size(); ++i) {
                DynamicObject exist = budgetCostList.get(i);
                error.append(i + 1).append("\uff1a");
                error.append(String.format(ResManager.loadKDString((String)"\u9884\u7b97\u4f59\u989d\u7f16\u7801[%1$s]", (String)"BudgetCostsServiceImpl_33", (String)"occ-ocmem-business", (Object[])new Object[0]), exist.getString("number"))).append("\uff0c");
                error.append(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7[%1$s]", (String)"BudgetCostsServiceImpl_31", (String)"occ-ocmem-business", (Object[])new Object[0]), DynamicObjectUtils.getString((DynamicObject)exist.getDynamicObject("org"), (String)"name"))).append("\uff0c");
                error.append(String.format(ResManager.loadKDString((String)"\u5e74\u4efd[%1$s]", (String)"BudgetCostsServiceImpl_32", (String)"occ-ocmem-business", (Object[])new Object[0]), DynamicObjectUtils.getString((DynamicObject)exist.getDynamicObject("budgetyear"), (String)"name"))).append("\uff0c");
                if (exist.getDynamicObject("channel") != null) {
                    error.append(String.format(ResManager.loadKDString((String)"\u6e20\u9053[%1$s]", (String)"BudgetCostsServiceImpl_27", (String)"occ-ocmem-business", (Object[])new Object[0]), DynamicObjectUtils.getString((DynamicObject)exist.getDynamicObject("channel"), (String)"name"))).append("\uff0c");
                }
                if (exist.getDynamicObject("feetype") != null) {
                    error.append(String.format(ResManager.loadKDString((String)"\u8d39\u7528\u7c7b\u578b[%1$s]", (String)"BudgetCostsServiceImpl_28", (String)"occ-ocmem-business", (Object[])new Object[0]), DynamicObjectUtils.getString((DynamicObject)exist.getDynamicObject("feetype"), (String)"name"))).append("\uff0c");
                }
                error.append(String.format(ResManager.loadKDString((String)"\u5176\u9884\u7b97\u4f59\u989d\u4e3a[%1$s]\u3002", (String)"BudgetCostsServiceImpl_29", (String)"occ-ocmem-business", (Object[])new Object[0]), exist.getBigDecimal("availableamount").stripTrailingZeros().toPlainString()));
            }
            throw new KDBizException(error.toString());
        }
    }

    public static DynamicObject queryBudgetCostsInfo(long orgId, long channelId, long currencyId, long feeTypeId, long budgetYearId) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("feetype", "=", (Object)feeTypeId);
        filter.and("channel", "=", (Object)channelId);
        filter.and("currency", "=", (Object)currencyId);
        filter.and("budgetyear", "=", (Object)budgetYearId);
        filter.and("enable", "=", (Object)"1");
        return BusinessDataServiceHelper.loadSingle((String)"ocdbd_budgetbalance", (String)"id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,longnumber,level,fullname,isleaf,parent,org,feetype,channel,currency,amount,availableamount,usedamount,sourcebill,year,yearestimateamt,writeoffamt,budgetyear", (QFilter[])filter.toArray());
    }

    private static QFilter buildFilters(long orgId, long channelId, long currencyId, long feeTypeId, long budgetYearId) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("feetype", "=", (Object)feeTypeId);
        filter.and("channel", "=", (Object)channelId);
        filter.and("currency", "=", (Object)currencyId);
        filter.and("budgetyear", "=", (Object)budgetYearId);
        return filter;
    }

    @Deprecated
    public static DynamicObject queryBudgetCostsInfo(long orgId, long channelId, long currencyId, long feeTypeId, Date dateTime) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("feetype", "=", (Object)feeTypeId);
        filter.and("channel", "=", (Object)channelId);
        filter.and("currency", "=", (Object)currencyId);
        filter.and(new QFilter("year", ">=", (Object)BudgetCostsServiceImpl.getFirstDayOfYear(dateTime)));
        filter.and(new QFilter("year", "<=", (Object)BudgetCostsServiceImpl.getLastDayOfYear(dateTime)));
        return BusinessDataServiceHelper.loadSingle((String)"ocdbd_budgetbalance", (String)"id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,longnumber,level,fullname,isleaf,parent,org,feetype,channel,currency,amount,availableamount,usedamount,sourcebill,year,yearestimateamt,writeoffamt,budgetyear", (QFilter[])filter.toArray());
    }

    public static Date getFirstDayOfYear(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.set(6, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getLastDayOfYear(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.set(6, 1);
        ((Calendar)calendar).add(1, 1);
        ((Calendar)calendar).add(6, -1);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime();
    }
}

