/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.business.budgetcosts;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.occ.ocbase.common.entity.BudgetCosts;
import kd.occ.ocmem.business.budgetcosts.BudgetCostsServiceImpl;
import org.apache.commons.collections.CollectionUtils;

public class BudgetCostsUpdateHelper {
    private static final String DISTRIBUTION = "insertBudgetCosts";
    private static final String ADJUST = "updateBudgetCosts";
    private static final String supplement = "supplementBudgetCosts";
    private static Log logger = LogFactory.getLog(BudgetCostsUpdateHelper.class);

    public static void insertBudgetCosts(List<BudgetCosts> budgetCostsList) {
        if (CollectionUtils.isEmpty(budgetCostsList)) {
            return;
        }
        List<BudgetCosts> mergeBudgetCosts = BudgetCostsServiceImpl.mergeBudgetCostsList(budgetCostsList);
        String tag = BudgetCostsUpdateHelper.getMethodTag(DISTRIBUTION);
        try (TXHandle tx = TX.required((String)tag);){
            try {
                BudgetCostsServiceImpl.distributeBudgetCostList(mergeBudgetCosts);
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error("\u9884\u7b97\u4f59\u989d\u5206\u914d\u5931\u8d25\uff0c" + e);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9884\u7b97\u4f59\u989d\u5206\u914d\u5931\u8d25\uff1a%1$s", (String)"BudgetCostsUpdateHelper_0", (String)"occ-ocmem-business", (Object[])new Object[0]), e.getMessage()));
            }
        }
    }

    public static void supplementBudgetCosts(List<BudgetCosts> budgetCostsList) {
        if (CollectionUtils.isEmpty(budgetCostsList)) {
            return;
        }
        List<BudgetCosts> mergeBudgetCosts = BudgetCostsServiceImpl.mergeBudgetCostsList(budgetCostsList);
        String tag = BudgetCostsUpdateHelper.getMethodTag(supplement);
        try (TXHandle tx = TX.required((String)tag);){
            try {
                BudgetCostsServiceImpl.supplementBudgetCostsList(mergeBudgetCosts);
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error("\u9884\u7b97\u4f59\u989d\u5206\u914d\u5931\u8d25\uff0c" + e);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9884\u7b97\u4f59\u989d\u5206\u914d\u5931\u8d25\uff1a%1$s", (String)"BudgetCostsUpdateHelper_0", (String)"occ-ocmem-business", (Object[])new Object[0]), e.getMessage()));
            }
        }
    }

    public static void updateBudgetCosts(List<BudgetCosts> budgetCostsList) {
        try (TXHandle tx = TX.required((String)BudgetCostsUpdateHelper.getMethodTag(ADJUST));){
            try {
                BudgetCostsServiceImpl.adjustBudgetCostList(budgetCostsList);
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error("\u9884\u7b97\u4f59\u989d\u8c03\u6574\u5931\u8d25\uff1a" + e);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9884\u7b97\u4f59\u989d\u8c03\u6574\u5931\u8d25\uff1a%1$s", (String)"BudgetCostsUpdateHelper_1", (String)"occ-ocmem-business", (Object[])new Object[0]), e.getMessage()));
            }
        }
    }

    public static void releaseBudgetCosts(List<BudgetCosts> budgetCostsList) {
        String tag = BudgetCostsUpdateHelper.getMethodTag(ADJUST);
        try (TXHandle tx = TX.required((String)tag);){
            try {
                BudgetCostsServiceImpl.releaseBudgetCostList(budgetCostsList);
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error("\u9884\u7b97\u4f59\u989d\u91ca\u653e\u5931\u8d25\uff1a" + e);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9884\u7b97\u4f59\u989d\u91ca\u653e\u5931\u8d25\uff1a%1$s", (String)"BudgetCostsUpdateHelper_2", (String)"occ-ocmem-business", (Object[])new Object[0]), e.getMessage()));
            }
        }
    }

    public static void occupyBudgetCosts(List<BudgetCosts> budgetCostsList) {
        String tag = BudgetCostsUpdateHelper.getMethodTag(ADJUST);
        try (TXHandle tx = TX.required((String)tag);){
            try {
                BudgetCostsServiceImpl.occupyBudgetCostsList(budgetCostsList);
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error("\u9884\u7b97\u4f59\u989d\u5360\u7528\u5931\u8d25\uff1a" + e);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9884\u7b97\u4f59\u989d\u5360\u7528\u5931\u8d25\uff1a%1$s", (String)"BudgetCostsUpdateHelper_3", (String)"occ-ocmem-business", (Object[])new Object[0]), e.getMessage()));
            }
        }
    }

    @Deprecated
    public static DynamicObject getBudgetCostsInfo(long orgId, long channelId, long currencyId, long feeTypeId, Date dateTime) {
        return BudgetCostsServiceImpl.queryBudgetCostsInfo(orgId, channelId, currencyId, feeTypeId, dateTime);
    }

    private static String getMethodTag(String methodName) {
        return String.format("%s.%s", BudgetCostsServiceImpl.class.getName(), methodName);
    }
}

