/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.business.budgetcosts;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.occ.ocmem.common.enums.UpdateOperationEnum;
import kd.occ.ocmem.common.vo.BudgetRecord;
import org.apache.commons.collections.CollectionUtils;

public class BudgetRecordHelper {
    public static void batchInsertRecordList(List<BudgetRecord> budgetRecordParamList, UpdateOperationEnum updateOperationEnum) {
        if (CollectionUtils.isEmpty(budgetRecordParamList)) {
            return;
        }
        ArrayList<DynamicObject> saveBudgetRecordList = new ArrayList<DynamicObject>(budgetRecordParamList.size());
        for (BudgetRecord param : budgetRecordParamList) {
            DynamicObject budgetRecord = BudgetRecordHelper.buildBudgetRecord(param, updateOperationEnum);
            saveBudgetRecordList.add(budgetRecord);
        }
        SaveServiceHelper.save((DynamicObject[])saveBudgetRecordList.toArray(new DynamicObject[saveBudgetRecordList.size()]));
    }

    private static DynamicObject buildBudgetRecord(BudgetRecord budgetRecord, UpdateOperationEnum updateOperationEnum) {
        DynamicObject newDataEntities = BusinessDataServiceHelper.newDynamicObject((String)"ocmem_bgrecord");
        newDataEntities.set("budgetbalance", (Object)budgetRecord.getBudgetBalanceId());
        newDataEntities.set("year", (Object)budgetRecord.getDateTime());
        newDataEntities.set("budgetyear", (Object)budgetRecord.getBudgetYearId());
        newDataEntities.set("org", (Object)budgetRecord.getOrgId());
        newDataEntities.set("feetype", (Object)budgetRecord.getFeeTypeId());
        newDataEntities.set("channel", (Object)budgetRecord.getChannelId());
        newDataEntities.set("currency", (Object)budgetRecord.getCurrencyId());
        newDataEntities.set("sourcebillno", (Object)budgetRecord.getSourceBillNo());
        newDataEntities.set("sourcebill", (Object)budgetRecord.getSourceBill());
        newDataEntities.set("creator", (Object)UserServiceHelper.getCurrentUserId());
        newDataEntities.set("createtime", (Object)TimeServiceHelper.now());
        newDataEntities.set("operation", (Object)updateOperationEnum.getValue());
        newDataEntities.set("beforeamount", (Object)budgetRecord.getBeforeAmount());
        newDataEntities.set("updateamount", (Object)budgetRecord.getUpdateAmount());
        newDataEntities.set("afteramount", (Object)budgetRecord.getAfterAmount());
        return newDataEntities;
    }
}

