/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.business.cost;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.occ.ocbase.common.util.memutil.OCMEMFilterUtil;

public class CostBillServiceHelper {
    private static Log logger = LogFactory.getLog(CostBillServiceHelper.class);

    public static DynamicObject getBillConfigByActivityType(long activityTypeId) {
        QFilter[] qFilters = OCMEMFilterUtil.getQFilter((String)"activitytype", (Object)activityTypeId);
        String selectFields = "id,name,number,billconfigentry.fieldname,isdisplay,isrequired";
        return BusinessDataServiceHelper.loadSingle((String)"ocdbd_billconfig", (String)selectFields, (QFilter[])qFilters);
    }

    public static DynamicObject getBillConfigExpenseType(Object expensetypePk) {
        String selectFields = "id,name,number,billconfigentry.fieldname,isdisplay,isrequired";
        QFilter[] qFilters = OCMEMFilterUtil.getQFilter((String)"expensetype", (Object)expensetypePk);
        DynamicObject[] expensetypes = BusinessDataServiceHelper.load((String)"ocdbd_billconfig", (String)selectFields, (QFilter[])qFilters);
        if (expensetypes.length > 0) {
            return expensetypes[0];
        }
        return null;
    }

    public static void initObjByMap(Object billObj, Map<String, Object> billMap) {
        block4: {
            Set<Map.Entry<String, Object>> entrySet;
            block3: {
                if (billObj == null || billMap == null) {
                    return;
                }
                entrySet = billMap.entrySet();
                if (!(billObj instanceof DynamicObject)) break block3;
                DynamicObject dynamicObject = (DynamicObject)billObj;
                for (Map.Entry<String, Object> entry : entrySet) {
                    dynamicObject.set(entry.getKey(), entry.getValue());
                }
                break block4;
            }
            if (!(billObj instanceof IDataModel)) break block4;
            IDataModel billModel = (IDataModel)billObj;
            for (Map.Entry<String, Object> entry : entrySet) {
                if (billModel.getProperty(entry.getKey()) == null) continue;
                billModel.setValue(entry.getKey(), entry.getValue());
            }
        }
    }

    public static Map<String, Object> createNewData(Long applierId) {
        HashMap<String, Object> billMap = new HashMap<String, Object>();
        if (applierId == null) {
            return billMap;
        }
        Map<String, Object> userMap = CostBillServiceHelper.getUserMap(applierId);
        if (CollectionUtils.isEmpty(userMap)) {
            return billMap;
        }
        DynamicObject dept = (DynamicObject)userMap.get("dept");
        billMap.put("dept", dept);
        billMap.put("costdept", dept);
        Long deptId = null;
        if (dept != null) {
            deptId = (Long)dept.getPkValue();
            Long companyId = CostBillServiceHelper.initCompanyByDept(deptId);
            billMap.put("company", companyId);
            billMap.put("costcompany", companyId);
        }
        billMap.put("applierpositionstr", userMap.get("applierpositionstr"));
        Map<String, Object> retMap = CostBillServiceHelper.getCurrencySet(deptId);
        billMap.put("currencysetting", retMap.get("currencysetting"));
        billMap.put("currency", retMap.get("currency"));
        return billMap;
    }

    public static void changeExpenseTypeFullNameToName(DynamicObject expenseType) {
        QFilter[] qFilters;
        DynamicObject[] expenseTypes;
        if (expenseType != null && (expenseTypes = BusinessDataServiceHelper.load((String)"ocdbd_expensetype", (String)"id,fullname", (QFilter[])(qFilters = OCMEMFilterUtil.getPKQFilter((Object)expenseType.getPkValue())))).length > 0) {
            expenseType.set("name", expenseTypes[0].get("fullname"));
        }
    }

    public static void changeDeptFullNameToName(DynamicObject dept) {
        QFilter[] qFilters;
        DynamicObject[] adminOrgs;
        if (dept != null && (adminOrgs = BusinessDataServiceHelper.load((String)"bos_adminorg_structure", (String)"id,fullname", (QFilter[])(qFilters = OCMEMFilterUtil.getQFilter((String)"org", (Object)dept.getPkValue())))).length > 0) {
            dept.set("name", adminOrgs[0].get("fullname"));
        }
    }

    public static Map<String, Object> getCurrencySet(Long orgId) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        if (orgId == null) {
            RequestContext requestContext = RequestContext.get();
            orgId = requestContext.getOrgId();
        }
        ORM orm = ORM.create();
        Map accountinfo = BaseDataServiceHelper.getBaseAccountingInfo((Long)orgId);
        if (accountinfo != null && accountinfo.size() > 0) {
            QFilter qFilter = new QFilter("id", "=", accountinfo.get("baseCurrencyID"));
            DynamicObjectCollection dynamicObjects = orm.query("bd_currency", "id,name,number,amtprecision,priceprecision,sign,isshowsign", new QFilter[]{qFilter});
            if (dynamicObjects != null && dynamicObjects.size() > 0) {
                retMap.put("currency", dynamicObjects.get(0));
            }
            retMap.put("currencysetting", accountinfo.get("exchangeRateTableID"));
        }
        return retMap;
    }

    public static Long initCompanyByDept(Long deptId) {
        Map company;
        Long companyId = 0L;
        try {
            String fromOrgType = "01";
            String toOrgType = "1";
            Long billTypeId = 0L;
            companyId = OrgServiceHelper.getToOrg((String)fromOrgType, (String)toOrgType, (Long)deptId, (Long)billTypeId);
        }
        catch (Exception e) {
            logger.error("========================get companyId error ", (Throwable)e);
        }
        if (companyId == 0L && (company = OrgServiceHelper.getCompanyfromOrg((Object)deptId)) != null) {
            companyId = (Long)company.get("id");
        }
        return companyId;
    }

    public static Map<String, Object> getUserMap(Long userId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String selectFields = "id,name,number,phone,entryentity.id,entryentity.position,entryentity.dpt.*,entryentity.dpt,entryentity.ispartjob";
        QFilter[] qFilters = OCMEMFilterUtil.getQFilter((String)"id", (Object)userId);
        DynamicObject[] users = BusinessDataServiceHelper.load((String)"bos_user", (String)selectFields, (QFilter[])qFilters);
        if (users.length > 0) {
            DynamicObject user = users[0];
            DynamicObjectCollection userEntrys = user.getDynamicObjectCollection("entryentity");
            for (DynamicObject userEntry : userEntrys) {
                boolean isPartjob = userEntry.getBoolean("ispartjob");
                resultMap.put("applierpositionstr", userEntry.getString("position"));
                DynamicObject dept = userEntry.getDynamicObject("dpt");
                resultMap.put("dept", dept);
                if (isPartjob) continue;
                break;
            }
        }
        return resultMap;
    }
}

