/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.business.cost;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.orm.util.CollectionUtils;

public class MCReimburseUpgradeHelper {
    public static final void upgradeHistoryData() {
        List<Map<String, Object>> list = MCReimburseUpgradeHelper.getNeedUpdateList();
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(list.size());
        ArrayList<Object[]> paramHeadList = new ArrayList<Object[]>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            Map<String, Object> item = list.get(i);
            Object[] param = new Object[]{item.get("fexpensetypeid"), item.get("fparentexpenseid"), item.get("fid")};
            paramList.add(param);
            Object[] paramHead = new Object[]{item.get("factypeid"), item.get("fid")};
            paramHeadList.add(paramHead);
        }
        MCReimburseUpgradeHelper.batchUpdateEntry(paramList);
        MCReimburseUpgradeHelper.batchUpdateHead(paramHeadList);
    }

    private static final void batchUpdateEntry(List<Object[]> paramList) {
        String sql = "UPDATE t_ocmem_mc_reimentry SET frowexpensetypeid=?, frowparentexpenseid=? WHERE fid=? AND frowexpensetypeid=0 AND frowparentexpenseid=0";
        DB.executeBatch((DBRoute)DBRoute.of((String)"drp"), (String)sql, paramList);
    }

    private static final void batchUpdateHead(List<Object[]> paramList) {
        String sql = "UPDATE t_ocmem_mc_reimburse SET factivitytypeid=? WHERE fid=? AND factivitytypeid=0;";
        DB.executeBatch((DBRoute)DBRoute.of((String)"drp"), (String)sql, paramList);
    }

    private static final List<Map<String, Object>> getNeedUpdateList() {
        StringBuilder sql = new StringBuilder(100);
        sql.append(" SELECT t1.fid,factivitytypeid,fexpensetypeid,fparentexpenseid,t2.fnumber,t3.fid as factypeid  ");
        sql.append(" FROM t_ocmem_mc_reimburse t1  ");
        sql.append(" INNER JOIN t_ocdbd_expensetype t2 ON t1.fexpensetypeid=t2.fid  ");
        sql.append(" INNER JOIN t_ocdbd_activitytype t3 ON t2.fnumber=t3.fnumber  ");
        sql.append(" WHERE factivitytypeid=0 AND fexpensetypeid>0 ");
        return (List)DB.query((DBRoute)DBRoute.of((String)"drp"), (String)sql.toString(), (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

            public List<Map<String, Object>> handle(ResultSet rs) throws Exception {
                ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(32);
                while (rs.next()) {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("fid", rs.getLong("fid"));
                    data.put("fnumber", rs.getString("fnumber"));
                    data.put("factivitytypeid", rs.getLong("factivitytypeid"));
                    data.put("fexpensetypeid", rs.getLong("fexpensetypeid"));
                    data.put("fparentexpenseid", rs.getLong("fparentexpenseid"));
                    data.put("factypeid", rs.getLong("factypeid"));
                    dataList.add(data);
                }
                return dataList;
            }
        });
    }
}

