/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.business.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.util.CommonUtils;
import org.apache.commons.lang.StringUtils;

public class BudgetTransferPushHelper {
    private static final String DATAPOOL_TRANSFERIN_BOTP_ID = "1829624682673312768";
    private static final String DATAPOOL_TRANSFEROUT_BOTP_ID = "1829609237392102400";

    public static void push(List<DynamicObject> budgetTransferList) {
        List<DynamicObject> adjustBillList = BudgetTransferPushHelper.budgetTransferPushToBudgetAdjust(budgetTransferList);
        BudgetTransferPushHelper.auditSubmitAndAuditAdjustBills(adjustBillList);
        BudgetTransferPushHelper.updateBudgetTransfetBillStatus(budgetTransferList);
    }

    private static void auditSubmitAndAuditAdjustBills(List<DynamicObject> adjustBillList) {
        List<Object> adjustBillIdList = adjustBillList.stream().map(r -> r.get("id")).collect(Collectors.toList());
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"submit", (String)"ocmem_budgetadjustbill", (DynamicObject[])adjustBillList.toArray(new DynamicObject[0]), (OperateOption)CommonUtils.getOperateOption());
        String errorMsg = BudgetTransferPushHelper.validateResult(operationResult);
        if (StringUtils.isNotEmpty((String)errorMsg)) {
            BudgetTransferPushHelper.rollBackSubmitAdjustBills(adjustBillIdList, operationResult.getSuccessPkIds());
            throw new KDBizException(errorMsg);
        }
        errorMsg = BudgetTransferPushHelper.validateResult(operationResult = BudgetTransferPushHelper.executeOperation("audit", operationResult.getSuccessPkIds()));
        if (StringUtils.isNotEmpty((String)errorMsg)) {
            BudgetTransferPushHelper.rollBackAuditAdjustBills(adjustBillIdList, operationResult.getSuccessPkIds());
            throw new KDBizException(errorMsg);
        }
    }

    private static void rollBackAuditAdjustBills(List<Object> adjustBillIdList, List<Object> auditIdList) {
        BudgetTransferPushHelper.executeOperation("unaudit", auditIdList);
        List<Object> unSubmitIdList = adjustBillIdList.stream().filter(r -> !auditIdList.contains(r)).collect(Collectors.toList());
        BudgetTransferPushHelper.executeOperation("unsubmit", unSubmitIdList);
        BudgetTransferPushHelper.executeOperation("delete", adjustBillIdList);
    }

    private static void rollBackSubmitAdjustBills(List<Object> adjustBillIdList, List<Object> successBillIdList) {
        BudgetTransferPushHelper.executeOperation("unsubmit", successBillIdList);
        BudgetTransferPushHelper.executeOperation("delete", adjustBillIdList);
    }

    private static OperationResult executeOperation(String operation, List<Object> idList) {
        return OperationServiceHelper.executeOperate((String)operation, (String)"ocmem_budgetadjustbill", (Object[])idList.toArray(new Object[0]), (OperateOption)CommonUtils.getOperateOption());
    }

    private static String validateResult(OperationResult result) {
        StringBuilder errorBuilder = new StringBuilder(ResManager.loadKDString((String)"\u9884\u7b97\u7ed3\u8f6c\u5355\u4e0b\u63a8\u751f\u6210\u9884\u7b97\u8c03\u6574\u5355\u5931\u8d25\u3002", (String)"BudgetTransferPushHelper_0", (String)"occ-ocmem-business", (Object[])new Object[0]));
        if (result == null) {
            return errorBuilder.toString();
        }
        if (result.isSuccess()) {
            return null;
        }
        return errorBuilder.append(BudgetTransferPushHelper.getErrDetail(result)).toString();
    }

    private static List<DynamicObject> budgetTransferPushToBudgetAdjust(List<DynamicObject> billDynObjColl) {
        PushArgs pushArgs1 = BudgetTransferPushHelper.buildPushArgs(billDynObjColl);
        pushArgs1.setRuleId(DATAPOOL_TRANSFEROUT_BOTP_ID);
        List<DynamicObject> outResultList = BudgetTransferPushHelper.getConvertOperationResult(pushArgs1, "ocmem_budgetadjustbill");
        PushArgs pushArgs2 = BudgetTransferPushHelper.buildPushArgs(billDynObjColl);
        pushArgs2.setRuleId(DATAPOOL_TRANSFERIN_BOTP_ID);
        List<DynamicObject> inResultList = BudgetTransferPushHelper.getConvertOperationResult(pushArgs2, "ocmem_budgetadjustbill");
        outResultList.addAll(inResultList);
        return outResultList;
    }

    private static PushArgs buildPushArgs(List<DynamicObject> billDynObjColl) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber("ocmem_budgettransfer");
        pushArgs.setTargetEntityNumber("ocmem_budgetadjustbill");
        pushArgs.setHasRight(true);
        pushArgs.setBuildConvReport(true);
        ArrayList<ListSelectedRow> needPushRowList = new ArrayList<ListSelectedRow>(billDynObjColl.size());
        for (DynamicObject billDynObj : billDynObjColl) {
            DynamicObjectCollection entryColl = billDynObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryDynObj : entryColl) {
                ListSelectedRow selectRow = new ListSelectedRow((Object)billDynObj.getLong("id"));
                selectRow.setEntryEntityKey("entryentity");
                selectRow.setEntryPrimaryKeyValue((Object)entryDynObj.getLong("id"));
                needPushRowList.add(selectRow);
            }
        }
        pushArgs.setSelectedRows(needPushRowList);
        return pushArgs;
    }

    private static List<DynamicObject> getConvertOperationResult(PushArgs pushArgs, String billFormId) {
        ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        if (!pushResult.isSuccess()) {
            StringBuilder errMessage = new StringBuilder();
            for (SourceBillReport billReport : pushResult.getBillReports()) {
                if (billReport.isSuccess()) continue;
                errMessage.append(billReport.getFailMessage());
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ed3\u8f6c\u5355\u81ea\u52a8\u751f\u6210\u9884\u7b97\u8c03\u6574\u5355\u51fa\u73b0\u5f02\u5e38\uff1a%1$s", (String)"BudgetTransferPushHelper_1", (String)"occ-ocmem-business", (Object[])new Object[0]), errMessage));
        }
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)billFormId);
        return pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
    }

    private static String getErrDetail(OperationResult optResult) {
        StringBuilder errDetail = new StringBuilder();
        errDetail.append(optResult.getMessage());
        for (IOperateInfo errInfo : optResult.getAllErrorOrValidateInfo()) {
            errDetail.append(errInfo.getMessage());
        }
        return errDetail.toString();
    }

    private static void updateBudgetTransfetBillStatus(List<DynamicObject> budgetTransferList) {
        DynamicObject[] sourceBillList;
        List budgetTransferIdList = budgetTransferList.stream().map(r -> r.get("id")).collect(Collectors.toList());
        QFilter filter = new QFilter("id", "in", budgetTransferIdList);
        for (DynamicObject sourceBill : sourceBillList = BusinessDataServiceHelper.load((String)"ocmem_budgettransfer", (String)"transferstatus", (QFilter[])filter.toArray())) {
            sourceBill.set("transferstatus", (Object)"B");
        }
        SaveServiceHelper.update((DynamicObject[])sourceBillList);
    }
}

