/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.constants.DBRouteConst;
import kd.occ.ocbase.common.entity.BudgetCosts;
import kd.occ.ocbase.common.util.CollectionUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocmem.business.budgetcosts.BudgetCostsUpdateHelper;
import kd.occ.ocmem.common.vo.FixedApplyVo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class FixedBudgetBalanceHelper {
    private static final String SUM_AMT_APPROVED = "sumamtapproved";
    private static final String APPLY_ENTITY_ID = "applyentityid";
    private static final String MARKETAPPLY_COLS = String.join((CharSequence)",", "billno", "budgetyear", "entryentity", "billstatus", "id", "costdept", "currency", "orderchannel", "totalamtapproved", "entryentity.rowexpensetype", "entryentity.balancenumber", "entryentity.id", "entryentity.amount", "entryentity.amtapproved", "entryentity.amtunapproved");

    public static void fixedMarketApplyBudgetBalance() {
        try (TXHandle h = TX.required();){
            try {
                List<FixedApplyVo> fixedApplyVoList = FixedBudgetBalanceHelper.getFixedApplyVoList();
                if (CollectionUtils.isNotEmpty(fixedApplyVoList)) {
                    List<String> balanceNumberList = fixedApplyVoList.stream().map(FixedApplyVo::getBalanceNumber).collect(Collectors.toList());
                    FixedBudgetBalanceHelper.batchLockBalanceBudget(balanceNumberList);
                    FixedBudgetBalanceHelper.fixedMarketBudgetAndBuildAdjustBill(fixedApplyVoList);
                }
            }
            catch (Exception error) {
                h.markRollback();
                throw error;
            }
        }
    }

    private static void fixedMarketBudgetAndBuildAdjustBill(List<FixedApplyVo> fixedApplyVoList) {
        List<Long> applyIdList = fixedApplyVoList.stream().map(FixedApplyVo::getApplyId).collect(Collectors.toList());
        List<DynamicObject> marketApplyList = FixedBudgetBalanceHelper.queryMarketApplyList(applyIdList);
        HashMap<String, DynamicObject> insertBalanceBudgetMap = new HashMap<String, DynamicObject>(fixedApplyVoList.size() * 2);
        Map<String, DynamicObject> adjustBillMap = FixedBudgetBalanceHelper.buildBudgetAdjustBill(marketApplyList, fixedApplyVoList, insertBalanceBudgetMap);
        FixedBudgetBalanceHelper.reCalculateInsertBalanceBudgetMap(adjustBillMap, insertBalanceBudgetMap);
        FixedBudgetBalanceHelper.removeLessThanZeroAdjustBill(adjustBillMap);
        FixedBudgetBalanceHelper.createBudgetAdjustBillList(adjustBillMap);
        Map<String, BigDecimal> approvedAmountMap = fixedApplyVoList.stream().collect(Collectors.toMap(FixedApplyVo::getKey, FixedApplyVo::getActualSumApprovedAmount, (k1, k2) -> k2));
        FixedBudgetBalanceHelper.updateApplyEntry(marketApplyList, insertBalanceBudgetMap, approvedAmountMap);
        SaveServiceHelper.update((DynamicObject[])marketApplyList.toArray(new DynamicObject[marketApplyList.size()]));
    }

    private static void removeLessThanZeroAdjustBill(Map<String, DynamicObject> adjustBillMap) {
        ArrayList<String> removeOrgKeys = new ArrayList<String>(3);
        for (Map.Entry<String, DynamicObject> adjustBill : adjustBillMap.entrySet()) {
            DynamicObjectCollection entryList = adjustBill.getValue().getDynamicObjectCollection("entryentity");
            DynamicObjectCollection saveEntryList = new DynamicObjectCollection();
            for (DynamicObject entry : entryList) {
                BigDecimal afterAmount = entry.getBigDecimal("adjustamount").add(entry.getBigDecimal("oldamount"));
                if (afterAmount.compareTo(BigDecimal.ZERO) < 0) continue;
                entry.set("newamount", (Object)afterAmount);
                saveEntryList.add((Object)entry);
            }
            entryList.clear();
            entryList.addAll((Collection)saveEntryList);
            if (!CollectionUtil.isNull((List)entryList)) continue;
            removeOrgKeys.add(adjustBill.getKey());
        }
        for (String key : removeOrgKeys) {
            adjustBillMap.remove(key);
        }
    }

    private static Map<String, DynamicObject> buildBudgetAdjustBill(List<DynamicObject> marketApplyList, List<FixedApplyVo> fixedApplyVoList, Map<String, DynamicObject> insertBalanceBudgetMap) {
        Map<String, BigDecimal> approvedAmountMap = fixedApplyVoList.stream().collect(Collectors.toMap(FixedApplyVo::getKey, FixedApplyVo::getActualSumApprovedAmount, (k1, k2) -> k2));
        HashMap<String, DynamicObject> adjustBillMap = new HashMap<String, DynamicObject>(fixedApplyVoList.size());
        for (DynamicObject marketApply : marketApplyList) {
            long orgId = DynamicObjectUtils.getPkValue((DynamicObject)marketApply, (String)"costdept");
            long budgetYearId = DynamicObjectUtils.getPkValue((DynamicObject)marketApply, (String)"budgetyear");
            String adjustKey = orgId + "_" + budgetYearId;
            DynamicObjectCollection detailList = marketApply.getDynamicObjectCollection("entryentity");
            Map<String, DynamicObject> detailMap = detailList.stream().collect(Collectors.toMap(a -> DynamicObjectUtils.getPkValue((DynamicObject)marketApply) + "_" + DynamicObjectUtils.getPkValue((DynamicObject)a), a -> a, (k1, k2) -> k2));
            for (Map.Entry<String, DynamicObject> detail : detailMap.entrySet()) {
                BigDecimal sumApprovedAmount = approvedAmountMap.get(detail.getKey());
                DynamicObject detailInfo = detail.getValue();
                BigDecimal approvedAmount = detailInfo.getBigDecimal("amtapproved");
                if (sumApprovedAmount == null || approvedAmount.compareTo(sumApprovedAmount) == 0) continue;
                BigDecimal actualUnApprovedAmount = detailInfo.getBigDecimal("amount").subtract(sumApprovedAmount);
                BigDecimal adjustAmount = actualUnApprovedAmount.subtract(detailInfo.getBigDecimal("amtunapproved"));
                if (!"G".equalsIgnoreCase(DynamicObjectUtils.getString((DynamicObject)marketApply, (String)"billstatus"))) continue;
                DynamicObject adjustBill = (DynamicObject)adjustBillMap.get(adjustKey);
                if (adjustBill == null) {
                    adjustBill = FixedBudgetBalanceHelper.createAdjustBill(orgId, budgetYearId);
                }
                DynamicObjectCollection adjustBillEntrys = adjustBill.getDynamicObjectCollection("entryentity");
                FixedBudgetBalanceHelper.buildAdjustBillEntry(adjustBillEntrys, marketApply, detailInfo, insertBalanceBudgetMap, adjustAmount);
                adjustBillMap.put(adjustKey, adjustBill);
            }
        }
        FixedBudgetBalanceHelper.combineAdjustAmount(adjustBillMap);
        return adjustBillMap;
    }

    private static List<FixedApplyVo> getFixedApplyVoList() {
        DataSet needFixedDataSet = FixedBudgetBalanceHelper.queryNeedToFixedApplyList();
        if (needFixedDataSet.isEmpty()) {
            return new ArrayList<FixedApplyVo>(0);
        }
        ArrayList<FixedApplyVo> fixedApplyVoList = new ArrayList<FixedApplyVo>(20);
        for (Row row : needFixedDataSet) {
            Object sourceId = row.get("sourceid");
            if (sourceId == null) continue;
            FixedApplyVo vo = new FixedApplyVo();
            vo.setApplyId(Long.parseLong(sourceId.toString()));
            String sourceEntryId = row.getString("sourceentryid");
            if (StringUtils.isNotEmpty((String)sourceEntryId)) {
                vo.setApplyEntryId(Long.parseLong(sourceEntryId));
            }
            vo.setActualSumApprovedAmount(row.getBigDecimal(SUM_AMT_APPROVED));
            vo.setBalanceNumber(row.getString("entryentity.balancenumber"));
            fixedApplyVoList.add(vo);
        }
        return fixedApplyVoList;
    }

    private static void batchLockBalanceBudget(List<String> balanceNumberList) {
        if (CollectionUtil.isNotNull(balanceNumberList)) {
            StringBuilder updateSql = new StringBuilder();
            updateSql.append("UPDATE T_OCDBD_BUDGETCOSTS SET FAVAILABLEAMOUNT=FAVAILABLEAMOUNT+0 WHERE FNUMBER=?");
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(balanceNumberList.size());
            for (String number : balanceNumberList) {
                if (!StringUtils.isNotEmpty((String)number)) continue;
                Object[] paramObj = new Object[]{number};
                paramsList.add(paramObj);
            }
            if (CollectionUtil.isNotNull(paramsList)) {
                DB.executeBatch((DBRoute)DBRouteConst.DRP, (String)updateSql.toString(), paramsList);
            }
        }
    }

    private static void reCalculateInsertBalanceBudgetMap(Map<String, DynamicObject> adjustBillMap, Map<String, DynamicObject> insertBalanceBudgetMap) {
        HashMap<Long, BigDecimal> adjustAmountMap = new HashMap<Long, BigDecimal>();
        for (Map.Entry<String, DynamicObject> adjustBill : adjustBillMap.entrySet()) {
            DynamicObjectCollection entry = adjustBill.getValue().getDynamicObjectCollection("entryentity");
            for (DynamicObject detail : entry) {
                long key = DynamicObjectUtils.getPkValue((DynamicObject)detail, (String)"budgetbalance");
                BigDecimal adjustAmount = (BigDecimal)adjustAmountMap.get(key);
                if (adjustAmount == null) {
                    adjustAmount = BigDecimal.ZERO;
                }
                adjustAmount = adjustAmount.add(detail.getBigDecimal("adjustamount"));
                adjustAmountMap.put(key, adjustAmount);
            }
        }
        for (Map.Entry<String, DynamicObject> insertValue : insertBalanceBudgetMap.entrySet()) {
            DynamicObject insertObj = insertValue.getValue();
            long balanceId = DynamicObjectUtils.getPkValue((DynamicObject)insertObj, (String)"budgetbalance");
            BigDecimal adjustAmount = (BigDecimal)adjustAmountMap.get(balanceId);
            if (adjustAmount == null) continue;
            insertObj.set("adjustamount", (Object)adjustAmount);
        }
    }

    private static void updateApplyEntry(List<DynamicObject> updateApplyList, Map<String, DynamicObject> adjustBillEntryMap, Map<String, BigDecimal> amountMap) {
        for (DynamicObject apply : updateApplyList) {
            DynamicObjectCollection detailList = apply.getDynamicObjectCollection("entryentity");
            BigDecimal reCalculateAmount = BigDecimal.ZERO;
            for (DynamicObject detailInfo : detailList) {
                String key = DynamicObjectUtils.getPkValue((DynamicObject)apply) + "_" + DynamicObjectUtils.getPkValue((DynamicObject)detailInfo);
                DynamicObject adjustBalanceBudget = adjustBillEntryMap.get(key);
                if (adjustBalanceBudget != null && adjustBalanceBudget.getBigDecimal("oldamount").add(adjustBalanceBudget.getBigDecimal("adjustamount")).compareTo(BigDecimal.ZERO) < 0) {
                    reCalculateAmount = reCalculateAmount.add(detailInfo.getBigDecimal("amtapproved"));
                    continue;
                }
                if (amountMap.get(key) != null) {
                    BigDecimal sumApprovedAmount = amountMap.get(key);
                    detailInfo.set("amtapproved", (Object)sumApprovedAmount);
                    if (detailInfo.getBigDecimal("amount") != null) {
                        detailInfo.set("amtunapproved", (Object)detailInfo.getBigDecimal("amount").subtract(sumApprovedAmount));
                    }
                }
                reCalculateAmount = reCalculateAmount.add(detailInfo.getBigDecimal("amtapproved"));
            }
            apply.set("totalamtapproved", (Object)reCalculateAmount);
        }
    }

    private static void combineAdjustAmount(Map<String, DynamicObject> adjustBillMap) {
        if (adjustBillMap == null || adjustBillMap.size() == 0) {
            return;
        }
        for (Map.Entry<String, DynamicObject> adjustBill : adjustBillMap.entrySet()) {
            DynamicObjectCollection entryList = adjustBill.getValue().getDynamicObjectCollection("entryentity");
            Map entryMap = entryList.stream().collect(Collectors.groupingBy(obj -> FixedBudgetBalanceHelper.getGroupKey(obj), LinkedHashMap::new, Collectors.toList()));
            entryList.clear();
            for (Map.Entry mapEntry : entryMap.entrySet()) {
                List list = (List)mapEntry.getValue();
                BigDecimal ajustAmount = list.stream().map(obj -> obj.getBigDecimal("adjustamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                DynamicObject dynObj = (DynamicObject)list.get(0);
                dynObj.set("adjustamount", (Object)ajustAmount);
                BigDecimal afterAmount = ajustAmount.add(dynObj.getBigDecimal("oldamount"));
                dynObj.set("newamount", (Object)afterAmount);
                entryList.add((Object)dynObj);
            }
        }
    }

    private static void createBudgetAdjustBillList(Map<String, DynamicObject> adjustBillMap) {
        ArrayList<DynamicObject> saveAdjustBillList = new ArrayList<DynamicObject>(adjustBillMap.size());
        for (Map.Entry<String, DynamicObject> saveBill : adjustBillMap.entrySet()) {
            saveAdjustBillList.add(saveBill.getValue());
        }
        DynamicObject[] saveResult = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])saveAdjustBillList.toArray(new DynamicObject[saveAdjustBillList.size()]));
        FixedBudgetBalanceHelper.updateBudgetCostList(saveResult);
    }

    private static void updateBudgetCostList(DynamicObject[] saveResult) {
        ArrayList<BudgetCosts> budgetCostsList = new ArrayList<BudgetCosts>(saveResult.length * 3);
        for (DynamicObject bill : saveResult) {
            for (DynamicObject entry : bill.getDynamicObjectCollection("entryentity")) {
                BudgetCosts budgetCosts = new BudgetCosts();
                budgetCosts.setSourceBill("ocmem_budgetadjustbill");
                budgetCosts.setSourceBillNo(bill.getString("billno"));
                budgetCosts.setId(DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)entry, (String)"budgetbalance"));
                budgetCosts.setOrgId(DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)entry, (String)"entryorg"));
                budgetCosts.setFeeTypeId(DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)entry, (String)"feetype"));
                budgetCosts.setChannelId(DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)entry, (String)"channel"));
                budgetCosts.setCurrencyId(DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)entry, (String)"currency"));
                budgetCosts.setDateTime(bill.getDate("bizdate"));
                budgetCosts.setAvailableAmount(entry.getBigDecimal("adjustamount"));
                budgetCosts.setBudgetYearId(DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)bill, (String)"budgetyear"));
                budgetCostsList.add(budgetCosts);
            }
        }
        if (!CollectionUtils.isEmpty(budgetCostsList)) {
            BudgetCostsUpdateHelper.updateBudgetCosts(budgetCostsList);
        }
    }

    private static String getGroupKey(DynamicObject entry) {
        return String.format("%d_%d_%d_%d_%d", DynamicObjectUtils.getPkValue((DynamicObject)entry, (String)"entryorg"), DynamicObjectUtils.getPkValue((DynamicObject)entry, (String)"feetype"), DynamicObjectUtils.getPkValue((DynamicObject)entry, (String)"channel"), DynamicObjectUtils.getPkValue((DynamicObject)entry, (String)"budgetbalance"), DynamicObjectUtils.getPkValue((DynamicObject)entry, (String)"currency"));
    }

    private static List<DynamicObject> queryMarketApplyList(List<Long> applyIdList) {
        QFilter filter = new QFilter("id", "in", applyIdList);
        DynamicObject[] updateApplys = BusinessDataServiceHelper.load((String)"ocmem_marketcost_apply", (String)MARKETAPPLY_COLS, (QFilter[])filter.toArray());
        return DynamicObjectUtils.convertDynamicObjList((DynamicObject[])updateApplys);
    }

    private static DataSet queryNeedToFixedApplyList() {
        DataSet mcReimburseDataSet = FixedBudgetBalanceHelper.queryMcReimburseDataSet();
        DataSet marketApplyDataSet = FixedBudgetBalanceHelper.queryMarketApplyDataSet();
        JoinDataSet join = marketApplyDataSet.leftJoin(mcReimburseDataSet);
        return join.on(APPLY_ENTITY_ID, "sourceentryid").on("id", "sourceid").select(new String[]{APPLY_ENTITY_ID, "id", "amtapproved", "budgetyear", "entryentity.balancenumber"}, new String[]{"sourceid", "sourceentryid", SUM_AMT_APPROVED}).finish().filter("sumamtapproved <> amtapproved and sumamtapproved is not null");
    }

    private static DynamicObject createAdjustBill(long orgId, long budgetYearId) {
        DynamicObject adjustBill = BusinessDataServiceHelper.newDynamicObject((String)"ocmem_budgetadjustbill");
        String number = CodeRuleServiceHelper.getNumber((String)adjustBill.getDataEntityType().getName(), (DynamicObject)adjustBill, (String)String.valueOf(orgId));
        adjustBill.set("billno", (Object)number);
        adjustBill.set("billstatus", (Object)"C");
        adjustBill.set("bizdate", (Object)KDDateUtils.now());
        adjustBill.set("adjusttype", (Object)"B");
        adjustBill.set("billsource", (Object)"A");
        adjustBill.set("remark", (Object)ResManager.loadKDString((String)"\u7cfb\u7edf\u81ea\u52a8\u751f\u6210\u3002", (String)"FixedBudgetBalanceHelper_0", (String)"occ-ocmem-business", (Object[])new Object[0]));
        adjustBill.set("creator", (Object)1L);
        adjustBill.set("createtime", (Object)KDDateUtils.now());
        adjustBill.set("budgetyear", (Object)budgetYearId);
        adjustBill.set("modifier", (Object)1L);
        adjustBill.set("modifytime", (Object)KDDateUtils.now());
        adjustBill.set("auditor", (Object)1L);
        adjustBill.set("auditdate", (Object)KDDateUtils.now());
        adjustBill.set("org", (Object)orgId);
        return adjustBill;
    }

    private static void buildAdjustBillEntry(DynamicObjectCollection adjustBillEntrys, DynamicObject apply, DynamicObject detailInfo, Map<String, DynamicObject> insertBalanceBudgetMap, BigDecimal adjustAmount) {
        String budgetNumber = DynamicObjectUtils.getString((DynamicObject)detailInfo, (String)"balancenumber");
        QFilter budgetFilter = new QFilter("number", "=", (Object)budgetNumber);
        DynamicObject budget = BusinessDataServiceHelper.loadSingle((String)"ocdbd_budgetbalance", (String)String.join((CharSequence)",", "id", "number", "availableamount"), (QFilter[])budgetFilter.toArray());
        if (budget != null) {
            long orgId = DynamicObjectUtils.getPkValue((DynamicObject)apply, (String)"costdept");
            long channelId = DynamicObjectUtils.getPkValue((DynamicObject)apply, (String)"orderchannel");
            long currencyId = DynamicObjectUtils.getPkValue((DynamicObject)apply, (String)"currency");
            DynamicObject addEntry = adjustBillEntrys.addNew();
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)addEntry, (String)"entryorg", (long)orgId);
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)addEntry, (String)"feetype", (long)DynamicObjectUtils.getPkValue((DynamicObject)detailInfo, (String)"rowexpensetype"));
            DynamicObject expenseType = DynamicObjectUtils.getDynamicObject((DynamicObject)detailInfo, (String)"rowexpensetype");
            String control = DynamicObjectUtils.getString((DynamicObject)expenseType, (String)"control");
            if (control.contains(",2,")) {
                DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)addEntry, (String)"channel", (long)channelId);
            }
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)addEntry, (String)"budgetbalance", (long)DynamicObjectUtils.getPkValue((DynamicObject)budget));
            addEntry.set("oldamount", (Object)budget.getBigDecimal("availableamount"));
            addEntry.set("adjustamount", (Object)adjustAmount);
            addEntry.set("newamount", (Object)budget.getBigDecimal("availableamount").add(adjustAmount));
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)addEntry, (String)"currency", (long)currencyId);
            insertBalanceBudgetMap.put(DynamicObjectUtils.getPkValue((DynamicObject)apply) + "_" + DynamicObjectUtils.getPkValue((DynamicObject)detailInfo), addEntry);
        }
    }

    private static DataSet queryMcReimburseDataSet() {
        ArrayList<String> billStatusList = new ArrayList<String>(4);
        billStatusList.add("A");
        billStatusList.add("B");
        billStatusList.add("C");
        billStatusList.add("D");
        QFilter reimburseFilter = new QFilter("billstatus", "not in", billStatusList);
        DataSet reimburseDataSet = QueryServiceHelper.queryDataSet((String)FixedBudgetBalanceHelper.class.getName(), (String)"ocmem_mc_reimburse", (String)String.join((CharSequence)",", "entrys.sourceid sourceid", "entrys.sourceentryid sourceentryid", "entrys.amtapproved sumamtapproved"), (QFilter[])reimburseFilter.toArray(), (String)String.join((CharSequence)",", "entrys.sourceid", "entrys.sourceentryid"));
        GroupbyDataSet groupbyDataSet = reimburseDataSet.groupBy(new String[]{"sourceid", "sourceentryid"});
        return groupbyDataSet.sum(SUM_AMT_APPROVED).finish();
    }

    private static DataSet queryMarketApplyDataSet() {
        String[] billStatus = new String[]{"F", "G"};
        QFilter filter = new QFilter("billstatus", "in", (Object)billStatus);
        String queryCols = String.join((CharSequence)",", "billno", "budgetyear", "entryentity", "billstatus", "concat(entryentity.id,\"\") as applyentityid", "concat(id,\"\") as id", "entryentity.balancenumber", "entryentity.amount", "entryentity.amtapproved amtapproved", "entryentity.amtunapproved");
        return QueryServiceHelper.queryDataSet((String)FixedBudgetBalanceHelper.class.getName(), (String)"ocmem_marketcost_apply", (String)queryCols, (QFilter[])filter.toArray(), null);
    }
}

