/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.business.helper;

import java.io.Serializable;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.occ.ocmem.common.constants.BudgetYear;
import org.apache.commons.collections.CollectionUtils;

public class FixedBudgetYearHelper {
    public static void fixedBillBudgetYear() {
        List<BudgetYear> budgetYearList = FixedBudgetYearHelper.queryBudgetYearList();
        FixedBudgetYearHelper.updateAssignBudgetList(budgetYearList);
        FixedBudgetYearHelper.updateExpenseBudgetList(budgetYearList);
        FixedBudgetYearHelper.updateBudgetRecordist(budgetYearList);
        FixedBudgetYearHelper.updatBudgetAdjustBillList(budgetYearList);
        FixedBudgetYearHelper.updateMarketCostApplyBillList(budgetYearList);
        FixedBudgetYearHelper.updateReimburseApplyBillList(budgetYearList);
    }

    private static List<BudgetYear> queryBudgetYearList() {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT FID,FPERIODYEAR,FBEGINDATE,FENDDATE FROM T_OCDBD_ASSESS_PERIOD WHERE FUESTYPE LIKE '%,B,%'", new Object[0]);
        List periodList = (List)DB.query((DBRoute)DBRoute.of((String)"drp"), (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

            public List<Map<String, Object>> handle(ResultSet rs) throws Exception {
                ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(1000);
                while (rs.next()) {
                    HashMap<String, Serializable> data = new HashMap<String, Serializable>(2);
                    data.put("FID", Long.valueOf(rs.getLong("FID")));
                    data.put("FPERIODYEAR", Integer.valueOf(rs.getInt("FPERIODYEAR")));
                    data.put("FBEGINDATE", rs.getDate("FBEGINDATE"));
                    data.put("FENDDATE", rs.getDate("FENDDATE"));
                    dataList.add(data);
                }
                return dataList;
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)periodList)) {
            ArrayList<BudgetYear> budgetYearList = new ArrayList<BudgetYear>(periodList.size());
            for (Map value : periodList) {
                int year = (Integer)value.get("FPERIODYEAR");
                long id = (Long)value.get("FID");
                Date beginDate = (Date)value.get("FBEGINDATE");
                Date endDate = (Date)value.get("FENDDATE");
                BudgetYear budgetYear = new BudgetYear();
                budgetYear.setId(id);
                budgetYear.setYear(year);
                budgetYear.setBeginDate(beginDate);
                budgetYear.setEndDate(endDate);
                budgetYearList.add(budgetYear);
            }
            return budgetYearList;
        }
        return new ArrayList<BudgetYear>(0);
    }

    private static long getDateTimeBudgetYear(Date dateTime, List<BudgetYear> budgetYearList) {
        if (CollectionUtils.isNotEmpty(budgetYearList) && dateTime != null) {
            for (BudgetYear budgetYear : budgetYearList) {
                if (!budgetYear.isBetweenDate(dateTime)) continue;
                return budgetYear.getId();
            }
        }
        return 0L;
    }

    private static void updateReimburseApplyBillList(List<BudgetYear> budgetYearList) {
        if (CollectionUtils.isEmpty(budgetYearList)) {
            return;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT FID,FBILLDATE,FBUDGETYEARID FROM T_OCMEM_MC_REIMBURSE WHERE FBUDGETYEARID = 0 ", new Object[0]);
        List reimburseApplyList = (List)DB.query((DBRoute)DBRoute.of((String)"drp"), (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

            public List<Map<String, Object>> handle(ResultSet rs) throws Exception {
                ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(1000);
                while (rs.next()) {
                    HashMap<String, Comparable<Long>> data = new HashMap<String, Comparable<Long>>(2);
                    data.put("FID", Long.valueOf(rs.getLong("FID")));
                    data.put("FYEAR", rs.getDate("FBILLDATE"));
                    dataList.add(data);
                }
                return dataList;
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)reimburseApplyList)) {
            ArrayList<Object[]> updateList = new ArrayList<Object[]>(reimburseApplyList.size());
            for (Map reimburseApply : reimburseApplyList) {
                Date year = (Date)reimburseApply.get("FYEAR");
                long budgetYearId = FixedBudgetYearHelper.getDateTimeBudgetYear(year, budgetYearList);
                if (budgetYearId <= 0L) continue;
                ArrayList<Long> table = new ArrayList<Long>(2);
                table.add(budgetYearId);
                table.add((Long)reimburseApply.get("FID"));
                updateList.add(table.toArray());
            }
            if (CollectionUtils.isNotEmpty(updateList)) {
                String sql = "UPDATE T_OCMEM_MC_REIMBURSE SET FBUDGETYEARID =? WHERE FID =?";
                DB.executeBatch((DBRoute)DBRoute.of((String)"drp"), (String)sql, updateList);
            }
        }
    }

    private static void updateMarketCostApplyBillList(List<BudgetYear> budgetYearList) {
        if (CollectionUtils.isEmpty(budgetYearList)) {
            return;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT FID,FBILLDATE,FBUDGETYEARID FROM T_OCMEM_MCOST_APPLY WHERE FBUDGETYEARID = 0 ", new Object[0]);
        List costApplyList = (List)DB.query((DBRoute)DBRoute.of((String)"drp"), (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

            public List<Map<String, Object>> handle(ResultSet rs) throws Exception {
                ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(1000);
                while (rs.next()) {
                    HashMap<String, Comparable<Long>> data = new HashMap<String, Comparable<Long>>(2);
                    data.put("FID", Long.valueOf(rs.getLong("FID")));
                    data.put("FYEAR", rs.getDate("FBILLDATE"));
                    dataList.add(data);
                }
                return dataList;
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)costApplyList)) {
            ArrayList<Object[]> updateList = new ArrayList<Object[]>(costApplyList.size());
            for (Map costApply : costApplyList) {
                Date year = (Date)costApply.get("FYEAR");
                long budgetYearId = FixedBudgetYearHelper.getDateTimeBudgetYear(year, budgetYearList);
                if (budgetYearId <= 0L) continue;
                ArrayList<Long> table = new ArrayList<Long>(2);
                table.add(budgetYearId);
                table.add((Long)costApply.get("FID"));
                updateList.add(table.toArray());
            }
            if (CollectionUtils.isNotEmpty(updateList)) {
                String sql = "UPDATE T_OCMEM_MCOST_APPLY SET FBUDGETYEARID =? WHERE FID =?";
                DB.executeBatch((DBRoute)DBRoute.of((String)"drp"), (String)sql, updateList);
            }
        }
    }

    private static void updatBudgetAdjustBillList(List<BudgetYear> budgetYearList) {
        if (CollectionUtils.isEmpty(budgetYearList)) {
            return;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT FID,FBIZDATE,FBUDGETYEARID FROM T_OCMEM_BCADJUSTBILL WHERE FBUDGETYEARID = 0 ", new Object[0]);
        List adjustBudgetList = (List)DB.query((DBRoute)DBRoute.of((String)"drp"), (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

            public List<Map<String, Object>> handle(ResultSet rs) throws Exception {
                ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(1000);
                while (rs.next()) {
                    HashMap<String, Comparable<Long>> data = new HashMap<String, Comparable<Long>>(2);
                    data.put("FID", Long.valueOf(rs.getLong("FID")));
                    data.put("FYEAR", rs.getDate("FBIZDATE"));
                    dataList.add(data);
                }
                return dataList;
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)adjustBudgetList)) {
            ArrayList<Object[]> updateList = new ArrayList<Object[]>(adjustBudgetList.size());
            for (Map adjustBudget : adjustBudgetList) {
                Date year = (Date)adjustBudget.get("FYEAR");
                long budgetYearId = FixedBudgetYearHelper.getDateTimeBudgetYear(year, budgetYearList);
                if (budgetYearId <= 0L) continue;
                ArrayList<Long> table = new ArrayList<Long>(2);
                table.add(budgetYearId);
                table.add((Long)adjustBudget.get("FID"));
                updateList.add(table.toArray());
            }
            if (CollectionUtils.isNotEmpty(updateList)) {
                String sql = "UPDATE T_OCMEM_BCADJUSTBILL SET FBUDGETYEARID =? WHERE FID =?";
                DB.executeBatch((DBRoute)DBRoute.of((String)"drp"), (String)sql, updateList);
            }
        }
    }

    private static void updateBudgetRecordist(List<BudgetYear> budgetYearList) {
        if (CollectionUtils.isEmpty(budgetYearList)) {
            return;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT FID,FYEAR,FBUDGETYEARID FROM T_OCMEM_BGRECORD WHERE FBUDGETYEARID = 0 ", new Object[0]);
        List budgetRecordList = (List)DB.query((DBRoute)DBRoute.of((String)"drp"), (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

            public List<Map<String, Object>> handle(ResultSet rs) throws Exception {
                ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(1000);
                while (rs.next()) {
                    HashMap<String, Comparable<Long>> data = new HashMap<String, Comparable<Long>>(2);
                    data.put("FID", Long.valueOf(rs.getLong("FID")));
                    data.put("FYEAR", rs.getDate("FYEAR"));
                    dataList.add(data);
                }
                return dataList;
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)budgetRecordList)) {
            ArrayList<Object[]> updateList = new ArrayList<Object[]>(budgetRecordList.size());
            for (Map budgetRecord : budgetRecordList) {
                Date year = (Date)budgetRecord.get("FYEAR");
                long budgetYearId = FixedBudgetYearHelper.getDateTimeBudgetYear(year, budgetYearList);
                if (budgetYearId <= 0L) continue;
                ArrayList<Long> table = new ArrayList<Long>(2);
                table.add(budgetYearId);
                table.add((Long)budgetRecord.get("FID"));
                updateList.add(table.toArray());
            }
            if (CollectionUtils.isNotEmpty(updateList)) {
                String sql = "UPDATE T_OCMEM_BGRECORD SET FBUDGETYEARID =? WHERE FID =?";
                DB.executeBatch((DBRoute)DBRoute.of((String)"drp"), (String)sql, updateList);
            }
        }
    }

    private static void updateExpenseBudgetList(List<BudgetYear> budgetYearList) {
        if (CollectionUtils.isEmpty(budgetYearList)) {
            return;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT FID,FYEAR,FBUDGETYEARID FROM T_OCMEM_EXPENSEBUDGET WHERE FBUDGETYEARID = 0 ", new Object[0]);
        List expenseBudgetList = (List)DB.query((DBRoute)DBRoute.of((String)"drp"), (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

            public List<Map<String, Object>> handle(ResultSet rs) throws Exception {
                ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(1000);
                while (rs.next()) {
                    HashMap<String, Comparable<Long>> data = new HashMap<String, Comparable<Long>>(2);
                    data.put("FID", Long.valueOf(rs.getLong("FID")));
                    data.put("FYEAR", rs.getDate("FYEAR"));
                    dataList.add(data);
                }
                return dataList;
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)expenseBudgetList)) {
            ArrayList<Object[]> updateList = new ArrayList<Object[]>(expenseBudgetList.size());
            for (Map expenseBudget : expenseBudgetList) {
                Date year = (Date)expenseBudget.get("FYEAR");
                long budgetYearId = FixedBudgetYearHelper.getDateTimeBudgetYear(year, budgetYearList);
                if (budgetYearId <= 0L) continue;
                ArrayList<Long> table = new ArrayList<Long>(2);
                table.add(budgetYearId);
                table.add((Long)expenseBudget.get("FID"));
                updateList.add(table.toArray());
            }
            if (CollectionUtils.isNotEmpty(updateList)) {
                String sql = "UPDATE T_OCMEM_EXPENSEBUDGET SET FBUDGETYEARID =? WHERE FID =?";
                DB.executeBatch((DBRoute)DBRoute.of((String)"drp"), (String)sql, updateList);
            }
        }
    }

    private static void updateAssignBudgetList(List<BudgetYear> budgetYearList) {
        if (CollectionUtils.isEmpty(budgetYearList)) {
            return;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT FYEAR,FBUDGETYEARID,FID FROM T_OCMEM_ASSIGNBUDGET WHERE FBUDGETYEARID = 0 ", new Object[0]);
        List assignBudgetList = (List)DB.query((DBRoute)DBRoute.of((String)"drp"), (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

            public List<Map<String, Object>> handle(ResultSet rs) throws Exception {
                ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(1000);
                while (rs.next()) {
                    HashMap<String, Comparable<Long>> data = new HashMap<String, Comparable<Long>>(2);
                    data.put("FID", Long.valueOf(rs.getLong("FID")));
                    data.put("FYEAR", rs.getDate("FYEAR"));
                    dataList.add(data);
                }
                return dataList;
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)assignBudgetList)) {
            ArrayList<Object[]> updateList = new ArrayList<Object[]>(assignBudgetList.size());
            for (Map assignBudget : assignBudgetList) {
                Date year = (Date)assignBudget.get("FYEAR");
                long budgetYearId = FixedBudgetYearHelper.getDateTimeBudgetYear(year, budgetYearList);
                if (budgetYearId <= 0L) continue;
                ArrayList<Long> table = new ArrayList<Long>(2);
                table.add(budgetYearId);
                table.add((Long)assignBudget.get("FID"));
                updateList.add(table.toArray());
            }
            if (CollectionUtils.isNotEmpty(updateList)) {
                String sql = "UPDATE T_OCMEM_ASSIGNBUDGET SET FBUDGETYEARID =? WHERE FID =?";
                DB.executeBatch((DBRoute)DBRoute.of((String)"drp"), (String)sql, updateList);
            }
        }
    }
}

