/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.business.money;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.occ.ocbase.common.entity.AccountRecord;
import kd.occ.ocbase.common.entity.BudgetCosts;
import kd.occ.ocbase.common.entity.ItemSup;
import kd.occ.ocbase.common.enums.AccountUpdateTypeEnum;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocmem.business.budgetcosts.BudgetCostsUpdateHelper;
import kd.occ.ocmem.business.cost.CostAppFormHelper;
import org.apache.commons.collections.CollectionUtils;

public class MoneyIncomeHelper {
    public static void batchUpdateRebateAccountListByAudit(DynamicObject[] billDynObjs) {
        List<AccountRecord> accountRecordList = MoneyIncomeHelper.getAccountRecordList(billDynObjs);
        if (!CommonUtils.isNull(accountRecordList)) {
            DispatchServiceHelper.invokeBizService((String)"occ", (String)"occba", (String)"Occba_RebateAccountPoolService", (String)"batchUpdateRebateAccountList", (Object[])new Object[]{accountRecordList});
        }
    }

    public static void releaseBudgetCostsByCostApply(DynamicObject[] costApplyDynObjs, boolean isClose) {
        if (CommonUtils.isNull((Object)costApplyDynObjs)) {
            return;
        }
        ArrayList<BudgetCosts> budgetCostsList = new ArrayList<BudgetCosts>(costApplyDynObjs.length);
        for (DynamicObject info : costApplyDynObjs) {
            DynamicObjectCollection entryCollection = info.getDynamicObjectCollection("entryentity");
            for (DynamicObject eachEntry : entryCollection) {
                DynamicObject expenseType = eachEntry.getDynamicObject("rowexpensetype");
                BigDecimal availableAmount = eachEntry.getBigDecimal("amount");
                if (!CostAppFormHelper.ifBudget(expenseType) || availableAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                if (isClose) {
                    availableAmount = eachEntry.getBigDecimal("amtunapproved");
                }
                BudgetCosts anewBudgetCost = MoneyIncomeHelper.buildBudgetCosts(info, expenseType, eachEntry, availableAmount);
                budgetCostsList.add(anewBudgetCost);
            }
        }
        if (!CollectionUtils.isEmpty(budgetCostsList)) {
            BudgetCostsUpdateHelper.releaseBudgetCosts(budgetCostsList);
        }
    }

    private static BudgetCosts buildBudgetCosts(DynamicObject info, DynamicObject expenseType, DynamicObject detail, BigDecimal availableAmount) {
        BudgetCosts budgetCost = new BudgetCosts();
        String control = expenseType.getString("control");
        if (control.contains("1")) {
            budgetCost.setOrgId(DynamicObjectUtils.getPkValue((DynamicObject)info, (String)"costdept"));
        }
        if (control.contains("2")) {
            budgetCost.setChannelId(DynamicObjectUtils.getPkValue((DynamicObject)info, (String)"orderchannel"));
        }
        budgetCost.setSourceBill("ocmem_marketcost_apply");
        budgetCost.setSourceBillNo(info.getString("billno"));
        budgetCost.setNumber(info.getString("number"));
        budgetCost.setAvailableAmount(availableAmount);
        budgetCost.setDateTime(info.getDate("billdate"));
        budgetCost.setBudgetYearId(DynamicObjectUtils.getPkValue((DynamicObject)info, (String)"budgetyear"));
        budgetCost.setFeeTypeId(DynamicObjectUtils.getPkValue((DynamicObject)expenseType));
        budgetCost.setCurrencyId(DynamicObjectUtils.getPkValue((DynamicObject)info, (String)"currency"));
        QFilter filter = new QFilter("number", "=", (Object)detail.getString("balancenumber"));
        DynamicObject queryObjects = BusinessDataServiceHelper.loadSingle((String)"ocdbd_budgetbalance", (String)"id", (QFilter[])filter.toArray());
        if (queryObjects != null) {
            budgetCost.setId(DynamicObjectUtils.getPkValue((DynamicObject)queryObjects));
        }
        return budgetCost;
    }

    private static List<AccountRecord> getAccountRecordList(DynamicObject[] billDynObjs) {
        ArrayList<AccountRecord> accountRecordList = new ArrayList<AccountRecord>(10);
        if (!CommonUtils.isNull((Object)billDynObjs)) {
            for (DynamicObject billDynObj : billDynObjs) {
                DynamicObjectCollection recEntryColl = billDynObj.getDynamicObjectCollection("entrys");
                for (DynamicObject entryDynObj : recEntryColl) {
                    long accountTypeId = DynamicObjectUtils.getPkValue((DynamicObject)entryDynObj, (String)"entryaccountid");
                    BigDecimal amtApproved = entryDynObj.getBigDecimal("amtapproved");
                    if (accountTypeId == 0L || BigDecimal.ZERO.compareTo(amtApproved) == 0) continue;
                    AccountRecord accountRecord = new AccountRecord();
                    accountRecord.setCustomerId(DynamicObjectUtils.getPkValue((DynamicObject)billDynObj.getDynamicObject("orderchannel"), (String)"customer"));
                    accountRecord.setChannelId(DynamicObjectUtils.getPkValue((DynamicObject)billDynObj, (String)"orderchannel"));
                    accountRecord.setSourceBillNo(billDynObj.getString("billno"));
                    accountRecord.setSourceBillId(DynamicObjectUtils.getPkValue((DynamicObject)billDynObj));
                    accountRecord.setSourceEntryId(DynamicObjectUtils.getPkValue((DynamicObject)entryDynObj));
                    accountRecord.setOrgId(DynamicObjectUtils.getPkValue((DynamicObject)billDynObj, (String)"settleorgid"));
                    accountRecord.setCurrencyId(DynamicObjectUtils.getPkValue((DynamicObject)billDynObj, (String)"currency"));
                    accountRecord.setBillEntity("ocmem_mc_reimburse");
                    accountRecord.setSourceBillNo(billDynObj.getString("billno"));
                    accountRecord.setAccountType(accountTypeId);
                    accountRecord.setAmount(amtApproved);
                    accountRecord.setUpdateType(AccountUpdateTypeEnum.settlementPayment.getValue());
                    accountRecord.setIsAutoCreateRebateAccount(true);
                    accountRecord.setIsAutoCreateItemSupp(true);
                    ArrayList<ItemSup> supList = new ArrayList<ItemSup>(1);
                    ItemSup itemSup = new ItemSup();
                    itemSup.setItemId(DynamicObjectUtils.getPkValue((DynamicObject)entryDynObj, (String)"iteminfo"));
                    itemSup.setMaterialId(DynamicObjectUtils.getPkValue((DynamicObject)entryDynObj, (String)"material"));
                    itemSup.setAuxptyId(DynamicObjectUtils.getPkValue((DynamicObject)entryDynObj, (String)"auxptyid"));
                    itemSup.setUnitId(DynamicObjectUtils.getPkValue((DynamicObject)entryDynObj, (String)"baseunit"));
                    itemSup.setUpdateQty(entryDynObj.getBigDecimal("verifiedqty"));
                    supList.add(itemSup);
                    accountRecord.setSupList(supList);
                    accountRecordList.add(accountRecord);
                }
            }
        }
        return accountRecordList;
    }
}

