/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.business.task;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.occ.ocbase.common.pagemodel.ocmem.OcmemBudgetdatapool;
import kd.occ.ocbase.common.util.CommonUtils;

public class ScrollCalculateExpenseBudgetTask
extends AbstractTask {
    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        DynamicObjectCollection billDynObjColl = this.getBudgetDataPoolColl();
        if (CommonUtils.isNull((Object)billDynObjColl)) {
            return;
        }
        List<DynamicObject> targetBillObjs = this.getConvertResultBill(billDynObjColl);
        if (targetBillObjs == null || targetBillObjs.size() == 0) {
            return;
        }
        OperateOption submitOption = this.getOperateOption();
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"ocmem_budgetadjustbill", (DynamicObject[])targetBillObjs.toArray(new DynamicObject[targetBillObjs.size()]), (OperateOption)submitOption);
        if (!submitResult.isSuccess() && CommonUtils.isNull((Object)submitResult.getSuccessPkIds())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9884\u7b97\u8c03\u6574\u5355\u81ea\u52a8\u63d0\u4ea4\u5931\u8d25\uff1a%1$s", (String)"ScrollCalculateExpenseBudgetTask_0", (String)"occ-ocmem-business", (Object[])new Object[0]), this.getErrDetail(submitResult)));
        }
    }

    private DynamicObjectCollection getBudgetDataPoolColl() {
        QFilter qFilter = new QFilter("billstatus", "=", (Object)"B");
        qFilter = qFilter.and(new QFilter("isrolledbudget", "=", (Object)"0"));
        qFilter = qFilter.and(new QFilter(String.join((CharSequence)".", "entryentity", "taxamount"), ">", (Object)0));
        qFilter = qFilter.and(new QFilter("departmentid", ">", (Object)0));
        qFilter = qFilter.and(new QFilter("settlecurrencyid", "=", (Object)1));
        String selectFields = String.join((CharSequence)",", "id", OcmemBudgetdatapool.E_entryentity_id);
        return QueryServiceHelper.query((String)"ocmem_budgetdatapool", (String)selectFields, (QFilter[])qFilter.toArray());
    }

    private List<DynamicObject> getConvertResultBill(DynamicObjectCollection billDynObjColl) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber("ocmem_budgetdatapool");
        pushArgs.setTargetEntityNumber("ocmem_budgetadjustbill");
        pushArgs.setHasRight(true);
        pushArgs.setBuildConvReport(true);
        ArrayList<ListSelectedRow> needPushRowList = new ArrayList<ListSelectedRow>(billDynObjColl.size());
        for (DynamicObject billDynObj : billDynObjColl) {
            ListSelectedRow srcBill = new ListSelectedRow((Object)billDynObj.getLong("id"));
            srcBill.setEntryEntityKey("entryentity");
            srcBill.setEntryPrimaryKeyValue((Object)billDynObj.getLong(OcmemBudgetdatapool.E_entryentity_id));
            needPushRowList.add(srcBill);
        }
        pushArgs.setSelectedRows(needPushRowList);
        pushArgs.setRuleId("1280286905392675840");
        List<DynamicObject> resultBillList = this.getConvertOperationResult(pushArgs, "ocmem_budgetadjustbill");
        return resultBillList.stream().filter(dynObj -> dynObj.getDynamicObjectCollection("entryentity").size() > 0).collect(Collectors.toList());
    }

    private List<DynamicObject> getConvertOperationResult(PushArgs pushArgs, String billFormId) {
        ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        if (!pushResult.isSuccess()) {
            StringBuilder errMessage = new StringBuilder().append(pushResult.getMessage());
            for (SourceBillReport billReport : pushResult.getBillReports()) {
                if (billReport.isSuccess()) continue;
                errMessage.append(billReport.getFailMessage());
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6eda\u52a8\u9884\u7b97\u81ea\u52a8\u751f\u6210\u9884\u7b97\u8c03\u6574\u5355\u51fa\u73b0\u5f02\u5e38\uff1a%1$s", (String)"ScrollCalculateExpenseBudgetTask_2", (String)"occ-ocmem-business", (Object[])new Object[0]), errMessage));
        }
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)billFormId);
        return pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
    }

    private OperateOption getOperateOption() {
        OperateOption saveOption = OperateOption.create();
        saveOption.setVariableValue("ignorewarn", String.valueOf(true));
        saveOption.setVariableValue("ignoreinteraction", String.valueOf(true));
        saveOption.setVariableValue("strictvalidation", String.valueOf(false));
        saveOption.setVariableValue("ignoreValidation", String.valueOf(true));
        saveOption.setVariableValue("ishasright", "true");
        saveOption.setVariableValue("WF", "false");
        return saveOption;
    }

    private String getErrDetail(OperationResult optResult) {
        StringBuilder errDetail = new StringBuilder();
        errDetail.append(optResult.getMessage());
        for (IOperateInfo errInfo : optResult.getAllErrorOrValidateInfo()) {
            errDetail.append(errInfo.getMessage());
        }
        return errDetail.toString();
    }
}

