/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.business.task;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocmem.business.budgetpool.BudgetPoolSettingHelper;

public class UpdateBudgetDataPoolTask
extends AbstractTask {
    protected Log logger = LogFactory.getLog(UpdateBudgetDataPoolTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        QFilter saleOrderQFilter = BudgetPoolSettingHelper.getSaleOrderPoolSettingFilter();
        if (saleOrderQFilter == null) {
            this.logger.error("\u83b7\u53d6\u8981\u8d27\u8ba2\u5355\u7684QFilter\u4e3a\u7a7a");
            return;
        }
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"ocbsoc_saleorder", (String)"id,itementry.id", (QFilter[])saleOrderQFilter.toArray());
        if (bills == null || bills.size() <= 0) {
            return;
        }
        Map<Long, List<DynamicObject>> map = bills.stream().collect(Collectors.groupingBy(r -> r.getLong("id")));
        this.saleOrderPushBudgetDataPool(map);
    }

    public void saleOrderPushBudgetDataPool(Map<Long, List<DynamicObject>> map) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber("ocbsoc_saleorder");
        pushArgs.setTargetEntityNumber("ocmem_budgetdatapool");
        pushArgs.setHasRight(false);
        pushArgs.setAppId("");
        pushArgs.setDefOrgId(Long.valueOf(0L));
        pushArgs.setRuleId("");
        pushArgs.setBuildConvReport(true);
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>();
        for (Map.Entry<Long, List<DynamicObject>> entry : map.entrySet()) {
            Long billId = entry.getKey();
            List<DynamicObject> saleOrderList = entry.getValue();
            for (DynamicObject saleOrder : saleOrderList) {
                ListSelectedRow srcBill = new ListSelectedRow((Object)billId);
                srcBill.setEntryEntityKey("entryentity");
                srcBill.setEntryPrimaryKeyValue(saleOrder.get("itementry.id"));
                selectedRows.add(srcBill);
            }
        }
        pushArgs.setSelectedRows(selectedRows);
        ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        if (!pushResult.isSuccess()) {
            StringBuilder billMessage = new StringBuilder(ResManager.loadKDString((String)"\u4e0b\u63a8\u5931\u8d25\uff1a", (String)"UpdateBudgetDataPoolTask_2", (String)"occ-ocmem-business", (Object[])new Object[0]));
            billMessage.append(pushResult.getMessage());
            for (SourceBillReport billReport : pushResult.getBillReports()) {
                if (billReport.isSuccess()) continue;
                billMessage.append(billReport.getFailMessage());
            }
            this.logger.error(billMessage.toString());
            throw new KDBizException(billMessage.toString());
        }
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)"ocmem_budgetdatapool");
        List targetBillObjs = pushResult.loadTargetDataObjects(new IRefrencedataProvider(){

            public void fillReferenceData(Object[] objs, IDataEntityType dType) {
                BusinessDataReader.loadRefence((Object[])objs, (IDataEntityType)dType);
            }
        }, targetMainType);
        if (targetBillObjs == null || targetBillObjs.size() == 0) {
            return;
        }
        DynamicObject target = (DynamicObject)targetBillObjs.get(0);
        OperateOption saveOption = OperateOption.create();
        saveOption.setVariableValue("ignorewarn", String.valueOf(true));
        saveOption.setVariableValue("ignoreinteraction", String.valueOf(true));
        saveOption.setVariableValue("strictvalidation", String.valueOf(true));
        OperationResult saveResult = SaveServiceHelper.saveOperate((String)"ocmem_budgetdatapool", (DynamicObject[])targetBillObjs.toArray(new DynamicObject[0]), (OperateOption)saveOption);
        if (!saveResult.isSuccess()) {
            StringBuilder errMessage = new StringBuilder(ResManager.loadKDString((String)"\u9884\u7b97\u6570\u636e\u6c60\u5355\u4fdd\u5b58\u5931\u8d25\uff1a", (String)"UpdateBudgetDataPoolTask_1", (String)"occ-ocmem-business", (Object[])new Object[0]));
            errMessage.append(saveResult.getMessage());
            for (IOperateInfo errInfo : saveResult.getAllErrorOrValidateInfo()) {
                errMessage.append(errInfo.getMessage());
            }
            this.logger.error(errMessage.toString());
            throw new KDBizException(errMessage.toString());
        }
    }
}

