/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.report;

import kd.bos.algo.FilterFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import org.apache.commons.lang.StringUtils;

public class MarketCostFilterFunction
extends FilterFunction {
    private static final long serialVersionUID = 8019698973365431978L;
    private RowMeta rowMeta;

    public MarketCostFilterFunction(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }

    public boolean test(Row row) {
        boolean result = false;
        if (this.checkOrgPattern(row)) {
            result = this.checkExpenseTypeControl(row);
        }
        return result;
    }

    private boolean checkExpenseTypeControl(Row row) {
        int channelIndex = this.rowMeta.getFieldIndex("channel");
        int orgIndex = this.rowMeta.getFieldIndex("org");
        int controlIndex = this.rowMeta.getFieldIndex("control");
        boolean isNeedChannel = StringUtils.contains((String)row.getString(controlIndex), (String)"2");
        boolean isNeedOrg = StringUtils.contains((String)row.getString(controlIndex), (String)"1");
        long channelId = row.getLong(channelIndex) == null ? 0L : row.getLong(channelIndex);
        long orgId = row.getLong(orgIndex) == null ? 0L : row.getLong(orgIndex);
        return isNeedChannel && isNeedOrg && channelId > 0L && orgId > 0L || !isNeedChannel && isNeedOrg && channelId == 0L && orgId > 0L || !isNeedChannel && !isNeedOrg && channelId == 0L && orgId == 0L || isNeedChannel && !isNeedOrg && channelId > 0L && orgId == 0L;
    }

    private boolean checkOrgPattern(Row row) {
        int orgPatternIndex = this.rowMeta.getFieldIndex("orgpattern");
        int expenseTypeOrgPatternIndex = this.rowMeta.getFieldIndex("expensetypeorgpattern");
        if (orgPatternIndex > 0 && expenseTypeOrgPatternIndex > 0 && row.getLong(orgPatternIndex) != null && row.getLong(expenseTypeOrgPatternIndex) != null) {
            return row.getLong(orgPatternIndex).longValue() == row.getLong(expenseTypeOrgPatternIndex).longValue();
        }
        return false;
    }
}

