/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.report;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocmem.report.DateTransform;
import kd.occ.ocmem.report.MarketCostDataTransform;
import kd.occ.ocmem.report.MarketCostRptPlugin;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class MarketCostReportDataHandle
implements IReportDataHandle {
    private Set<String> sumKeyColsList = new HashSet<String>();
    private static final Set<String> commonSumColList = new HashSet<String>(5);

    public void setupCtx(ReportDataCtx ctx) {
        this.setCountQtyCols(ctx);
    }

    private void setCountQtyCols(ReportDataCtx ctx) {
        Set sumQtyCols = ctx.getShowQtyCols();
        sumQtyCols.add("budgetamount");
        sumQtyCols.add("nonreimbursedamount");
        sumQtyCols.add("availableamount");
        ctx.setSumQtyCols4Count(sumQtyCols);
        this.sumKeyColsList.addAll(ctx.getShowKeyCols());
        ctx.getShowKeyCols().addAll(commonSumColList);
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        super.handleBigtableCols(repoColFilter, ctx);
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new DateTransform(ctx));
    }

    public void beforeGroupData(ReportDataCtx ctx) {
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new MarketCostDataTransform(ctx, this.sumKeyColsList));
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        return cols;
    }

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        ReportQueryParam reportQueryParam = (ReportQueryParam)ctx.getParam(MarketCostRptPlugin.class.getName());
        FilterInfo filterInfo = reportQueryParam.getFilter();
        boolean isHandmake = true;
        boolean isApplyClose = false;
        DynamicObject rptColCfg = BusinessDataServiceHelper.loadSingle((Object)1499888184602177536L, (String)"ocmem_rpt_colcfg");
        DynamicObjectCollection configDetail = rptColCfg.getDynamicObjectCollection("entryentity");
        HashMap<String, String> colNameMap = new HashMap<String, String>(3);
        for (DynamicObject colConfig : configDetail) {
            colNameMap.put(DynamicObjectUtils.getString((DynamicObject)colConfig.getDynamicObject("srcentity"), (String)"number"), colConfig.getString("datatimecol"));
        }
        ArrayList<SrcBlockConf> addBlockCollector = new ArrayList<SrcBlockConf>(2);
        for (SrcBlockConf srcBlockConf : blockCollector) {
            SrcBlockConf orgSrcBlockConf;
            QFilter customerFilter2;
            QFilter customerFilter1;
            QFilter dataFs;
            String srcEntity = srcBlockConf.getSrcEntity();
            if ("ocmem_assignbudget".equalsIgnoreCase(srcEntity)) {
                this.handleAssignBudgetBlock(srcBlockConf, filterInfo, (String)colNameMap.get("ocmem_assignbudget"));
                continue;
            }
            if ("ocmem_budgetadjustbill".equalsIgnoreCase(srcEntity) && isHandmake) {
                this.handleHandmakeAdjustBlock(srcBlockConf, filterInfo, (String)colNameMap.get("ocmem_budgetadjustbill"));
                isHandmake = false;
                continue;
            }
            if ("ocmem_budgetadjustbill".equalsIgnoreCase(srcEntity) && !isHandmake) {
                this.handleRollAdjustBlock(srcBlockConf, filterInfo, (String)colNameMap.get("ocmem_budgetadjustbill"));
                continue;
            }
            if ("ocmem_marketcost_apply".equalsIgnoreCase(srcEntity) && !isApplyClose) {
                this.handleMarketCostApplyBlock(srcBlockConf, filterInfo, (String)colNameMap.get("ocmem_marketcost_apply"));
                dataFs = srcBlockConf.getDataFs().copy();
                customerFilter1 = new QFilter("entryentity.rowexpensetype.control", "=", (Object)",1,2,");
                customerFilter2 = new QFilter("entryentity.rowexpensetype.control", "=", (Object)",2,1,");
                customerFilter1 = customerFilter1.or(customerFilter2);
                customerFilter1 = customerFilter1.and(dataFs);
                orgSrcBlockConf = this.buildUnCloseOrgSrcBlockConf(srcBlockConf);
                addBlockCollector.add(orgSrcBlockConf);
                srcBlockConf.setDataFs(customerFilter1);
                isApplyClose = true;
                continue;
            }
            if ("ocmem_marketcost_apply".equalsIgnoreCase(srcEntity) && isApplyClose) {
                this.handleMarketCostApplyBlock(srcBlockConf, filterInfo, (String)colNameMap.get("ocmem_marketcost_apply"));
                QFilter customerFilter12 = new QFilter("entryentity.rowexpensetype.control", "=", (Object)",1,2,");
                QFilter customerFilter22 = new QFilter("entryentity.rowexpensetype.control", "=", (Object)",2,1,");
                customerFilter12 = customerFilter12.or(customerFilter22);
                customerFilter12 = customerFilter12.and(srcBlockConf.getDataFs());
                SrcBlockConf orgSrcBlockConf2 = this.buildCloseOrgSrcBlockConf(srcBlockConf);
                addBlockCollector.add(orgSrcBlockConf2);
                srcBlockConf.setDataFs(customerFilter12);
                continue;
            }
            if (!"ocmem_mc_reimburse".equalsIgnoreCase(srcEntity)) continue;
            this.handleMarketCostReimburseBlock(srcBlockConf, filterInfo, (String)colNameMap.get("ocmem_mc_reimburse"));
            dataFs = srcBlockConf.getDataFs().copy();
            customerFilter1 = new QFilter("entrys.rowexpensetype.control", "=", (Object)",1,2,");
            customerFilter2 = new QFilter("entrys.rowexpensetype.control", "=", (Object)",2,1,");
            customerFilter1 = customerFilter1.or(customerFilter2);
            customerFilter1 = customerFilter1.and(dataFs);
            orgSrcBlockConf = this.createMcReimburseOrgSrcBlockConf(srcBlockConf);
            addBlockCollector.add(orgSrcBlockConf);
            srcBlockConf.setDataFs(customerFilter1);
        }
        if (CollectionUtils.isNotEmpty(addBlockCollector)) {
            blockCollector.addAll(addBlockCollector);
        }
    }

    private SrcBlockConf buildUnCloseOrgSrcBlockConf(SrcBlockConf srcBlockConf) {
        SrcBlockConf orgSrcBlockConf = new SrcBlockConf();
        orgSrcBlockConf.setDefVals(srcBlockConf.getDefVals());
        Map map = srcBlockConf.getRepoColFullSrcColMap();
        int size = map == null ? 0 : map.size();
        HashMap copyMap = new HashMap(size);
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                if ("channel".equalsIgnoreCase((String)entry.getKey())) continue;
                copyMap.put(entry.getKey(), entry.getValue());
            }
        }
        orgSrcBlockConf.setRepoColFullSrcColMap(copyMap);
        orgSrcBlockConf.setRepoColSrcColMap(srcBlockConf.getRepoColSrcColMap());
        orgSrcBlockConf.setSrcEntity(srcBlockConf.getSrcEntity());
        orgSrcBlockConf.setType(srcBlockConf.getType());
        orgSrcBlockConf.setUserFs(srcBlockConf.getUserFs());
        orgSrcBlockConf.setEnbale(true);
        QFilter customerFilter1 = new QFilter("entryentity.rowexpensetype.control", "=", (Object)",1,");
        customerFilter1 = customerFilter1.and(srcBlockConf.getDataFs());
        orgSrcBlockConf.setDataFs(customerFilter1);
        orgSrcBlockConf.setAllowNotMatch(true);
        return orgSrcBlockConf;
    }

    private SrcBlockConf buildCloseOrgSrcBlockConf(SrcBlockConf srcBlockConf) {
        SrcBlockConf orgSrcBlockConf = new SrcBlockConf();
        orgSrcBlockConf.setDefVals(srcBlockConf.getDefVals());
        Map map = srcBlockConf.getRepoColFullSrcColMap();
        HashMap copyMap = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            if ("channel".equalsIgnoreCase((String)entry.getKey())) continue;
            if ("applyamount".equalsIgnoreCase((String)entry.getKey())) {
                copyMap.put(entry.getKey(), "entryentity.amtapproved");
                continue;
            }
            copyMap.put(entry.getKey(), (String)entry.getValue());
        }
        orgSrcBlockConf.setRepoColFullSrcColMap(copyMap);
        orgSrcBlockConf.setRepoColSrcColMap(srcBlockConf.getRepoColSrcColMap());
        orgSrcBlockConf.setSrcEntity(srcBlockConf.getSrcEntity());
        orgSrcBlockConf.setType(srcBlockConf.getType());
        orgSrcBlockConf.setUserFs(srcBlockConf.getUserFs());
        orgSrcBlockConf.setEnbale(true);
        QFilter customerFilter = new QFilter("entryentity.rowexpensetype.control", "=", (Object)",1,");
        customerFilter = customerFilter.and(srcBlockConf.getDataFs());
        orgSrcBlockConf.setDataFs(customerFilter);
        return orgSrcBlockConf;
    }

    private SrcBlockConf createMcReimburseOrgSrcBlockConf(SrcBlockConf srcBlockConf) {
        SrcBlockConf orgSrcBlockConf = new SrcBlockConf();
        orgSrcBlockConf.setDefVals(srcBlockConf.getDefVals());
        Map map = srcBlockConf.getRepoColFullSrcColMap();
        int size = map == null ? 0 : map.size();
        HashMap copyMap = new HashMap(size);
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                if ("channel".equalsIgnoreCase((String)entry.getKey())) continue;
                copyMap.put(entry.getKey(), entry.getValue());
            }
        }
        orgSrcBlockConf.setRepoColFullSrcColMap(copyMap);
        orgSrcBlockConf.setRepoColSrcColMap(srcBlockConf.getRepoColSrcColMap());
        orgSrcBlockConf.setSrcEntity(srcBlockConf.getSrcEntity());
        orgSrcBlockConf.setType(srcBlockConf.getType());
        orgSrcBlockConf.setUserFs(srcBlockConf.getUserFs());
        QFilter dataFs = srcBlockConf.getDataFs();
        QFilter customerFilter = new QFilter("entrys.rowexpensetype.control", "=", (Object)",1,");
        if (dataFs != null) {
            customerFilter.and(dataFs);
        }
        orgSrcBlockConf.setDataFs(customerFilter);
        orgSrcBlockConf.setAllowNotMatch(true);
        return orgSrcBlockConf;
    }

    private void handleMarketCostReimburseBlock(SrcBlockConf srcBlockConf, FilterInfo filterInfo, String sourceEntityCol) {
        QFilter dataFs;
        FilterItemInfo expenseType;
        FilterItemInfo orgPattern;
        FilterItemInfo budgetYear;
        QFilter customerFilter = new QFilter("id", ">", (Object)0L);
        FilterItemInfo startDate = filterInfo.getFilterItem("search_startexpensedate");
        FilterItemInfo endDate = filterInfo.getFilterItem("search_endexpensedate");
        String string = sourceEntityCol = StringUtils.isEmpty((String)sourceEntityCol) ? "billdate" : sourceEntityCol;
        if (startDate != null && startDate.getValue() != null) {
            customerFilter.and(sourceEntityCol, ">=", startDate.getValue());
        }
        if (endDate != null && endDate.getValue() != null) {
            Date lastDay = (Date)endDate.getValue();
            customerFilter.and(sourceEntityCol, "<=", (Object)DateUtil.getDayLast2((Date)lastDay));
        }
        if ((budgetYear = filterInfo.getFilterItem("search_budgetyear")) != null && budgetYear.getValue() != null) {
            DynamicObject budgetYearParam = (DynamicObject)budgetYear.getValue();
            customerFilter.and("budgetyear", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)budgetYearParam));
        }
        if ((orgPattern = filterInfo.getFilterItem("search_orgpattern")) != null && orgPattern.getValue() != null) {
            DynamicObjectCollection orgPatternList = (DynamicObjectCollection)orgPattern.getValue();
            customerFilter.and("costdept.orgpattern", "in", MarketCostReportDataHandle.getBaseDataIds(orgPatternList));
        }
        if ((expenseType = filterInfo.getFilterItem("search_expensetype")) != null && expenseType.getValue() != null) {
            DynamicObjectCollection expenseTypeList = (DynamicObjectCollection)expenseType.getValue();
            customerFilter.and("entrys.rowexpensetype", "in", MarketCostReportDataHandle.getBaseDataIds(expenseTypeList));
        }
        if ((dataFs = srcBlockConf.getDataFs()) != null) {
            customerFilter.and(dataFs);
        }
        srcBlockConf.setDataFs(customerFilter);
        srcBlockConf.setAllowNotMatch(true);
    }

    private void handleMarketCostApplyBlock(SrcBlockConf srcBlockConf, FilterInfo filterInfo, String sourceEntityCol) {
        QFilter dataFs;
        FilterItemInfo expenseType;
        FilterItemInfo orgPattern;
        FilterItemInfo budgetYear;
        QFilter customerFilter = new QFilter("id", ">", (Object)0L);
        FilterItemInfo startDate = filterInfo.getFilterItem("search_startexpensedate");
        FilterItemInfo endDate = filterInfo.getFilterItem("search_endexpensedate");
        String string = sourceEntityCol = StringUtils.isEmpty((String)sourceEntityCol) ? "billdate" : sourceEntityCol;
        if (startDate != null && startDate.getValue() != null) {
            customerFilter.and(sourceEntityCol, ">=", startDate.getValue());
        }
        if (endDate != null && endDate.getValue() != null) {
            Date lastDay = (Date)endDate.getValue();
            customerFilter.and(sourceEntityCol, "<=", (Object)DateUtil.getDayLast2((Date)lastDay));
        }
        if ((budgetYear = filterInfo.getFilterItem("search_budgetyear")) != null && budgetYear.getValue() != null) {
            DynamicObject budgetYearParam = (DynamicObject)budgetYear.getValue();
            customerFilter.and("budgetyear", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)budgetYearParam));
        }
        if ((orgPattern = filterInfo.getFilterItem("search_orgpattern")) != null && orgPattern.getValue() != null) {
            DynamicObjectCollection orgPatternList = (DynamicObjectCollection)orgPattern.getValue();
            customerFilter.and("costdept.orgpattern", "in", MarketCostReportDataHandle.getBaseDataIds(orgPatternList));
        }
        if ((expenseType = filterInfo.getFilterItem("search_expensetype")) != null && expenseType.getValue() != null) {
            DynamicObjectCollection expenseTypeList = (DynamicObjectCollection)expenseType.getValue();
            customerFilter.and("entryentity.rowexpensetype", "in", MarketCostReportDataHandle.getBaseDataIds(expenseTypeList));
        }
        if ((dataFs = srcBlockConf.getDataFs()) != null) {
            customerFilter.and(dataFs);
        }
        srcBlockConf.setDataFs(customerFilter);
        srcBlockConf.setAllowNotMatch(true);
    }

    private void handleRollAdjustBlock(SrcBlockConf srcBlockConf, FilterInfo filterInfo, String sourceEntityCol) {
        QFilter dataFs = srcBlockConf.getDataFs();
        QFilter customerFilter = this.buildBalanceAdjustFilter(filterInfo);
        FilterItemInfo startFixedDate = filterInfo.getFilterItem("search_startrolldate");
        FilterItemInfo endFixedDate = filterInfo.getFilterItem("search_endrolldate");
        String string = sourceEntityCol = StringUtils.isEmpty((String)sourceEntityCol) ? "bizdate" : sourceEntityCol;
        if (startFixedDate != null && startFixedDate.getValue() != null) {
            customerFilter.and(sourceEntityCol, ">=", startFixedDate.getValue());
        }
        if (endFixedDate != null && endFixedDate.getValue() != null) {
            Date lastDay = (Date)endFixedDate.getValue();
            customerFilter.and(sourceEntityCol, "<=", (Object)DateUtil.getDayLast2((Date)lastDay));
        }
        customerFilter.and("billsource", "=", (Object)"B");
        if (dataFs != null) {
            customerFilter.and(dataFs);
        }
        srcBlockConf.setDataFs(customerFilter);
        srcBlockConf.setAllowNotMatch(true);
    }

    private void handleHandmakeAdjustBlock(SrcBlockConf srcBlockConf, FilterInfo filterInfo, String sourceEntityCol) {
        FilterItemInfo budgetYear;
        QFilter dataFs = srcBlockConf.getDataFs();
        QFilter customerFilter = this.buildBalanceAdjustFilter(filterInfo);
        FilterItemInfo startFixedDate = filterInfo.getFilterItem("search_startfixeddate");
        FilterItemInfo endFixedDate = filterInfo.getFilterItem("search_endfixeddate");
        String string = sourceEntityCol = StringUtils.isEmpty((String)sourceEntityCol) ? "bizdate" : sourceEntityCol;
        if (startFixedDate != null && startFixedDate.getValue() != null) {
            customerFilter.and(sourceEntityCol, ">=", startFixedDate.getValue());
        }
        if (endFixedDate != null && endFixedDate.getValue() != null) {
            Date lastDay = (Date)endFixedDate.getValue();
            customerFilter.and(sourceEntityCol, "<=", (Object)DateUtil.getDayLast2((Date)lastDay));
        }
        if ((budgetYear = filterInfo.getFilterItem("budgetyear")) != null && budgetYear.getValue() != null) {
            DynamicObject budgetYearParam = (DynamicObject)budgetYear.getValue();
            customerFilter.and("budgetyear", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)budgetYearParam));
        }
        customerFilter.and("billsource", "=", (Object)"A");
        if (dataFs != null) {
            customerFilter.and(dataFs);
        }
        srcBlockConf.setDataFs(customerFilter);
        srcBlockConf.setAllowNotMatch(true);
    }

    private QFilter buildBalanceAdjustFilter(FilterInfo filterInfo) {
        FilterItemInfo expenseType;
        FilterItemInfo orgPattern;
        QFilter filter = new QFilter("id", ">", (Object)0L);
        FilterItemInfo yearFilter = filterInfo.getFilterItem("search_budgetyear");
        if (yearFilter != null && yearFilter.getValue() != null) {
            DynamicObject budgetYearParam = (DynamicObject)yearFilter.getValue();
            filter.and("budgetyear", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)budgetYearParam));
        }
        if ((orgPattern = filterInfo.getFilterItem("search_orgpattern")) != null && orgPattern.getValue() != null) {
            DynamicObjectCollection orgPatternList = (DynamicObjectCollection)orgPattern.getValue();
            filter.and("entryentity.entryorg.orgpattern", "in", MarketCostReportDataHandle.getBaseDataIds(orgPatternList));
        }
        if ((expenseType = filterInfo.getFilterItem("search_expensetype")) != null && expenseType.getValue() != null) {
            DynamicObjectCollection expenseTypeList = (DynamicObjectCollection)expenseType.getValue();
            filter.and("entryentity.feetype", "in", MarketCostReportDataHandle.getBaseDataIds(expenseTypeList));
        }
        return filter;
    }

    private void handleAssignBudgetBlock(SrcBlockConf srcBlockConf, FilterInfo filterInfo, String sourceEntityCol) {
        QFilter dataFs = srcBlockConf.getDataFs();
        QFilter customerFilter = this.buildAssignBudget(filterInfo, sourceEntityCol);
        if (dataFs != null) {
            customerFilter.and(dataFs);
        }
        srcBlockConf.setDataFs(customerFilter);
        srcBlockConf.setAllowNotMatch(true);
    }

    private QFilter buildAssignBudget(FilterInfo filterInfo, String sourceEntityCol) {
        FilterItemInfo expenseType;
        FilterItemInfo orgPattern;
        FilterItemInfo budgetYear;
        QFilter filter = new QFilter("id", ">", (Object)0L);
        FilterItemInfo yearFilter = filterInfo.getFilterItem("search_budgetyear");
        if (yearFilter != null && yearFilter.getValue() != null) {
            DynamicObject budgetYearParam = (DynamicObject)yearFilter.getValue();
            filter.and("budgetyear", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)budgetYearParam));
        }
        sourceEntityCol = StringUtils.isEmpty((String)sourceEntityCol) ? "bizdate" : sourceEntityCol;
        FilterItemInfo startFixedDate = filterInfo.getFilterItem("search_startfixeddate");
        FilterItemInfo endFixedDate = filterInfo.getFilterItem("search_endfixeddate");
        if (startFixedDate != null && startFixedDate.getValue() != null) {
            filter.and(sourceEntityCol, ">=", startFixedDate.getValue());
        }
        if (endFixedDate != null && endFixedDate.getValue() != null) {
            Date lastDay = (Date)endFixedDate.getValue();
            filter.and(sourceEntityCol, "<=", (Object)DateUtil.getDayLast2((Date)lastDay));
        }
        if ((budgetYear = filterInfo.getFilterItem("budgetyear")) != null && budgetYear.getValue() != null) {
            filter.and("budgetyear", "=", budgetYear.getValue());
        }
        if ((orgPattern = filterInfo.getFilterItem("search_orgpattern")) != null && orgPattern.getValue() != null) {
            DynamicObjectCollection orgPatternList = (DynamicObjectCollection)orgPattern.getValue();
            filter.and("entryentity.assignorgid.orgpattern", "in", MarketCostReportDataHandle.getBaseDataIds(orgPatternList));
        }
        if ((expenseType = filterInfo.getFilterItem("search_expensetype")) != null && expenseType.getValue() != null) {
            DynamicObjectCollection expenseTypeList = (DynamicObjectCollection)expenseType.getValue();
            filter.and("entryentity.assignexpensetypeid", "in", MarketCostReportDataHandle.getBaseDataIds(expenseTypeList));
        }
        return filter;
    }

    private static List<Long> getBaseDataIds(DynamicObjectCollection data) {
        ArrayList<Long> lstBaseDataId = new ArrayList<Long>();
        for (DynamicObject item : data) {
            lstBaseDataId.add(item.getLong("Id"));
        }
        return lstBaseDataId;
    }

    private static Date getLastDayOfYear(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.set(6, 1);
        ((Calendar)calendar).add(1, 1);
        ((Calendar)calendar).add(6, -1);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime();
    }

    static {
        commonSumColList.add("org");
        commonSumColList.add("expensetype");
        commonSumColList.add("parentexpensetype");
        commonSumColList.add("channel");
    }
}

