/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.report;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.KDDateUtils;
import kd.occ.ocbase.common.util.DateUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class MarketCostRptPlugin
extends AbstractReportFormPlugin {
    public void beforeQuery(ReportQueryParam queryParam) {
        this.buildReportParms();
        super.beforeQuery(queryParam);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObject budgetYear = (DynamicObject)this.getModel().getValue("search_budgetyear");
        if (budgetYear == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9884\u7b97\u5e74\u5ea6\u3002", (String)"MarketCostRptPlugin_0", (String)"occ-ocmem-report", (Object[])new Object[0]));
            return false;
        }
        String showKeyCols = (String)filterInfo.getValue("showkeycols");
        if (CollectionUtils.isEmpty(MarketCostRptPlugin.splitCombColToList(showKeyCols))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6c47\u603b\u4f9d\u636e\u3002", (String)"MarketCostRptPlugin_1", (String)"occ-ocmem-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void buildReportParms() {
        ReportQueryParam param = this.getQueryParam();
        param.getCustomParam().put(MarketCostRptPlugin.class.getName(), param);
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
    }

    public static List<String> splitCombColToList(String combColVal) {
        if (combColVal != null) {
            String[] split = combColVal.split(",");
            ArrayList<String> tempSet = new ArrayList<String>(split.length);
            for (String key : split) {
                if (!StringUtils.isNotEmpty((String)key)) continue;
                tempSet.add(key);
            }
            return tempSet;
        }
        return new ArrayList<String>(0);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initDate();
    }

    private void initDate() {
        Date nowDate = KDDateUtils.now();
        Date firstDate = DateUtil.getFirstDayOfYear((Date)nowDate);
        this.getModel().setValue("search_startrolldate", (Object)firstDate);
        this.getModel().setValue("search_endrolldate", (Object)nowDate);
        this.getModel().setValue("search_startexpensedate", (Object)firstDate);
        this.getModel().setValue("search_endexpensedate", (Object)nowDate);
    }
}

