/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.common.util;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.occ.ocbase.common.enums.EnableStatusEnum;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.memutil.OCMEMUtil;
import kd.occ.ocmem.common.enums.BizBillStatusEnum;

public class ToExecFilterUtil {
    private static Log logger = LogFactory.getLog(ToExecFilterUtil.class);

    public static QFilter getOrgFilter() {
        Long userId = UserServiceHelper.getCurrentUserId();
        Long mainOrgId = UserServiceHelper.getUserMainOrgId((long)userId);
        QFilter filter = new QFilter("dept", "=", (Object)mainOrgId);
        return filter;
    }

    public static QFilter getCostTypeFilter() {
        QFilter f = new QFilter("expensetype", "in", ToExecFilterUtil.getCostTypeSet());
        return f;
    }

    public static Set<Object> getCostTypeSet() {
        QFilter filter = new QFilter("costexecute", "=", (Object)"1");
        filter.and("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        DynamicObjectCollection rs = QueryServiceHelper.query((String)"ocdbd_billconfig", (String)"expensetype,enable,costexecute", (QFilter[])filter.toArray());
        HashSet<Object> set = new HashSet<Object>();
        for (DynamicObject obj : rs) {
            set.add(obj.get("expensetype"));
        }
        return set;
    }

    public static QFilter getDateFilter() {
        Date date = new Date();
        date = DateUtil.getDayFirst((Date)date);
        QFilter filter = new QFilter("begindate", "<=", (Object)date);
        filter.and("enddate", ">=", (Object)date);
        return filter;
    }

    public static QFilter getBillStatusFilter() {
        QFilter filter = new QFilter("billstatus", "=", (Object)BizBillStatusEnum.AUDIDPASS.getValue());
        filter.or(new QFilter("billstatus", "=", (Object)BizBillStatusEnum.PARTREFUND.getValue()));
        return filter;
    }

    public static QFilter getMobSetFilter() {
        List ownerIDs;
        Map map = OCMEMUtil.getCustomerIds();
        List supplierIDs = map == null ? null : (List)map.get("SUPPLIER");
        List list = ownerIDs = map == null ? null : (List)map.get("OWNER");
        if (supplierIDs != null && supplierIDs.size() > 0 && (ownerIDs == null || ownerIDs.size() < 1)) {
            return new QFilter("orderChannel", "in", new HashSet(supplierIDs));
        }
        if (ownerIDs != null && ownerIDs.size() > 0 && (supplierIDs == null || supplierIDs.size() < 1)) {
            logger.info(RequestContext.get() + "\u662f\u5185\u90e8\u5ba2\u6237\uff0c\u91c7\u7528\u6807\u51c6\u8fc7\u6ee4");
            logger.info(RequestContext.get() + "\u662f\u5185\u90e8\u5ba2\u6237");
            if (OCMEMUtil.isDispatcher((Object)ownerIDs)) {
                logger.info(RequestContext.get() + "\u662f\u7763\u5bfc\u7528\u6237");
                return null;
            }
        } else {
            return new QFilter("customer", "<", (Object)0);
        }
        return null;
    }

    public static QFilter getDefaultFilter() {
        return ToExecFilterUtil.getCostTypeFilter().and(ToExecFilterUtil.getDateFilter()).and(ToExecFilterUtil.getBillStatusFilter()).and(ToExecFilterUtil.getMobSetFilter());
    }

    public static QFilter getFilterNoDate() {
        return ToExecFilterUtil.getCostTypeFilter().and(ToExecFilterUtil.getBillStatusFilter()).and(ToExecFilterUtil.getMobSetFilter());
    }
}

