/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.formplugin.activityplan;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.helper.CUserHelper;
import kd.occ.ocbase.common.util.CollectionUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.formplugin.base.OcbaseBillPlugin;
import kd.occ.ocmem.business.cost.CostBillServiceHelper;

public class ActivityPlanEdit
extends OcbaseBillPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{"channel"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getView().getModel();
        Long currentUserID = Long.valueOf(RequestContext.get().getUserId());
        Map userMap = CostBillServiceHelper.getUserMap((Long)currentUserID);
        if (!CollectionUtils.isEmpty((Map)userMap)) {
            DynamicObject dept = (DynamicObject)userMap.get("dept");
            model.setValue("planorg", (Object)DynamicObjectUtils.getPkValue((DynamicObject)dept));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "channel": {
                List channelIds = CUserHelper.getAuthorizedChannelIdList((long)RequestContext.get().getCurrUserId());
                ArrayList<QFilter> list = new ArrayList<QFilter>();
                QFilter filter = new QFilter("id", "in", (Object)channelIds);
                list.add(filter);
                ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setQFilters(list);
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.updateFieldEnable();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        int index = this.getRowIndex(e);
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (key) {
            case "item": {
                if (newValue == null) break;
                DynamicObject item = (DynamicObject)newValue;
                this.getModel().setValue("unit", (Object)DynamicObjectUtils.getPkValue((DynamicObject)item, (String)"baseunit"));
                break;
            }
            case "sumfeeamount": {
                BigDecimal sumSaleAmount;
                Object sumSaleAmountValue = this.getModel().getValue("sumsaleamount");
                BigDecimal bigDecimal = sumSaleAmount = sumSaleAmountValue == null ? BigDecimal.ZERO : (BigDecimal)sumSaleAmountValue;
                if (newValue != null && sumSaleAmount.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal sumFeeAmount = (BigDecimal)newValue;
                    this.getModel().setValue("feesalerate", (Object)sumFeeAmount.divide(sumSaleAmount, RoundingMode.HALF_UP).setScale(2));
                    break;
                }
                this.getModel().setValue("feesalerate", (Object)BigDecimal.ZERO);
                break;
            }
            case "sumsaleamount": {
                BigDecimal sumFeeAmount;
                Object sumFeeAmountValue = this.getModel().getValue("sumfeeamount");
                BigDecimal bigDecimal = sumFeeAmount = sumFeeAmountValue == null ? BigDecimal.ZERO : (BigDecimal)sumFeeAmountValue;
                if (newValue != null && sumFeeAmount.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal sSaleAmount = (BigDecimal)newValue;
                    this.getModel().setValue("feesalerate", (Object)sumFeeAmount.divide(sSaleAmount, RoundingMode.HALF_UP).setScale(2));
                    break;
                }
                this.getModel().setValue("feesalerate", (Object)BigDecimal.ZERO);
                break;
            }
            case "expenserowtype": {
                DynamicObject expenseRowType;
                if (newValue == null || !"A".equalsIgnoreCase(DynamicObjectUtils.getString((DynamicObject)(expenseRowType = (DynamicObject)newValue), (String)"typesign"))) break;
                this.getModel().setValue("item", null, index);
                this.getModel().setValue("qty", null, index);
                this.getModel().setValue("price", null, index);
                this.getModel().setValue("unit", null, index);
                break;
            }
            case "feeamount": {
                BigDecimal feeAmount = newValue == null ? BigDecimal.ZERO : (BigDecimal)newValue;
                Object companyRate = this.getModel().getValue("companyrate", index);
                BigDecimal companyRateValue = companyRate == null ? BigDecimal.ZERO : (BigDecimal)companyRate;
                this.getModel().setValue("companyamount", (Object)companyRateValue.multiply(feeAmount).divide(new BigDecimal("100")));
                break;
            }
            case "companyrate": {
                BigDecimal indexCompanyRate = newValue == null ? BigDecimal.ZERO : (BigDecimal)newValue;
                Object indexFeeAmount = this.getModel().getValue("feeamount", index);
                BigDecimal indexFeeAmountValue = indexFeeAmount == null ? BigDecimal.ZERO : (BigDecimal)indexFeeAmount;
                this.getModel().setValue("companyamount", (Object)indexFeeAmountValue.multiply(indexCompanyRate).divide(new BigDecimal("100")));
                break;
            }
            case "channel": {
                if (newValue == null) {
                    this.getView().setEnable(Boolean.TRUE, index, new String[]{"channelgrade", "channelclasses"});
                    break;
                }
                this.getView().setEnable(Boolean.FALSE, index, new String[]{"channelgrade", "channelclasses"});
                break;
            }
            case "channelgrade": {
                if (newValue == null) {
                    this.getView().setEnable(Boolean.TRUE, index, new String[]{"channel", "channelclasses"});
                    break;
                }
                this.getView().setEnable(Boolean.FALSE, index, new String[]{"channel", "channelclasses"});
                break;
            }
            case "channelclasses": {
                if (newValue == null) {
                    this.getView().setEnable(Boolean.TRUE, index, new String[]{"channel", "channelgrade"});
                    break;
                }
                this.getView().setEnable(Boolean.FALSE, index, new String[]{"channel", "channelgrade"});
                break;
            }
            case "planitem": {
                if (newValue == null) {
                    this.getView().setEnable(Boolean.TRUE, index, new String[]{"planitembrand", "planitemgroup"});
                    break;
                }
                DynamicObject item = (DynamicObject)newValue;
                this.getModel().setValue("itemunit", (Object)DynamicObjectUtils.getPkValue((DynamicObject)item, (String)"orderunit"));
                this.getView().setEnable(Boolean.FALSE, index, new String[]{"planitembrand", "planitemgroup"});
                break;
            }
            case "planitembrand": {
                if (newValue == null) {
                    this.getView().setEnable(Boolean.TRUE, index, new String[]{"planitem", "planitemgroup"});
                    break;
                }
                this.getView().setEnable(Boolean.FALSE, index, new String[]{"planitem", "planitemgroup"});
                break;
            }
            case "planitemgroup": {
                if (newValue == null) {
                    this.getView().setEnable(Boolean.TRUE, index, new String[]{"planitem", "planitembrand"});
                    break;
                }
                this.getView().setEnable(Boolean.FALSE, index, new String[]{"planitem", "planitembrand"});
                break;
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        if ("orgentryentity".equals(e.getEntryProp().getName()) && rowDataEntities != null && rowDataEntities.length > 0) {
            int index = rowDataEntities[0].getRowIndex();
            Date startActivityDate = (Date)this.getModel().getValue("startactivitydate");
            long assessPeriodId = this.getAssessPeriodByDate(startActivityDate);
            this.setValue("budgetyear", assessPeriodId, index);
        }
    }

    private long getAssessPeriodByDate(Date date) {
        if (date == null) {
            return 0L;
        }
        QFilter filters = new QFilter("begindate", "<=", (Object)date);
        filters.and("enddate", ">=", (Object)date);
        DynamicObject assessPeriod = BusinessDataServiceHelper.loadSingle((String)"ocdbd_assess_period", (String)"id", (QFilter[])filters.toArray());
        return DynamicObjectUtils.getPkValue((DynamicObject)assessPeriod);
    }

    private void updateFieldEnable() {
        DynamicObjectCollection itemEntryEntity;
        this.getView().setEnable(Boolean.FALSE, new String[]{"billtype"});
        DynamicObjectCollection channelEntryEntity = this.getView().getModel().getEntryEntity("channelentryentity");
        if (CollectionUtil.isNotNull((List)channelEntryEntity)) {
            for (int index = 0; index < channelEntryEntity.size(); ++index) {
                DynamicObject channelEntity = (DynamicObject)channelEntryEntity.get(index);
                if (channelEntity.getDynamicObject("channel") != null) {
                    this.getView().setEnable(Boolean.FALSE, index, new String[]{"channelgrade", "channelclasses"});
                    continue;
                }
                if (channelEntity.getDynamicObject("channelgrade") != null) {
                    this.getView().setEnable(Boolean.FALSE, index, new String[]{"channel", "channelclasses"});
                    continue;
                }
                if (channelEntity.getDynamicObject("channelclasses") == null) continue;
                this.getView().setEnable(Boolean.FALSE, index, new String[]{"channel", "channelgrade"});
            }
        }
        if (CollectionUtil.isNotNull((List)(itemEntryEntity = this.getView().getModel().getEntryEntity("itementryentity")))) {
            for (int index = 0; index < itemEntryEntity.size(); ++index) {
                DynamicObject itemEntity = (DynamicObject)itemEntryEntity.get(index);
                if (itemEntity.getDynamicObject("planitem") != null) {
                    this.getView().setEnable(Boolean.FALSE, index, new String[]{"planitembrand", "planitemgroup"});
                    continue;
                }
                if (itemEntity.getDynamicObject("planitembrand") != null) {
                    this.getView().setEnable(Boolean.FALSE, index, new String[]{"planitem", "planitemgroup"});
                    continue;
                }
                if (itemEntity.getDynamicObject("planitemgroup") == null) continue;
                this.getView().setEnable(Boolean.FALSE, index, new String[]{"planitem", "planitembrand"});
            }
        }
    }
}

