/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.formplugin.babill;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.occ.ocbase.business.helper.AssessPeriodHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.OrgUtil;
import kd.occ.ocbase.formplugin.base.OcbaseBasePlugin;
import kd.occ.ocmem.business.budgetcosts.BudgetCostsServiceImpl;
import kd.occ.ocmem.business.budgetcosts.BudgetCostsUpdateHelper;

public class BudgetAdjustBillEdit
extends OcbaseBasePlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{"entryorg", "feetype"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("budgetyear", (Object)AssessPeriodHelper.getNowAssessPeriodId());
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        DynamicObject bill = this.getModel().getDataEntity();
        DynamicObjectCollection entries = bill.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entries) {
            DynamicObject budgetBalance = entry.getDynamicObject("budgetbalance");
            if (budgetBalance == null) continue;
            BigDecimal availableAmount = budgetBalance.getBigDecimal("availableamount");
            entry.set("oldamount", (Object)availableAmount);
            entry.set("newamount", (Object)availableAmount.add(entry.getBigDecimal("adjustamount")));
        }
        this.getView().updateView("entryentity");
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "entryorg": {
                Object orgId = this.getF7PKValue("org");
                if (orgId != null) {
                    long orgIdL = (Long)orgId;
                    Set orgIds = OrgUtil.querySubOrg((long)orgIdL);
                    orgIds.add(orgIdL);
                    F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("id", "in", (Object)orgIds));
                } else {
                    F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("id", "=", (Object)0L));
                }
                e.getFormShowParameter().setCustomParam("isIncludeAllSub", (Object)true);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e, String key) {
        super.propertyChanged(e, key);
        switch (key) {
            case "entryorg": 
            case "feetype": 
            case "channel": {
                this.setBudgetCosts(e);
                break;
            }
            case "adjustamount": {
                this.calculateNewAmount(e);
                break;
            }
            case "bizdate": {
                Date billDate = (Date)this.getModel().getValue("bizdate");
                if (billDate == null) {
                    this.getModel().setValue("budgetyear", (Object)0L);
                    break;
                }
                this.getModel().setValue("budgetyear", (Object)AssessPeriodHelper.queryAssessPeriod((Date)billDate));
                break;
            }
            case "budgetyear": {
                DynamicObjectCollection detailList = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                detailList.clear();
                this.getView().updateView("entryentity");
                break;
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent e) {
        String itemKey;
        switch (itemKey = e.getItemKey()) {
            case "bar_submit": 
            case "bar_submitandnew": {
                OperateOption paramOperateOption = OperateOption.create();
                paramOperateOption.setVariableValue("notShowSaveMessage", "true");
                this.getView().invokeOperation("save", paramOperateOption);
                break;
            }
        }
    }

    private void calculateNewAmount(PropertyChangedArgs e) {
        int rowIndex = this.getRowIndex(e);
        this.updateEntryAmount(rowIndex);
    }

    private void updateEntryAmount(int rowIndex) {
        BigDecimal oldAmount = (BigDecimal)this.getValue("oldamount", rowIndex);
        BigDecimal adjustAmount = (BigDecimal)this.getValue("adjustamount", rowIndex);
        if (oldAmount != null && adjustAmount != null) {
            this.setValue("newamount", oldAmount.add(adjustAmount), rowIndex);
        }
    }

    private void setBudgetCosts(PropertyChangedArgs e) {
        int rowIndex = this.getRowIndex(e);
        this.fetchBudgetCosts(rowIndex);
    }

    private void fetchBudgetCosts(int rowIndex) {
        long feeTypeId = this.getF7PKLongValue("feetype", rowIndex);
        long orgId = this.getF7PKLongValue("entryorg", rowIndex);
        long channelId = this.getF7PKLongValue("channel", rowIndex);
        long currencyId = this.getF7PKLongValue("currency", rowIndex);
        DynamicObject budgetYear = this.getF7Value("budgetyear");
        long budgetYearId = DynamicObjectUtils.getPkValue((DynamicObject)budgetYear);
        if (budgetYearId == 0L) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8c03\u6574\u5e74\u5ea6\u3002", (String)"BudgetAdjustBillEdit_0", (String)"occ-ocmem-formplugin", (Object[])new Object[0]));
        } else {
            DynamicObject budgetCosts = BudgetCostsServiceImpl.queryBudgetCostsInfo((long)orgId, (long)channelId, (long)currencyId, (long)feeTypeId, (long)budgetYearId);
            if (budgetCosts == null) {
                this.setValue("budgetbalance", null, rowIndex);
                this.setValue("oldamount", BigDecimal.ZERO, rowIndex);
                this.setValue("adjustamount", BigDecimal.ZERO, rowIndex);
                this.setValue("newamount", BigDecimal.ZERO, rowIndex);
            } else {
                this.setValue("budgetbalance", budgetCosts.getPkValue(), rowIndex);
                this.setValue("oldamount", budgetCosts.getBigDecimal("availableamount"), rowIndex);
                this.updateEntryAmount(rowIndex);
            }
        }
    }

    private long getF7PKLongValue(String f7Name, int i) {
        Object pkValue = this.getF7PKValue(f7Name, i);
        return pkValue == null ? 0L : (Long)pkValue;
    }

    private DynamicObject queryBudgetCosts(long orgId, long feeTypeId, long channelId, long currencyId, Date year) {
        return BudgetCostsUpdateHelper.getBudgetCostsInfo((long)orgId, (long)channelId, (long)currencyId, (long)feeTypeId, (Date)year);
    }
}

