/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.formplugin.basedata;

import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.enums.EnableStatusEnum;
import kd.occ.ocbase.common.util.memutil.OCMEMFilterUtil;
import kd.occ.ocmem.business.cost.CostAppFormHelper;
import kd.occ.ocmem.business.cost.CostBillServiceHelper;
import kd.occ.ocmem.formplugin.basedata.OCMEMBillFormPlugin;
import net.sf.json.JSONObject;

public class CostFormPlugin
extends OCMEMBillFormPlugin
implements BeforeF7SelectListener {
    public static final Log logger = LogFactory.getLog(CostFormPlugin.class);
    protected final String SHOP = "shop";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"tbmain", "expensetype"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IDataModel model = this.getView().getModel();
        if (model.getProperty("expensetype") != null) {
            DynamicObject expenseType = (DynamicObject)model.getValue("expensetype");
            CostBillServiceHelper.changeExpenseTypeFullNameToName((DynamicObject)expenseType);
        }
        this.displayEntry();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "expensetype": {
                IDataModel model = this.getView().getModel();
                if (model.getProperty("expensetype") != null) {
                    DynamicObject expenseType = (DynamicObject)model.getValue("expensetype");
                    CostBillServiceHelper.changeExpenseTypeFullNameToName((DynamicObject)expenseType);
                }
                this.displayEntry();
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "expensetype": {
                QFilter[] filters = OCMEMFilterUtil.getQFilter((String)"enable", (Object)EnableStatusEnum.ENABLE.getValue());
                DynamicObjectCollection bcc = QueryServiceHelper.query((String)"ocdbd_billconfig", (String)"expensetype.id,expensetype,expensetype.number,expensetype.name", (QFilter[])filters);
                HashSet<Object> set = new HashSet<Object>(bcc.size());
                for (int i = 0; i < bcc.size(); ++i) {
                    set.add(((DynamicObject)bcc.get(i)).get("expensetype"));
                }
                HashSet<Long> setLong = new HashSet<Long>(set.size());
                for (Object e2 : set) {
                    setLong.add(Long.parseLong(String.valueOf(e2)));
                }
                QFilter filter = new QFilter("id", "in", setLong);
                this.setF7Filter("expensetype", filter);
                ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(filter);
            }
        }
    }

    protected void displayEntry() {
        DynamicObject expensetype = this.getDynamicObject("activitytype");
        if (expensetype != null) {
            Map map = CostAppFormHelper.displayEntry((IFormView)this.getView(), (Object)expensetype.getPkValue(), (String)this.getEntryKey());
            JSONObject entryDisplayMapMapJSON = JSONObject.fromObject((Object)map);
            this.getPageCache().put("entryDisplayMap", entryDisplayMapMapJSON.toString());
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long currentUserID = 0L;
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        if (pageCache.get("consignorId") != null) {
            currentUserID = Long.valueOf(pageCache.get("consignorId"));
            pageCache.remove("consignorId");
        } else {
            RequestContext requestContext = RequestContext.get();
            currentUserID = Long.valueOf(requestContext.getUserId());
        }
        Map billMap = CostBillServiceHelper.createNewData((Long)currentUserID);
        this.initObjByMap(billMap);
    }

    public void initObjByMap(Map<String, Object> billMap) {
        IDataModel model = this.getView().getModel();
        model.setValue("billdate", (Object)new Date());
        CostBillServiceHelper.initObjByMap((Object)model, billMap);
    }
}

