/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.formplugin.basedata;

import java.text.MessageFormat;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Label;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.occ.ocbase.common.constants.OCMEMConstants;
import kd.occ.ocbase.common.util.memutil.OCMEMQueryUtil;
import kd.occ.ocbase.common.util.memutil.OCMEMUtil;
import kd.occ.ocbase.formplugin.base.OCMEMFormPlugin;
import kd.occ.ocmem.common.enums.BizBillStatusEnum;

public class OCMEMBillFormPlugin
extends OCMEMFormPlugin
implements OCMEMConstants {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Label label = (Label)this.getControl("title");
        if (label != null) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String title = formShowParameter.getCaption();
            if (StringUtils.isNotBlank((CharSequence)title)) {
                title = formShowParameter.getFormConfig().getCaption().toString();
            }
            label.setText(formShowParameter.getCaption());
        }
        this.setBillStatus();
    }

    private void setBillStatus() {
        IDataEntityProperty property = this.getModel().getProperty("billstatus");
        if (property != null) {
            if (this.getView().getFormShowParameter().getStatus() == OperationStatus.VIEW) {
                ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
            } else {
                String value = (String)this.getModel().getValue("billstatus");
                if (BizBillStatusEnum.SAVED.getValue().equals(value)) {
                    boolean bFromDb = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
                    if (bFromDb) {
                        ((IBillView)this.getView()).setBillStatus(BillOperationStatus.EDIT);
                    } else {
                        ((IBillView)this.getView()).setBillStatus(BillOperationStatus.ADDNEW);
                    }
                } else if (BizBillStatusEnum.SUBMITED.getValue().equals(value)) {
                    ((IBillView)this.getView()).setBillStatus(BillOperationStatus.SUBMIT);
                } else if (BizBillStatusEnum.AUDITNOPASS.getValue().equals(value) || BizBillStatusEnum.AUDIDPASS.getValue().equals(value) || BizBillStatusEnum.PARTREFUND.getValue().equals(value) || BizBillStatusEnum.CLOSED.getValue().equals(value)) {
                    ((IBillView)this.getView()).setBillStatus(BillOperationStatus.AUDIT);
                    String[] entryActionControls = this.getEntryActionControl();
                    if (entryActionControls != null && entryActionControls.length > 0) {
                        this.setUnEnable(entryActionControls);
                        this.setVisible(entryActionControls);
                    }
                }
            }
        }
    }

    protected String[] getEntryActionControl() {
        return null;
    }

    protected String getEntryKey() {
        return "entryentity";
    }

    protected DynamicObject getDynamicObject(String key) {
        return (DynamicObject)this.getValue(key);
    }

    protected void setOuterCustomerFilter(BeforeF7SelectEvent e, String cusomter) {
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(this.getCustomerFitler());
    }

    protected QFilter getCustomerFitler() {
        Map map = OCMEMUtil.getCustomerIds();
        List ownerIDs = map == null ? null : (List)map.get("OWNER");
        Long userId = UserServiceHelper.getCurrentUserId();
        HashSet<Object> allIds = new HashSet<Object>();
        if (ownerIDs != null && ownerIDs.size() > 0) {
            for (Object ownerID : ownerIDs) {
                Set<Object> set = this.getCustomerIds(ownerID, userId);
                if (set == null) continue;
                for (Object id : set) {
                    allIds.add(id);
                }
            }
        }
        HashSet<Long> allIdsLong = new HashSet<Long>(allIds.size());
        for (Object e : allIds) {
            allIdsLong.add(Long.parseLong(String.valueOf(e)));
        }
        return new QFilter("id", "in", allIdsLong);
    }

    private Set<Object> getCustomerIds(Object ownerID, Object userId) {
        boolean isSaler = OCMEMUtil.isSaler((Object)ownerID);
        Set ids = null;
        ids = isSaler ? OCMEMQueryUtil.queryCustomerPKBySaler((Object)ownerID, (Object)userId) : OCMEMQueryUtil.getAuthSubsIds((Object)ownerID);
        return ids;
    }

    protected void setOuterCustomerFilter(BeforeF7SelectEvent e, String cusomter, String authowner) {
        if (kd.bos.util.StringUtils.isEmpty((String)authowner)) {
            HashSet<Object> innerorgs = new HashSet<Object>();
            QFilter filter = new QFilter("isinnerorg", "=", (Object)Boolean.FALSE);
            DynamicObjectCollection innerorgCustomerCollection = QueryServiceHelper.query((String)"ocdbd_channel", (String)"id", (QFilter[])filter.toArray());
            for (Object innerorgCustomer : innerorgCustomerCollection) {
                innerorgs.add(innerorgCustomer.get("id"));
            }
            HashSet<Long> innerorgsLong = new HashSet<Long>(innerorgs.size());
            for (Object e2 : innerorgs) {
                innerorgsLong.add(Long.parseLong(String.valueOf(e2)));
            }
            filter = new QFilter("id", "in", innerorgsLong);
            this.setF7Filter(cusomter, filter);
            if (e != null) {
                ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(filter);
            }
        } else {
            DynamicObject value = this.getDynamicObject(authowner);
            QFilter filter = new QFilter("salechannel.id", "=", (Object)value);
            DynamicObjectCollection customerCollection = QueryServiceHelper.query((String)"ocdbd_channel_authorize", (String)"orderchannel.id", (QFilter[])filter.toArray());
            HashSet<Object> set = new HashSet<Object>(customerCollection.size());
            for (int i = 0; i < customerCollection.size(); ++i) {
                set.add(((DynamicObject)customerCollection.get(i)).getPkValue());
            }
            HashSet<Long> setLong = new HashSet<Long>(set.size());
            for (Object e3 : set) {
                setLong.add(Long.parseLong(String.valueOf(e3)));
            }
            filter = new QFilter("id", "in", setLong);
            this.setF7Filter(cusomter, filter);
            if (e != null) {
                ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(filter);
            }
        }
    }

    protected OperationResult invokeOperation(DynamicObject[] objs, String operation) throws KDBizException {
        if (objs == null || objs.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25", (String)"OCMEMBillFormPlugin_0", (String)"occ-ocmem-formplugin", (Object[])new Object[0]));
        }
        OperationResult result = OperationServiceHelper.executeOperate((String)operation, (String)objs[0].getDataEntityType().getName(), (DynamicObject[])objs, (OperateOption)OperateOption.create());
        if (!result.isSuccess()) {
            StringBuilder sb = new StringBuilder();
            List validResultList = result.getValidateResult().getValidateErrors();
            for (ValidateResult validation : validResultList) {
                validation.getAllErrorInfo().forEach(info -> sb.append(info.getMessage()).append(','));
            }
            if (sb.length() == 0) {
                throw new KDBizException(result.getMessage());
            }
            throw new KDBizException(MessageFormat.format("{0} - {1}", result.getMessage(), sb));
        }
        return result;
    }
}

