/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.formplugin.budgetpool;

import java.util.Collections;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.occ.ocbase.common.util.StringUtils;

public class BudgetPoolSettingEdit
extends AbstractBillPlugIn
implements BeforeFilterF7SelectListener,
EntryGridBindDataListener {
    private static final String filtergridap = "filtergridap";

    public void beforeF7Select(BeforeFilterF7SelectEvent arg0) {
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setFilterDetailValues("filterscheme", filtergridap);
    }

    public void beforeBindData(EventObject e) {
        super.afterBindData(e);
        this.updateRequestFilterCols(false);
    }

    private void setFilterDetailValues(String ctrlName, String filterGrid) {
        FilterGrid filterGridCtrl = (FilterGrid)this.getView().getControl(filterGrid);
        FilterCondition filterCondition = this.loadFilter(ctrlName);
        if (filterCondition != null) {
            filterGridCtrl.SetValue(filterCondition);
            this.getView().updateView(filterGrid);
        }
    }

    private FilterCondition loadFilter(String ctrlName) {
        Object filter = this.getModel().getValue(ctrlName);
        if (StringUtils.isEmpty((Object)filter)) {
            return null;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filter.toString(), FilterCondition.class);
        return filterCondition;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        int index = valueSet[0].getRowIndex();
        switch (key) {
            case "billentity": {
                this.updateRequestFilterCols(true);
                break;
            }
        }
    }

    private void updateRequestFilterCols(boolean changed) {
        MainEntityType entityType = this.getRequireBillMainEntityType();
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(filtergridap);
        if (entityType == null) {
            filterGrid.SetValue(new FilterCondition());
            filterGrid.setFilterColumns(Collections.EMPTY_LIST);
        } else {
            if (changed) {
                filterGrid.SetValue(new FilterCondition());
            }
            filterGrid.setEntityNumber(entityType.getName());
        }
        this.getView().updateView(filtergridap);
    }

    private MainEntityType getRequireBillMainEntityType() {
        IDataModel model = this.getModel();
        DynamicObject requireBill = model.getDataEntity().getDynamicObject("billentity");
        if (requireBill == null) {
            return null;
        }
        String metaDataNo = requireBill.getString("number");
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)metaDataNo);
        return mainEntityType;
    }

    private void beforeSave() {
        IDataModel model = this.getModel();
        String requestFilter = this.getRequestFilterStr();
        model.setValue("filterscheme", (Object)requestFilter);
    }

    private String getRequestFilterStr() {
        FilterGrid grid = (FilterGrid)this.getControl(filtergridap);
        if (grid == null) {
            return null;
        }
        FilterCondition condition = grid.getFilterGridState().getFilterCondition();
        return SerializationUtils.toJsonString((Object)condition);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "save": {
                this.beforeSave();
                break;
            }
            case "submit": {
                this.beforeSave();
                break;
            }
        }
    }
}

