/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.formplugin.budgettransfer;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.helper.CUserHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.UserUtil;
import kd.occ.ocbase.formplugin.base.OcbaseBasePlugin;

public class BudgetTransferEdit
extends OcbaseBasePlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{"outbudgetbalance", "inchannel", "inexpensetype", "outbudgetbalance", "outbudgetyear", "inbudgetyear"});
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "outbudgetbalance": {
                this.addOutBudgetBalanceFilter(e);
                break;
            }
            case "inchannel": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("id", "in", (Object)CUserHelper.getAuthorizedChannelIdList((long)UserUtil.getCurrUserId(), (boolean)false)));
                break;
            }
        }
    }

    private void addOutBudgetBalanceFilter(BeforeF7SelectEvent e) {
        DynamicObject outBudgetYear = (DynamicObject)this.getModel().getValue("outbudgetyear");
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter = filter.and("availableamount", "!=", (Object)0);
        filter = filter.and("budgetyear", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)outBudgetYear));
        DynamicObject[] budgetBalanceList = BusinessDataServiceHelper.load((String)"ocdbd_budgetbalance", (String)String.join((CharSequence)",", "org", "feetype"), (QFilter[])filter.toArray());
        ArrayList<Long> idList = new ArrayList<Long>(budgetBalanceList.length);
        for (DynamicObject budgetBalance : budgetBalanceList) {
            DynamicObject org = DynamicObjectUtils.getDynamicObject((DynamicObject)budgetBalance, (String)"org");
            DynamicObject feeType = DynamicObjectUtils.getDynamicObject((DynamicObject)budgetBalance, (String)"feetype");
            if (DynamicObjectUtils.getPkValue((DynamicObject)org, (String)"orgpattern") != DynamicObjectUtils.getPkValue((DynamicObject)feeType, (String)"orgpattern")) continue;
            idList.add(DynamicObjectUtils.getPkValue((DynamicObject)budgetBalance));
        }
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        showParameter.setShowApproved(false);
        F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("id", "in", idList));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        int rowIndex = this.getRowIndex(e);
        switch (key = e.getProperty().getName()) {
            case "outbudgetyear": {
                this.getModel().deleteEntryData("entryentity");
                this.getView().updateView("entryentity");
                break;
            }
            case "outbudgetbalance": {
                DynamicObject outBudgetBalance = (DynamicObject)e.getChangeSet()[0].getNewValue();
                this.updateInBudgetBalanceInfo(outBudgetBalance, rowIndex);
                break;
            }
            case "inorg": {
                this.updateBudgetBalanceInfo(rowIndex);
                break;
            }
            case "inchannel": {
                this.updateBudgetBalanceInfo(rowIndex);
                break;
            }
            case "inexpensetype": {
                this.updateBudgetBalanceInfo(rowIndex);
                DynamicObject expenseType = (DynamicObject)this.getModel().getValue("inexpensetype", rowIndex);
                String control = DynamicObjectUtils.getString((DynamicObject)expenseType, (String)"control");
                if (expenseType == null || control.contains("2")) {
                    this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"inchannel"});
                    break;
                }
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"inchannel"});
                break;
            }
            case "inbudgetyear": {
                DynamicObjectCollection detailInfoList = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                DynamicObject budgetYear = (DynamicObject)e.getChangeSet()[0].getNewValue();
                long budgetYearId = DynamicObjectUtils.getPkValue((DynamicObject)budgetYear);
                for (DynamicObject detail : detailInfoList) {
                    long orgId = DynamicObjectUtils.getPkValue((DynamicObject)detail.getDynamicObject("inorg"));
                    long channelId = DynamicObjectUtils.getPkValue((DynamicObject)detail.getDynamicObject("inchannel"));
                    long currenryId = DynamicObjectUtils.getPkValue((DynamicObject)detail.getDynamicObject("outcurrency"));
                    long expenseTypeId = DynamicObjectUtils.getPkValue((DynamicObject)detail.getDynamicObject("inexpensetype"));
                    DynamicObject budgetBalance = this.queryBudgetBalanceInfo(orgId, channelId, expenseTypeId, currenryId, budgetYearId);
                    if (budgetBalance == null) {
                        detail.set("inbudgetbalance", (Object)0L);
                        detail.set("inbudgetamount", (Object)BigDecimal.ZERO);
                        continue;
                    }
                    detail.set("inbudgetbalance", (Object)budgetBalance);
                    detail.set("inbudgetamount", (Object)DynamicObjectUtils.getBigDecimal((DynamicObject)budgetBalance, (String)"availableamount"));
                }
                this.getView().updateView("entryentity");
                break;
            }
        }
    }

    private void updateInBudgetBalanceInfo(DynamicObject outBudgetBalance, int rowIndex) {
        if (outBudgetBalance == null) {
            this.getModel().setValue("inorg", null, rowIndex);
            this.getModel().setValue("inchannel", null, rowIndex);
            this.getModel().setValue("inexpensetype", null, rowIndex);
            this.getModel().setValue("inbudgetbalance", null, rowIndex);
            this.getModel().setValue("inbudgetamount", (Object)BigDecimal.ZERO, rowIndex);
            return;
        }
        this.getModel().setValue("inorg", (Object)DynamicObjectUtils.getPkValue((DynamicObject)outBudgetBalance, (String)"org"), rowIndex);
        this.getModel().setValue("inchannel", (Object)DynamicObjectUtils.getPkValue((DynamicObject)outBudgetBalance, (String)"channel"), rowIndex);
        this.getModel().setValue("inexpensetype", (Object)DynamicObjectUtils.getPkValue((DynamicObject)outBudgetBalance, (String)"feetype"), rowIndex);
        this.updateBudgetBalanceInfo(rowIndex);
    }

    private void updateBudgetBalanceInfo(int rowIndex) {
        DynamicObject budgetYear = (DynamicObject)this.getValue("inbudgetyear");
        DynamicObject currenry = (DynamicObject)this.getModel().getValue("outcurrency", rowIndex);
        DynamicObject org = (DynamicObject)this.getModel().getValue("inorg", rowIndex);
        DynamicObject expenseType = (DynamicObject)this.getModel().getValue("inexpensetype", rowIndex);
        if (budgetYear == null || currenry == null || org == null || expenseType == null) {
            this.getModel().setValue("inbudgetbalance", (Object)-1, rowIndex);
            return;
        }
        DynamicObject channel = (DynamicObject)this.getModel().getValue("inchannel", rowIndex);
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)org);
        long channelId = DynamicObjectUtils.getPkValue((DynamicObject)channel);
        long currenryId = DynamicObjectUtils.getPkValue((DynamicObject)currenry);
        long budgetYearId = DynamicObjectUtils.getPkValue((DynamicObject)budgetYear);
        long expenseTypeId = DynamicObjectUtils.getPkValue((DynamicObject)expenseType);
        DynamicObject budgetBalance = this.queryBudgetBalanceInfo(orgId, channelId, expenseTypeId, currenryId, budgetYearId);
        if (budgetBalance == null) {
            this.getModel().setValue("inbudgetbalance", null, rowIndex);
            this.getModel().setValue("inbudgetamount", (Object)0, rowIndex);
            return;
        }
        this.getModel().setValue("inbudgetbalance", (Object)DynamicObjectUtils.getPkValue((DynamicObject)budgetBalance), rowIndex);
        this.getModel().setValue("inbudgetamount", (Object)DynamicObjectUtils.getBigDecimal((DynamicObject)budgetBalance, (String)"availableamount"), rowIndex);
    }

    private DynamicObject queryBudgetBalanceInfo(long orgId, long channelId, long expenseTypeId, long currenryId, long budgetYearId) {
        QFilter filters = new QFilter("org", "=", (Object)orgId);
        filters = filters.and("channel", "=", (Object)channelId);
        filters = filters.and("feetype", "=", (Object)expenseTypeId);
        filters = filters.and("currency", "=", (Object)currenryId);
        filters = filters.and("budgetyear", "=", (Object)budgetYearId);
        return BusinessDataServiceHelper.loadSingle((String)"ocdbd_budgetbalance", (String)"id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,longnumber,level,fullname,isleaf,parent,org,feetype,channel,currency,amount,availableamount,usedamount,sourcebill,year,yearestimateamt,writeoffamt,budgetyear", (QFilter[])filters.toArray());
    }
}

