/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.formplugin.cost;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.util.memutil.OCMEMFilterUtil;

public class CostExecuteListFormPlugin
extends AbstractFormPlugin {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setBaseInfo();
        this.initListExecPage();
    }

    private void setBaseInfo() {
        Object pk = this.getView().getFormShowParameter().getCustomParam("COST_APPLY_ENTRYID");
        if (pk != null) {
            DynamicObject entryInfo = QueryServiceHelper.queryOne((String)"ocmem_mcostapply_entry", (String)this.getOql().toString(), (QFilter[])OCMEMFilterUtil.getQFilter((String)"id", (Object)Long.parseLong((String)pk)));
            this.setBaseInfo(entryInfo);
        }
    }

    private Object getOql() {
        StringBuffer oql = new StringBuffer();
        oql.append("id,shop,shop.address,shop.area,shop.phone,");
        oql.append("displayarea,entrybegindate,entryenddate,promotion,remark");
        return oql;
    }

    private void setBaseInfo(DynamicObject entryInfo) {
        if (entryInfo.get("shop") != null) {
            if (entryInfo.get("shop.storetype") != null) {
                this.getModel().setValue("storetype", (Object)entryInfo.getString("shop.storetype.name"));
            }
            this.getModel().setValue("address", (Object)entryInfo.getString("shop.address"));
            if (entryInfo.getString("shop.area") != null) {
                String str = entryInfo.getString("shop.area");
                if (str.indexOf(46) > 0) {
                    str = str.replaceAll("0+?$", "");
                    str = str.replaceAll("[.]$", "");
                }
                this.getModel().setValue("shoparea", (Object)str);
            }
        }
        this.getModel().setValue("displayarea", (Object)entryInfo.getString("displayarea"));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date begin = entryInfo.getDate("entrybegindate");
        Date end = entryInfo.getDate("entryenddate");
        this.getModel().setValue("begintoend", (Object)(sdf.format(begin) + sdf.format(end)));
        this.getModel().setValue("reason", (Object)"");
        this.getModel().setValue("promotion", (Object)entryInfo.getBoolean("promotion"));
        this.getModel().setValue("remark", (Object)entryInfo.getString("remark"));
    }

    protected void initListExecPage() {
        Object markCostApplyBillId;
        Object markCostApplyBillEntryId = this.getView().getFormShowParameter().getCustomParam("COST_APPLY_ENTRYID");
        QFilter[] qFilter = null;
        if (markCostApplyBillEntryId != null) {
            qFilter = OCMEMFilterUtil.getQFilter((String)"costapplyentry", (Object)Long.parseLong((String)markCostApplyBillEntryId));
        }
        if (qFilter == null && (markCostApplyBillId = this.getView().getFormShowParameter().getCustomParam("COST_APPLY_BILLID")) != null) {
            DynamicObject markCostApplyBill = BusinessDataServiceHelper.loadSingle((String)"ocmem_marketcost_apply", (String)"id,billno,entryentity.id,entryentity.shop", (QFilter[])OCMEMFilterUtil.getQFilter((String)"id", (Object)Long.parseLong((String)markCostApplyBillId)));
            DynamicObjectCollection entryCollection = markCostApplyBill.getDynamicObjectCollection("entryentity");
            int size = entryCollection.size();
            HashSet<Long> set = new HashSet<Long>(size);
            for (int i = 0; i < size; ++i) {
                DynamicObject entry = (DynamicObject)entryCollection.get(i);
                set.add((Long)entry.getPkValue());
            }
            qFilter = OCMEMFilterUtil.getQFilter((String)"costapplyentry", (String)"in", set);
        }
        if (qFilter != null) {
            Container flexexeclist = (Container)this.getView().getControl("flexexeclist");
            DynamicObjectCollection costExecCollection = QueryServiceHelper.query((String)"ocmem_marketcostexecute", (String)"id", (QFilter[])qFilter, (String)"createtime");
            if (costExecCollection == null || costExecCollection.size() < 1) {
                return;
            }
            for (int i = 0; i < costExecCollection.size(); ++i) {
                DynamicObject info = (DynamicObject)costExecCollection.get(i);
                FlexPanelAp flexAp = new FlexPanelAp();
                flexAp.setKey(info.get("id").toString());
                ArrayList<Map> list = new ArrayList<Map>();
                list.add(flexAp.createControl());
                flexexeclist.insertControls(i, list);
                String pageid = this.showForm(ShowType.InContainer, info.get("id").toString(), i);
                IFormView view = this.getView().getView(pageid);
                this.getView().sendFormAction(view);
            }
        }
    }

    private String showForm(ShowType showType, String targetKey, int index) {
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(showType);
        param.getOpenStyle().setTargetKey(targetKey);
        param.setFormId("ocmem_costexecute_sview");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("applyid", targetKey);
        params.put("form_index", index);
        param.setCustomParams(params);
        this.getView().showForm(param);
        return param.getPageId();
    }
}

