/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.formplugin.cost;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.util.StringUtils;
import kd.occ.ocbase.business.helper.AssessPeriodHelper;
import kd.occ.ocbase.common.enums.GoodsTypeEnum;
import kd.occ.ocbase.common.enums.StatusEnum;
import kd.occ.ocbase.common.enums.changemodel.EnableStatusEnum;
import kd.occ.ocbase.common.helper.CUserHelper;
import kd.occ.ocbase.common.util.BigDecimalUtil;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.SysParamsUtil;
import kd.occ.ocmem.business.budgetcosts.BudgetCostsServiceImpl;
import kd.occ.ocmem.business.cost.CostAppFormHelper;
import kd.occ.ocmem.business.marketcostapply.MarketCostApplyHelper;
import kd.occ.ocmem.common.enums.BizBillStatusEnum;
import kd.occ.ocmem.common.enums.ExecStatusEnum;
import kd.occ.ocmem.common.enums.FreezeStatusEnum;
import kd.occ.ocmem.formplugin.cost.CostBaseForm;
import net.sf.json.JSONObject;

public class MarketCostApplyEdit
extends CostBaseForm {
    public static final Log logger = LogFactory.getLog(MarketCostApplyEdit.class);
    protected final String TOTALAMTUNAPPROVED = "totalamtunapproved";
    protected final String TOTALAMOUNT2 = "totalamount";
    protected final String AMTUNAPPROVED = "amtunapproved";
    protected final String ENDDATE2 = "enddate";
    protected final String BEGINDATE2 = "begindate";
    protected final String REACHRATE = "reachrate";
    protected final String ENTRYENTITY = "entryentity";
    protected final String PLANSALEQTY = "plansaleqty";
    protected final String ACTUALSALEQTY = "actualsaleqty";
    protected final String ENTRYENDDATE = "entryenddate";
    protected final String ENTRYBEGINDATE = "entrybegindate";
    protected final String SHOP = "shop";
    protected final String SHOPREGION = "shopregion";
    protected final String EXECUTOR = "executor";
    protected final String CHANNELCLASSENTITY = "channelclassentity";
    protected final String CLASSSTANDARD = "classstandard";
    protected final String NUMBER = "number";
    protected final String DEFAULTNUMBER = "001";
    protected final String SHOPTYPE = "shoptype";
    protected final String CHANNELCLASS = "channelclass";
    protected final String CUSTOMER = "orderchannel";
    protected final String SETTLEORGID = "settleorgid";
    protected final String CURRENCY = "currency";
    protected volatile boolean triggerChangeEvent = true;
    protected final String ACCOUNTINGSYS = "bd_accountingsys_base";
    protected final String BUDGET = "budget";
    protected final String BUDGETNUMBER = "number";
    protected final String REIMBURSEWAY = "reimburseway";
    protected final String PAYMETHOD = "paymenthod";
    protected final String ACCOUNTTYPE = "accounttype";
    protected final String ACTIVITYPLAN = "activityplan";
    protected final String ISNEEDACTIVITYPLAN = "isneedactivityplan";
    protected final String PAGE_SIGN = "ocmem_marketcost_apply";
    protected final String P_ocdbd_expensetype_entry = "ocdbd_expensetype_entry";

    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{"orderchannel", "shop", "iteminfo", "expensetype", "entrywriteoff", "entryexpensetype", "warzoneid", "rowexpensetype", "activitytype", "budgetyear"});
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getView().getFormShowParameter().getStatus() != OperationStatus.VIEW) {
            String value = (String)this.getModel().getValue("billstatus");
            if (BizBillStatusEnum.AUDIDPASS.getValue().equals(value) || BizBillStatusEnum.PARTREFUND.getValue().equals(value) || BizBillStatusEnum.CLOSED.getValue().equals(value)) {
                EntryGrid entryGrid = (EntryGrid)this.getControl(this.getEntryKey());
                List fields = entryGrid.getFieldEdits();
                for (FieldEdit fieldEdit : fields) {
                    if (!"shop".equals(fieldEdit.getKey())) continue;
                    fieldEdit.setEnable("", false, -1);
                    break;
                }
            }
        }
        this.setInvisibleField();
        this.reimbursewayChanged();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"headwriteoff"});
        DynamicObjectCollection ec = this.getModel().getEntryEntity(this.getEntryKey());
        for (DynamicObject dynamicObject : ec) {
            int rowIndex = dynamicObject.getInt("seq") - 1;
            this.setEnableByEntryType(DynamicObjectUtils.getString((DynamicObject)dynamicObject.getDynamicObject("entrywriteoff"), (String)"typesign"), rowIndex);
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"rowbudget", "rowexpensetype", "rowparentexpense", "balancenumber"});
        this.setActivityPlanMustInput();
    }

    public void afterCopyData(EventObject e) {
        BillModel model = (BillModel)e.getSource();
        Date dateTime = new Date();
        model.setValue("billdate", (Object)dateTime);
        model.setValue("budgetyear", (Object)AssessPeriodHelper.queryAssessPeriod((Date)dateTime));
        DynamicObjectCollection ec = model.getEntityEntity(this.getEntryKey());
        for (DynamicObject dynamicObject : ec) {
            dynamicObject.set("amtapproved", null);
            dynamicObject.set("refundamount", null);
            dynamicObject.set("entrybegindate", null);
            dynamicObject.set("entryenddate", null);
            dynamicObject.set("AMTUNAPPROVED", dynamicObject.get("amount"));
            int rowIndex = dynamicObject.getInt("seq") - 1;
            this.setValueByEntryType(rowIndex);
        }
        model.setValue("totalamtunapproved", model.getValue("totalamount"));
        model.setValue("totalamtapproved", null);
        model.setValue("totalrefundamount", null);
        model.setValue("execstatus", (Object)ExecStatusEnum.UNECECUTE.getValue());
        model.setValue("freezestatus", (Object)FreezeStatusEnum.EMPTY.getValue());
        model.setValue("freezedate", null);
        this.setInvisibleField();
        this.reimbursewayChanged();
        this.updateEntryBudgetCostInfo();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getView().getModel();
        model.setValue("execstatus", (Object)ExecStatusEnum.UNECECUTE.getValue());
        model.setValue("freezestatus", (Object)FreezeStatusEnum.EMPTY.getValue());
        model.setValue("budgetyear", (Object)AssessPeriodHelper.getNowAssessPeriodId());
        this.setInvisibleField();
        this.reimbursewayChanged();
        this.setDefaultValue();
        this.setDefaultRegionId();
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        switch (entryName) {
            case "entryentity": {
                for (RowDataEntity rowDataEntity : rowDataEntities) {
                    int rowIndex = rowDataEntity.getRowIndex();
                    this.setRowValueByTypeSign(rowIndex);
                    this.setValue("entrychannelid", this.getF7PKValue("orderchannel"), rowIndex);
                }
                break;
            }
        }
    }

    private void setRowValueByTypeSign(int rowIndex) {
        DynamicObject entryExpenseType = (DynamicObject)this.getModel().getValue("entrywriteoff");
        if (entryExpenseType == null) {
            return;
        }
        this.getModel().setValue("iteminfo", null, rowIndex);
        this.getModel().setValue("auxptyid", null, rowIndex);
        this.getModel().setValue("qty", null, rowIndex);
        this.getModel().setValue("verifiedqty", null, rowIndex);
        this.getModel().setValue("price", null, rowIndex);
        this.getModel().setValue("amount", null, rowIndex);
        this.getModel().setValue("originalqty", null, rowIndex);
        this.getModel().setValue("originalamt", null, rowIndex);
        this.getModel().setValue("finalqty", null, rowIndex);
        this.getModel().setValue("finalamt", null, rowIndex);
        this.getModel().setValue("amtapproved", null, rowIndex);
        this.getModel().setValue("amtunapproved", null, rowIndex);
        this.getModel().setValue("entrywriteoffname", null, rowIndex);
        this.getModel().setValue("entrybegindate", null, rowIndex);
        this.getModel().setValue("entryenddate", null, rowIndex);
        this.getModel().setValue("remark", null, rowIndex);
        this.getModel().setValue("joinqty", null, rowIndex);
        this.getModel().setValue("totalqty", null, rowIndex);
        this.getModel().setValue("entryaccountid", null, rowIndex);
        this.getModel().setValue("entrychannelid", null, rowIndex);
        this.getModel().setValue("shop", null, rowIndex);
        this.getModel().setValue("shoptype", null, rowIndex);
        this.getModel().setValue("baseunit", null, rowIndex);
        this.getModel().setValue("assistunit", null, rowIndex);
        this.getModel().setValue("displaytype", null, rowIndex);
        this.getModel().setValue("displayarea", null, rowIndex);
        this.getModel().setValue("imagesize", null, rowIndex);
        this.getModel().setValue("entrywriteoff", null, rowIndex);
        this.getModel().setValue("promotion", null, rowIndex);
        this.getModel().setValue("productprice", null, rowIndex);
        this.getModel().setValue("promotiontheme", null, rowIndex);
        this.getModel().setValue("promotionaddress", null, rowIndex);
        this.getModel().setValue("contractpoint", null, rowIndex);
        this.getModel().setValue("plansaleqty", null, rowIndex);
        this.getModel().setValue("actualsaleqty", null, rowIndex);
        this.getModel().setValue("reachrate", null, rowIndex);
        this.getModel().setValue("material", null, rowIndex);
        this.getModel().setValue("lossrate", null, rowIndex);
        this.getModel().setValue("costprice", null, rowIndex);
        this.getModel().setValue("costamount", null, rowIndex);
        this.getModel().setValue("oldshop", null, rowIndex);
        this.getModel().setValue("executor", null, rowIndex);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        super.beforeF7Select(e);
        switch (key = e.getProperty().getName()) {
            case "settleorgid": {
                QFilter qfilter = new QFilter("fisaccounting", "=", (Object)"1");
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)qfilter);
                break;
            }
            case "orderchannel": {
                this.setNewCustomerFilter(e);
                break;
            }
            case "shop": {
                String value = (String)this.getModel().getValue("billstatus");
                if (BizBillStatusEnum.AUDIDPASS.getValue().equals(value) || BizBillStatusEnum.PARTREFUND.getValue().equals(value) || BizBillStatusEnum.CLOSED.getValue().equals(value)) {
                    ((ListShowParameter)e.getFormShowParameter()).setMultiSelect(false);
                } else {
                    ((ListShowParameter)e.getFormShowParameter()).setMultiSelect(true);
                }
                DynamicObject customer = this.getDynamicObject("orderchannel");
                if (customer == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5ba2\u6237", (String)"MarketCostApplyEdit_0", (String)"occ-ocmem-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                QFilter filter = new QFilter("parent", "=", customer.getPkValue());
                filter.and("enable", "=", (Object)"1");
                filter.and(this.getFilterChannels());
                this.setF7Filter("shop", filter);
                ArrayList<QFilter> list = new ArrayList<QFilter>();
                list.add(filter);
                ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setQFilters(list);
                break;
            }
            case "entryexpensetype": {
                QFilter typeFilter = new QFilter(String.join((CharSequence)".", "ocdbd_entryexpensetype", "enable"), "=", (Object)EnableStatusEnum.ENABLE.getValue());
                typeFilter = typeFilter.and(new QFilter(String.join((CharSequence)".", "ocdbd_entryexpensetype", "status"), "=", (Object)StatusEnum.AUDIT.getValue()));
                QFilter entryTypeFilter = QFilter.join((String)"billid", (String)String.join((CharSequence)".", "ocdbd_entryexpensetype", "id"), (QFilter)typeFilter);
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)entryTypeFilter);
                break;
            }
            case "warzoneid": {
                DynamicObject departmentDynObj = this.getF7Value("dept");
                if (departmentDynObj == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d39\u7528\u7533\u8bf7\u90e8\u95e8\u3002", (String)"MarketCostApplyEdit_1", (String)"occ-ocmem-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                e.getFormShowParameter().setCustomParam("isIncludeAllSub", (Object)true);
                long departmentId = DynamicObjectUtils.getPkValue((DynamicObject)departmentDynObj);
                List orgParentIdList = OrgUnitServiceHelper.getAllSuperiorOrgs((String)"01", (long)departmentId);
                QFilter regionFilter = new QFilter("id", "in", (Object)orgParentIdList);
                regionFilter = regionFilter.and("orgpattern", "=", (Object)SysParamsUtil.getOrgPatternId());
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)regionFilter);
                break;
            }
            case "iteminfo": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("itemtypeid", "!=", (Object)Long.parseLong(GoodsTypeEnum.COMBINEGOODS.getValue())));
                break;
            }
            case "activitytype": {
                QFilter acfilter = new QFilter("enable", "=", (Object)"1");
                DynamicObject[] billConfigList = BusinessDataServiceHelper.load((String)"ocdbd_billconfig", (String)"activitytype", (QFilter[])acfilter.toArray());
                if (billConfigList == null || billConfigList.length == 0) {
                    F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("1", "!=", (Object)1));
                    break;
                }
                List activityTypeIds = DynamicObjectUtils.convertDynamicObjList((DynamicObject[])billConfigList).stream().map(s -> DynamicObjectUtils.getPkValue((DynamicObject)s, (String)"activitytype")).collect(Collectors.toList());
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("id", "in", activityTypeIds));
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        Object source = e.getSource();
        if (source instanceof Donothing) {
            boolean inProcess;
            Donothing donothing = (Donothing)source;
            if (("btnunfreeze".equals(donothing.getOperateKey()) || "unfreeze".equals(donothing.getOperateKey())) && (inProcess = WorkflowServiceHelper.inProcess((String)this.getView().getModel().getValue("id").toString()))) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u89e3\u51bb\u5de5\u4f5c\u6d41", (String)"MarketCostApplyEdit_2", (String)"occ-ocmem-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u89e3\u51bb\u5de5\u4f5c\u6d41\u3002", (String)"MarketCostApplyEdit_3", (String)"occ-ocmem-formplugin", (Object[])new Object[0]));
                return;
            }
            if ("changeshop".equals(donothing.getOperateKey())) {
                DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
                int qty = 0;
                long currentTime = new Date().getTime();
                for (int i = 0; i < entrys.size(); ++i) {
                    DynamicObject eInfo = (DynamicObject)entrys.get(i);
                    if (eInfo.getDate("entrybegindate") != null && currentTime < eInfo.getDate("entrybegindate").getTime()) continue;
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"shop"});
                    ++qty;
                }
                if (qty == entrys.size()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65f6\u95f4\u5927\u4e8e\u6240\u6709\u7684\u5f00\u59cb\u65f6\u95f4,\u4e0d\u80fd\u53d8\u66f4\u95e8\u5e97", (String)"MarketCostApplyEdit_4", (String)"occ-ocmem-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u65f6\u95f4\u5927\u4e8e\u6240\u6709\u7684\u5f00\u59cb\u65f6\u95f4,\u4e0d\u80fd\u53d8\u66f4\u95e8\u5e97", (String)"MarketCostApplyEdit_4", (String)"occ-ocmem-formplugin", (Object[])new Object[0]));
                }
            }
            if ("closebill".equals(donothing.getOperateKey())) {
                this.getView().invokeOperation("refresh");
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        int rowIndex;
        DynamicObject orderEntry;
        EntryGrid entryGrid;
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("changeshop".equals(operateKey)) {
            entryGrid = (EntryGrid)this.getControl(this.getEntryKey());
            List fields = entryGrid.getFieldEdits();
            for (FieldEdit fieldEdit : fields) {
                if (!"shop".equals(fieldEdit.getKey())) continue;
                fieldEdit.setEnable("", true, -1);
                break;
            }
            DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject eInfo = (DynamicObject)entrys.get(i);
                long currentTime = new Date().getTime();
                if (eInfo.getDate("entrybegindate") != null && currentTime < eInfo.getDate("entrybegindate").getTime()) continue;
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"shop"});
            }
        }
        if ("unsubmit".equals(operateKey)) {
            this.resetAvailableAmount();
            this.getView().updateView();
        }
        if ("submit".equals(operateKey) || "closebill".equals(operateKey) || "audit".equals(operateKey) || "confirmchange".equals(operateKey)) {
            this.getView().updateView();
        }
        if ("viewexecdetail".equals(operateKey) && (orderEntry = this.getRowInfo("entryentity", rowIndex = (entryGrid = (EntryGrid)this.getControl(this.getEntryKey())).getModel().getEntryCurrentRowIndex("entryentity"))) != null && orderEntry.getPkValue() != null) {
            CostAppFormHelper.openCostExecuteDetailForm((IFormView)this.getView(), null, (Object)orderEntry.getPkValue(), (ShowType)ShowType.MainNewTabPage);
        }
        if ("deleteentry".equals(operateKey)) {
            this.calcTotalAmount();
            this.calcBeginDate(-1, null);
            this.calcEndDate(-1, null);
        }
        if ("addentry".equals(operateKey)) {
            Boolean isCopyRelateEntity = Boolean.TRUE;
            int[] rowIndexs = new int[]{0};
            IDataModel model = (IDataModel)this.getView().getService(IDataModel.class);
            model.copyEntryRow("entryentity", rowIndexs, isCopyRelateEntity.booleanValue());
            this.calcTotalAmount();
            int rowIndex2 = this.getModel().getEntryEntity("entryentity").size() - 1;
            this.setValue("entrychannelid", this.getF7PKValue("orderchannel"), rowIndex2);
            this.setValue("rowexpensetype", null, rowIndex2);
            this.setValue("rowparentexpense", null, rowIndex2);
            this.setValue("rowbudget", null, rowIndex2);
            this.setValue("balancenumber", null, rowIndex2);
            this.setValueByEntryType(rowIndex2);
        }
        if ("fillbudgetnum".equalsIgnoreCase(operateKey) || "fiexedjoinqty".equalsIgnoreCase(operateKey)) {
            this.getView().updateView("entryentity");
        }
    }

    private void checkBeginDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        Date beginDate = (Date)this.getModel().getValue("begindate");
        if (beginDate == null) {
            return;
        }
        Date endDate = (Date)this.getModel().getValue("enddate");
        if (endDate != null && beginDate.getTime() > endDate.getTime() && !sdf.format(beginDate).equals(sdf.format(endDate))) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6700\u65e9\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u6700\u665a\u7ed3\u675f\u65e5\u671f\u3002", (String)"MarketCostApplyEdit_5", (String)"occ-ocmem-formplugin", (Object[])new Object[0]));
            this.setValue("begindate", null);
            return;
        }
        Date nowDate = DateUtil.getNowDate();
        if (sdf.format(beginDate).equals(sdf.format(nowDate))) {
            return;
        }
    }

    private void checkEndDate() {
        Date beginDate = (Date)this.getModel().getValue("begindate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        if (endDate == null) {
            return;
        }
        if (beginDate != null && beginDate.getTime() > endDate.getTime() && !sdf.format(beginDate).equals(sdf.format(endDate))) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6700\u65e9\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u6700\u665a\u7ed3\u675f\u65e5\u671f\u3002", (String)"MarketCostApplyEdit_5", (String)"occ-ocmem-formplugin", (Object[])new Object[0]));
            this.setValue("enddate", null);
            return;
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        int index = this.getRowIndex(e);
        String key = e.getProperty().getName();
        if (!this.triggerChangeEvent) {
            return;
        }
        switch (key) {
            case "begindate": {
                this.checkBeginDate();
                break;
            }
            case "enddate": {
                this.checkEndDate();
                break;
            }
            case "qty": {
                this.calcAmount(index);
                this.calcCostAmount(index, this.getRowInfo("entryentity", index), null);
                this.setVerifyQty(index);
                break;
            }
            case "orderchannel": {
                this.clearShop(index);
                this.customerChanged();
                this.updateEntryBudgetCostInfo();
                DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
                Object channelId = this.getF7PKValue("orderchannel");
                for (int i = 0; i < entity.size(); ++i) {
                    this.getModel().setValue("entrychannelid", channelId, i);
                }
                break;
            }
            case "price": {
                this.calcAmount(index);
                break;
            }
            case "amount": {
                this.setValue("amtunapproved", BigDecimalUtil.subtractObject((Object)this.getValue("AMOUNT", index), (Object)this.getValue("amtapproved", index)), index);
                this.calcTotalAmount();
                break;
            }
            case "entrybegindate": {
                this.triggerChangeEvent = false;
                this.calcBeginDate(index, (Date)e.getChangeSet()[0].getOldValue());
                break;
            }
            case "entryenddate": {
                this.triggerChangeEvent = false;
                this.calcEndDate(index, (Date)e.getChangeSet()[0].getOldValue());
                break;
            }
            case "actualsaleqty": {
                this.calcReachrate(index);
                break;
            }
            case "plansaleqty": {
                this.calcReachrate(index);
                break;
            }
            case "material": {
                this.setValue("auxptyid", null, index);
                this.calcCostAmount(index, "iteminfo");
                break;
            }
            case "amtapproved": {
                this.setValue("amtunapproved", BigDecimalUtil.subtractObject((Object)this.getValue("AMOUNT", index), (Object)this.getValue("amtapproved", index)), index);
                this.calcTotalAmount();
                break;
            }
            case "iteminfo": {
                DynamicObject newItem = (DynamicObject)e.getChangeSet()[0].getNewValue();
                this.setBdMaterial(index, newItem);
                this.setUnit(index, newItem);
                this.setPrice(index, newItem);
                this.calcCostAmount(index, "iteminfo");
                this.setEntryChannel(index);
                break;
            }
            case "shop": {
                this.changeShopType(index);
                break;
            }
            case "settleorgid": {
                break;
            }
            case "expensetype": {
                this.getModel().setValue("parentexpenseid", null);
                Object expenseType = this.getModel().getValue("expensetype");
                if (expenseType != null) {
                    this.getModel().setValue("parentexpenseid", (Object)((DynamicObject)expenseType).getDynamicObject("parent"));
                }
            }
            case "currency": 
            case "billdate": {
                this.updateEntryBudgetCostInfo();
                Date billDate = (Date)this.getModel().getValue("billdate");
                if (billDate == null) {
                    this.getModel().setValue("budgetyear", (Object)0L);
                    break;
                }
                this.getModel().setValue("budgetyear", (Object)AssessPeriodHelper.queryAssessPeriod((Date)billDate));
                break;
            }
            case "budgetyear": {
                this.updateEntryBudgetCostInfo();
                break;
            }
            case "costdept": {
                this.updateEntryBudgetCostInfo();
                break;
            }
            case "dept": {
                this.setDefaultRegionId();
                break;
            }
            case "reimburseway": {
                this.reimbursewayChanged();
                break;
            }
            case "entryexpensetype": {
                this.setRowValueByTypeSign(index);
                this.setValueByEntryType(index);
                break;
            }
            case "entrywriteoff": {
                String typeSign = DynamicObjectUtils.getString((DynamicObject)this.getEntryF7Value("entryentity", "entrywriteoff", index), (String)"typesign");
                if (!typeSign.equals("A")) break;
                this.getModel().setValue("iteminfo", null, index);
                break;
            }
            case "rowexpensetype": {
                DynamicObject rowExpenseType = (DynamicObject)e.getChangeSet()[0].getNewValue();
                this.updateSingleEntryBudgetCostInfo(rowExpenseType, index);
                if (rowExpenseType == null) break;
                this.getModel().setValue("rowparentexpense", (Object)DynamicObjectUtils.getPkValue((DynamicObject)rowExpenseType.getDynamicObject("parent")), index);
                break;
            }
            case "activitytype": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"rowbudget", "rowexpensetype", "rowparentexpense", "balancenumber"});
                this.setActivityPlanMustInput();
                break;
            }
            case "finalamt": {
                BigDecimal originalAmt = (BigDecimal)this.getValue("originalamt", index);
                BigDecimal updateAmount = originalAmt.compareTo(BigDecimal.ZERO) == 0 ? (BigDecimal)this.getValue("amount", index) : originalAmt;
                this.getModel().setValue("finalamt", (Object)updateAmount, index);
            }
        }
    }

    private void setActivityPlanMustInput() {
        Object activityType = this.getValue("activitytype");
        if (activityType != null) {
            DynamicObject activityTypeDym = (DynamicObject)activityType;
            boolean bIsNeedActivityPlan = DynamicObjectUtils.getBoolean((DynamicObject)activityTypeDym, (String)"isneedactivityplan");
            if (bIsNeedActivityPlan) {
                this.setMustInput("activityplan", Boolean.TRUE);
            } else {
                this.setMustInput("activityplan", Boolean.FALSE);
            }
        } else {
            this.setMustInput("activityplan", Boolean.FALSE);
        }
    }

    private void setInvisibleField() {
    }

    private void setDefaultValue() {
        this.getModel().setValue("currency", (Object)1L);
    }

    private void setNewCustomerFilter(BeforeF7SelectEvent e) {
        List channelIds = CUserHelper.getAuthorizedChannelIdList((long)RequestContext.get().getCurrUserId());
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        QFilter filter = new QFilter("id", "in", (Object)channelIds);
        list.add(filter);
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setQFilters(list);
    }

    private QFilter getFilterChannels() {
        ArrayList<String> numbers = new ArrayList<String>(8);
        numbers.add("002");
        numbers.add("003");
        numbers.add("004");
        numbers.add("005");
        numbers.add("006");
        numbers.add("007");
        DynamicObject[] dos = BusinessDataServiceHelper.load((String)"ocdbd_channel_type", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", numbers)});
        ArrayList<Long> ids = new ArrayList<Long>(dos.length);
        if (dos.length > 0) {
            for (DynamicObject eachDynamicObject : dos) {
                ids.add(eachDynamicObject.getLong("id"));
            }
        }
        return new QFilter("channeltype", "in", ids);
    }

    private void resetAvailableAmount() {
        String number = (String)this.getModel().getValue("billno");
        QFilter qFilter = new QFilter("billno", "=", (Object)number);
        DynamicObject[] kpiMiddleHeadObjs = BusinessDataServiceHelper.load((String)"ocmem_marketcost_apply", (String)"id,budget", (QFilter[])qFilter.toArray());
        if (kpiMiddleHeadObjs != null && kpiMiddleHeadObjs.length > 0) {
            this.getModel().setValue("budget", (Object)kpiMiddleHeadObjs[0].getBigDecimal("budget"));
        }
        this.getView().updateView();
    }

    private void setBdMaterial(int index, DynamicObject itemInfo) {
        Object materialPk = null;
        if (itemInfo != null) {
            materialPk = DynamicObjectUtils.getPkId((DynamicObject)itemInfo.getDynamicObject("material"), (String)"id");
        }
        this.getModel().setValue("material", materialPk, index);
    }

    private void setVerifyQty(int index) {
        Object qty = this.getModel().getValue("qty");
        this.getModel().setValue("verifiedqty", qty, index);
    }

    private void setEntryChannel(int index) {
        Object channel = this.getModel().getValue("orderchannel");
        this.getModel().setValue("entrychannelid", channel, index);
    }

    private void setValueByEntryType(int index) {
        this.setValue("entrywriteoff", null, index);
        this.setValue("entryaccountid", null, index);
        this.setMustInput("amount", false);
        DynamicObject entryType = this.getEntryF7Value("entryentity", "entryexpensetype", index);
        if (entryType == null) {
            return;
        }
        this.setValue("entrywriteoff", DynamicObjectUtils.getPkValue((DynamicObject)entryType.getDynamicObject("billid")), index);
        DynamicObject expenseType = this.getEntryF7Value("entryentity", "entrywriteoff", index);
        String typeSign = "";
        if (expenseType != null) {
            Object entryWriteOffName = entryType.get("writeoffname");
            this.setValue("entrywriteoffname", entryWriteOffName, index);
            long entryTypeId = DynamicObjectUtils.getPkValue((DynamicObject)entryType);
            QFilter qFilter = new QFilter("id", "=", (Object)entryTypeId);
            DynamicObject expenseTypeEntry = QueryServiceHelper.queryOne((String)"ocdbd_expensetype_entry", (String)"id,writeoffaccountid", (QFilter[])qFilter.toArray());
            if (expenseTypeEntry != null) {
                long writeOffAccountId = DynamicObjectUtils.getLong((DynamicObject)expenseTypeEntry, (String)"writeoffaccountid");
                this.setValue("entryaccountid", writeOffAccountId, index);
            }
            typeSign = expenseType.getString("typesign");
        }
        this.setEnableByEntryType(typeSign, index);
    }

    private void setEnableByEntryType(String typeSign, int index) {
        if (typeSign.equals("A")) {
            this.setVisible(new String[]{"entryexpensetype", "iteminfo", "rowexpensetype", "qty", "price"});
            this.setEnable(index, new String[]{"entryexpensetype", "rowexpensetype", "amount"});
            this.setMustInput("entryexpensetype", Boolean.TRUE);
            this.setMustInput("rowexpensetype", Boolean.TRUE);
            this.setMustInput("amount", Boolean.TRUE);
        } else {
            this.setVisible(new String[]{"entryexpensetype", "iteminfo", "rowexpensetype", "qty", "price"});
            this.setEnable(index, new String[]{"entryexpensetype", "iteminfo", "rowexpensetype", "qty", "price"});
            this.setMustInput("entryexpensetype", Boolean.TRUE);
        }
        this.setUnEnable(index, new String[]{"entryaccountid"});
        this.setEnable(index, new String[]{"entrybegindate"});
        this.setEnable(index, new String[]{"entryenddate"});
        String value = (String)this.getModel().getValue("billstatus");
        if (!BizBillStatusEnum.SAVED.getValue().equals(value) && !BizBillStatusEnum.SUBMITED.getValue().equals(value)) {
            this.setVisible(new String[]{"joinqty", "totalqty"});
        }
    }

    private void lockEntryByType(boolean status, int index) {
        IFormView view = this.getView();
        EntryGrid entryGrid = (EntryGrid)view.getControl("entryentity");
        if (entryGrid != null) {
            List<String> keyList = entryGrid.getFieldEdits().stream().map(obj -> obj.getKey()).collect(Collectors.toList());
            keyList.remove("amount");
            keyList.remove("entryexpensetype");
            keyList.remove("entrybegindate");
            keyList.remove("entryenddate");
            keyList.remove("rowbudget");
            keyList.remove("rowexpensetype");
            keyList.remove("balancenumber");
            keyList.remove("rowparentexpense");
            this.getView().setEnable(Boolean.valueOf(status), index, keyList.toArray(new String[keyList.size()]));
        }
    }

    private void setMustInput(String fieldName, boolean isMustInput) {
        FieldEdit fieldEdit = this.getFieldEdit(fieldName);
        if (fieldEdit != null) {
            fieldEdit.setMustInput(isMustInput);
        }
    }

    private FieldEdit getFieldEdit(String key) {
        return (FieldEdit)this.getView().getControl(key);
    }

    private void reimbursewayChanged() {
        Object reimburseWay = this.getModel().getValue("reimburseway");
        if (reimburseWay == null) {
            return;
        }
        if (reimburseWay.equals("B")) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"accounttype"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"accounttype"});
        }
    }

    private void customerChanged() {
        this.setSettleOrg(this.getF7Value("orderchannel"));
    }

    private void setSettleOrg(DynamicObject customerDynObj) {
        DynamicObject saleOrgDynObj;
        Map map;
        Object settleorgId = null;
        if (customerDynObj != null && !CollectionUtils.isEmpty((Map)(map = OrgUnitServiceHelper.getCompanyByOrg((Long)(saleOrgDynObj = customerDynObj.getDynamicObject("saleorg")).getLong("id"), (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE)))) {
            settleorgId = map.get("id");
        }
        this.setValue("settleorgid", settleorgId);
    }

    private void changeShopType(int index) {
        Object shop = this.getEntryF7PKValue("entryentity", "shop", index);
        if (shop != null) {
            DynamicObject shopChannel = BusinessDataServiceHelper.loadSingle((Object)((Long)shop), (String)"ocdbd_channel");
            DynamicObjectCollection doc = shopChannel.getDynamicObjectCollection("channelclassentity");
            if (doc != null && doc.size() > 0) {
                for (DynamicObject eachdoc : doc) {
                    if (!eachdoc.getDynamicObject("classstandard").getString("number").equals("001")) continue;
                    this.getModel().setValue("shoptype", (Object)eachdoc.getDynamicObject("channelclass"), index);
                    break;
                }
            }
        } else {
            this.getModel().setValue("shoptype", null, index);
        }
    }

    private void calcCostAmount(int index, String key) {
        DynamicObject orderEntry = this.getRowInfo("entryentity", index);
        if (orderEntry != null) {
            DynamicObject itemInfo = orderEntry.getDynamicObject(key);
            BigDecimal costPrice = null;
            if (itemInfo != null) {
                costPrice = itemInfo.getBigDecimal("costprice");
            }
            this.setValue("costprice", costPrice, index);
            String s = this.getPageCache().get("entryDisplayMap");
            logger.info("entryDisplayMap:" + s);
            if (StringUtils.isNotEmpty((String)s)) {
                JSONObject totalExecJson = null;
                totalExecJson = !StringUtils.isEmpty((String)s) ? JSONObject.fromObject((Object)s) : new JSONObject();
                if (totalExecJson.getBoolean("costprice")) {
                    this.setValue("price", costPrice, index);
                } else {
                    logger.info("costprice si false");
                }
            }
            this.calcCostAmount(index, orderEntry, costPrice);
        }
    }

    private void calcCostAmount(int index, DynamicObject orderEntry, BigDecimal costPrice) {
        if (costPrice == null) {
            costPrice = orderEntry.getBigDecimal("costprice");
        }
        BigDecimal qty = orderEntry.getBigDecimal("qty");
        int amtprecision = 2;
        BigDecimal costamount = BigDecimalUtil.multiplyObject((Object)costPrice, (Object)qty, (int)amtprecision);
        this.setValue("costamount", costamount, index);
    }

    private void clearShop(int index) {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entrys.size(); ++i) {
            this.setValue("shop", null, i);
        }
    }

    private void setPrice(int index, DynamicObject itemInfo) {
        this.setValue("price", null, index);
        if (itemInfo != null) {
            BigDecimal price = itemInfo.getBigDecimal("costprice");
            this.setValue("price", price, index);
        }
    }

    private void setUnit(int index, DynamicObject itemPK) {
        Object baseUnit = null;
        Object assistUnit = null;
        if (itemPK != null) {
            baseUnit = DynamicObjectUtils.getPkId((DynamicObject)itemPK, (String)"baseunit");
            assistUnit = DynamicObjectUtils.getPkId((DynamicObject)itemPK, (String)"assistunit");
        } else {
            this.getModel().setValue("qty", null, index);
        }
        this.getModel().setValue("baseunit", baseUnit, index);
        this.getModel().setValue("assistunit", assistUnit, index);
    }

    private void calcReachrate(int index) {
        BigDecimal plansaleqty;
        DynamicObject orderEntry = this.getRowInfo("entryentity", index);
        if (orderEntry != null && (plansaleqty = orderEntry.getBigDecimal("plansaleqty")) != null && plansaleqty.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal actualsaleqty = orderEntry.getBigDecimal("actualsaleqty");
            BigDecimal reachrate = BigDecimalUtil.multiplyObject((Object)actualsaleqty, (Object)100, (int)10);
            reachrate = BigDecimalUtil.divideObject((Object)reachrate, (Object)plansaleqty, (int)10);
            this.setValue("reachrate", reachrate, index);
        }
    }

    private void calcBeginDate(int index, Date oldDate) {
        Date beginDate;
        DynamicObject orderEntry;
        Date headBeginDate = (Date)this.getModel().getValue("begindate");
        Date headEndDate = (Date)this.getModel().getValue("enddate");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        if (index >= 0 && (orderEntry = this.getRowInfo("entryentity", index)) != null && orderEntry.getDate("entrybegindate") != null) {
            beginDate = orderEntry.getDate("entrybegindate");
            beginDate = DateUtil.getDayLast((Date)beginDate);
            if (headBeginDate != null && beginDate.getTime() < headBeginDate.getTime() && !sdf.format(headBeginDate).equals(sdf.format(beginDate))) {
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5355\u636e\u5934\u6700\u65e9\u5f00\u59cb\u65e5\u671f\u3002", (String)"MarketCostApplyEdit_6", (String)"occ-ocmem-formplugin", (Object[])new Object[0]), index + 1));
                this.setValue("entrybegindate", oldDate, index);
                return;
            }
            if (headEndDate != null && beginDate.getTime() > headEndDate.getTime() && !sdf.format(beginDate).equals(sdf.format(headEndDate))) {
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u5355\u636e\u5934\u6700\u665a\u7ed3\u675f\u65e5\u671f\u3002", (String)"MarketCostApplyEdit_7", (String)"occ-ocmem-formplugin", (Object[])new Object[0]), index + 1));
                this.setValue("entrybegindate", oldDate, index);
                return;
            }
            Date endDate = orderEntry.getDate("entryenddate");
            if (endDate != null && (endDate = DateUtil.getDayLast((Date)endDate)).getTime() < beginDate.getTime() && !sdf.format(endDate).equals(sdf.format(beginDate))) {
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u5f00\u59cb\u65e5\u671f.", (String)"MarketCostApplyEdit_8", (String)"occ-ocmem-formplugin", (Object[])new Object[0]), index + 1));
                this.setValue("entrybegindate", oldDate, index);
                return;
            }
        }
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
        beginDate = null;
        for (DynamicObject entry : entrys) {
            Date date = entry.getDate("entrybegindate");
            if (beginDate != null && (date == null || beginDate.getTime() <= date.getTime())) continue;
            beginDate = date;
        }
        this.setValue("begindate", beginDate);
    }

    private void calcEndDate(int index, Date oldDate) {
        Date endDate;
        DynamicObject orderEntry;
        Date headBeginDate = (Date)this.getModel().getValue("begindate");
        Date headEndDate = (Date)this.getModel().getValue("enddate");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        if (index >= 0 && (orderEntry = this.getRowInfo("entryentity", index)) != null && orderEntry.getDate("entryenddate") != null) {
            endDate = orderEntry.getDate("entryenddate");
            endDate = DateUtil.getDayFirst((Date)endDate);
            if (headBeginDate != null && endDate.getTime() < headBeginDate.getTime() && !sdf.format(headBeginDate).equals(sdf.format(endDate))) {
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5355\u636e\u5934\u6700\u65e9\u5f00\u59cb\u65e5\u671f\u3002", (String)"MarketCostApplyEdit_9", (String)"occ-ocmem-formplugin", (Object[])new Object[0]), index + 1));
                this.setValue("entryenddate", oldDate, index);
                return;
            }
            if (headEndDate != null && endDate.getTime() > headEndDate.getTime() && !sdf.format(headEndDate).equals(sdf.format(endDate))) {
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u5355\u636e\u5934\u6700\u665a\u7ed3\u675f\u65e5\u671f\u3002", (String)"MarketCostApplyEdit_10", (String)"occ-ocmem-formplugin", (Object[])new Object[0]), index + 1));
                this.setValue("entryenddate", oldDate, index);
                return;
            }
            Date beginDate = orderEntry.getDate("entrybegindate");
            if (beginDate != null) {
                beginDate = DateUtil.getDayFirst((Date)beginDate);
                if (endDate.getTime() < beginDate.getTime() && !sdf.format(beginDate).equals(sdf.format(endDate))) {
                    this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"MarketCostApplyEdit_11", (String)"occ-ocmem-formplugin", (Object[])new Object[0]), index + 1));
                    this.setValue("entryenddate", oldDate, index);
                    return;
                }
            }
        }
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
        endDate = null;
        for (DynamicObject entry : entrys) {
            Date date = entry.getDate("entryenddate");
            if (endDate != null && (date == null || endDate.getTime() >= date.getTime())) continue;
            endDate = date;
        }
        this.setValue("enddate", endDate);
    }

    private void calcAmount(int index) {
        DynamicObject orderEntry = this.getRowInfo("entryentity", index);
        if (orderEntry != null) {
            BigDecimal qty = orderEntry.getBigDecimal("qty");
            BigDecimal itemPrice = orderEntry.getBigDecimal("price");
            int amtprecision = 2;
            BigDecimal primAmount = BigDecimalUtil.multiplyObject((Object)itemPrice, (Object)qty, (int)amtprecision);
            this.setValue("amount", primAmount, index);
            this.setValue("amtunapproved", BigDecimalUtil.subtractObject((Object)primAmount, (Object)this.getValue("amtapproved", index)), index);
        }
        this.calcTotalAmount();
    }

    private void calcTotalAmount() {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (DynamicObject entry : entrys) {
            totalAmount = BigDecimalUtil.addObject((Object)totalAmount, (Object)entry.getBigDecimal("amount"));
        }
        this.setValue("totalamount", totalAmount);
        this.setValue("totalamtunapproved", BigDecimalUtil.subtractObject((Object)totalAmount, (Object)this.getValue("totalamtapproved")));
    }

    private void setDefaultRegionId() {
        long orgpatternId = SysParamsUtil.getOrgPatternId();
        if (orgpatternId > 0L) {
            long departmentId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("dept"));
            long regionId = 0L;
            List orgParentIdList = OrgUnitServiceHelper.getAllSuperiorOrgs((String)"01", (long)departmentId);
            if (orgParentIdList.size() > 0) {
                QFilter qFilter = new QFilter("org", "in", (Object)orgParentIdList);
                DynamicObjectCollection dynObjColl = QueryServiceHelper.query((String)"bos_org_structure", (String)"org", (QFilter[])(qFilter = qFilter.and(new QFilter(String.join((CharSequence)".", "org", "orgpattern"), "=", (Object)orgpatternId))).toArray(), (String)"level desc", (int)1);
                if (!CommonUtils.isNull((Object)dynObjColl)) {
                    regionId = ((DynamicObject)dynObjColl.get(0)).getLong("org");
                }
            }
            this.setValue("warzoneid", regionId == 0L ? departmentId : regionId);
        }
    }

    private void updateEntryBudgetCostInfo() {
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("costdept"));
        long budgetYearId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("budgetyear"));
        long orderChannelId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("orderchannel"));
        long currencyId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("currency"));
        DynamicObjectCollection detailList = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        MarketCostApplyHelper helper = new MarketCostApplyHelper();
        helper.batchQueryBudgetCosts(orgId, orderChannelId, currencyId, budgetYearId, detailList, this.getView());
    }

    private void updateSingleEntryBudgetCostInfo(DynamicObject expenseType, int rowIndex) {
        DynamicObject budgetCost;
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("costdept"));
        long budgetYearId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("budgetyear"));
        long orderChannelId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("orderchannel"));
        long currencyId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("currency"));
        if (expenseType == null || !CostAppFormHelper.ifBudget((DynamicObject)expenseType)) {
            this.getModel().setValue("rowbudget", null, rowIndex);
            this.getModel().setValue("balancenumber", null, rowIndex);
            return;
        }
        long expenseTypeId = DynamicObjectUtils.getPkValue((DynamicObject)expenseType);
        String control = expenseType.getString("control");
        if (!control.contains("1")) {
            orgId = 0L;
        }
        if (!control.contains("2")) {
            orderChannelId = 0L;
        }
        if ((budgetCost = BudgetCostsServiceImpl.queryBudgetCostsInfo((long)orgId, (long)orderChannelId, (long)currencyId, (long)expenseTypeId, (long)budgetYearId)) == null) {
            this.getModel().setValue("rowbudget", null, rowIndex);
            this.getModel().setValue("balancenumber", null, rowIndex);
            return;
        }
        this.getModel().setValue("rowbudget", (Object)budgetCost.getBigDecimal("availableamount"), rowIndex);
        this.getModel().setValue("balancenumber", (Object)budgetCost.getString("number"), rowIndex);
    }
}

