/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.formplugin.cost;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.CollectionUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.formplugin.base.OCMEMListPlugin;
import kd.occ.ocmem.business.cost.CostAppFormHelper;
import kd.occ.ocmem.business.helper.FixedBudgetBalanceHelper;

public class MarketCostApplyList
extends OCMEMListPlugin {
    public static final Log logger = LogFactory.getLog(MarketCostApplyList.class);
    public static final ThreadLocal<ArrayList<Long>> contianExcuteIds = new ThreadLocal();

    public void beforePackageData(BeforePackageDataEvent e) {
        super.beforePackageData(e);
        DynamicObjectCollection datas = e.getPageData();
        ArrayList<Long> idList = new ArrayList<Long>();
        for (DynamicObject data : datas) {
            long id = data.getLong("id");
            idList.add(id);
        }
        if (idList.size() > 0) {
            ArrayList<Long> exIds = MarketCostApplyList.getContianExcuIds(idList);
            contianExcuteIds.set(exIds);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        switch (key = operate.getOperateKey()) {
            case "copy": {
                ListSelectedRowCollection selectedRows = this.getSelectedRows();
                if (CollectionUtil.isNull((List)selectedRows)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"MarketCostApplyList_0", (String)"occ-ocmem-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                if (selectedRows.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"MarketCostApplyList_1", (String)"occ-ocmem-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                ListSelectedRow selectedRow = selectedRows.get(0);
                Object primaryKeyValue = selectedRow.getPrimaryKeyValue();
                QFilter filter = new QFilter("id", "=", primaryKeyValue);
                DynamicObject marketApply = BusinessDataServiceHelper.loadSingle((String)"ocmem_marketcost_apply", (String)String.join((CharSequence)",", "activitytype", "id"), (QFilter[])filter.toArray());
                DynamicObject activityType = DynamicObjectUtils.getDynamicObject((DynamicObject)marketApply, (String)"activitytype");
                if (!"0".equalsIgnoreCase(DynamicObjectUtils.getString((DynamicObject)activityType, (String)"enable"))) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u6d3b\u52a8\u7c7b\u578b\u5df2\u88ab\u7981\u7528\uff0c\u4e0d\u5141\u8bb8\u590d\u5236\u3002", (String)"MarketCostApplyList_2", (String)"occ-ocmem-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
        }
    }

    public static ArrayList<Long> getContianExcuIds(ArrayList<Long> ids) {
        ArrayList<Long> excuIds = new ArrayList<Long>();
        StringBuilder sql = new StringBuilder();
        sql.append(" select a.fid,b.fentryid from t_ocmem_mcost_apply a inner join t_ocmem_mcost_applye b on a.fid=b.fid ");
        sql.append(" inner join t_ocmem_mcostexecute c on b.fentryid=c.fcostapplyentryid where a.fid in ( ");
        int size = ids.size();
        for (int i = 0; i < size; ++i) {
            if (i == size - 1) {
                sql.append("?)");
                continue;
            }
            sql.append("?,");
        }
        DataSet set = DB.queryDataSet((String)"MarketCostApplyList", (DBRoute)new DBRoute("drp"), (String)sql.toString(), (Object[])ids.toArray());
        while (set.hasNext()) {
            Row row = set.next();
            long id = row.getLong("fid");
            excuIds.add(id);
        }
        return excuIds;
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        long userId = RequestContext.get().getCurrUserId();
        CostAppFormHelper.setListFilter((long)userId, (SetFilterEvent)e);
        e.setOrderBy("createtime desc");
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key;
        super.afterDoOperation(e);
        switch (key = e.getOperateKey()) {
            case "viewexecdetail": {
                Donothing operate = (Donothing)e.getSource();
                ListSelectedRow listFocusRow = operate.getListFocusRow();
                Object pk = listFocusRow.getPrimaryKeyValue();
                CostAppFormHelper.openCostExecuteDetailForm((IFormView)this.getView(), (Object)pk, null, (ShowType)ShowType.MainNewTabPage);
                break;
            }
            case "fixedapprovedamount": {
                FixedBudgetBalanceHelper.fixedMarketApplyBudgetBalance();
            }
        }
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        Object formatValue = e.getFormatValue();
        Object source = e.getSource();
        DynamicObject rowData = e.getRowData();
        if (source instanceof ListOperationColumnDesc) {
            List items = (List)formatValue;
            for (OperationColItem item : items) {
                if (!item.getOperationKey().equals("viewExecDetail") || contianExcuteIds.get().contains(rowData.getPkValue())) continue;
                item.setVisible(false);
            }
        }
    }
}

