/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.formplugin.cost;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.constants.BigDecimalConstants;
import kd.occ.ocbase.common.util.BigDecimalUtil;
import kd.occ.ocbase.common.util.memutil.OCMEMFilterUtil;
import kd.occ.ocbase.common.util.memutil.OCMEMUtil;
import kd.occ.ocmem.business.cost.CostAppFormHelper;
import kd.occ.ocmem.formplugin.basedata.CostFormPlugin;
import org.apache.commons.lang.StringUtils;

public class MarketCostReimburseEdit
extends CostFormPlugin
implements BeforeF7SelectListener {
    public static final Log logger = LogFactory.getLog(MarketCostReimburseEdit.class);
    protected String TOOL_ENTRYS = "toolentrys";
    protected String TOOL_RECEIVABLE = "toolreceivable";
    protected String BTN_ADD_ENTRYS_ROW = "btnaddentrysrow";
    protected String BTN_DELETE_ENTRYS_ROW = "btnredeleteentrysrow";
    protected String BTN_ADD_RECEIVABLE_ROW = "btnaddreceivablerow";
    protected String BTN_DELETE_RECEIVABLE_ROW = "btndeletereceivablerow";
    protected String TOTAL_AMT_APPLY = "totalamtapply";
    protected String TOTAL_AMOUNT = "totalamount";
    protected String TOTAL_AMT_APPROVED = "totalamtapproved";
    protected String ENTRYS = "entrys";
    protected String AMT_APPLY = "amtapply";
    protected String AMT_APPROVED = "amtapproved";
    protected String AMT_UNAPPROVED = "amtunapproved";
    protected String TOTAL_AMT_INVOICE = "totalamtinvoice";
    protected String EXCLUDE_TAX_AMT = "excludetaxamt";
    protected String TAX_RATE = "taxrate";
    protected String OFFSET_BORROW = "offsetborrow";
    protected String BORROW = "borrow";
    protected String BRW_REASONS = "brwreasons";
    protected String BRW_CURRENCY = "brwcurrency";
    protected String BRW_RATE = "brwrate";
    protected String BRW_AMT = "brwamt";
    protected String BRW_AMT_LOCAL = "brwamtlocal";
    protected String OFFSET_AMT = "offsetamt";
    protected String OFFSET_AMT_LOCAL = "offsetamtlocal";
    protected String RECEIVABLE = "receivable";
    protected String PAYER = "payer";
    protected String PAYER_BANK = "payerbank";
    protected String PAYER_ACCOUNT = "payeraccount";
    protected String PAY_CURRENCY = "paycurrency";
    protected String PAY_RATE = "payrate";
    protected String RECEIVABLE_AMT = "receivableamt";
    protected String RECEIVABLE_AMT_LOCAL = "receivableamtlocal";
    public static final String F_expensebearaptid = "costdept";
    public static final String F_warzoneid = "warzoneid";
    public static final String F_agencyid = "agencyid";
    public static final String F_parentexpenseid = "parentexpenseid";
    public static final String F_expenseprojectid = "expenseprojectid";
    public static final String F_pretotalamount = "pretotalamount";
    public static final String F_pretotalqty = "pretotalqty";
    public static final String F_finaltotalamount = "finaltotalamount";
    public static final String F_finaltotalqty = "finaltotalqty";
    public static final String E_toriginalqty = "toriginalqty";
    public static final String E_toriginalamt = "toriginalamt";
    public static final String E_tfinalqty = "tfinalqty";
    public static final String E_tfinalamt = "tfinalamt";
    public static final String EF_entrytype = "entrytype";
    public static final String EF_writeoff = "writeoff";
    public static final String EF_entryaccountid = "entryaccountid";
    public static final String EF_auxptyid = "auxptyid";
    public static final String EF_entrychannelid = "entrychannelid";
    public static final String EF_quantity = "qty";
    public static final String EF_verifiedqty = "verifiedqty";
    public static final String EF_roworiginalqty = "originalqty";
    public static final String EF_roworiginalamt = "originalamt";
    public static final String EF_rowfinalqty = "finalqty";
    public static final String EF_rowfinalamt = "finalamt";
    protected final String REIMBURSEWAY = "reimburseway";
    protected final String PAYMETHOD = "paymethod";
    protected final String ACCOUNTTYPE = "accounttype";

    private void calcTotal() {
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection(this.ENTRYS);
        BigDecimal totalOriginalQty = BigDecimal.ZERO;
        BigDecimal totalOriginalAmt = BigDecimal.ZERO;
        BigDecimal totalFinalQty = BigDecimal.ZERO;
        BigDecimal totalFinalAmt = BigDecimal.ZERO;
        for (DynamicObject entry : entrys) {
            totalOriginalQty = BigDecimalUtil.addObject((Object)totalOriginalQty, (Object)entry.getBigDecimal(EF_roworiginalqty));
            totalOriginalAmt = BigDecimalUtil.addObject((Object)totalOriginalAmt, (Object)entry.getBigDecimal(EF_roworiginalamt));
            totalFinalQty = BigDecimalUtil.addObject((Object)totalFinalQty, (Object)entry.getBigDecimal(EF_rowfinalqty));
            totalFinalAmt = BigDecimalUtil.addObject((Object)totalFinalAmt, (Object)entry.getBigDecimal(EF_rowfinalamt));
        }
        this.setValue(E_toriginalqty, totalOriginalQty);
        this.setValue(E_toriginalamt, totalOriginalAmt);
        this.setValue(E_tfinalqty, totalFinalQty);
        this.setValue(E_tfinalamt, totalFinalAmt);
    }

    @Override
    public void registerListener(EventObject eventobject) {
        super.registerListener(eventobject);
        this.addItemClickListeners(new String[]{this.TOOL_RECEIVABLE, this.TOOL_ENTRYS});
        this.addF7Listener(this, new String[]{"payer"});
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.ADDNEW)) {
            // empty if block
        }
        this.setInvisibleField();
        this.reimbursewayChanged();
        this.calcTotal();
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().setVisible(Boolean.TRUE, new String[]{"rowexpensetype", "rowparentexpense"});
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        super.beforeF7Select(e);
        switch (key = e.getProperty().getName()) {
            case "payer": {
                DynamicObject customer = (DynamicObject)this.getModel().getValue("orderChannel");
                if (customer == null) {
                    this.setF7CustomerFilter(e, "kingdee");
                    break;
                }
                this.setF7CustomerFilter(e, customer.getString("name"));
                break;
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        List successPkIds;
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("viewexecdetail".equals(operateKey) && (successPkIds = e.getOperationResult().getSuccessPkIds()) != null && successPkIds.size() > 0) {
            Object pk = successPkIds.get(0);
            DynamicObject marketCostReimburse = QueryServiceHelper.queryOne((String)"ocmem_mc_reimburse", (String)"id,sourcebillid", (QFilter[])OCMEMFilterUtil.getPKQFilter(pk));
            CostAppFormHelper.openCostExecuteDetailForm((IFormView)this.getView(), (Object)marketCostReimburse.get("sourcebillid"), null, (ShowType)ShowType.MainNewTabPage);
        }
        if ("btnredeleteentrysrow".equals(operateKey)) {
            this.calcTotal();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        HashMap returnData;
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((String)closedCallBackEvent.getActionId(), (String)"adjustfeecashtype") && null != closedCallBackEvent.getReturnData() && (returnData = (HashMap)closedCallBackEvent.getReturnData()) != null) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(this.ENTRYS);
            int[] selectRows = entryGrid.getSelectRows();
            Object feeCashTypeId = returnData.get("feecashtype");
            Object accounTypeId = returnData.get("accountype");
            for (int index = 0; index < selectRows.length; ++index) {
                this.getModel().setValue(EF_entryaccountid, accounTypeId, selectRows[index]);
                this.getModel().setValue("feecashtype", feeCashTypeId, selectRows[index]);
            }
            this.getView().invokeOperation("save");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        switch (((AbstractOperate)evt.getSource()).getOperateKey()) {
            case "adjustfeecashtype": {
                EntryGrid entryGrid = (EntryGrid)this.getControl(this.ENTRYS);
                int[] selectRows = entryGrid.getSelectRows();
                if (selectRows.length == 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u884c\u8c03\u6574\u5151\u4ed8\u65b9\u5f0f\u3002", (String)"MarketCostReimburseEdit_0", (String)"occ-ocmem-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                evt.setCancel(true);
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("ocmem_adjustcashtype");
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "adjustfeecashtype"));
                showParameter.getOpenStyle().setShowType(ShowType.NonModal);
                showParameter.setParentPageId(this.getView().getPageId());
                this.getView().showForm(showParameter);
                break;
            }
            default: {
                super.beforeDoOperation(evt);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String eventKey = evt.getItemKey();
        if (this.BTN_DELETE_ENTRYS_ROW.equals(eventKey)) {
            this.btnDeleteEntrysRow_click((EventObject)evt);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        ChangeData[] changeset = e.getChangeSet();
        String entityName = changeset[0].getDataEntity().getDataEntityType().getName();
        if (EF_roworiginalamt.equals(propertyName)) {
            this.calcTotal();
        }
        if (EF_roworiginalqty.equals(propertyName)) {
            this.calcTotal();
        }
        if (EF_rowfinalqty.equals(propertyName)) {
            this.calcTotal();
        }
        if (EF_rowfinalamt.equals(propertyName)) {
            this.calcTotal();
        }
        if (this.ENTRYS.equals(entityName)) {
            this.entrys_changed(e);
        }
        if (this.OFFSET_BORROW.equals(entityName)) {
            this.offsetborrow_changed(e);
        }
        if (this.EXCLUDE_TAX_AMT.equals(propertyName) || "taxamount".equals(propertyName)) {
            // empty if block
        }
        if (this.RECEIVABLE.equals(entityName)) {
            this.receivable_changed(e);
        }
        if ("iteminfo".equals(propertyName)) {
            this.setUnit(this.getRowIndex(e));
        }
        if ("reimburseway".equals(propertyName)) {
            this.reimbursewayChanged();
        }
        if (this.TAX_RATE.equals(propertyName) || "taxamount".equals(propertyName) || this.TOTAL_AMT_INVOICE.equals(propertyName)) {
            BigDecimal taxRate = (BigDecimal)this.getValue(this.TAX_RATE);
            BigDecimal totalamtinvoice = (BigDecimal)this.getValue(this.TOTAL_AMT_INVOICE);
            taxRate = taxRate.divide(BigDecimalConstants.ONEHUNDRED);
            BigDecimal taxAmount = totalamtinvoice.multiply(taxRate).divide(BigDecimalConstants.ONE.add(taxRate), this.getAmtPrecision(), 4);
            this.setValue("taxamount", taxAmount);
            this.setValue(this.EXCLUDE_TAX_AMT, totalamtinvoice.subtract(taxAmount));
        }
        if (EF_quantity.equals(propertyName)) {
            int rowIndex = changeset[0].getRowIndex();
            DynamicObject row = this.getModel().getEntryRowEntity(this.ENTRYS, rowIndex);
            BigDecimal qty = row.getBigDecimal(EF_quantity);
            BigDecimal price = row.getBigDecimal("price");
            this.setValue(EF_verifiedqty, qty, rowIndex);
            this.setValue(EF_roworiginalqty, qty, rowIndex);
            this.setValue(EF_rowfinalqty, qty, rowIndex);
            this.setValue(EF_roworiginalamt, qty.multiply(price), rowIndex);
            this.setValue(EF_rowfinalamt, qty.multiply(price), rowIndex);
        }
    }

    @Override
    protected String getEntryKey() {
        return this.ENTRYS;
    }

    @Override
    protected String[] getEntryActionControl() {
        return new String[]{this.BTN_DELETE_ENTRYS_ROW};
    }

    private void reimbursewayChanged() {
        Object reimburseWay = this.getModel().getValue("reimburseway");
        if (reimburseWay == null) {
            return;
        }
        if (reimburseWay.equals("A")) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"paymethod"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"paymethod"});
        }
        if (reimburseWay.equals("B")) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"accounttype"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"accounttype"});
        }
    }

    private void setF7CustomerFilter(BeforeF7SelectEvent e, String cusomterName) {
        logger.info("cusomterName:" + cusomterName);
        if (EntityMetadataCache.getDataEntityType((String)"er_payeer").getAllFields().get("dept") != null && this.getModel().getValue("dept") != null) {
            logger.info("\u90e8\u95e8\u8fc7\u6ee4:" + this.getModel().getValue("dept"));
            QFilter filter = new QFilter("dept", "=", ((DynamicObject)this.getModel().getValue("dept")).getPkValue());
            logger.info("filter:" + filter);
            this.setF7Filter("payer", filter);
            if (e != null) {
                ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(filter);
            }
        } else {
            QFilter filter = new QFilter("outpayer", "=", (Object)cusomterName);
            logger.info("cfilter:" + filter);
            DynamicObject[] customerCollection = BusinessDataServiceHelper.load((String)"er_payeer", (String)"outpayer", (QFilter[])filter.toArray());
            HashSet<Object> set = new HashSet<Object>(customerCollection.length);
            for (DynamicObject info : customerCollection) {
                set.add(info.get("outpayer"));
            }
            filter = new QFilter("outpayer", "in", set);
            this.setF7Filter("payer", filter);
            logger.info("cfilter:" + filter);
            if (e != null) {
                ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(filter);
            }
        }
    }

    private void btnDeleteEntrysRow_click(EventObject evt) {
        this.calTotalAmount();
    }

    private void setUnit(int index) {
        Object assistUnit;
        Object itemPK = this.getEntryF7PKValue("entry", "iteminfo", index);
        Object baseUnit = OCMEMUtil.queryMasteridBaseUnitId((Object)itemPK);
        if (baseUnit != null) {
            this.getModel().setValue("baseunit", baseUnit, index);
        }
        if ((assistUnit = OCMEMUtil.queryMasteridAssistUnitId((Object)itemPK)) != null) {
            this.getModel().setValue("assistunit", assistUnit, index);
        }
    }

    private void offsetborrow_changed(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        DynamicObject row = this.getModel().getEntryRowEntity(this.RECEIVABLE, rowIndex);
        if (row.getBigDecimal("offsetamt").compareTo(BigDecimal.ZERO) != 0) {
            row.set("offsetamtlocal", (Object)row.getBigDecimal("offsetamt"));
        }
    }

    private void entrys_changed(PropertyChangedArgs e) {
        BigDecimal amount;
        DynamicObject row;
        String propertyName = e.getProperty().getName();
        ChangeData[] changeset = e.getChangeSet();
        int rowIndex = changeset[0].getRowIndex();
        if ("amount".equals(propertyName) || this.AMT_APPLY.equals(propertyName)) {
            row = this.getModel().getEntryRowEntity(this.ENTRYS, rowIndex);
            amount = row.get("amount") == null ? BigDecimal.ZERO : (BigDecimal)row.get("amount");
            row.set(this.AMT_APPROVED, (Object)amount);
            row.set(this.AMT_UNAPPROVED, (Object)amount.subtract(amount));
            row.set(EF_roworiginalamt, (Object)amount);
            row.set(EF_rowfinalamt, (Object)amount);
            this.calTotalAmount();
            this.getView().updateView(this.ENTRYS);
        }
        if (this.AMT_APPROVED.equals(propertyName) || this.AMT_APPLY.equals(propertyName)) {
            row = this.getModel().getEntryRowEntity(this.ENTRYS, rowIndex);
            amount = row.get("amount") == null ? BigDecimal.ZERO : (BigDecimal)row.get("amount");
            BigDecimal amtApproved = row.get(this.AMT_APPROVED) == null ? BigDecimal.ZERO : (BigDecimal)row.get(this.AMT_APPROVED);
            row.set(this.AMT_UNAPPROVED, (Object)amount.subtract(amtApproved));
            this.calTotalAmount();
            this.getView().updateView(this.ENTRYS);
        }
        if (this.AMT_UNAPPROVED.equals(propertyName)) {
            this.calTotalAmount();
        }
        if (EF_quantity.equals(propertyName)) {
            DynamicObject entry = this.getModel().getEntryRowEntity(this.ENTRYS, rowIndex);
            amount = entry.getBigDecimal("price").multiply(entry.getBigDecimal(EF_quantity));
            this.setValue("amount", amount, rowIndex);
        }
    }

    private int getAmtPrecision() {
        int amountPrecision = 2;
        DynamicObject currencyDynObj = this.getF7Value("currency");
        if (currencyDynObj != null) {
            amountPrecision = currencyDynObj.getInt("amtprecision");
        }
        return amountPrecision;
    }

    private void calTotalAmount() {
        int rowCount = this.getModel().getEntryRowCount(this.ENTRYS);
        BigDecimal amtApplySum = BigDecimal.ZERO;
        BigDecimal amountSum = BigDecimal.ZERO;
        BigDecimal amtApprovedSum = BigDecimal.ZERO;
        BigDecimal amtUnApprovedSum = BigDecimal.ZERO;
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            BigDecimal amtApply = this.getModel().getValue(this.AMT_APPLY, rowIndex) == null ? BigDecimal.ZERO : (BigDecimal)this.getModel().getValue(this.AMT_APPLY, rowIndex);
            BigDecimal amount = this.getModel().getValue("amount", rowIndex) == null ? BigDecimal.ZERO : (BigDecimal)this.getModel().getValue("amount", rowIndex);
            BigDecimal amtApproved = this.getModel().getValue(this.AMT_APPROVED, rowIndex) == null ? BigDecimal.ZERO : (BigDecimal)this.getModel().getValue(this.AMT_APPROVED, rowIndex);
            BigDecimal amtUnApproved = this.getModel().getValue(this.AMT_UNAPPROVED, rowIndex) == null ? BigDecimal.ZERO : (BigDecimal)this.getModel().getValue(this.AMT_UNAPPROVED, rowIndex);
            amtApplySum = amtApplySum.add(amtApply);
            amountSum = amountSum.add(amount);
            amtApprovedSum = amtApprovedSum.add(amtApproved);
            amtUnApprovedSum = amtUnApprovedSum.add(amtUnApproved);
        }
        this.getModel().setValue(this.TOTAL_AMT_APPLY, (Object)amtApplySum);
        this.getModel().setValue(this.TOTAL_AMOUNT, (Object)amountSum);
        this.getModel().setValue(this.TOTAL_AMT_APPROVED, (Object)amtApprovedSum);
        this.getModel().setValue(this.TOTAL_AMT_INVOICE, (Object)amtApprovedSum);
    }

    private void receivable_changed(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        ChangeData[] changeset = e.getChangeSet();
        int rowIndex = changeset[0].getRowIndex();
        DynamicObject row = this.getModel().getEntryRowEntity(this.RECEIVABLE, rowIndex);
        if (this.PAYER.equals(propertyName)) {
            DynamicObject payer = row.getDynamicObject(this.PAYER);
            if (payer != null) {
                StringBuilder selector = new StringBuilder();
                selector.append("id,");
                selector.append("payer,");
                selector.append("payer.id,");
                selector.append("payer.number,");
                selector.append("payer.name,");
                selector.append("outpayer,");
                selector.append("payerbank,");
                selector.append("payerbank.id,");
                selector.append("payerbank.number,");
                selector.append("payerbank.name,");
                selector.append("payeraccount");
                DynamicObject document = BusinessDataServiceHelper.loadSingle((Object)payer.getPkValue(), (String)payer.getDataEntityType().getName(), (String)selector.toString());
                if (document != null) {
                    row.set(this.PAYER_BANK, (Object)document.getDynamicObject("payerbank"));
                    row.set(this.PAYER_ACCOUNT, document.get("payeraccount"));
                    row.set(this.RECEIVABLE_AMT, this.getModel().getValue(this.TOTAL_AMT_APPROVED));
                    this.calReceivableAmtLocal(row);
                }
            } else {
                row.set(this.PAYER_BANK, null);
                row.set(this.PAYER_ACCOUNT, null);
            }
            this.getView().updateView(this.RECEIVABLE);
        }
        if (this.PAY_RATE.equals(propertyName) || this.RECEIVABLE_AMT.equals(propertyName)) {
            this.calReceivableAmtLocal(row);
            this.getView().updateView(this.RECEIVABLE);
        }
    }

    private void calReceivableAmtLocal(DynamicObject row) {
        row.set(this.RECEIVABLE_AMT_LOCAL, (Object)BigDecimalUtil.multiplyObject((Object)row.get(this.PAY_RATE), (Object)row.get(this.RECEIVABLE_AMT), (int)10));
    }

    private void setInvisibleField() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"accounttype"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"paymethod"});
    }
}

