/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.formplugin.cost;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.helper.CUserHelper;
import kd.occ.ocbase.common.util.CustomerSalerUtil;
import kd.occ.ocbase.common.util.CustomerUtil;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.ItemNSaleControlUtil;
import kd.occ.ocbase.common.util.ItemUtil;
import kd.occ.ocbase.common.util.QueryUtil;
import kd.occ.ocbase.common.util.UserUtil;
import kd.occ.ocmem.formplugin.basedata.OCMEMBillFormPlugin;

public class PricePolicyApplyEdit
extends OCMEMBillFormPlugin
implements BeforeF7SelectListener {
    public static final String BILL_DATE = "billdate";
    public static final String PRICE_POLICY_TYPE = "pricepolicytype";
    public static final String BILL_STATUS = "billstatus";
    public static final String CHANNEL_CLASS = "channelclass";
    public static final String START_TIME = "starttime";
    public static final String END_TIME = "endtime";
    public static final String COMPETITION_STATUS = "competitionstatus";
    public static final String APPLY_REASON = "applyreason";
    public static final String ITEM_ENTRY = "itementry";
    public static final String ENTRY_SHOP_ID = "shopid";
    public static final String ENTRY_STORE_NAME = "storename";
    public static final String ENTRY_ITEM_NAME = "itemname";
    public static final String ENTRY_ITEM_ID = "itemid";
    public static final String ENTRY_SPEC = "spec";
    public static final String ENTRY_MEASURE_UNIT = "measureunit";
    public static final String ENTRY_REF_PRICE = "refprice";
    public static final String ENTRY_MONTHLY_POLICY_PRICE = "monthlypolicyprice";
    public static final String ENTRY_APPLY_PRICE = "applyprice";
    public static final String ENTRY_PRICE_MAGRIN = "pricemagrin";
    public static final String ENTRY_RETAIL_PRICE = "retailprice";
    public static final String ENTRY_QUANTITY = "quantity";
    public static final String ENTRY_AMOUNT_MAGRIN = "amountmagrin";
    public static final String POLICY_START_TIME = "policystarttime";
    public static final String POLICY_END_TIME = "policyendtime";
    public static final String ORG = "org";
    protected volatile boolean triggerChangeEvent = true;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{"salechannel", "orderchannel", ORG, ENTRY_SHOP_ID, ENTRY_ITEM_ID, ENTRY_MEASURE_UNIT});
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        int rowIndex = e.getRow();
        switch (key) {
            case "salechannel": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getOwnerFilter());
                break;
            }
            case "orderchannel": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getCustomerFilter());
                break;
            }
            case "org": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getOrgFilter());
                break;
            }
            case "measureunit": {
                if (this.getEntryF7PKValue(ITEM_ENTRY, ENTRY_ITEM_ID, rowIndex) == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5546\u54c1", (String)"PricePolicyApplyEdit_0", (String)"occ-ocmem-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getUnitFilter(rowIndex));
                break;
            }
            case "itemid": {
                if (this.getCustomerF7PKValue() == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5ba2\u6237", (String)"PricePolicyApplyEdit_1", (String)"occ-ocmem-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, this.getItemFilter());
                break;
            }
            case "shopid": {
                if (this.getCustomerF7PKValue() == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5ba2\u6237", (String)"PricePolicyApplyEdit_1", (String)"occ-ocmem-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getShopNameFilter());
            }
        }
    }

    private QFilter getOwnerFilter() {
        return CUserHelper.getAuthorizedChannelFilter();
    }

    private QFilter getCustomerFilter() {
        Object ownerID = this.getOwnerF7PKValue();
        boolean isSaler = UserUtil.isSaler((Object)ownerID);
        Set ids = null;
        ids = isSaler ? CustomerSalerUtil.queryCustomerPKBySaler((Object)ownerID, (Object)UserUtil.getCurrUserId()) : CustomerUtil.getAuthSubsIds((Object)ownerID);
        return new QFilter("id", "in", (Object)ids);
    }

    private QFilter getOrgFilter() {
        QFilter userFilter = new QFilter("id", "=", (Object)UserUtil.getCurrUserId());
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bos_user", (String)"entryentity.dpt", (QFilter[])userFilter.toArray());
        List dpts = QueryUtil.toList((DynamicObjectCollection)collection, (String)"entryentity.dpt");
        return new QFilter("id", "=", (Object)dpts);
    }

    private QFilter getUnitFilter(int rowIndex) {
        Object itemId = this.getEntryF7PKValue(ITEM_ENTRY, ENTRY_ITEM_ID, rowIndex);
        List unitIds = this.getUnitFormHandler().getUnitIdList(itemId);
        return new QFilter("id", "in", (Object)unitIds);
    }

    private List<QFilter> getItemFilter() {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        Object org = this.getF7PKValue(ORG);
        Object saleChannel = this.getOwnerF7PKValue();
        Object orderChannel = this.getCustomerF7PKValue();
        if (saleChannel == null || org == null || orderChannel == null) {
            filters.add(new QFilter("2", "=", (Object)"1"));
        } else {
            filters.addAll(ItemNSaleControlUtil.getItemFilterBySaleChannel((long)((Long)org), (long)((Long)saleChannel), (long)((Long)orderChannel)));
        }
        return filters;
    }

    private QFilter getShopNameFilter() {
        QFilter shopFilter = new QFilter("channel", "=", this.getCustomerF7PKValue());
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"ocdbd_shopmanage", (String)"id,channel", (QFilter[])shopFilter.toArray());
        List shopIds = QueryUtil.toList((DynamicObjectCollection)collection, (String)"id");
        return new QFilter("id", "in", (Object)shopIds);
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().deleteEntryData(ITEM_ENTRY);
        this.initDefaultOwner();
    }

    private void initDefaultOwner() {
        List owners = CUserHelper.getAuthorizedChannelIdList();
        if (owners.size() == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u60a8\u8fd8\u6ca1\u6709\u6240\u5c5e\u6e20\u9053\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6dfb\u52a0", (String)"PricePolicyApplyEdit_2", (String)"occ-ocmem-formplugin", (Object[])new Object[0]));
            return;
        }
        if (owners.size() == 1) {
            this.setUnEnable(new String[]{"salechannel"});
        }
        this.setF7Value("salechannel", owners.get(0));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        int index = e.getChangeSet()[0].getRowIndex();
        if (!this.triggerChangeEvent) {
            return;
        }
        switch (key) {
            case "salechannel": {
                this.setF7Value("orderchannel", null);
                break;
            }
            case "orderchannel": {
                this.getModel().deleteEntryData(ITEM_ENTRY);
                break;
            }
            case "itemid": {
                this.changeEntryItemName(index);
                this.calcuPriceMagrin(index);
                break;
            }
            case "quantity": {
                this.calcuAmountMagrin(index);
                break;
            }
            case "billdate": {
                this.setAllMonthlyPolicyPrice();
                break;
            }
            case "monthlypolicyprice": 
            case "applyprice": {
                this.calcuPriceMagrin(index);
                break;
            }
            case "starttime": {
                if (this.compareStartAndEndTime()) break;
                this.getView().showMessage(ResManager.loadKDString((String)"\u6d3b\u52a8\u5f00\u59cb\u65e5\u671f \u4e0d\u80fd\u665a\u4e8e \u6d3b\u52a8\u7ed3\u675f\u65e5\u671f,\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PricePolicyApplyEdit_3", (String)"occ-ocmem-formplugin", (Object[])new Object[0]));
                this.setValue(START_TIME, null, index);
                break;
            }
            case "endtime": {
                if (this.compareStartAndEndTime()) break;
                this.getView().showMessage(ResManager.loadKDString((String)"\u6d3b\u52a8\u5f00\u59cb\u65e5\u671f \u4e0d\u80fd\u665a\u4e8e \u6d3b\u52a8\u7ed3\u675f\u65e5\u671f,\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PricePolicyApplyEdit_3", (String)"occ-ocmem-formplugin", (Object[])new Object[0]));
                this.setValue(END_TIME, null, index);
                break;
            }
            case "policystarttime": {
                if (!this.comparePolicyStartAndEndTime(index)) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u653f\u7b56\u5f00\u59cb\u65e5\u671f \u4e0d\u80fd\u665a\u4e8e \u653f\u7b56\u7ed3\u675f\u65e5\u671f,\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PricePolicyApplyEdit_4", (String)"occ-ocmem-formplugin", (Object[])new Object[0]));
                    this.setValue(POLICY_START_TIME, null, index);
                }
                this.triggerChangeEvent = false;
                this.calcBeginDate(index, (Date)e.getChangeSet()[0].getOldValue());
                break;
            }
            case "policyendtime": {
                if (!this.comparePolicyStartAndEndTime(index)) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u653f\u7b56\u7ed3\u675f\u65e5\u671f \u4e0d\u80fd\u65e9\u4e8e \u653f\u7b56\u5f00\u59cb\u65e5\u671f,\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PricePolicyApplyEdit_5", (String)"occ-ocmem-formplugin", (Object[])new Object[0]));
                    this.setValue(POLICY_END_TIME, null, index);
                }
                this.triggerChangeEvent = false;
                this.calcEndDate(index, (Date)e.getChangeSet()[0].getOldValue());
                break;
            }
            case "measureunit": {
                this.setMonthlyPolicyPrice(index);
                this.changeQtyPrecision(index);
                break;
            }
        }
    }

    private void changeQtyPrecision(int index) {
        this.setValue(ENTRY_QUANTITY, this.getModel().getValue(ENTRY_QUANTITY, index), index);
    }

    private boolean compareStartAndEndTime() {
        Date startTime = (Date)this.getValue(START_TIME);
        Date endTime = (Date)this.getValue(END_TIME);
        return startTime == null || endTime == null || !startTime.after(endTime);
    }

    private boolean comparePolicyStartAndEndTime(int index) {
        Date policyStartTime = (Date)this.getValue(POLICY_START_TIME, index);
        Date policyEndTime = (Date)this.getValue(POLICY_END_TIME, index);
        return policyStartTime == null || policyEndTime == null || !policyStartTime.after(policyEndTime);
    }

    private void changeEntryItemName(int index) {
        DynamicObject item = this.getEntryF7Value(ITEM_ENTRY, ENTRY_ITEM_ID, index);
        DynamicObject itemInfo = ItemUtil.getItemBizInfo((Object)item.getPkValue());
        Object baseUnit = this.getUnitFormHandler().getBaseUnitId(item.getPkValue());
        this.setValue(ENTRY_MEASURE_UNIT, baseUnit, index);
        this.setValue(ENTRY_REF_PRICE, itemInfo.getBigDecimal("referenceprice"), index);
        this.setMonthlyPolicyPrice(index);
    }

    private void setMonthlyPolicyPrice(int index) {
        BigDecimal monthlyPolicyPrice = BigDecimal.ZERO;
        this.setValue(ENTRY_MONTHLY_POLICY_PRICE, monthlyPolicyPrice, index);
    }

    private void setAllMonthlyPolicyPrice() {
        int size = this.getModel().getEntryEntity(ITEM_ENTRY).size();
        for (int i = 0; i < size; ++i) {
            this.setMonthlyPolicyPrice(i);
        }
    }

    private void calcuPriceMagrin(int index) {
        DynamicObject item = (DynamicObject)this.getModel().getEntryEntity(ITEM_ENTRY).get(index);
        BigDecimal monthlyPolicyPrice = item.getBigDecimal(ENTRY_MONTHLY_POLICY_PRICE);
        BigDecimal applyPrice = item.getBigDecimal(ENTRY_APPLY_PRICE);
        BigDecimal priceMagrin = monthlyPolicyPrice.subtract(applyPrice);
        this.setValue(ENTRY_PRICE_MAGRIN, priceMagrin, index);
        this.calcuAmountMagrin(index);
    }

    private void calcuAmountMagrin(int index) {
        DynamicObject item = (DynamicObject)this.getModel().getEntryEntity(ITEM_ENTRY).get(index);
        BigDecimal priceMagrin = item.getBigDecimal(ENTRY_PRICE_MAGRIN);
        BigDecimal quantity = item.getBigDecimal(ENTRY_QUANTITY);
        BigDecimal amountMagrin = priceMagrin.multiply(quantity);
        this.setValue(ENTRY_AMOUNT_MAGRIN, amountMagrin, index);
    }

    protected void calcBeginDate(int index, Date oldDate) {
        Date beginDate;
        DynamicObject orderEntry;
        if (index >= 0 && (orderEntry = this.getRowInfo(ITEM_ENTRY, index)) != null && orderEntry.getDate(POLICY_START_TIME) != null) {
            beginDate = orderEntry.getDate(POLICY_START_TIME);
            if ((beginDate = DateUtil.getDayLast((Date)beginDate)).getTime() < System.currentTimeMillis()) {
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"PricePolicyApplyEdit_6", (String)"occ-ocmem-formplugin", (Object[])new Object[0]), index + 1));
                this.setValue(POLICY_START_TIME, oldDate, index);
                return;
            }
            Date endDate = orderEntry.getDate(POLICY_END_TIME);
            if (endDate != null && (endDate = DateUtil.getDayLast((Date)endDate)).getTime() < beginDate.getTime()) {
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"PricePolicyApplyEdit_7", (String)"occ-ocmem-formplugin", (Object[])new Object[0]), index + 1));
                this.setValue(POLICY_START_TIME, oldDate, index);
                return;
            }
        }
        DynamicObjectCollection entrys = this.getModel().getEntryEntity(ITEM_ENTRY);
        beginDate = null;
        for (DynamicObject entry : entrys) {
            Date date = entry.getDate(POLICY_START_TIME);
            if (beginDate != null && (date == null || beginDate.getTime() <= date.getTime())) continue;
            beginDate = date;
        }
        this.setValue(START_TIME, beginDate);
    }

    protected void calcEndDate(int index, Date oldDate) {
        Date endDate;
        DynamicObject orderEntry;
        if (index >= 0 && (orderEntry = this.getRowInfo(ITEM_ENTRY, index)) != null && orderEntry.getDate(POLICY_END_TIME) != null) {
            endDate = orderEntry.getDate(POLICY_END_TIME);
            if ((endDate = DateUtil.getDayFirst((Date)endDate)).getTime() < DateUtil.getDayFirst((Date)new Date()).getTime() && endDate.getTime() < System.currentTimeMillis()) {
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"PricePolicyApplyEdit_8", (String)"occ-ocmem-formplugin", (Object[])new Object[0]), index + 1));
                this.setValue(POLICY_END_TIME, oldDate, index);
                return;
            }
            Date beginDate = orderEntry.getDate(POLICY_START_TIME);
            if (beginDate != null) {
                beginDate = DateUtil.getDayFirst((Date)beginDate);
                if (endDate.getTime() < beginDate.getTime()) {
                    this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"PricePolicyApplyEdit_9", (String)"occ-ocmem-formplugin", (Object[])new Object[0]), index + 1));
                    this.setValue(POLICY_END_TIME, oldDate, index);
                    return;
                }
            }
        }
        DynamicObjectCollection entrys = this.getModel().getEntryEntity(ITEM_ENTRY);
        endDate = null;
        for (DynamicObject entry : entrys) {
            Date date = entry.getDate(POLICY_END_TIME);
            if (endDate != null && (date == null || endDate.getTime() >= date.getTime())) continue;
            endDate = date;
        }
        this.setValue(END_TIME, endDate);
    }
}

