/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.formplugin.cost.mobile;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.list.BillList;
import kd.bos.list.MobileSearch;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.formplugin.base.OCMEMBillFormMobPlugin;
import kd.occ.ocmem.business.cost.CostAppFormHelper;
import kd.occ.ocmem.common.enums.BizBillStatusEnum;
import kd.occ.ocmem.common.util.ToExecFilterUtil;
import org.apache.commons.lang.StringUtils;

public class CostApplyListMobFormPlugin
extends OCMEMBillFormMobPlugin
implements ClickListener,
MobileSearchTextChangeListener {
    private static final String DROP_DOWN_BUTTON = "dropdownbutton";
    private static final String COSTOMER_BUTTON = "customerbutton";
    private static final String EXCUTE_TIME_FILTER = "excutetimefilter";
    private static final String RESETBUTTON = "resetbutton";
    private static final String COST_APPLY_INFO = "costapplyinfo";
    private static final String CACHE_TXT = "searchtxt";
    private static final String Entry = "entryentity";
    private static final String EXECUTOR = "executor";

    public void initialize() {
        super.initialize();
        BillList list = (BillList)this.getControl("billlist");
        list.addSetFilterListener(new SetFilterListener(){

            public void setFilter(SetFilterEvent e) {
                ArrayList<QFilter> defaultFilter = e.getQFilters();
                if (defaultFilter == null) {
                    defaultFilter = new ArrayList<QFilter>();
                }
                QFilter exeCutorfilter = CostApplyListMobFormPlugin.this.getExecutorFilter();
                QFilter filter = CostApplyListMobFormPlugin.this.getDefaultFilter();
                QFilter ancestorFilter = CostAppFormHelper.getMobSetFilterUpdate();
                if (ancestorFilter != null) {
                    if (exeCutorfilter != null) {
                        exeCutorfilter.or(ancestorFilter);
                        defaultFilter.add(exeCutorfilter);
                    } else if (ancestorFilter.toString().equals("id = 888")) {
                        defaultFilter.add(new QFilter("id", "=", (Object)888L));
                    } else {
                        defaultFilter.add(ancestorFilter);
                    }
                }
                defaultFilter.add(filter);
                e.setQFilters(defaultFilter);
                e.setOrderBy("billno desc");
                CostApplyListMobFormPlugin.this.statisticUnexecutoryBills(e.getQFilters());
            }
        });
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.hiddenDateFilter();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{COST_APPLY_INFO, COSTOMER_BUTTON, DROP_DOWN_BUTTON, RESETBUTTON});
        MobileSearch searchap = (MobileSearch)this.getView().getControl("mobilesearchap");
        searchap.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (DROP_DOWN_BUTTON.equals(key)) {
            this.openDateFilter();
        } else if (COST_APPLY_INFO.equals(key)) {
            this.openCostApplyDetail(evt);
        } else if (COSTOMER_BUTTON.equals(key)) {
            this.openChooseCustomer();
        } else if (RESETBUTTON.equals(key)) {
            this.resetApplyDateFilter();
        }
    }

    private void resetApplyDateFilter() {
        this.getView().getControl("begindate").getModel().setValue("begindate", (Object)"");
        this.getView().getControl("enddate").getModel().setValue("enddate", (Object)"");
    }

    private void hiddenDateFilter() {
        if (this.getPageCache().get("show") == null) {
            Control control = this.getView().getControl(EXCUTE_TIME_FILTER);
            control.getView().setVisible(Boolean.FALSE, new String[]{EXCUTE_TIME_FILTER});
            this.getPageCache().put("show", "disVisible");
        }
    }

    private void statisticUnexecutoryBills(List<QFilter> qFilter) {
        DynamicObjectCollection rs = QueryServiceHelper.query((String)"ocmem_marketcost_apply", (String)"execstatus", (QFilter[])qFilter.toArray(new QFilter[1]));
        Label control = (Label)this.getView().getControl("count");
        control.setText(String.valueOf(rs.size()));
    }

    private void openDateFilter() {
        if ("disVisible".equals(this.getPageCache().get("show"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{EXCUTE_TIME_FILTER});
            this.getPageCache().put("show", "visible");
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{EXCUTE_TIME_FILTER});
            this.getPageCache().put("show", "disVisible");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("begindate".equals(key) || "enddate".equals(key)) {
            Date beginDate = (Date)this.getModel().getValue("begindate");
            Date endDate = (Date)this.getModel().getValue("enddate");
            if (beginDate != null && endDate != null) {
                if (endDate.compareTo(beginDate) >= 0) {
                    BillList list = (BillList)this.getControl("billlist");
                    list.refresh();
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u5f00\u59cb\u65e5\u671f", (String)"CostApplyListMobFormPlugin_0", (String)"occ-ocmem-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
                    this.getModel().setValue(key, null);
                    this.getModel().setDataChanged(false);
                }
            } else {
                BillList list = (BillList)this.getControl("billlist");
                list.refresh();
            }
        }
    }

    private void openCostApplyDetail(EventObject evt) {
        List objs;
        Control control = (Control)evt.getSource();
        IClientViewProxy cvp = (IClientViewProxy)control.getView().getService(IClientViewProxy.class);
        LinkedHashMap billList = (LinkedHashMap)cvp.getViewState("billlist");
        List list = (List)billList.get("selDatas");
        if (list != null && list.size() > 0 && (objs = (List)list.get(0)) != null && objs.size() > 0) {
            Object pk = objs.get(0);
            MobileBillShowParameter param = new MobileBillShowParameter();
            param.getOpenStyle().setShowType(ShowType.Floating);
            param.getOpenStyle().setTargetKey(pk.toString());
            param.setBillStatus(BillOperationStatus.VIEW);
            param.setStatus(OperationStatus.VIEW);
            param.setPkId(pk);
            param.setFormId("ocmem_mc_apply_detailmob");
            HashMap params = new HashMap();
            params.put("applyid", pk);
            param.setCustomParams(params);
            this.getView().showForm((FormShowParameter)param);
        }
    }

    private void openChooseCustomer() {
        MobileFormShowParameter param = new MobileFormShowParameter();
        param.getOpenStyle().setShowType(ShowType.Floating);
        param.setFormId("ocmem_cust_list_stamob");
        param.setStatus(OperationStatus.ADDNEW);
        Date beginDate = (Date)this.getModel().getValue("begindate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        param.setCustomParam("beginDate", (Object)beginDate);
        param.setCustomParam("endDate", (Object)endDate);
        this.getView().showForm((FormShowParameter)param);
    }

    public void click(MobileSearchTextChangeEvent e) {
        String searchtxt = e.getText();
        this.getPageCache().put(CACHE_TXT, searchtxt.trim());
        BillList list = (BillList)this.getControl("billlist");
        list.refresh();
    }

    protected QFilter getDefaultFilter() {
        QFilter filter = this.getDateFilter();
        filter.and(ToExecFilterUtil.getCostTypeFilter());
        String searchtxt = this.getPageCache().get(CACHE_TXT);
        if (searchtxt != null && StringUtils.isNotBlank((String)searchtxt.trim())) {
            String likeValue = "%" + searchtxt + "%";
            QFilter qFilter = new QFilter("name", "like", (Object)likeValue);
            DynamicObject[] expenseTypeList = BusinessDataServiceHelper.load((String)"ocdbd_expensetype", (String)"id,number,name", (QFilter[])qFilter.toArray());
            HashSet<Object> set = new HashSet<Object>(expenseTypeList.length);
            for (int i = 0; i < expenseTypeList.length; ++i) {
                DynamicObject expensetype = expenseTypeList[i];
                set.add(expensetype.getPkValue());
            }
            QFilter filter1 = new QFilter("expensetype", "in", set);
            filter1.or(new QFilter("orderchannel.name", "like", (Object)likeValue));
            filter1.or(new QFilter("billno", "like", (Object)likeValue));
            filter.and(filter1);
        }
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)BizBillStatusEnum.AUDIDPASS.getValue());
        statusFilter.or(new QFilter("billstatus", "=", (Object)BizBillStatusEnum.PARTREFUND.getValue()));
        filter.and(statusFilter);
        return filter;
    }

    private QFilter getExecutorFilter() {
        QFilter defaultFilter = this.getDefaultFilter();
        QFilter filter = new QFilter("id", "is not null", null);
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        ArrayList<Long> ids = new ArrayList<Long>();
        DynamicObject[] billList = BusinessDataServiceHelper.load((String)"ocmem_marketcost_apply", (String)"id,number,name,entryentity.id,entryentity.executor ", (QFilter[])filter.toArray());
        if (billList != null && billList.length > 0) {
            block0: for (int i = 0; i < billList.length; ++i) {
                DynamicObjectCollection entryCollection = (DynamicObjectCollection)billList[i].get(Entry);
                Long id = (Long)billList[i].get("id");
                for (int j = 0; j < entryCollection.size(); ++j) {
                    Object executor = ((DynamicObject)entryCollection.get(j)).get(EXECUTOR);
                    if (!(executor instanceof DynamicObjectCollection)) continue;
                    DynamicObjectCollection executorCollection = (DynamicObjectCollection)executor;
                    for (int k = 0; k < executorCollection.size(); ++k) {
                        Long eachExecutorId = (Long)((DynamicObject)executorCollection.get(k)).get("fbasedataid_id");
                        if (!eachExecutorId.equals(userId)) continue;
                        ids.add(id);
                        continue block0;
                    }
                }
            }
        }
        if (ids.size() > 0) {
            return new QFilter("id", "in", ids);
        }
        return null;
    }

    private QFilter getDateFilter() {
        QFilter filter = new QFilter("id", "is not null", null);
        Date beginDate = (Date)this.getModel().getValue("begindate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        if (beginDate != null && endDate != null) {
            QFilter f1 = new QFilter("begindate", ">=", (Object)beginDate);
            f1.and("begindate", "<=", (Object)endDate);
            QFilter f2 = new QFilter("begindate", "<=", (Object)beginDate);
            f2.and("enddate", ">=", (Object)beginDate);
            filter.and(f1.or(f2));
        } else {
            Date date = new Date();
            date = DateUtil.getDayFirst((Date)date);
            filter.and("begindate", "<=", (Object)date);
            filter.and("enddate", ">=", (Object)date);
        }
        return filter;
    }
}

