/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.formplugin.cost.mobile;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.bill.events.LocateEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.ImageList;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.occ.ocbase.formplugin.base.OCMEMBillFormMobPlugin;
import kd.occ.ocmem.business.cost.CostAppFormHelper;
import net.sf.json.JSONObject;

public class CostExecuteEditMob
extends OCMEMBillFormMobPlugin {
    public static final Log logger = LogFactory.getLog(CostExecuteEditMob.class);
    protected boolean isTest = false;

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.isTest) {
            return;
        }
        this.initHead();
        CostAppFormHelper.initImgList((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"execimagelist", (String)"entryentity");
        OperationStatus opStatus = this.getView().getFormShowParameter().getStatus();
        logger.info("OperationStatus:" + opStatus);
        if (opStatus.toString().equals(OperationStatus.VIEW.toString())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"execimagelist", "description"});
        } else {
            ((IMobileView)this.getView()).locate();
            try {
                logger.info("go to callYZJApi ------");
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("method", "getDevicedMsg");
                this.getView().executeClientCommand("callYZJApi", new Object[]{data});
            }
            catch (Exception e2) {
                logger.info("fail to callYZJApi ------");
            }
        }
    }

    public void locate(LocateEvent e) {
        super.locate(e);
        logger.info("go in locate ------");
        if (e.getMobLocation() != null) {
            logger.info("locate getAddressdetail = " + e.getMobLocation().getAddressdetail());
            this.getModel().setValue("execaddress", (Object)e.getMobLocation().getAddressdetail());
            OperationStatus opStatus = this.getView().getFormShowParameter().getStatus();
            logger.info("OperationStatus:" + opStatus);
            if (!opStatus.toString().equals(OperationStatus.VIEW.toString())) {
                logger.info("is view:" + opStatus);
                ((Label)this.getControl("lb_execaddress")).setText((String)this.getModel().getValue("execaddress"));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u624b\u673a\u5b9a\u4f4d\u4fe1\u606f\u3002", (String)"CostExecuteEditMob_0", (String)"occ-ocmem-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            logger.info("do not get MobLocation ------");
        }
    }

    private void initHead() {
        Date date;
        DynamicObject user;
        DynamicObject bill;
        DynamicObject shop;
        DynamicObject shopObj;
        IDataModel model = this.getModel();
        DynamicObject costEntry = (DynamicObject)model.getValue("costapplyentry");
        if (!(costEntry instanceof DynamicObject)) {
            return;
        }
        DynamicObject item = costEntry.getDynamicObject("iteminfo");
        if (item != null && item.get("name") != null) {
            ((Label)this.getControl("label_itemname")).setText(item.getString("name"));
            DynamicObject modelnum = QueryServiceHelper.queryOne((String)"ocdbd_iteminfo", (String)"modelnum", (QFilter[])new QFilter("id", "=", item.getPkValue()).toArray());
            if (modelnum != null && modelnum.getString("modelnum") != null) {
                ((Label)this.getControl("label_modelnum")).setText(modelnum.getString("modelnum"));
            }
        }
        if ((shopObj = costEntry.getDynamicObject("shop")) != null && (shop = BusinessDataServiceHelper.loadSingle((Object)shopObj.getPkValue(), (String)"ocdbd_channel")) != null) {
            ((Label)this.getControl("label_shopname")).setText(shop.getString("name"));
        }
        if ((bill = costEntry.getDynamicObject("bill")) != null) {
            bill = BusinessDataServiceHelper.loadSingle((Object)bill.getPkValue(), (String)"ocmem_marketcost_apply");
            ((Label)this.getControl("label_costtype")).setText(bill.getString("expensetype.name"));
        }
        if ((user = (DynamicObject)model.getValue("creator")) != null) {
            ((Label)this.getControl("lb_creator")).setText(user.getString("name"));
        }
        if ((date = (Date)model.getValue("createtime")) != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            ((Label)this.getControl("lb_createtime")).setText(sdf.format(date));
        }
        logger.info((String)model.getValue("execaddress"));
        ((Label)this.getControl("lb_execaddress")).setText((String)model.getValue("execaddress"));
        logger.info((String)model.getValue("execdevice"));
        ((Label)this.getControl("lb_execdevice")).setText((String)model.getValue("execdevice"));
    }

    private void removeImages(UploadEvent evt) {
        Log logger = LogFactory.getLog(CostExecuteEditMob.class);
        logger.info("remove");
        Object[] indexes = evt.getIndexes();
        for (int i = 0; i < indexes.length; ++i) {
            int index = Integer.parseInt(indexes[0].toString());
            this.getModel().deleteEntryRow("entryentity", index);
        }
        CostAppFormHelper.initImgList((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"execimagelist", (String)"entryentity");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadImage(UploadEvent evt) {
        Log logger = LogFactory.getLog(CostExecuteEditMob.class);
        logger.info("upload");
        StringBuilder msg = new StringBuilder();
        msg.append("memUpload:start");
        msg.append("\t\n");
        try {
            Object[] urls = evt.getUrls();
            msg.append("urls : ");
            msg.append(Arrays.toString(urls));
            msg.append("\t\n");
            String url = urls[0].toString();
            Object[] urllist = url.split(",");
            msg.append("urllist : ");
            msg.append(Arrays.toString(urllist));
            msg.append("\t\n");
            msg.append("urllist.length : ");
            msg.append(urllist.length);
            msg.append("\t\n");
            for (int i = 0; i < urllist.length; ++i) {
                Object eurl = urllist[i];
                int index = this.getModel().createNewEntryRow("entryentity");
                msg.append("setValue thumbnailurl: eurl=");
                msg.append((String)eurl);
                msg.append(", index = ");
                msg.append(index);
                msg.append("\t\n");
                this.getModel().setValue("thumbnailurl", eurl, index);
                Object[] eurls = ((String)eurl).split("_thumbnails_scalePic");
                msg.append("eurls : ");
                msg.append(Arrays.toString(eurls));
                msg.append("\t\n");
                if (eurls.length < 2) continue;
                String bigimurl = (String)eurls[0] + (String)eurls[1];
                msg.append("setValue picurl: bigimurl=");
                msg.append(bigimurl);
                msg.append(", index = ");
                msg.append(index);
                msg.append("\t\n");
                this.getModel().setValue("picurl", (Object)bigimurl, index);
            }
            this.getModel().updateCache();
            CostAppFormHelper.initImgList((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"execimagelist", (String)"entryentity");
        }
        catch (Exception e) {
            msg.append("Exception : ");
            msg.append(e.getMessage());
            msg.append("\t\n");
            logger.error(e.getMessage());
        }
        finally {
            msg.append("memUpload:end");
            msg.append("\t\n");
            logger.info(msg.toString());
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnprevious", "btnfirst", "btnnext", "btnlast", "btncontinue"});
        ImageList imageList = (ImageList)this.getControl("execimagelist");
        imageList.addUploadListener(new UploadListener(){

            public void remove(UploadEvent evt) {
                CostExecuteEditMob.this.removeImages(evt);
            }

            public void afterUpload(UploadEvent evt) {
                Log logger = LogFactory.getLog(CostExecuteEditMob.class);
                logger.info("afterUpload");
                super.afterUpload(evt);
            }

            public void upload(UploadEvent evt) {
                CostExecuteEditMob.this.uploadImage(evt);
            }
        });
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "save": {
                if (this.isPicEmtry()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u56fe\u7247\u4e3a\u7a7a\u4e0d\u80fd\u6267\u884c\u3002", (String)"CostExecuteEditMob_1", (String)"occ-ocmem-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    e.setCancel(true);
                    return;
                }
                if (this.isDescriptionEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6267\u884c\u8bf4\u660e\u4e3a\u7a7a\u4e0d\u80fd\u6267\u884c\u3002", (String)"CostExecuteEditMob_2", (String)"occ-ocmem-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    e.setCancel(true);
                    return;
                }
                this.savePicListToModel();
                ((IMobileView)this.getView()).locate();
                try {
                    logger.info("go to callYZJApi ------");
                    HashMap<String, String> data = new HashMap<String, String>();
                    data.put("method", "getDevicedMsg");
                    this.getView().executeClientCommand("callYZJApi", new Object[]{data});
                    break;
                }
                catch (Exception e2) {
                    logger.info("fail to callYZJApi ------");
                }
            }
        }
    }

    private boolean isDescriptionEmpty() {
        String description = (String)this.getModel().getValue("description");
        return StringUtils.isBlank((String)description);
    }

    private boolean isPicEmtry() {
        return this.getModel().getEntryEntity("entryentity").size() == 0;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
    }

    public void savePicListToModel() {
        ImageList imgList = (ImageList)this.getView().getControl("execimagelist");
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        Object execimagelist = proxy.getViewState("execimagelist");
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btnfirst": {
                this.queryFirst();
                break;
            }
            case "btnprevious": {
                this.queryPrevious();
                break;
            }
            case "btnnext": {
                this.queryNext();
                break;
            }
            case "btnlast": {
                this.queryLast();
                break;
            }
            case "btncontinue": {
                this.continueExe();
                break;
            }
        }
    }

    private void continueExe() {
        DynamicObject costEntry = (DynamicObject)this.getModel().getValue("costapplyentry");
        Object entryId = costEntry.getPkValue();
        MobileBillShowParameter param = new MobileBillShowParameter();
        param.setCustomParam("applyEntryId", entryId);
        param.getOpenStyle().setShowType(ShowType.Floating);
        param.setFormId("ocmem_costexecute_editmob");
        this.getView().showForm((FormShowParameter)param);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setValue("number", String.valueOf(System.currentTimeMillis()));
        this.setValue("name", String.valueOf(System.currentTimeMillis()));
        Object applyEntryId = this.getView().getFormShowParameter().getCustomParam("applyEntryId");
        if (applyEntryId != null) {
            DynamicObject costApplyEntry = BusinessDataServiceHelper.loadSingle((Object)applyEntryId, (String)"ocmem_mcostapply_entry");
            this.setValue("costapplyentry", costApplyEntry);
        }
    }

    private void queryPrevious() {
        Object pk = this.getModel().getValue("id");
        List<Object> pkList = this.getExecuteList();
        int index = pkList.indexOf(pk);
        if (index == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5df2\u7ecf\u662f\u6700\u521d\u4e00\u4e2a", (String)"CostExecuteEditMob_3", (String)"occ-ocmem-formplugin", (Object[])new Object[0]));
            return;
        }
        this.showCostCostExecute(pkList.get(index - 1));
    }

    private void queryNext() {
        Object pk = this.getModel().getValue("id");
        List<Object> pkList = this.getExecuteList();
        int index = pkList.indexOf(pk);
        if (index == pkList.size() - 1) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5df2\u7ecf\u662f\u6700\u540e\u4e00\u4e2a", (String)"CostExecuteEditMob_4", (String)"occ-ocmem-formplugin", (Object[])new Object[0]));
            return;
        }
        this.showCostCostExecute(pkList.get(index + 1));
    }

    private void queryFirst() {
        Object pk = this.getModel().getValue("id");
        List<Object> pkList = this.getExecuteList();
        int index = pkList.indexOf(pk);
        if (index == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5df2\u7ecf\u662f\u6700\u521d\u4e00\u4e2a", (String)"CostExecuteEditMob_3", (String)"occ-ocmem-formplugin", (Object[])new Object[0]));
            return;
        }
        this.showCostCostExecute(pkList.get(0));
    }

    private void queryLast() {
        Object pk = this.getModel().getValue("id");
        List<Object> pkList = this.getExecuteList();
        int index = pkList.indexOf(pk);
        if (index == pkList.size() - 1) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5df2\u7ecf\u662f\u6700\u540e\u4e00\u4e2a", (String)"CostExecuteEditMob_4", (String)"occ-ocmem-formplugin", (Object[])new Object[0]));
            return;
        }
        this.showCostCostExecute(pkList.get(pkList.size() - 1));
    }

    private void showCostCostExecute(Object pk) {
        MobileBillShowParameter param = new MobileBillShowParameter();
        param.setPkId(pk);
        param.setStatus(OperationStatus.VIEW);
        param.getOpenStyle().setShowType(ShowType.Floating);
        param.setFormId("ocmem_costexecute_editmob");
        this.getView().showForm((FormShowParameter)param);
    }

    private List<Object> getExecuteList() {
        Object applyEntryId;
        ArrayList<Object> list = new ArrayList<Object>();
        DynamicObject obj = (DynamicObject)this.getModel().getValue("costapplyentry");
        if (obj != null && (applyEntryId = obj.getPkValue()) != null) {
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"ocmem_marketcostexecute", (String)"id", (QFilter[])new QFilter("costapplyentry.id", "=", applyEntryId).toArray(), (String)"createtime asc");
            for (int i = 0; i < coll.size(); ++i) {
                list.add(((DynamicObject)coll.get(i)).get("id"));
            }
        }
        return list;
    }

    public void customEvent(CustomEventArgs e) {
        String eventArgs = e.getEventArgs();
        JSONObject jsonObject = JSONObject.fromObject((Object)eventArgs);
        if (StringUtil.isEmpty((CharSequence)eventArgs)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u624b\u673a\u8bbe\u5907\u4fe1\u606f\u3002", (String)"CostExecuteEditMob_5", (String)"occ-ocmem-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
        }
        logger.info("eventArgs:" + eventArgs + "\n");
        String eventName = e.getEventName();
        logger.info("eventName:" + eventName + "\n");
        if (eventName.equals("getDevicedMsg")) {
            this.getModel().setValue("execdevice", (Object)jsonObject.getString("deviceId"));
        }
        ((Label)this.getControl("lb_execdevice")).setText((String)this.getModel().getValue("execdevice"));
    }
}

