/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.formplugin.expensebudget;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.business.helper.AssessPeriodHelper;
import kd.occ.ocbase.business.helper.ComboItemHelper;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.formplugin.base.OcbaseBillPlugin;
import kd.occ.ocmem.business.budgetcosts.AssignBudgetHelper;

public class AssignBudgetEdit
extends OcbaseBillPlugin
implements BeforeF7SelectListener {
    private static final String ORG_TO_EXPENSETYPE = "A";
    private static final String EXPENSETYPE_TO_ORG = "B";
    private static final String EXPENSETYPE_TO_CUSTOM = "C";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{"assignorgid", "assignexpensetypeid"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void afterCreateNewData(EventObject e) {
        Date billDate = (Date)this.getModel().getValue("bizdate");
        this.getModel().setValue("budgetyear", (Object)AssessPeriodHelper.queryAssessPeriod((Date)billDate));
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operateKey = evt.getOperateKey();
        if (("save".equalsIgnoreCase(operateKey) || "submit".equalsIgnoreCase(operateKey)) && evt.getOperationResult().isSuccess()) {
            DynamicObjectCollection entryColl = this.getModel().getEntryEntity("entryentity");
            BigDecimal sumAssignAmount = entryColl.stream().map(obj -> obj.getBigDecimal("assignamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            this.setValue("beforesumasnamount", sumAssignAmount);
            this.getView().updateView("beforesumasnamount");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "assignorgid": {
                DynamicObject orgDynObj = this.getF7Value("orgid");
                long orgId = DynamicObjectUtils.getPkValue((DynamicObject)orgDynObj);
                Set<Long> orgIdSet = this.getChildNodeByOrgId(orgId);
                orgIdSet.add(orgId);
                QFilter idFilter = new QFilter("id", "in", orgIdSet);
                e.getFormShowParameter().setCustomParam("isIncludeAllSub", (Object)true);
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)idFilter);
                break;
            }
            case "assignexpensetypeid": {
                long expenseTypeId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("expensetypeid"));
                if (expenseTypeId <= 0L) break;
                QFilter qFilter = new QFilter("parent", "=", (Object)expenseTypeId);
                qFilter = qFilter.or(new QFilter("id", "=", (Object)expenseTypeId));
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)qFilter);
                e.getFormShowParameter().setFormId("bos_listf7");
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object expenseBudgetId = this.getView().getFormShowParameter().getCustomParam("isfromassignbudget");
        if (!CommonUtils.isNull((Object)expenseBudgetId)) {
            DynamicObject expenseBudgetDynObj = BusinessDataServiceHelper.loadSingle((Object)expenseBudgetId, (String)"ocmem_expensebudget");
            Date year = DynamicObjectUtils.getDate((DynamicObject)expenseBudgetDynObj, (String)"year");
            this.setValue("year", year);
            long budgetYearId = DynamicObjectUtils.getPkValue((DynamicObject)expenseBudgetDynObj, (String)"budgetyear");
            this.setValue("budgetyear", budgetYearId);
            long orgId = DynamicObjectUtils.getPkValue((DynamicObject)expenseBudgetDynObj, (String)"orgid");
            this.setValue("orgid", orgId);
            this.setValue("parentorgid", DynamicObjectUtils.getPkValue((DynamicObject)expenseBudgetDynObj, (String)"parentorgid"));
            long expensetypeId = DynamicObjectUtils.getPkValue((DynamicObject)expenseBudgetDynObj, (String)"expensetypeid");
            this.setValue("expensetypeid", expensetypeId);
            long channelId = DynamicObjectUtils.getPkValue((DynamicObject)expenseBudgetDynObj, (String)"channelid");
            this.setValue("channelid", channelId);
            DynamicObject expenseType = this.getF7Value("expensetypeid");
            DynamicObject channel = this.getF7Value("channelid");
            this.updateAssignTypeValues(expenseType, channel);
            BigDecimal saleAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)expenseBudgetDynObj, (String)"saleamount");
            this.setValue("saleamount", saleAmount);
            BigDecimal expenseRate = DynamicObjectUtils.getBigDecimal((DynamicObject)expenseBudgetDynObj, (String)"expenserate");
            this.setValue("expenserate", expenseRate);
            this.setValue("availableamount", DynamicObjectUtils.getBigDecimal((DynamicObject)expenseBudgetDynObj, (String)"availableamount"));
            this.setValue("yearestimateamt", DynamicObjectUtils.getBigDecimal((DynamicObject)expenseBudgetDynObj, (String)"availableamount"));
            DynamicObject[] budgetBalanceDynObjs = AssignBudgetHelper.queryBudgetBalanceDynObj((long)orgId, (long)expensetypeId, (long)channelId, (Date)year);
            if (!CommonUtils.isNull((Object)budgetBalanceDynObjs)) {
                this.setValue("budgetno", budgetBalanceDynObjs[0].getString("number"));
            }
            this.setValue("remark", DynamicObjectUtils.getString((DynamicObject)expenseBudgetDynObj, (String)"remark"));
            this.setValue("expensebudgetid", DynamicObjectUtils.getPkValue((DynamicObject)expenseBudgetDynObj));
            this.setValue("budgetbillno", expenseBudgetDynObj.getString("billno"));
            Object sourceType = this.getView().getFormShowParameter().getCustomParam("sourcetype_param");
            this.setValue("sourcetype", sourceType);
        }
        this.lockHeadData();
        this.setValue("beforesumasnamount", this.getModel().getValue("sumassignamount"));
        String budgetAssignType = (String)this.getModel().getValue("budgetassigntype");
        if (ORG_TO_EXPENSETYPE.equalsIgnoreCase(budgetAssignType)) {
            this.setDisVisible(new String[]{"assignchannelid"});
        } else if (EXPENSETYPE_TO_ORG.equalsIgnoreCase(budgetAssignType)) {
            this.setDisVisible(new String[]{"assignchannelid"});
        } else if (EXPENSETYPE_TO_CUSTOM.equalsIgnoreCase(budgetAssignType)) {
            this.setVisible(new String[]{"assignchannelid"});
        }
    }

    private void updateAssignTypeValues(DynamicObject expenseType, DynamicObject channel) {
        if (expenseType == null) {
            this.setValue("budgetassigntype", ORG_TO_EXPENSETYPE);
            this.setUnEnable(new String[]{"budgetassigntype"});
        } else {
            String control = DynamicObjectUtils.getString((DynamicObject)expenseType, (String)"control");
            boolean isAllowToChannel = control.contains(",2,");
            HashSet<String> valueSet = new HashSet<String>();
            valueSet.add(ORG_TO_EXPENSETYPE);
            if (!isAllowToChannel) {
                valueSet.add(EXPENSETYPE_TO_CUSTOM);
            }
            ComboEdit budgetAssignType = (ComboEdit)this.getControl("budgetassigntype");
            ComboItemHelper.setItemVisible((ComboEdit)budgetAssignType, valueSet, (boolean)false);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        switch (entryName) {
            case "entryentity": {
                Object budgetAssignType;
                long orgId = DynamicObjectUtils.getPkValue((DynamicObject)this.getF7Value("orgid"));
                Set<Long> orgIdSet = this.getChildNodeByOrgId(orgId);
                if (orgIdSet.size() == 0) {
                    for (RowDataEntity rowDataEntity : rowDataEntities) {
                        int rowIndex = rowDataEntity.getRowIndex();
                        this.setValue("assignorgid", orgId, rowIndex);
                        this.setUnEnable(rowIndex, new String[]{"assignorgid"});
                    }
                }
                if ((budgetAssignType = this.getModel().getValue("budgetassigntype")) == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9884\u7b97\u5206\u914d\u7c7b\u578b\u5fc5\u586b", (String)"AssignBudgetEdit_0", (String)"occ-ocmem-formplugin", (Object[])new Object[0]));
                }
                this.properChangeCalEntryData(e.getInsertRow());
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if ("budgetassigntypeCallBack".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.getModel().deleteEntryData("entryentity");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        int rowIndex = this.getRowIndex(e);
        switch (key) {
            case "assignorgid": {
                this.setValue("assignparentorgid", this.getF7PKValue("orgid"), rowIndex);
                break;
            }
            case "assignrate": {
                this.calculateEntryValue(rowIndex);
                break;
            }
            case "saleamount": 
            case "yearestimateamt": {
                this.reCalculateEntryData();
                break;
            }
            case "expensetypeid": 
            case "budgetassigntype": {
                String budgetAssignType = (String)this.getModel().getValue("budgetassigntype");
                if (ORG_TO_EXPENSETYPE.equalsIgnoreCase(budgetAssignType)) {
                    this.setDisVisible(new String[]{"assignchannelid"});
                } else if (EXPENSETYPE_TO_ORG.equalsIgnoreCase(budgetAssignType)) {
                    this.setDisVisible(new String[]{"assignchannelid"});
                } else if (EXPENSETYPE_TO_CUSTOM.equalsIgnoreCase(budgetAssignType)) {
                    this.setVisible(new String[]{"assignchannelid"});
                }
                this.changeAssignBudgetConfirm();
                break;
            }
            case "assignexpensetypeid": {
                Object assignExpenseTypeId = this.getModel().getValue("assignexpensetypeid", rowIndex);
                if (assignExpenseTypeId == null) break;
                this.getModel().setValue("entryparentexpenseid", (Object)((DynamicObject)assignExpenseTypeId).getDynamicObject("parent"), rowIndex);
                break;
            }
            case "assignamount": {
                DynamicObjectCollection entryColl = this.getModel().getEntryEntity("entryentity");
                BigDecimal sumAssignEntryAmount = entryColl.stream().map(obj -> obj.getBigDecimal("assignamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                this.setValue("sumassignamount", sumAssignEntryAmount);
                break;
            }
        }
    }

    private void controlAssignType(long expensetypeId, long channelId) {
        if (expensetypeId == 0L) {
            this.setValue("budgetassigntype", ORG_TO_EXPENSETYPE);
            this.setUnEnable(new String[]{"budgetassigntype"});
        } else if (expensetypeId > 0L && channelId == 0L) {
            ComboEdit budgetAssignType = (ComboEdit)this.getControl("budgetassigntype");
            HashSet<String> valueSet = new HashSet<String>();
            valueSet.add(ORG_TO_EXPENSETYPE);
            ComboItemHelper.setItemVisible((ComboEdit)budgetAssignType, valueSet, (boolean)false);
        }
    }

    private void lockHeadData() {
        this.setUnEnable(new String[]{"saleamount", "expenserate", "yearestimateamt"});
    }

    private void changeAssignBudgetConfirm() {
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        if (entryRowCount > 0) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("budgetassigntypeCallBack", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u9884\u7b97\u5206\u914d\u7c7b\u578b\u53d1\u751f\u53d8\u66f4\uff0c\u662f\u5426\u5220\u9664\u5206\u5f55\uff1f", (String)"AssignBudgetEdit_1", (String)"occ-ocmem-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
        }
    }

    private Set<Long> getChildNodeByOrgId(long orgId) {
        Set<Long> orgIdSet = new HashSet<Long>(20);
        if (orgId > 0L) {
            QFilter filter = new QFilter("org", "=", (Object)orgId);
            DynamicObject orgDyn = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)"longnumber", (QFilter[])filter.toArray());
            String longNubmer = orgDyn.getString("longnumber");
            filter = new QFilter("longnumber", "like", (Object)("%" + longNubmer + "%"));
            filter = filter.and(new QFilter("view", "=", (Object)1L));
            DynamicObjectCollection orgDynColl = QueryServiceHelper.query((String)"bos_org_structure", (String)"org", (QFilter[])filter.toArray());
            orgIdSet = orgDynColl.stream().map(obj -> obj.getLong("org")).collect(Collectors.toSet());
        }
        return orgIdSet;
    }

    private void reCalculateEntryData() {
        DynamicObjectCollection entity = (DynamicObjectCollection)this.getModel().getValue("entryentity");
        if (entity != null && entity.size() > 0) {
            for (int i = 0; i < entity.size(); ++i) {
                this.calEstimateSaleAmount(i);
            }
        }
    }

    private void calEstimateSaleAmount(int rowIndex) {
        BigDecimal saleAmount = (BigDecimal)this.getModel().getValue("saleamount");
        BigDecimal assignRate = (BigDecimal)this.getModel().getValue("assignrate", rowIndex);
        BigDecimal estimalSaleAmount = saleAmount.multiply(assignRate).divide(new BigDecimal(100), 6, 4);
        this.getModel().setValue("estimatesaleamt", (Object)estimalSaleAmount, rowIndex);
        BigDecimal yearEstimateAmt = (BigDecimal)this.getModel().getValue("yearestimateamt");
        BigDecimal entryEstimateAmt = yearEstimateAmt.multiply(assignRate).divide(new BigDecimal(100), 6, 4);
        this.getModel().setValue("entryestimateamt", (Object)entryEstimateAmt, rowIndex);
    }

    private void properChangeCalEntryData(int index) {
        DynamicObjectCollection entity = (DynamicObjectCollection)this.getModel().getValue("entryentity");
        if (entity != null && entity.size() > 0) {
            if (index < 0) {
                index = entity.size() - 1;
            }
            this.setEntryFieldValueAfterPropertyChanged(index);
            this.calculateEntryValue(index);
        }
    }

    private void setEntryFieldValueAfterPropertyChanged(int rowIndex) {
        this.setValue("assignorgid", this.getF7PKValue("orgid"), rowIndex);
        Object budgetAssignType = this.getModel().getValue("budgetassigntype");
        if (budgetAssignType == null) {
            return;
        }
        Object expenseTypeId = this.getModel().getValue("expensetypeid");
        if (((String)budgetAssignType).equals(ORG_TO_EXPENSETYPE)) {
            this.setValue("assignorgid", this.getF7PKValue("orgid"), rowIndex);
            this.setUnEnable(rowIndex, new String[]{"assignorgid"});
            this.setMustInput("assignorgid", true);
            this.setMustInput("assignexpensetypeid", true);
            this.setValue("assignchannelid", null, rowIndex);
            this.setDisVisible(new String[]{"assignchannelid"});
            this.setEnable(rowIndex, new String[]{"entryestimateamt"});
            this.setEnable(rowIndex, new String[]{"assignamount"});
            this.setEnable(rowIndex, new String[]{"assignexpensetypeid"});
        } else if (((String)budgetAssignType).equals(EXPENSETYPE_TO_ORG)) {
            this.setValue("assignorgid", null, rowIndex);
            this.setMustInput("assignorgid", true);
            this.setEnable(rowIndex, new String[]{"assignorgid"});
            this.getModel().setValue("assignexpensetypeid", expenseTypeId, rowIndex);
            this.setMustInput("assignexpensetypeid", true);
            this.setUnEnable(rowIndex, new String[]{"assignexpensetypeid"});
            Object assignExpenseTypeId = this.getModel().getValue("assignexpensetypeid", rowIndex);
            if (assignExpenseTypeId != null) {
                this.getModel().setValue("entryparentexpenseid", (Object)((DynamicObject)assignExpenseTypeId).getDynamicObject("parent"), rowIndex);
            }
            this.setEnable(rowIndex, new String[]{"entryestimateamt"});
            this.setEnable(rowIndex, new String[]{"assignamount"});
            this.setDisVisible(new String[]{"assignchannelid"});
            this.setUnEnable(rowIndex, new String[]{"assignexpensetypeid"});
        } else if (((String)budgetAssignType).equals(EXPENSETYPE_TO_CUSTOM)) {
            this.setValue("assignorgid", this.getF7PKValue("orgid"), rowIndex);
            this.setUnEnable(rowIndex, new String[]{"assignorgid"});
            this.setMustInput("assignorgid", true);
            this.getModel().setValue("assignexpensetypeid", expenseTypeId, rowIndex);
            this.setMustInput("assignexpensetypeid", true);
            this.setUnEnable(rowIndex, new String[]{"assignexpensetypeid"});
            Object assignExpenseTypeId = this.getModel().getValue("assignexpensetypeid", rowIndex);
            if (assignExpenseTypeId != null) {
                this.getModel().setValue("entryparentexpenseid", (Object)((DynamicObject)assignExpenseTypeId).getDynamicObject("parent"), rowIndex);
            }
            this.setVisible(new String[]{"assignchannelid"});
            this.setEnable(rowIndex, new String[]{"assignchannelid"});
            this.setMustInput("assignchannelid", true);
            this.setEnable(rowIndex, new String[]{"entryestimateamt"});
            this.setEnable(rowIndex, new String[]{"assignamount"});
            this.setValue("assignchannelid", null, rowIndex);
            this.setUnEnable(rowIndex, new String[]{"assignexpensetypeid"});
        }
    }

    private void calculateEntryValue(int rowIndex) {
        BigDecimal saleAmount = (BigDecimal)this.getModel().getValue("saleamount");
        BigDecimal assignRate = (BigDecimal)this.getModel().getValue("assignrate", rowIndex);
        this.getModel().setValue("estimatesaleamt", (Object)saleAmount.multiply(assignRate).multiply(new BigDecimal("0.01")), rowIndex);
    }
}

