/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.formplugin.expensebudget;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.formplugin.base.OcbaseListPlugin;

public class BudgetDataPoolList
extends OcbaseListPlugin {
    public static final String CONFIRMDATA = "confirmdata";

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName;
        super.billListHyperLinkClick(args);
        HyperLinkClickEvent event = args.getHyperLinkClickEvent();
        switch (fieldName = event.getFieldName()) {
            case "srcbillnumber": {
                args.setCancel(true);
                BillList billList = (BillList)event.getSource();
                ListSelectedRow currentSelectRow = billList.getCurrentSelectedRowInfo();
                Object entryId = currentSelectRow.getEntryPrimaryKeyValue();
                Object pkValue = currentSelectRow.getPrimaryKeyValue();
                DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"ocmem_budgetdatapool");
                DynamicObjectCollection entries = bill.getDynamicObjectCollection("entryentity");
                List list = entries.stream().filter(r -> r.getPkValue().equals(entryId)).collect(Collectors.toList());
                if (list == null || list.size() == 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u9519\u8bef,\u8bf7\u5237\u65b0\u91cd\u8bd5\u3002", (String)"BudgetDataPoolList_0", (String)"occ-ocmem-formplugin", (Object[])new Object[0]));
                }
                DynamicObject target = (DynamicObject)list.get(0);
                String srcBillNumber = target.getString("srcbillnumber");
                DynamicObject saleOrder = QueryServiceHelper.queryOne((String)"ocbsoc_saleorder", (String)"id", (QFilter[])new QFilter("billno", "=", (Object)srcBillNumber).toArray());
                long saleOrderId = saleOrder.getLong("id");
                BillShowParameter billShowParameter = new BillShowParameter();
                billShowParameter.setFormId("ocbsoc_saleorder");
                billShowParameter.setPkId((Object)saleOrderId);
                billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm((FormShowParameter)billShowParameter);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String key;
        super.beforeDoOperation(evt);
        switch (key = ((AbstractOperate)evt.getSource()).getOperateKey()) {
            case "confirmdata": {
                ListSelectedRowCollection listSelectedData = evt.getListSelectedData();
                List ids = listSelectedData.stream().map(r -> r.getPrimaryKeyValue()).collect(Collectors.toList());
                Map<Object, Integer> map = listSelectedData.stream().collect(Collectors.toMap(k -> k.getPrimaryKeyValue(), v -> v.getRowKey(), (r1, r2) -> r1));
                QFilter qFilter = new QFilter("id", "in", ids);
                String selectFields = String.join((CharSequence)",", "id", "departmentid.id");
                DynamicObjectCollection bills = QueryServiceHelper.query((String)"ocmem_budgetdatapool", (String)selectFields, (QFilter[])qFilter.toArray());
                StringBuilder sb = new StringBuilder();
                for (DynamicObject bill : bills) {
                    Object departmentId = bill.get("departmentid.id");
                    if (departmentId != null && !departmentId.equals(0L)) continue;
                    sb.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u9500\u552e\u90e8\u95e8\u4e3a\u7a7a,\u4e0d\u5141\u8bb8\u786e\u8ba4\u6570\u636e\u3002", (String)"BudgetDataPoolList_1", (String)"occ-ocmem-formplugin", (Object[])new Object[0]) + "\n", map.get(bill.get("id")) + 1));
                }
                if (sb.length() <= 0) break;
                throw new KDBizException(sb.toString());
            }
        }
    }
}

