/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.formplugin.expensebudget;

import java.math.BigDecimal;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.formplugin.base.OcbaseListPlugin;
import org.apache.commons.lang.StringUtils;

public class ExpenseBudgetList
extends OcbaseListPlugin {
    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String operateKey;
        super.afterDoOperation(evt);
        switch (operateKey = evt.getOperateKey()) {
            case "addbudget": 
            case "assignbudget": {
                if (!evt.getOperationResult().isSuccess()) break;
                ListSelectedRowCollection selectRowColl = ((IListView)this.getView()).getSelectedRows();
                if (selectRowColl.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u884c\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ExpenseBudgetList_0", (String)"occ-ocmem-formplugin", (Object[])new Object[0]));
                    return;
                }
                ListSelectedRow selectedRow = selectRowColl.get(0);
                Object primaryKeyValue = selectedRow.getPrimaryKeyValue();
                String checkMsg = this.checkBeforeAssignBudget(primaryKeyValue);
                if (StringUtils.isNotEmpty((String)checkMsg)) {
                    this.getView().showTipNotification(checkMsg);
                    return;
                }
                BillShowParameter formshowParameter = new BillShowParameter();
                formshowParameter.setBillStatus(BillOperationStatus.ADDNEW);
                formshowParameter.setStatus(OperationStatus.ADDNEW);
                formshowParameter.setFormId("ocmem_assignbudget");
                formshowParameter.setCustomParam("isfromassignbudget", selectRowColl.get(0).getPrimaryKeyValue());
                formshowParameter.setCustomParam("sourcetype_param", (Object)("assignbudget".equals(operateKey) ? "1" : "0"));
                formshowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)formshowParameter);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        FormOperate operate = (FormOperate)evt.getSource();
        if (operate.getOperateKey().equals("new")) {
            evt.setCancel(true);
            BillShowParameter formshowParameter = new BillShowParameter();
            formshowParameter.setBillStatus(BillOperationStatus.ADDNEW);
            formshowParameter.setStatus(OperationStatus.ADDNEW);
            formshowParameter.setFormId("ocmem_expensebudget");
            formshowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)formshowParameter);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName;
        super.billListHyperLinkClick(args);
        HyperLinkClickEvent event = args.getHyperLinkClickEvent();
        switch (fieldName = event.getFieldName()) {
            case "billno": {
                args.setCancel(true);
                BillList billList = (BillList)event.getSource();
                ListSelectedRow currentSelectRow = billList.getCurrentSelectedRowInfo();
                Object pkValue = currentSelectRow.getPrimaryKeyValue();
                BillShowParameter formshowParameter = new BillShowParameter();
                formshowParameter.setBillStatus(BillOperationStatus.VIEW);
                formshowParameter.setStatus(OperationStatus.VIEW);
                formshowParameter.setFormId("ocmem_expensebudget");
                formshowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                formshowParameter.setPkId(pkValue);
                this.getView().showForm((FormShowParameter)formshowParameter);
            }
        }
    }

    private String checkBeforeAssignBudget(Object primaryKeyValue) {
        DynamicObject assignBudget = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"ocmem_expensebudget");
        if (assignBudget == null) {
            return ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002", (String)"ExpenseBudgetList_1", (String)"occ-ocmem-formplugin", (Object[])new Object[0]);
        }
        BigDecimal availableAmount = assignBudget.getBigDecimal("availableamount");
        if (availableAmount.compareTo(BigDecimal.ZERO) < 0) {
            return ResManager.loadKDString((String)"\u9009\u62e9\u884c\u7684\u53ef\u5206\u914d\u4f59\u989d\u5c0f\u4e8e0\uff0c\u4e0d\u5141\u8bb8\u5206\u914d\u3002", (String)"ExpenseBudgetList_2", (String)"occ-ocmem-formplugin", (Object[])new Object[0]);
        }
        if ("A".equalsIgnoreCase(assignBudget.getString("expensetypeid.expensetype")) && availableAmount.compareTo(BigDecimal.ZERO) == 0) {
            return ResManager.loadKDString((String)"\u5f53\u8d39\u7528\u7c7b\u578b\u4e3a\u56fa\u5b9a\u9884\u7b97\u4e14\u53ef\u5206\u914d\u91d1\u989d\u4e3a0\u7684\u65f6\u5019\uff0c\u4e0d\u5141\u8bb8\u5206\u914d\u3002", (String)"ExpenseBudgetList_3", (String)"occ-ocmem-formplugin", (Object[])new Object[0]);
        }
        if (!assignBudget.getBoolean("enable")) {
            return ResManager.loadKDString((String)"\u5df2\u7981\u7528\u7684\u8d39\u7528\u9884\u7b97\u4e0d\u5141\u8bb8\u5206\u914d\u6216\u8005\u8ffd\u52a0\u9884\u7b97\u3002", (String)"ExpenseBudgetList_4", (String)"occ-ocmem-formplugin", (Object[])new Object[0]);
        }
        return "";
    }
}

