/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.formplugin.expensebudget;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import org.apache.commons.lang.StringUtils;

public class ExpenseBudgetTreelist
extends StandardTreeListPlugin {
    private static final String ROOTNODEID = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    private static final String PROP_STANDARDLST = "cmbstandardlst";

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        e.setCancel(true);
        QFilter subOrgFilter = this.getBuildTreeListFilter(e.getNodeId().toString());
        if (subOrgFilter != null) {
            e.addQFilter(subOrgFilter);
        }
    }

    private QFilter getBuildTreeListFilter(String nodeId) {
        if (StringUtils.isBlank((String)nodeId) || "0".equals(nodeId)) {
            return null;
        }
        if (ROOTNODEID.equals(nodeId)) {
            return QFilter.of((String)"1=1", (Object[])new Object[0]);
        }
        ArrayList<Long> orgIds = new ArrayList<Long>(1);
        orgIds.add(Long.parseLong(nodeId));
        if (this.isIncludeGrand()) {
            List subordinateOrgIdList = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"01", orgIds, (boolean)true);
            orgIds.addAll(subordinateOrgIdList);
        }
        QFilter filter = new QFilter("orgid", "in", orgIds);
        DynamicObject[] budgetBalanceList = BusinessDataServiceHelper.load((String)"ocmem_expensebudget", (String)"id", (QFilter[])filter.toArray());
        List ids = DynamicObjectUtils.convertDynamicObjList((DynamicObject[])budgetBalanceList).stream().map(a -> DynamicObjectUtils.getPkValue((DynamicObject)a)).collect(Collectors.toList());
        return new QFilter("id", "in", ids);
    }

    private boolean isIncludeGrand() {
        boolean isIncludeGrand = true;
        Object includeChild = this.getModel().getValue("chkincludechild");
        if (includeChild != null) {
            isIncludeGrand = Boolean.parseBoolean(includeChild.toString());
        }
        return isIncludeGrand;
    }

    public void refreshNode(RefreshNodeEvent e) {
        super.refreshNode(e);
        String currNodeId = (String)e.getNodeId();
        if (ROOTNODEID.equals(currNodeId)) {
            OrgTreeParam param = this.getOrgTreeParam(OrgUnitServiceHelper.getRootOrgId());
            e.setChildNodes(OrgUnitServiceHelper.getTreeChildren((OrgTreeParam)param));
        } else {
            OrgTreeParam param = this.getOrgTreeParam(Long.parseLong(currNodeId));
            e.setChildNodes(OrgUnitServiceHelper.getTreeChildren((OrgTreeParam)param));
        }
    }

    private OrgTreeParam getOrgTreeParam(long orgId) {
        boolean buildRootNodeInRange;
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        OrgTreeParam param = new OrgTreeParam();
        param.setId(orgId);
        param.setOrgViewNumber("01");
        param.setMarkFreeze(true);
        param.setIncludeFreeze(false);
        param.setIncludeDisable(false);
        boolean bl = buildRootNodeInRange = !listShowParameter.isLookUp() || 0 == listShowParameter.getF7Style() || 3 == listShowParameter.getF7Style();
        if (buildRootNodeInRange) {
            param.getCustomFilterList().addAll(listShowParameter.getListFilterParameter().getQFilters());
        }
        param.setBuildRootNodeInRange(buildRootNodeInRange);
        return param;
    }

    public void expendTreeNode(TreeNodeEvent e) {
        TreeNode rootNode = this.getTreeModel().getRoot();
        if (rootNode == null) {
            return;
        }
        String nodeId = (String)e.getNodeId();
        TreeNode node = this.treeListView.getTreeModel().getRoot().getTreeNode(nodeId, 10);
        node.setIsOpened(true);
        e.setExpandedNode(node);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        this.treeListView.getTreeView().queryTreeNodeChildren(evt.getParentNodeId().toString(), nodeId);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object currentNodeId;
        String proName = e.getProperty().getName();
        TreeView treeView = this.treeListView.getTreeView();
        if ("chkincludechild".equals(proName) && (currentNodeId = this.getTreeModel().getCurrentNodeId()) != null && StringUtils.isNotBlank((String)currentNodeId.toString())) {
            treeView.treeNodeClick("", currentNodeId.toString());
        }
    }
}

