/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocmem.formplugin.rule;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.formplugin.base.OcbaseBasePlugin;

public class RollRateRuleEdit
extends OcbaseBasePlugin
implements BeforeF7SelectListener {
    public static final String SAVE = "save";
    public static final String SUBMIT = "submit";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{"expensetypeid", "itemid"});
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key;
        switch (key = beforeF7SelectEvent.getProperty().getName()) {
            case "expensetypeid": {
                HashSet<String> expenseTypeSet = new HashSet<String>(2);
                expenseTypeSet.add("B");
                expenseTypeSet.add("C");
                QFilter expenseTypeQFilter = new QFilter("ifbudget", "=", (Object)"1");
                expenseTypeQFilter.and("expensetype", "in", expenseTypeSet);
                QFilter qFilter = this.getExpenseTypeIdQFilter();
                if (qFilter != null) {
                    expenseTypeQFilter.and(qFilter);
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)beforeF7SelectEvent, (QFilter)expenseTypeQFilter);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "save": {
                if (this.checkTotalSaleRate()) break;
                throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25, \u5206\u914d\u6bd4\u4f8b\u5408\u8ba1\u987b\u7b49\u4e8e\u5546\u54c1\u603b\u9500\u8d39\u6bd4\u7387", (String)"RollRateRuleEdit_0", (String)"occ-ocmem-formplugin", (Object[])new Object[0]));
            }
            case "submit": {
                if (this.checkTotalSaleRate()) break;
                throw new KDBizException(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25, \u5206\u914d\u6bd4\u4f8b\u5408\u8ba1\u987b\u7b49\u4e8e\u5546\u54c1\u603b\u9500\u8d39\u6bd4\u7387", (String)"RollRateRuleEdit_1", (String)"occ-ocmem-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private boolean checkTotalSaleRate() {
        BigDecimal totalSaleRate = this.getView().getModel().getDataEntity().getBigDecimal("totalsalerate");
        DynamicObjectCollection entries = this.getView().getModel().getEntryEntity("entryentity");
        if (entries == null || entries.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8d39\u7528\u7c7b\u578b\u5206\u914d\u6bd4\u4f8b", (String)"RollRateRuleEdit_2", (String)"occ-ocmem-formplugin", (Object[])new Object[0]));
        }
        BigDecimal allocationRateSum = entries.stream().map(r -> r.getBigDecimal("allocationrate")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return allocationRateSum.compareTo(totalSaleRate) == 0;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "userange": {
                DynamicObjectCollection orgRangeList = this.getView().getModel().getEntryEntity("useorgentity");
                orgRangeList.clear();
                this.getView().updateView("useorgentity");
                break;
            }
            case "channelrange": {
                String channelRange = this.getStringValue("channelrange");
                DynamicObjectCollection channelDetail = this.getView().getModel().getEntryEntity("channelentity");
                DynamicObjectCollection channelTypeDetail = this.getView().getModel().getEntryEntity("channeltype");
                if ("B".equalsIgnoreCase(channelRange)) {
                    channelDetail.clear();
                    this.getView().updateView("channelentity");
                    break;
                }
                if ("C".equalsIgnoreCase(channelRange)) {
                    channelTypeDetail.clear();
                    this.getView().updateView("channeltype");
                    break;
                }
                if (!"A".equalsIgnoreCase(channelRange)) break;
                channelDetail.clear();
                channelTypeDetail.clear();
                this.getView().updateView("channelentity");
                this.getView().updateView("channeltype");
                break;
            }
        }
    }

    private QFilter getExpenseTypeIdQFilter() {
        QFilter qFilter = null;
        DynamicObjectCollection dyclo = this.getView().getModel().getEntryEntity("entryentity");
        if (dyclo == null || dyclo.isEmpty()) {
            return null;
        }
        Set idSet = dyclo.stream().map(r -> r.getLong(String.join((CharSequence)".", "expensetypeid", "id"))).collect(Collectors.toSet());
        qFilter = new QFilter("id", "not in", idSet);
        return qFilter;
    }
}

