/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.mservice.lot;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ococic.business.helper.LotHelper;
import kd.occ.ococic.enums.MoveDirectEnum;
import kd.occ.ococic.mservice.api.lot.LotService;
import kd.occ.ococic.pojo.LotMoveTrackVO;
import kd.occ.ococic.pojo.LotVO;
import kd.occ.ococic.util.StringUtils;

public class LotServiceImpl
implements LotService {
    public List<JSONObject> saveLot(List<JSONObject> lotJsonObjList) {
        if (CommonUtils.isNull(lotJsonObjList)) {
            return lotJsonObjList;
        }
        int size = lotJsonObjList.size();
        List<LotVO> lotVOList = new ArrayList(size);
        HashSet lotNumberSet = new HashSet();
        String lotNumber = "";
        ArrayList<LotMoveTrackVO> lotMoveTrackVOList = new ArrayList<LotMoveTrackVO>(size);
        LotVO lotVO = new LotVO();
        LotMoveTrackVO trackVO = new LotMoveTrackVO();
        String billFormId = "";
        for (JSONObject jsonObject : lotJsonObjList) {
            lotNumber = jsonObject.getString("number");
            if (CommonUtils.isNull((Object)lotNumber)) continue;
            billFormId = jsonObject.getString("billentityid");
            trackVO = new LotMoveTrackVO();
            if (!lotNumberSet.contains(lotNumber)) {
                lotVO = new LotVO();
                this.setLotMainFileData(jsonObject, lotVO);
                this.setLotMoveTrackData(jsonObject, trackVO);
                lotMoveTrackVOList = new ArrayList(size);
                lotMoveTrackVOList.add(trackVO);
                lotVO.setLotMoveTrackVOList(lotMoveTrackVOList);
                lotVOList.add(lotVO);
                continue;
            }
            this.setLotMoveTrackData(jsonObject, trackVO);
            lotVO.getLotMoveTrackVOList().add(trackVO);
        }
        ArrayList<JSONObject> resultObjList = new ArrayList<JSONObject>(lotVOList.size());
        if (!StringUtils.isBlank((String)billFormId) && !CommonUtils.isNull(lotMoveTrackVOList)) {
            LotHelper.deleteLot(lotMoveTrackVOList.stream().filter(lot -> lot.getBillID() > 0L).map(LotMoveTrackVO::getBillID).collect(Collectors.toList()), (String)billFormId);
        }
        lotVOList = LotHelper.saveLot(lotVOList);
        JSONObject resultObj = new JSONObject();
        if (!CommonUtils.isNull(lotJsonObjList)) {
            for (LotVO lotVo : lotVOList) {
                resultObj = new JSONObject();
                resultObj.put("lotid", (Object)lotVo.getLotID());
                resultObj.put("lotnumber", (Object)lotVo.getNumber());
                resultObj.put("billentryid", (Object)lotVo.getBillEntryId());
                resultObj.put("itemid", (Object)lotVo.getItemID());
                resultObjList.add(resultObj);
            }
        }
        return resultObjList;
    }

    private void setLotMainFileData(JSONObject jsonObject, LotVO lotVO) {
        lotVO.setScmLotId(jsonObject.getLongValue("scmlotid"));
        lotVO.setNumber(jsonObject.getString("number"));
        lotVO.setItemID(jsonObject.getLongValue("itemid"));
        lotVO.setMaterialID(jsonObject.getLongValue("materialid"));
        lotVO.setAuxPtyID(jsonObject.getLongValue("auxptyid"));
        lotVO.setProductDate(jsonObject.getDate("productdate"));
        lotVO.setEffectiveDate(jsonObject.getDate("expiredate"));
        lotVO.setBillEntryId(jsonObject.getLongValue("billentryid"));
    }

    private void setLotMoveTrackData(JSONObject jsonObject, LotMoveTrackVO trackVO) {
        String moveDirect = jsonObject.getString("movedirect");
        if (MoveDirectEnum.MOVEDIRECT_SRC.getValue().equals(moveDirect)) {
            trackVO.setMoveDirect(MoveDirectEnum.MOVEDIRECT_SRC);
            trackVO.setSrcChannelID(jsonObject.getLongValue("channelid"));
            trackVO.setSrcWarehouseID(jsonObject.getLongValue("channelstockid"));
            trackVO.setSrcLocationID(jsonObject.getLongValue("channellocationid"));
            if (jsonObject.getLongValue("channelorgid") > 0L) {
                trackVO.setSrcSaleChannelID(jsonObject.getLongValue("channelorgid"));
            }
        } else {
            trackVO.setMoveDirect(MoveDirectEnum.MOVEDIRECT_DES);
            trackVO.setDestChannelID(jsonObject.getLongValue("channelid"));
            trackVO.setDestWarehouseID(jsonObject.getLongValue("channelstockid"));
            trackVO.setDestLocationID(jsonObject.getLongValue("channellocationid"));
            if (jsonObject.getLongValue("channelorgid") > 0L) {
                trackVO.setDestSaleChannelID(jsonObject.getLongValue("channelorgid"));
            }
        }
        trackVO.setQty(jsonObject.getBigDecimal("qty"));
        trackVO.setUnitID(jsonObject.getLongValue("unit"));
        trackVO.setMoveDate(TimeServiceHelper.now());
        trackVO.setBillID(jsonObject.getLongValue("billid"));
        trackVO.setBillEntryID(jsonObject.getLongValue("billentryid"));
        trackVO.setBillNo(jsonObject.getString("billno"));
        trackVO.setBillDate(jsonObject.getDate("billdate"));
        trackVO.setBillEntityID(jsonObject.getString("billentityid"));
    }

    public void deleteLot(List<Long> billIds, String billFormId) {
        LotHelper.deleteLot(billIds, (String)billFormId);
    }
}

