/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.mservice.sharedinventory;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.occ.ocbase.common.enums.ReserveResultType;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ococic.business.helper.SharedInventoryHelper;
import kd.occ.ococic.mservice.api.sharedinventory.SharedInventoryService;
import kd.occ.ococic.pojo.InventoryDetailInfoVO;
import kd.occ.ococic.pojo.InventoryMatchResultVO;
import kd.occ.ococic.pojo.InventoryParamVO;
import kd.occ.ococic.util.CommonUtils;

public class SharedInventoryServiceImpl
implements SharedInventoryService {
    public List<JSONObject> matchDistributionWarehouse(List<JSONObject> jsonObjList) {
        if (CommonUtils.isNull(jsonObjList)) {
            return jsonObjList;
        }
        ArrayList<InventoryParamVO> invParamVOList = new ArrayList<InventoryParamVO>(jsonObjList.size());
        for (JSONObject jsonObject : jsonObjList) {
            InventoryParamVO invParam = new InventoryParamVO();
            invParam.setSaleOrgId(jsonObject.getLongValue("saleOrgId"));
            invParam.setSaleChannelID(jsonObject.getLongValue("saleChannelID"));
            invParam.setAdminDivisionId(jsonObject.getLongValue("adminDivisionId"));
            invParam.setItemId(jsonObject.getLongValue("itemId"));
            invParam.setMaterialId(jsonObject.getLongValue("materialId"));
            invParam.setAuxPtyID(jsonObject.getLongValue("auxPtyID"));
            invParam.setBaseUnitID(jsonObject.getLongValue("baseUnitID"));
            invParam.setBaseUnitQty(jsonObject.getBigDecimal("baseUnitQty"));
            invParam.setUnitId(jsonObject.getLongValue("unitId"));
            invParam.setUnitQty(jsonObject.getBigDecimal("unitQty"));
            invParam.setStockOrgId(jsonObject.getLongValue("stockOrgId"));
            invParam.setWarehouseId(jsonObject.getLongValue("warehouseId"));
            invParam.setDistributionModeId(jsonObject.getLongValue("distributionModeId"));
            invParam.setDeliveryDate(jsonObject.getDate("deliveryDate"));
            invParam.setInvtypeId(jsonObject.getLongValue("invtypeid"));
            invParam.setCustomerKey(jsonObject.getString("customerKey"));
            invParamVOList.add(invParam);
        }
        List invMatchResultList = SharedInventoryHelper.matchDistributionWarehouse(invParamVOList);
        ArrayList<JSONObject> resultObjList = new ArrayList<JSONObject>(invParamVOList.size());
        if (!CommonUtils.isNull((Object)invMatchResultList)) {
            for (InventoryMatchResultVO inventoryMatchResultVO : invMatchResultList) {
                JSONObject resultJsonObj = new JSONObject();
                for (Map.Entry entry : inventoryMatchResultVO.entrySet()) {
                    if ("invdetailinfolist".equals(entry.getKey())) {
                        ArrayList<JSONObject> detailJsonObjList = new ArrayList<JSONObject>(10);
                        for (InventoryDetailInfoVO detailInfoVO : (ArrayList)entry.getValue()) {
                            JSONObject detailJsonObj = new JSONObject();
                            for (Map.Entry detailEntry : detailInfoVO.entrySet()) {
                                detailJsonObj.put(detailEntry.getKey().toString(), detailEntry.getValue());
                            }
                            detailJsonObjList.add(detailJsonObj);
                        }
                        resultJsonObj.put(entry.getKey().toString(), detailJsonObjList);
                        continue;
                    }
                    resultJsonObj.put(entry.getKey().toString(), entry.getValue());
                }
                resultObjList.add(resultJsonObj);
            }
        }
        return resultObjList;
    }

    public void reserveRemove(Object billId, Object billEntryId) {
        DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"ReserveService", (String)"reserveRemove", (Object[])new Object[]{billId, billEntryId});
    }

    public void reserveRemove(Object billId) {
        DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"ReserveService", (String)"reserveRemove", (Object[])new Object[]{billId, null});
    }

    public List<JSONObject> reserve(DynamicObject billDynObj) {
        ArrayList<DynamicObject> billList = new ArrayList<DynamicObject>(1);
        billList.add(billDynObj);
        String resultStr = (String)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"ReserveService", (String)"reserveByBills", (Object[])new Object[]{billList});
        ArrayList<JSONObject> resultObjList = new ArrayList<JSONObject>(1);
        if (StringUtils.isNotEmpty((String)resultStr)) {
            JSONArray jArray = JSONArray.parseArray((String)resultStr);
            JSONObject resultJsonObj = jArray.getJSONObject(0);
            String resultType = resultJsonObj.getString("reserveResultType");
            if (resultType.equals(ReserveResultType.Failed.toString())) {
                JSONObject invJsonObj = new JSONObject();
                invJsonObj.put("issuccess", (Object)Boolean.FALSE);
                invJsonObj.put("message", (Object)resultJsonObj.getString("errorMsg"));
                invJsonObj.put("reserveQty", (Object)BigDecimal.ZERO);
                invJsonObj.put("entryId", (Object)0L);
                invJsonObj.put("data", null);
                return Collections.singletonList(invJsonObj);
            }
            JSONArray entryResultArray = resultJsonObj.getJSONArray("entryResultList");
            if (entryResultArray != null && entryResultArray.size() > 0) {
                for (Object entryResultObj : entryResultArray) {
                    JSONObject entryJsonObj = (JSONObject)entryResultObj;
                    JSONObject invJsonObj = new JSONObject();
                    invJsonObj.put("issuccess", (Object)Boolean.TRUE);
                    invJsonObj.put("message", (Object)"");
                    invJsonObj.put("reserveQty", (Object)entryJsonObj.getBigDecimal("reservedQty"));
                    invJsonObj.put("entryId", (Object)entryJsonObj.getLong("entryId"));
                    JSONArray detailInfo = new JSONArray();
                    for (Object stdInvResult : entryJsonObj.getJSONArray("stdInvResultList")) {
                        JSONObject stdInvResultObj = (JSONObject)stdInvResult;
                        JSONObject detailItem = new JSONObject();
                        Map invInfoMap = (Map)stdInvResultObj.getObject("invInfo", Map.class);
                        for (Map.Entry detailEntry : invInfoMap.entrySet()) {
                            detailItem.put((String)detailEntry.getKey(), detailEntry.getValue());
                        }
                        detailInfo.add((Object)detailItem);
                    }
                    invJsonObj.put("data", (Object)detailInfo);
                    resultObjList.add(invJsonObj);
                }
            }
        }
        return resultObjList;
    }
}

