/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.opplugin.inbill;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.occ.ococic.business.channelinv.ChannelInvAccHelper;
import kd.occ.ococic.business.helper.LotHelper;
import kd.occ.ococic.business.helper.SnMainFileHelper;
import kd.occ.ococic.util.CommonUtils;
import kd.occ.ococic.validator.inbill.ChannelInBillUnAuditSNValidator;
import kd.occ.ococic.validator.invacc.InvAccUpdateUnAuditValidator;

public class ChannelInBillUnAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("billtypeid");
        e.getFieldKeys().add("inchannelid");
        e.getFieldKeys().add("itemid");
        e.getFieldKeys().add("lotnumberid");
        e.getFieldKeys().add("lotnumber");
        e.getFieldKeys().add("projectid");
        e.getFieldKeys().add("producedate");
        e.getFieldKeys().add("expirydate");
        e.getFieldKeys().add("serialqty");
        e.getFieldKeys().add("serialnumber");
        e.getFieldKeys().add("serialid");
        e.getFieldKeys().add("serialunit");
        e.getFieldKeys().add("billentry.seq");
        e.getFieldKeys().add("ispresent");
        e.getFieldKeys().add("sourceentryid");
        e.getFieldKeys().add("srcbillentity");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ChannelInBillUnAuditSNValidator());
        e.addValidator((AbstractValidator)new InvAccUpdateUnAuditValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] bills = e.getDataEntities();
        ArrayList<Long> billIdList = new ArrayList<Long>(bills.length);
        ArrayList<Long> updateInvBillIdList = new ArrayList<Long>(bills.length);
        for (DynamicObject bill : bills) {
            billIdList.add(bill.getLong("id"));
            long billtypeid = bill.getLong("billtypeid.id");
            DynamicObject inchannel = bill.getDynamicObject("inchannelid");
            String invcontrolmode = inchannel.getString("invcontrolmode");
            if (StringUtils.equals((CharSequence)invcontrolmode, (CharSequence)"B") && billtypeid != 1640633200499768320L) continue;
            updateInvBillIdList.add(bill.getLong("id"));
        }
        SnMainFileHelper.saveSnMainFileByUnAudit(updateInvBillIdList, (String)"ococic_channelinbill");
        LotHelper.deleteLot(billIdList, (String)"ococic_channelinbill");
        Map errorMessageData = ChannelInvAccHelper.updateChannelInvAccByBillUnAudit(updateInvBillIdList, (String)"ococic_channelinbill");
        if (CommonUtils.isNull((Object)errorMessageData)) {
            return;
        }
        if (!CommonUtils.isNull((Object)errorMessageData)) {
            for (Map.Entry errorMessageEntry : errorMessageData.entrySet()) {
                List errorMessages = (List)errorMessageEntry.getValue();
                for (DynamicObject bill : bills) {
                    OperateErrorInfo errorInfo = new OperateErrorInfo("errorcode_001", ErrorLevel.Error, bill.getPkValue());
                    errorInfo.setMessage((String)errorMessages.get(0));
                    this.operationResult.addErrorInfo(errorInfo);
                }
            }
            e.setDataEntities(new DynamicObject[0]);
        }
    }
}

