/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.opplugin.inventoryreport;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.occ.ococic.business.channelinv.ChannelInvAccHelper;
import kd.occ.ococic.util.CommonUtils;

public class InventoryReportAuditOp
extends AbstractOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] bills = e.getDataEntities();
        ArrayList<Long> billIdList = new ArrayList<Long>(bills.length);
        for (DynamicObject bill : bills) {
            DynamicObject reportchannel = bill.getDynamicObject("reportchannelid");
            String invcontrolmode = reportchannel.getString("invcontrolmode");
            if (!StringUtils.equals((CharSequence)invcontrolmode, (CharSequence)"B")) continue;
            billIdList.add(bill.getLong("id"));
        }
        Map errorMessageData = ChannelInvAccHelper.updateChannelInvAccByBillAudit(billIdList, (String)"ococic_inventoryreport");
        if (!CommonUtils.isNull((Object)errorMessageData)) {
            for (Map.Entry errorMessageEntry : errorMessageData.entrySet()) {
                List errorMessages = (List)errorMessageEntry.getValue();
                for (DynamicObject bill : bills) {
                    OperateErrorInfo errorInfo = new OperateErrorInfo("errorcode_001", ErrorLevel.Error, bill.getPkValue());
                    errorInfo.setMessage((String)errorMessages.get(0));
                    this.operationResult.addErrorInfo(errorInfo);
                }
            }
            e.setDataEntities(new DynamicObject[0]);
        }
    }
}

