/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.opplugin.inventoryreport;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.util.CollectionUtils;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ococic.business.helper.LotHelper;
import kd.occ.ococic.pojo.LotVO;

public class InventoryReportSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("lotnumber");
        e.getFieldKeys().add("itemid");
        e.getFieldKeys().add("unitid");
        e.getFieldKeys().add("qty");
        e.getFieldKeys().add("material");
        e.getFieldKeys().add("auxptyid");
        e.getFieldKeys().add("lotnumberid");
        e.getFieldKeys().add("productdate");
        e.getFieldKeys().add("expiredate");
        e.getFieldKeys().add("reportchannelid");
        e.getFieldKeys().add("reportdate");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("warehouseid");
        e.getFieldKeys().add("locationid");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        List dynObjList = DynamicObjectUtils.convertDynamicObjList((DynamicObject[])e.getDataEntities());
        List lotVOList = LotHelper.saveLotByDynamicObjects((List)dynObjList, (String)"ococic_inventoryreport");
        if (CollectionUtils.isEmpty((Collection)lotVOList)) {
            return;
        }
        Map<String, Long> itemIdAndLotMap = lotVOList.stream().collect(Collectors.toMap(obj -> StringUtils.join((CharSequence)"_", (Object[])new Object[]{obj.getItemID(), obj.getNumber()}), LotVO::getLotID, (k1, k2) -> k1));
        for (DynamicObject entity : dynObjList) {
            DynamicObjectCollection entryColl = entity.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryDynObj : entryColl) {
                long itemId = DynamicObjectUtils.getPkValue((DynamicObject)entryDynObj, (String)"itemid");
                String lotNumber = entryDynObj.getString("lotnumber");
                long logId = 0L;
                String strkey = StringUtils.join((CharSequence)"_", (Object[])new Object[]{itemId, lotNumber});
                if (itemIdAndLotMap.containsKey(strkey)) {
                    logId = itemIdAndLotMap.get(strkey);
                }
                DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)entryDynObj, (String)"lotnumberid", (long)logId);
            }
        }
        e.setDataEntities(dynObjList.toArray(new DynamicObject[dynObjList.size()]));
    }
}

