/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.opplugin.outbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.OperationResultUtil;
import kd.occ.ococic.business.channelinv.ChannelInvAccHelper;
import kd.occ.ococic.business.helper.LotHelper;
import kd.occ.ococic.business.helper.SnMainFileHelper;
import kd.occ.ococic.validator.invacc.InvAccUpdateAuditValidator;
import kd.occ.ococic.validator.outbill.ChannelOutBillLotValidator;
import kd.occ.ococic.validator.outbill.ChannelOutBillSNValidator;

public class ChannelOutBillAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        ArrayList<String> keys = new ArrayList<String>(32);
        keys.add("itemid");
        keys.add("auxptyid");
        keys.add("lotid");
        keys.add("lotnumber");
        keys.add("stockid");
        keys.add("stockaddrid");
        keys.add("stocktypeid");
        keys.add("stockstatusid");
        keys.add("ownerid");
        keys.add("ownertype");
        keys.add("keeperid");
        keys.add("keepertype");
        keys.add("projectid");
        keys.add("productdate");
        keys.add("expiredate");
        keys.add("baseunitid");
        keys.add("basequantity");
        keys.add("unitid");
        keys.add("quantity");
        keys.add("auxptyunitid");
        keys.add("auxquantity");
        keys.add("outdirection");
        keys.add("org");
        keys.add("saleorgchannelid");
        keys.add("orderchannelid");
        keys.add("outchannelid");
        keys.add("billno");
        keys.add("snquantity");
        keys.add("serialnumber");
        keys.add("serialid");
        keys.add("snunit");
        keys.add("materielid");
        keys.add("creator");
        keys.add("createtime");
        keys.add("srcbillentryid");
        keys.add("serialcomment");
        keys.add("chnloutbill_sn");
        keys.add("billentry.seq");
        keys.add("outdate");
        keys.add("present");
        keys.add("srcbillentity");
        keys.add("srcbillid");
        keys.add("billtypeid");
        e.getFieldKeys().addAll(keys);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ChannelOutBillSNValidator());
        e.addValidator((AbstractValidator)new ChannelOutBillLotValidator());
        e.addValidator((AbstractValidator)new InvAccUpdateAuditValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] bills = e.getDataEntities();
        ArrayList<Long> billIdList = new ArrayList<Long>(bills.length);
        for (DynamicObject bill : bills) {
            long billtypeid = bill.getLong("billtypeid.id");
            DynamicObject outchannel = bill.getDynamicObject("outchannelid");
            String invcontrolmode = outchannel.getString("invcontrolmode");
            if (StringUtils.equals((CharSequence)invcontrolmode, (CharSequence)"B") && billtypeid != 1640631427215145984L) continue;
            billIdList.add(bill.getLong("id"));
        }
        SnMainFileHelper.saveSnMainFileByAudit(billIdList, (String)"ococic_channeloutbill");
        LotHelper.saveLotByDynamicObjects(Arrays.asList(bills), (String)"ococic_channeloutbill");
        Map errorMessageData = ChannelInvAccHelper.updateChannelInvAccByBillAudit(billIdList, (String)"ococic_channeloutbill");
        if (!CommonUtils.isNull((Object)errorMessageData)) {
            for (Map.Entry errorMessageEntry : errorMessageData.entrySet()) {
                List errorMessages = (List)errorMessageEntry.getValue();
                for (DynamicObject bill : bills) {
                    OperateErrorInfo errorInfo = new OperateErrorInfo("errorcode_001", ErrorLevel.Error, bill.getPkValue());
                    errorInfo.setMessage((String)errorMessages.get(0));
                    this.operationResult.addErrorInfo(errorInfo);
                }
            }
            e.setDataEntities(new DynamicObject[0]);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataArray = e.getDataEntities();
        if (dataArray != null && dataArray.length > 0) {
            OperationResult result;
            QFilter filter;
            String selectFields;
            DynamicObjectCollection transBillEntity;
            List<DynamicObject> dataList = Arrays.asList(dataArray);
            ArrayList<Object> needCreateDelivery = new ArrayList<Object>();
            HashMap<Long, DynamicObject> transBillOutStockMap = new HashMap<Long, DynamicObject>();
            for (DynamicObject data : dataList) {
                DynamicObjectCollection billEntry = data.getDynamicObjectCollection("billentry");
                if (CollectionUtils.isEmpty((Collection)billEntry)) continue;
                long billtypeid = DynamicObjectUtils.getPkValue((DynamicObject)data.getDynamicObject("billtypeid"));
                DynamicObject orderchannel = data.getDynamicObject("orderchannelid");
                if ("ococic_transbill".equals(((DynamicObject)billEntry.get(0)).getString("srcbillentity"))) {
                    transBillOutStockMap.put(((DynamicObject)billEntry.get(0)).getLong("srcbillid"), data);
                    continue;
                }
                if (orderchannel == null || billtypeid == 1028198029112451072L) continue;
                needCreateDelivery.add(data);
            }
            if (!transBillOutStockMap.isEmpty() && (transBillEntity = QueryServiceHelper.query((String)"ococic_transbill", (String)(selectFields = String.join((CharSequence)",", "transmode", "id")), (QFilter[])(filter = new QFilter("id", "in", transBillOutStockMap.keySet())).toArray())) != null && !transBillEntity.isEmpty()) {
                for (DynamicObject transBill : transBillEntity) {
                    if (!"1".equals(transBill.getString("transmode"))) continue;
                    needCreateDelivery.add(transBillOutStockMap.get(transBill.getLong("id")));
                }
            }
            if (needCreateDelivery != null && !needCreateDelivery.isEmpty() && !(result = OperationServiceHelper.executeOperate((String)"confirmdelivery", (String)"ococic_channeloutbill", (DynamicObject[])needCreateDelivery.toArray(new DynamicObject[needCreateDelivery.size()]), (OperateOption)CommonUtils.getOperateOption())).isSuccess()) {
                throw new KDBizException(OperationResultUtil.getErrorInfoMsg((OperationResult)result));
            }
        }
        super.endOperationTransaction(e);
    }
}

