/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ococic.opplugin.outbill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ococic.business.helper.LotHelper;
import kd.occ.ococic.business.helper.SnMainFileHelper;
import kd.occ.ococic.pojo.LotVO;
import kd.occ.ococic.pojo.SnMainFileVO;
import kd.occ.ococic.validator.outbill.ChannelOutBillLotValidatorNew;
import kd.occ.ococic.validator.outbill.StockoutBillSaveValidator;

public class ChannelOutBillSaveOp
extends AbstractOperationServicePlugIn {
    protected List<DynamicObject> oppositeOutBillEntities = new ArrayList<DynamicObject>(8);
    protected List<DynamicObject> forwardOutBillEntities = new ArrayList<DynamicObject>(8);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        ArrayList<String> keys = new ArrayList<String>(32);
        keys.add("billno");
        keys.add("billtypeid");
        keys.add("itemid");
        keys.add("lotid");
        keys.add("lotnumber");
        keys.add("projectid");
        keys.add("productdate");
        keys.add("expiredate");
        keys.add("snquantity");
        keys.add("serialnumber");
        keys.add("serialid");
        keys.add("snunit");
        keys.add("billentry.seq");
        keys.add("auxptyid");
        keys.add("stockid");
        keys.add("stockaddrid");
        keys.add("srcbillentryid");
        keys.add("serialcomment");
        keys.add("chnloutbill_sn");
        keys.add("outdate");
        keys.add("materielid");
        keys.add("auxptyunitid");
        keys.add("present");
        keys.add("saleorgchannelid");
        e.getFieldKeys().addAll(keys);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new StockoutBillSaveValidator());
        e.addValidator((AbstractValidator)new ChannelOutBillLotValidatorNew());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            if (this.isOppositeDirection((String)dataEntity.get("outdirection"))) {
                this.oppositeOutBillEntities.add(dataEntity);
                continue;
            }
            this.forwardOutBillEntities.add(dataEntity);
        }
        this.handlerBillEntities(this.oppositeOutBillEntities, false);
        this.handlerBillEntities(this.forwardOutBillEntities, true);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
    }

    protected void handlerBillEntities(List<DynamicObject> entities, boolean isOutWay) {
        block14: {
            block13: {
                if (CollectionUtils.isEmpty(entities)) {
                    return;
                }
                if (!isOutWay) break block13;
                for (DynamicObject entity : entities) {
                    DynamicObjectCollection entries = entity.getDynamicObjectCollection("billentry");
                    for (DynamicObject entry : entries) {
                        DynamicObject item = entry.getDynamicObject("itemid");
                        if (null == item || !item.getBoolean("enableserial")) continue;
                        DynamicObjectCollection subEntries = entry.getDynamicObjectCollection("chnloutbill_sn");
                        for (DynamicObject subEntry : subEntries) {
                            String snNumber = subEntry.getString("serialnumber");
                            DynamicObject[] sns = BusinessDataServiceHelper.load((String)"ococic_snmainfile", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)snNumber)});
                            if (sns == null || sns.length <= 0) continue;
                            Long snId = (Long)sns[0].getPkValue();
                            subEntry.set("serialid_id", (Object)snId);
                        }
                    }
                }
                break block14;
            }
            List lotVOS = LotHelper.saveLotByDynamicObjects(this.oppositeOutBillEntities, (String)"ococic_channeloutbill");
            HashMap itemIdAndLotMap = new HashMap();
            for (LotVO vo : lotVOS) {
                itemIdAndLotMap.putIfAbsent(vo.getItemID(), new HashMap());
                ((Map)itemIdAndLotMap.get(vo.getItemID())).put(vo.getNumber(), vo.getLotID());
            }
            if (!CollectionUtils.isEmpty((Collection)lotVOS)) {
                for (DynamicObject entity : entities) {
                    DynamicObjectCollection entries = entity.getDynamicObjectCollection("billentry");
                    for (DynamicObject entry : entries) {
                        Long itemId = (Long)entry.getDynamicObject("itemid").getPkValue();
                        String lotNumber = entry.getString("lotnumber");
                        Map lotNumberIdMap = (Map)itemIdAndLotMap.get(itemId);
                        if (CollectionUtils.isEmpty((Map)lotNumberIdMap)) continue;
                        Long lotId = (Long)lotNumberIdMap.get(lotNumber);
                        entry.set("lotid_id", (Object)lotId);
                    }
                }
            }
            ArrayList<DynamicObject> updateSnEntities = new ArrayList<DynamicObject>();
            for (DynamicObject outBillEntity : this.oppositeOutBillEntities) {
                long billtypeid = outBillEntity.getLong("billtypeid.id");
                DynamicObject outchannel = outBillEntity.getDynamicObject("outchannelid");
                String invcontrolmode = outchannel.getString("invcontrolmode");
                if (StringUtils.equals((CharSequence)invcontrolmode, (CharSequence)"B") && billtypeid != 1640631427215145984L) continue;
                updateSnEntities.add(outBillEntity);
            }
            List snMainFileVOS = SnMainFileHelper.saveSnMainFileBySave(updateSnEntities, (String)"ococic_channeloutbill");
            HashMap itemIdAndSNMap = new HashMap();
            for (SnMainFileVO vo : snMainFileVOS) {
                itemIdAndSNMap.putIfAbsent(vo.getItemID(), new HashMap());
                ((Map)itemIdAndSNMap.get(vo.getItemID())).put(vo.getNumber(), vo.getSnMainFileID());
            }
            if (CollectionUtils.isEmpty((Collection)snMainFileVOS)) break block14;
            for (DynamicObject entity : entities) {
                DynamicObjectCollection entries = entity.getDynamicObjectCollection("billentry");
                for (DynamicObject entry : entries) {
                    Long itemId = (Long)entry.getDynamicObject("itemid").getPkValue();
                    Map snNumberIdMap = (Map)itemIdAndSNMap.get(itemId);
                    if (CollectionUtils.isEmpty((Map)snNumberIdMap)) continue;
                    DynamicObjectCollection subEntries = entry.getDynamicObjectCollection("chnloutbill_sn");
                    for (DynamicObject subEntry : subEntries) {
                        String snNumber = subEntry.getString("serialnumber");
                        Long snId = (Long)snNumberIdMap.get(snNumber);
                        subEntry.set("serialid_id", (Object)snId);
                    }
                }
            }
        }
    }

    protected boolean isOppositeDirection(String directionCode) {
        return "2".equals(directionCode);
    }
}

